/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.prefs;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.PreferencesEditor;
import org.xissweb.gui.prefs.data.PreferenceElement;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.util.LabelCellRenderer;

public class PreferencesTreeCellRenderer
extends LabelCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = -1164749994273118739L;
    private PreferencesEditor editor;

    public PreferencesTreeCellRenderer(PreferencesEditor editor) {
        this.editor = editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof PreferenceElement) {
            PreferenceElement preferenceElement = (PreferenceElement)node.getUserObject();
            String theValue = PreferencesEditionManager.displayLabel(preferenceElement);
            if (node.getUserObject() instanceof PreferenceInfo) {
                Object v = this.editor.getPreferenceValue((PreferenceInfo)preferenceElement);
                theValue = theValue + " = " + (v == null ? "?" : v);
            }
            String stringValue = tree.convertValueToText(theValue, this.cellSelected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setIcon(null);
            if (sel) {
                this.setBackground(selectedBackgroundColor);
            }
            if (this.editor.isEdited(preferenceElement)) {
                this.setFont(this.boldTextFont);
            } else {
                this.setFont(this.plainTextFont);
            }
        }
        this.cellSelected = sel;
        return this;
    }
}

