/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.xerces.parsers.DOMParser;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.html.HtmlEditorHelper;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PageDecorationEditor
extends AbstractLayoutElementEditor
implements ErrorHandler {
    private static final long serialVersionUID = -7847856734296919654L;
    private static final String helpDecoration = "decoration";
    private static final int vButtonMargin = 2;
    private static final int hButtonMargin = 3;
    private static final String linkToHomeElement = "<link-to-home text=\"??\" title=\"??\"/>";
    private static final String descriptionElement = "<description/>";
    private static final String titleElement = "<title/>";
    private static final String builtWithElement = "<built-with type=\"normal\"/>";
    private static final String copyrightElement = "<copyright/>";
    private PageDecorationInfo pageDecoration;
    private String data;
    int textDot;
    private HtmlEditorHelper htmlEditorHelper;
    private JScrollPane textScrollPane = null;
    private JTextPane textArea = null;
    private JLabel contentLabel = null;
    private JPanel elementsPanel = null;
    private JButton linkToHomeButton = null;
    private JButton builtWithButton = null;
    private JButton copyrightButton = null;
    private JButton titleButton = null;
    private JButton descriptionButton = null;
    private JLabel elementsLabel = null;
    private JLabel errLabel = null;

    public PageDecorationEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.htmlEditorHelper = new HtmlEditorHelper(this, this.getTextArea());
        this.initialize();
    }

    public void setEditedDocument(Object document) {
        this.pageDecoration = (PageDecorationInfo)document;
    }

    public Object getEditedDocument() {
        return this.pageDecoration;
    }

    protected void doSave() {
        try {
            this.pageDecoration.setContent(XMLHelper.buildDocument(this.pageDecoration.getElement(), this.textArea.getText(), this.mainEditor.getEncoding()));
            this.data = this.textArea.getText();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    protected void initEdition() {
        try {
            String str = XMLHelper.valueOf(this.pageDecoration.getContent(), this.mainEditor.getEncoding(), false);
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
            this.textArea.read(new InputStreamReader((InputStream)in, this.mainEditor.getEncoding()), null);
            in.close();
            this.data = this.textArea.getText();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textDisplayer.register(this.titleLabel, this.getDecotationType());
    }

    public void modified(boolean error) {
        if (!this.initializing && this.pageDecoration != null) {
            if (!error) {
                boolean bl = this.isModified = !this.data.equals(this.textArea.getText());
                if (this.isModified) {
                    this.save();
                }
            }
            this.onError = error;
            this.errLabel.setVisible(this.onError);
        }
    }

    boolean validateContent() {
        this.onError = false;
        String value = XMLHelper.addXMLHeader(this.getTextArea().getText(), "header", this.mainEditor.getEncoding());
        try {
            DOMParser parser = new DOMParser();
            parser.setErrorHandler((ErrorHandler)this);
            StringReader reader = new StringReader(value);
            InputSource in = new InputSource(reader);
            parser.parse(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.onError;
    }

    public void error(SAXParseException e) throws SAXException {
        this.errLabel.setText(e.getLineNumber() + " " + e.getLocalizedMessage());
        this.onError = true;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.errLabel.setText(e.getLineNumber() + " " + e.getLocalizedMessage());
        this.onError = true;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.errLabel.setText(e.getLineNumber() + " " + e.getLocalizedMessage());
        this.onError = true;
    }

    private String getDecotationType() {
        if (this.pageDecoration.getDecorationType().equals("Header")) {
            return "decoration.header";
        }
        if (this.pageDecoration.getDecorationType().equals("Left Margin")) {
            return "decoration.left.margin";
        }
        if (this.pageDecoration.getDecorationType().equals("Right Margin")) {
            return "decoration.right.margin";
        }
        if (this.pageDecoration.getDecorationType().equals("Footer")) {
            return "decoration.footer";
        }
        return "editor.title";
    }

    private void initialize() {
        this.errLabel = new JLabel();
        this.errLabel.setIcon(XissWebUI.getIcon("/images/common/error.png"));
        this.errLabel.setFont(new Font("Dialog", 2, 11));
        this.errLabel.setVisible(false);
        this.elementsLabel = new JLabel();
        this.textDisplayer.register(this.elementsLabel, "elements.label");
        this.contentLabel = new JLabel();
        this.contentLabel.setText("content.label");
        this.textDisplayer.register(this.contentLabel, "content.label");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridheight = 1;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 2000.0;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints5.ipady = 0;
        gridBagConstraints5.gridwidth = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(7, 30, 7, 5);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(7, 5, 7, 5);
        this.setPreferredSize(new Dimension(450, 400));
        this.setSize(new Dimension(450, 400));
        this.setMaximumSize(new Dimension(400, 700));
        this.setMinimumSize(new Dimension(400, 700));
        this.addTitle(2, helpDecoration);
        this.add((Component)this.contentLabel, gridBagConstraints);
        this.add((Component)this.errLabel, gridBagConstraints2);
        this.add((Component)this.getElementsPanel(), gridBagConstraints7);
        this.add((Component)this.getTextScrollPane(), gridBagConstraints5);
    }

    void performInsertElement(String text) {
        this.textArea.replaceSelection(text);
        this.modified(this.onError);
    }

    private JScrollPane getTextScrollPane() {
        if (this.textScrollPane == null) {
            this.textScrollPane = new JScrollPane();
            this.textScrollPane.setViewportView(this.getTextArea());
        }
        return this.textScrollPane;
    }

    private JTextPane getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextPane();
            this.textArea.setFont(new Font("Courier New", 0, 12));
            this.textArea.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PageDecorationEditor.this.modified(PageDecorationEditor.this.validateContent());
                }
            });
            this.textArea.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    PageDecorationEditor.this.modified(PageDecorationEditor.this.validateContent());
                }
            });
            this.textArea.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    PageDecorationEditor.this.performMouseClicked(e);
                }
            });
        }
        return this.textArea;
    }

    void performMouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.htmlEditorHelper.showPopupMenu(e);
        }
    }

    private JPanel getElementsPanel() {
        if (this.elementsPanel == null) {
            this.elementsPanel = new JPanel();
            this.elementsPanel.add((Component)this.elementsLabel, null);
            this.elementsPanel.add((Component)this.getTitleButton(), null);
            this.elementsPanel.add((Component)this.getDescriptionButton(), null);
            this.elementsPanel.add((Component)this.getLinkToHomeButton(), null);
            this.elementsPanel.add((Component)this.getBuiltWithButton(), null);
            this.elementsPanel.add((Component)this.getCopyrightButton(), null);
        }
        return this.elementsPanel;
    }

    private JButton getLinkToHomeButton() {
        if (this.linkToHomeButton == null) {
            this.linkToHomeButton = new JButton();
            this.linkToHomeButton.setMargin(new Insets(2, 3, 2, 3));
            this.linkToHomeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageDecorationEditor.this.performInsertElement(PageDecorationEditor.linkToHomeElement);
                }
            });
            this.textDisplayer.register(this.linkToHomeButton, "link.to.home.button");
        }
        return this.linkToHomeButton;
    }

    private JButton getBuiltWithButton() {
        if (this.builtWithButton == null) {
            this.builtWithButton = new JButton();
            this.builtWithButton.setMargin(new Insets(2, 3, 2, 3));
            this.builtWithButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageDecorationEditor.this.performInsertElement(PageDecorationEditor.builtWithElement);
                }
            });
            this.textDisplayer.register(this.builtWithButton, "built.with.button");
        }
        return this.builtWithButton;
    }

    private JButton getCopyrightButton() {
        if (this.copyrightButton == null) {
            this.copyrightButton = new JButton();
            this.copyrightButton.setMargin(new Insets(2, 3, 2, 3));
            this.copyrightButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageDecorationEditor.this.performInsertElement(PageDecorationEditor.copyrightElement);
                }
            });
            this.textDisplayer.register(this.copyrightButton, "copyright.button");
        }
        return this.copyrightButton;
    }

    private JButton getTitleButton() {
        if (this.titleButton == null) {
            this.titleButton = new JButton();
            this.titleButton.setMargin(new Insets(2, 3, 2, 3));
            this.titleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageDecorationEditor.this.performInsertElement(PageDecorationEditor.titleElement);
                }
            });
            this.textDisplayer.register(this.titleButton, "title.button");
        }
        return this.titleButton;
    }

    private JButton getDescriptionButton() {
        if (this.descriptionButton == null) {
            this.descriptionButton = new JButton();
            this.descriptionButton.setMargin(new Insets(2, 3, 2, 3));
            this.descriptionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageDecorationEditor.this.performInsertElement(PageDecorationEditor.descriptionElement);
                }
            });
            this.textDisplayer.register(this.descriptionButton, "description.button");
        }
        return this.descriptionButton;
    }
}

