/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout;

import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.util.tree.AbstractPanelTreeCellRenderer;
import org.xissweb.i18n.TextDisplayer;

public class LayoutTreeCellRenderer
extends AbstractPanelTreeCellRenderer {
    private static final long serialVersionUID = -7777259717192600523L;
    private static final String LAYOUT_INFO_ICON = "/images/layout/layout.gif";
    private static final String LAYOUT_HEADER_ICON = "/images/layout/header.gif";
    private static final String LAYOUT_FOOTER_ICON = "/images/layout/footer.gif";
    private static final String LAYOUT_LEFT_MARGIN_ICON = "/images/layout/leftMargin.gif";
    private static final String LAYOUT_RIGHT_MARGIN_ICON = "/images/layout/rightMargin.gif";
    private static final String LAYOUT_SKIN_ICON = "/images/layout/skin.png";
    private static final String LAYOUT_ANIM_ICON = "/images/layout/animation.png";
    private static final String LAYOUT_THUMBNAILS_INFO_ICON = "/images/layout/thumbnailsInfo.gif";
    private static final String LAYOUT_ARRANGEMENT_H_ICON = "/images/layout/horizontal.gif";
    private static final String LAYOUT_ARRANGEMENT_V_ICON = "/images/layout/vertical.gif";
    private static final String LAYOUT_NAVIGATION_BAR_ICON = "/images/layout/navigationBar.gif";
    private static final String LAYOUT_THUMBNAILS_ICON = "/images/layout/thumbnails.gif";
    private static final String LAYOUT_IMAGE_AREA_ICON = "/images/layout/imageArea.gif";
    private static final String LAYOUT_LOCAL_INDEX_ICON = "/images/layout/localIndex.png";
    private static final String LAYOUT_IMAGE_LOCATION_ON_MAP = "/images/layout/imageLocationOnMap.png";
    private TextDisplayer textDisplayer = new TextDisplayer(this.getClass());

    protected String getStringForNode(DefaultMutableTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof ArrangementInfo) {
            return this.textDisplayer.getString("arrangement") + ' ' + o.toString();
        }
        if (o instanceof AnimationInfo) {
            return this.textDisplayer.getString("animation.kind." + ((AnimationInfo)o).getKind()) + " " + this.textDisplayer.getString("transition." + ((AnimationInfo)o).getTransition().getTransition());
        }
        if (o instanceof ThumbnailsInfoInfo) {
            return this.textDisplayer.getString("thumbnails.info") + ' ' + o.toString();
        }
        if (o instanceof ThumbnailsInfo) {
            return this.textDisplayer.getString("thumbnails") + ' ' + o.toString();
        }
        if (o instanceof PageDecorationInfo) {
            PageDecorationInfo deco = (PageDecorationInfo)o;
            if (deco.isHeader()) {
                return this.textDisplayer.getString("page.decoration.header");
            }
            if (deco.isLeftMargin()) {
                return this.textDisplayer.getString("page.decoration.left.margin");
            }
            if (deco.isRightMargin()) {
                return this.textDisplayer.getString("page.decoration.right.margin");
            }
            if (deco.isFooter()) {
                return this.textDisplayer.getString("page.decoration.footer");
            }
        } else if (o instanceof String) {
            String str = (String)o;
            if (str.equals("Previous")) {
                return this.textDisplayer.getString("navigation.bar.previous");
            }
            if (str.equals("Backward")) {
                return this.textDisplayer.getString("navigation.bar.backward");
            }
            if (str.equals("Init")) {
                return this.textDisplayer.getString("navigation.bar.init");
            }
            if (str.equals("Forward")) {
                return this.textDisplayer.getString("navigation.bar.forward");
            }
            if (str.equals("Next")) {
                return this.textDisplayer.getString("navigation.bar.next");
            }
        } else {
            if (o instanceof ImageAreaInfo) {
                ImageAreaInfo iArea = (ImageAreaInfo)o;
                Object[] args = new Object[]{new Integer(iArea.getWidth()), new Integer(iArea.getHeight()), this.textDisplayer.getString(iArea.getCommentPosition().equals("top") ? "image.area.comment.top" : "image.area.comment.bottom"), this.textDisplayer.getString("image.area.format"), iArea.getNumberFormat()};
                return MessageFormat.format("{0,number,integer}x{1,number,integer}, {2}, {3} \"{4}\"", args);
            }
            if (o instanceof LocationOnMapInfo) {
                return this.textDisplayer.getString("image.locatoin.on.map");
            }
        }
        return o.toString();
    }

    protected ImageIcon getIconFromNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof SlideShowLayoutInfo) {
            return XissWebUI.getIcon(LAYOUT_INFO_ICON);
        }
        if (userObject instanceof PageDecorationInfo) {
            PageDecorationInfo deco = (PageDecorationInfo)userObject;
            if (deco.isHeader()) {
                return XissWebUI.getIcon(LAYOUT_HEADER_ICON);
            }
            if (deco.isLeftMargin()) {
                return XissWebUI.getIcon(LAYOUT_LEFT_MARGIN_ICON);
            }
            if (deco.isRightMargin()) {
                return XissWebUI.getIcon(LAYOUT_RIGHT_MARGIN_ICON);
            }
            if (deco.isFooter()) {
                return XissWebUI.getIcon(LAYOUT_FOOTER_ICON);
            }
        }
        if (userObject instanceof SkinInfo) {
            return XissWebUI.getIcon(LAYOUT_SKIN_ICON);
        }
        if (userObject instanceof AnimationInfo) {
            return XissWebUI.getIcon(LAYOUT_ANIM_ICON);
        }
        if (userObject instanceof ThumbnailsInfoInfo) {
            return XissWebUI.getIcon(LAYOUT_THUMBNAILS_INFO_ICON);
        }
        if (userObject instanceof ArrangementInfo) {
            return ((ArrangementInfo)userObject).isHorizontal() ? XissWebUI.getIcon(LAYOUT_ARRANGEMENT_H_ICON) : XissWebUI.getIcon(LAYOUT_ARRANGEMENT_V_ICON);
        }
        if (userObject instanceof NavigationBarInfo) {
            return XissWebUI.getIcon(LAYOUT_NAVIGATION_BAR_ICON);
        }
        if (userObject instanceof ThumbnailsInfo) {
            return XissWebUI.getIcon(LAYOUT_THUMBNAILS_ICON);
        }
        if (userObject instanceof ImageAreaInfo) {
            return XissWebUI.getIcon(LAYOUT_IMAGE_AREA_ICON);
        }
        if (userObject instanceof LocationOnMapInfo) {
            return XissWebUI.getIcon(LAYOUT_IMAGE_LOCATION_ON_MAP);
        }
        if (userObject instanceof LocalIndexInfo) {
            return XissWebUI.getIcon(LAYOUT_LOCAL_INDEX_ICON);
        }
        return null;
    }
}

