/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.font;

import java.io.File;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.gui.util.tree.TreeModel;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class FontTreeModel
extends TreeModel
implements ContentHandler {
    private static final long serialVersionUID = 2001178112678897272L;
    private static final String FONTS_TAG = "fonts";
    private static final String GENERIC_TAG = "generic";
    private static final String FAMILY_TAG = "family";
    private static final String NAME_ATTRIBUTE = "name";
    private File fontsFile;
    private DefaultMutableTreeNode parentNode;

    public FontTreeModel(File file) {
        super(new DefaultMutableTreeNode(FONTS_TAG));
        this.fontsFile = file;
        this.init();
    }

    protected void init() {
        SAXParser parser = new SAXParser();
        parser.setContentHandler((ContentHandler)this);
        try {
            parser.parse(this.fontsFile.getAbsolutePath());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(FONTS_TAG)) {
            this.parentNode = null;
        } else if (localName.equals(GENERIC_TAG)) {
            this.parentNode = (DefaultMutableTreeNode)this.parentNode.getParent();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals(FONTS_TAG)) {
            this.parentNode = (DefaultMutableTreeNode)this.getRoot();
        } else if (localName.equals(GENERIC_TAG)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(attributes.getValue(NAME_ATTRIBUTE));
            this.parentNode.add(node);
            this.parentNode = node;
        } else if (localName.equals(FAMILY_TAG)) {
            this.parentNode.add(new DefaultMutableTreeNode(attributes.getValue(NAME_ATTRIBUTE)));
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void skippedEntity(String arg0) throws SAXException {
    }

    public void setDocumentLocator(Locator arg0) {
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }
}

