/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content.links;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.data.content.xml.ContentSerializer;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Help;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.content.ContentElementEditorObserver;
import org.xissweb.gui.content.ContentTreeCellEditor;
import org.xissweb.gui.content.links.LinksManagerObserver;
import org.xissweb.gui.content.links.LinksManagerTransferHandler;
import org.xissweb.gui.content.links.LinksManagerTreeCellRenderer;
import org.xissweb.gui.content.links.LinksManagerTreeModel;
import org.xissweb.gui.content.links.LinksTreeUI;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.util.ActiveLabel;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.prefs.ui.SplitPaneConfigurator;
import org.xissweb.produce.links.LinkChangeEvent;
import org.xissweb.produce.links.LinkChangeListener;
import org.xissweb.produce.links.Linker;
import org.xissweb.project.links.LinkedSlideshow;

public class LinksManagerDialog
extends JDialog
implements LinkChangeListener,
ContentElementEditorObserver {
    private static final long serialVersionUID = 6928983133022009591L;
    private static final String HELP_ICON = "/images/common/help.png";
    private static final String LINKS_TITLE_ICON = "/images/links/next-previous.png";
    private static final String LINKS_WARN_ICON = "/images/links/next-previous-warn.png";
    private static final String ICON_CIRCULAR = "/images/links/circular.png";
    private static final String ICON_CIRCULAR_SELECTED = "/images/links/circularSelected.png";
    private static final String ICON_NO_LINK = "/images/links/no-link.png";
    private static final String ICON_NO_LINK_OVER = "/images/links/no-link-over.png";
    private static final String ICON_NEXT_LINK = "/images/links/next-link.png";
    private static final String ICON_NEXT_LINK_OVER = "/images/links/next-link-over.png";
    private static final String ICON_PREVIOUS_LINK = "/images/links/previous-link.png";
    private static final String ICON_PREVIOUS_LINK_OVER = "/images/links/previous-link-over.png";
    private static final String ICON_NEXT_PERVIOUS_LINK = "/images/links/next-previous-link.png";
    private static final String ICON_NEXT_PERVIOUS_LINK_OVER = "/images/links/next-previous-link-over.png";
    private static final String helpLinks = "linksdialog";
    SlideShowContentInfo[] contentInfos;
    private LinksManagerObserver observer;
    LinkedSlideshow linkedSlideshow;
    private SlideShowContentInfo[] contentInfosIni;
    private boolean linkTextModified = false;
    private Comparator invAlpha = new Comparator(){

        public int compare(Object a1, Object a2) {
            SlideShowContentInfo i1 = (SlideShowContentInfo)a1;
            SlideShowContentInfo i2 = (SlideShowContentInfo)a2;
            return i2.getFile().compareTo(i1.getFile());
        }
    };
    private Comparator alpha = new Comparator(){

        public int compare(Object a1, Object a2) {
            SlideShowContentInfo i1 = (SlideShowContentInfo)a1;
            SlideShowContentInfo i2 = (SlideShowContentInfo)a2;
            return i1.getFile().compareTo(i2.getFile());
        }
    };
    private boolean isCircular = false;
    private ContentDeserializer deserializer = new ContentDeserializer();
    private ContentSerializer serializer = new ContentSerializer();
    private TextDisplayer textDisplayer;
    private Linker linker = new Linker();
    private SlideShowContentInfo currentContentInfo = null;
    private JPanel jContentPane = null;
    private JSplitPane mainSplitPane = null;
    private JPanel optionsAndActionsPanel = null;
    private JScrollPane contentFilesScrollPane = null;
    private JPanel footerPanel = null;
    private JButton okButton = null;
    private JPanel headerPanel = null;
    private JLabel titleLabel = null;
    private JCheckBox circularCheckBox = null;
    private JLabel helpLabel = null;
    private JTree slideShowContentsTree = null;
    private JButton resetButton = null;
    private JButton applyButton = null;
    private JPanel applyResetPanel = null;
    private JButton abortButton = null;
    private JPanel optionActionMainPanel = null;
    private ActiveLabel noLinkButton = null;
    private ActiveLabel nextOnlyButton = null;
    private ActiveLabel previousOnlyButton = null;
    private ActiveLabel nextPreviousButton = null;
    private JPopupMenu linkPopupMenu = null;
    private JMenuItem removeLinkMenuItem = null;
    private JPopupMenu slideshoxPopupMenu = null;
    private JMenu addPerviousMenu = null;
    private JMenu addNextMenu = null;
    private DefaultMutableTreeNode currentNodeInAction;
    private int lastLinkType;
    static /* synthetic */ Class class$org$xissweb$gui$content$links$LinksManagerDialog;

    public LinksManagerDialog(JFrame parent) {
        super(parent);
        this.linker.addLinkChangeListener((LinkChangeListener)((Object)Main.get().getEditorsContainer()));
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$content$links$LinksManagerDialog == null ? (class$org$xissweb$gui$content$links$LinksManagerDialog = LinksManagerDialog.class$("org.xissweb.gui.content.links.LinksManagerDialog")) : class$org$xissweb$gui$content$links$LinksManagerDialog);
        this.initialize();
        this.applyPreferences();
        this.setModal(true);
        this.linker.addLinkChangeListener(this);
    }

    public String getTextEncoding() {
        return null;
    }

    public LinksManagerObserver getObserver() {
        return this.observer;
    }

    public void setObserver(LinksManagerObserver observer) {
        this.observer = observer;
    }

    public void open(LinkedSlideshow linkedSlideshow) {
        this.linkedSlideshow = linkedSlideshow;
        this.initSlideShowDirsPresentation();
        TreeHelper.expandAll(this.slideShowContentsTree);
        this.linkTextModified = false;
        this.getApplyButton().setEnabled(false);
        this.getResetButton().setEnabled(false);
        this.setVisible(true);
    }

    void doClose() {
        if (this.getApplyButton().isEnabled()) {
            this.doSaveAll();
        }
        this.contentInfos = null;
        this.setVisible(false);
    }

    void doAbort() {
        this.contentInfos = null;
        this.setVisible(false);
    }

    void doSaveAll() {
        for (int i = 0; i < this.contentInfos.length; ++i) {
            this.serializer.serialize(this.contentInfos[i]);
            File f = this.contentInfos[i].getFile();
            Editor e = Main.get().getEditorsContainer().getEditor(f);
            if (e == null) continue;
            e.reload();
        }
        if (this.observer != null) {
            this.observer.linksChanged(this.contentInfos);
        }
    }

    void doUpdateAllLinks() {
        if (this.lastLinkType == -1) {
            this.performClearLinks();
        } else {
            this.doCreateLinks();
        }
    }

    void doCreateLinks() {
        if (this.lastLinkType != -1) {
            this.performCreateLinks(this.lastLinkType);
        }
    }

    void performCreateLinks(int linkType) {
        this.lastLinkType = linkType;
        this.getCircularCheckBox().setEnabled(true);
        this.linker.link(this.contentInfos, linkType, this.circularCheckBox.isSelected());
    }

    void performClearLinks() {
        this.lastLinkType = -1;
        this.linker.clear(this.contentInfos);
    }

    void doReset() {
        for (int i = 0; i < this.contentInfos.length; ++i) {
            this.contentInfos[i] = this.contentInfosIni[i];
            SlideShowContentInfo contentInfo = this.contentInfos[i];
            contentInfo.setNext(null);
            contentInfo.setPrevious(null);
            SlideShowContentInfo oldCInfo = this.deserializer.deserialize(contentInfo.getFile());
            if (oldCInfo.hasNextLink()) {
                contentInfo.setNext(oldCInfo.getNext().getHref(), oldCInfo.getNext().getText());
            }
            if (!oldCInfo.hasPreviousLink()) continue;
            contentInfo.setPrevious(oldCInfo.getPrevious().getHref(), oldCInfo.getPrevious().getText());
        }
        this.updateTreeChildren();
        this.circularCheckBox.setSelected(this.isCircular);
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    void doApply() {
        this.doSaveAll();
        for (int i = 0; i < this.contentInfos.length; ++i) {
            this.contentInfosIni[i] = this.contentInfos[i];
        }
        this.isCircular = this.circularCheckBox.isSelected();
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    private void linkNodeChanged(SlideShowContentInfo contentInfo) {
        this.getApplyButton().setEnabled(true);
        this.getResetButton().setEnabled(true);
        LinksManagerTreeModel treeModel = (LinksManagerTreeModel)this.slideShowContentsTree.getModel();
        DefaultMutableTreeNode node = treeModel.getNodeFromUserObject(contentInfo);
        node.removeAllChildren();
        treeModel.addChildren(node, contentInfo);
        treeModel.nodeStructureChanged(node);
        TreeHelper.expandNode(this.slideShowContentsTree, node);
    }

    void onKeyTypedOnTree(KeyEvent e) {
        DefaultMutableTreeNode node;
        TreePath tPath;
        if (e.getKeyChar() == 'a') {
            this.setAlphbeticOrder();
        } else if (e.getKeyChar() == 'z') {
            this.setAlphabeticOrderInverse();
        } else if (e.getKeyChar() == '\n' && (tPath = this.slideShowContentsTree.getSelectionPath()) != null && (node = (DefaultMutableTreeNode)tPath.getLastPathComponent()).getUserObject() instanceof SlideShowRefInfo) {
            this.slideShowContentsTree.setEditable(true);
            this.slideShowContentsTree.startEditingAtPath(tPath);
        }
        for (int i = 0; i < this.contentInfos.length; ++i) {
            if (this.contentInfos[i] == this.contentInfosIni[i]) continue;
            this.applyButton.setEnabled(true);
            this.resetButton.setEnabled(true);
            break;
        }
    }

    private void setAlphbeticOrder() {
        Arrays.sort(this.contentInfos, this.alpha);
        this.updateTreeChildren();
        this.updateMenus();
        this.doUpdateAllLinks();
    }

    private void setAlphabeticOrderInverse() {
        Arrays.sort(this.contentInfos, this.invAlpha);
        this.updateTreeChildren();
        this.doUpdateAllLinks();
    }

    private void updateTreeChildren() {
        LinksManagerTreeModel treeModel = (LinksManagerTreeModel)this.slideShowContentsTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        root.removeAllChildren();
        for (int i = 0; i < this.contentInfos.length; ++i) {
            root.add(treeModel.createNode(this.contentInfos[i]));
        }
        treeModel.nodeStructureChanged(root);
        TreeHelper.expandAll(this.slideShowContentsTree);
    }

    private void updateMenus() {
        this.getAddPerviousMenu().removeAll();
        this.getAddNextMenu().removeAll();
        this.initMenus();
    }

    private void initSlideShowDirsPresentation() {
        int i;
        Collection dirs = this.linkedSlideshow.getSlideshows();
        Object[] slideShowDirs = dirs.toArray(new File[dirs.size()]);
        Arrays.sort(slideShowDirs);
        this.contentInfos = new SlideShowContentInfo[slideShowDirs.length];
        for (i = 0; i < slideShowDirs.length; ++i) {
            File file = new File((File)slideShowDirs[i], "slideshow.xml");
            this.contentInfos[i] = this.deserializer.deserialize(file);
        }
        this.contentInfosIni = new SlideShowContentInfo[this.contentInfos.length];
        for (i = 0; i < this.contentInfos.length; ++i) {
            this.contentInfosIni[i] = this.contentInfos[i];
        }
        this.slideShowContentsTree.setModel(new LinksManagerTreeModel(this.contentInfos));
        this.titleLabel.setIcon(XissWebUI.getIcon(this.linkedSlideshow.isConsistent() ? LINKS_TITLE_ICON : LINKS_WARN_ICON));
        this.updateMenus();
    }

    private void initMenus() {
        for (int i = 0; i < this.contentInfos.length; ++i) {
            final SlideShowContentInfo info = this.contentInfos[i];
            String name = info.getFile().getParentFile().getName();
            JMenuItem item = new JMenuItem();
            item.setText(name);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.performAddPrevious(info);
                }
            });
            this.getAddPerviousMenu().add(item);
            item = new JMenuItem();
            item.setText(name);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.performAddNext(info);
                }
            });
            this.getAddNextMenu().add(item);
        }
    }

    void performAddPrevious(SlideShowContentInfo info) {
        SlideShowRefInfo link = this.getLinkInfo(info, "PREVIOUS");
        this.currentContentInfo.setPrevious(link);
        this.linkNodeChanged(this.currentContentInfo);
    }

    void performAddNext(SlideShowContentInfo info) {
        SlideShowRefInfo link = this.getLinkInfo(info, "NEXT");
        this.currentContentInfo.setNext(link);
        this.linkNodeChanged(this.currentContentInfo);
    }

    private SlideShowRefInfo getLinkInfo(SlideShowContentInfo info, String way) {
        File destDir = info.getFile().getParentFile();
        String href = FileHelper.relativeURL((File)this.currentContentInfo.getFile().getParentFile(), (File)destDir);
        return new SlideShowRefInfo(href, destDir.getName(), way);
    }

    public void linkChanged(LinkChangeEvent event) {
        this.linkNodeChanged(event.getContentInfo());
    }

    public void contentFileSaved(LinkChangeEvent event) {
    }

    public void elementEditionEnd(Object editor, DefaultMutableTreeNode node, boolean modified) {
        this.slideShowContentsTree.setEditable(false);
        if (!this.linkTextModified && modified) {
            this.linkTextModified = modified;
            this.getApplyButton().setEnabled(this.linkTextModified);
            this.getResetButton().setEnabled(this.linkTextModified);
        }
    }

    public String getTextEncoding(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        return ((SlideShowContentInfo)parent.getUserObject()).getEncoding();
    }

    private void initialize() {
        this.textDisplayer.registerTitle(this, "title");
        this.setSize(500, 300);
        this.setContentPane(this.getJContentPane());
    }

    private void applyPreferences() {
        ComponentConfigurator.configure((Component)this);
        SplitPaneConfigurator.configure((JSplitPane)this.mainSplitPane, (String)this.getClass().getName());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainSplitPane(), "Center");
            this.jContentPane.add((Component)this.getFooterPanel(), "South");
            this.jContentPane.add((Component)this.getHeaderPanel(), "North");
        }
        return this.jContentPane;
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setDividerSize(3);
            this.mainSplitPane.setDividerLocation(200);
            this.mainSplitPane.setRightComponent(this.getOptionsAndActionsPanel());
            this.mainSplitPane.setLeftComponent(this.getContentFilesScrollPane());
        }
        return this.mainSplitPane;
    }

    private JPanel getOptionsAndActionsPanel() {
        if (this.optionsAndActionsPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(4);
            gridLayout.setColumns(1);
            this.optionsAndActionsPanel = new JPanel();
            this.optionsAndActionsPanel.setLayout(new BorderLayout());
            this.optionsAndActionsPanel.add((Component)this.getOptionActionMainPanel(), "Center");
            this.optionsAndActionsPanel.add((Component)this.getApplyResetPanel(), "South");
        }
        return this.optionsAndActionsPanel;
    }

    private JScrollPane getContentFilesScrollPane() {
        if (this.contentFilesScrollPane == null) {
            this.contentFilesScrollPane = new JScrollPane();
            this.contentFilesScrollPane.setViewportView(this.getSlideShowContentsTree());
        }
        return this.contentFilesScrollPane;
    }

    private JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            FlowLayout flowLayout6 = new FlowLayout();
            flowLayout6.setAlignment(2);
            flowLayout6.setHgap(5);
            this.footerPanel = new JPanel();
            this.footerPanel.setLayout(flowLayout6);
            this.footerPanel.setBorder(BorderFactory.createLineBorder(XissWebUI.mediumDarkColor, 1));
            this.footerPanel.add((Component)this.getOkButton(), null);
            this.footerPanel.add((Component)this.getAbortButton(), null);
        }
        return this.footerPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.textDisplayer.register(this.okButton, "ok.button");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.doClose();
                }
            });
        }
        return this.okButton;
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.helpLabel = new JLabel();
            this.helpLabel.setIcon(XissWebUI.getIcon(HELP_ICON));
            this.helpLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Help.open(LinksManagerDialog.helpLinks);
                }
            });
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            flowLayout1.setHgap(15);
            this.titleLabel = new JLabel();
            this.textDisplayer.register(this.titleLabel, "title.long");
            this.titleLabel.setIcon(XissWebUI.getIcon(LINKS_TITLE_ICON));
            this.titleLabel.setForeground(XissWebUI.darkColor);
            this.titleLabel.setFont(XissWebUI.titleFont);
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(flowLayout1);
            this.headerPanel.add((Component)this.titleLabel, null);
            this.headerPanel.add((Component)this.helpLabel, null);
        }
        return this.headerPanel;
    }

    JCheckBox getCircularCheckBox() {
        if (this.circularCheckBox == null) {
            this.circularCheckBox = new JCheckBox();
            this.circularCheckBox.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent arg0) {
                    LinksManagerDialog.this.doCreateLinks();
                }
            });
            this.circularCheckBox.setIcon(XissWebUI.getIcon(ICON_CIRCULAR));
            this.circularCheckBox.setSelectedIcon(XissWebUI.getIcon(ICON_CIRCULAR_SELECTED));
            this.textDisplayer.register(this.circularCheckBox, "circular.check.box");
        }
        return this.circularCheckBox;
    }

    private JTree getSlideShowContentsTree() {
        if (this.slideShowContentsTree == null) {
            this.slideShowContentsTree = new JTree();
            LinksTreeUI.UI(this.slideShowContentsTree);
            this.slideShowContentsTree.setModel(new LinksManagerTreeModel(null));
            DefaultTreeSelectionModel selM = new DefaultTreeSelectionModel();
            selM.setSelectionMode(1);
            this.slideShowContentsTree.setSelectionModel(selM);
            this.slideShowContentsTree.setCellRenderer(new LinksManagerTreeCellRenderer());
            this.slideShowContentsTree.setDragEnabled(true);
            this.slideShowContentsTree.setCellEditor(new ContentTreeCellEditor(this.slideShowContentsTree, new DefaultTreeCellRenderer(), this));
            this.slideShowContentsTree.setTransferHandler(new LinksManagerTransferHandler(this));
            this.slideShowContentsTree.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    LinksManagerDialog.this.onKeyTypedOnTree(e);
                }
            });
            this.slideShowContentsTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    LinksManagerDialog.this.onMouseCliked(e);
                }
            });
        }
        return this.slideShowContentsTree;
    }

    void onMouseCliked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.currentContentInfo = null;
            this.currentNodeInAction = TreeHelper.getNode(this.slideShowContentsTree, e);
            if (this.currentNodeInAction != null) {
                if (this.currentNodeInAction.getUserObject() instanceof SlideShowContentInfo) {
                    int i;
                    this.currentContentInfo = (SlideShowContentInfo)this.currentNodeInAction.getUserObject();
                    this.getAddPerviousMenu().setEnabled(!this.currentContentInfo.hasPreviousLink());
                    this.getAddNextMenu().setEnabled(!this.currentContentInfo.hasNextLink());
                    if (this.getAddPerviousMenu().isEnabled()) {
                        for (i = 0; i < this.contentInfos.length; ++i) {
                            this.getAddPerviousMenu().getItem(i).setEnabled(this.contentInfos[i] != this.currentContentInfo);
                        }
                    }
                    if (this.getAddNextMenu().isEnabled()) {
                        for (i = 0; i < this.contentInfos.length; ++i) {
                            this.getAddNextMenu().getItem(i).setEnabled(this.contentInfos[i] != this.currentContentInfo);
                        }
                    }
                    this.getSlideshoxPopupMenu().show(this.slideShowContentsTree, e.getX(), e.getY());
                } else if (this.currentNodeInAction.getUserObject() instanceof SlideShowRefInfo) {
                    this.getLinkPopupMenu().show(this.slideShowContentsTree, e.getX(), e.getY());
                }
            }
        }
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.textDisplayer.register(this.resetButton, "reset.button");
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.doReset();
                }
            });
        }
        return this.resetButton;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton();
            this.textDisplayer.register(this.applyButton, "apply.button");
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.doApply();
                }
            });
        }
        return this.applyButton;
    }

    private JPanel getApplyResetPanel() {
        if (this.applyResetPanel == null) {
            FlowLayout flowLayout5 = new FlowLayout();
            flowLayout5.setVgap(5);
            flowLayout5.setAlignment(2);
            flowLayout5.setHgap(5);
            this.applyResetPanel = new JPanel();
            this.applyResetPanel.setLayout(flowLayout5);
            this.applyResetPanel.add((Component)this.getApplyButton(), null);
            this.applyResetPanel.add((Component)this.getResetButton(), null);
        }
        return this.applyResetPanel;
    }

    private JButton getAbortButton() {
        if (this.abortButton == null) {
            this.abortButton = new JButton();
            this.textDisplayer.register(this.abortButton, "abort.button");
            this.abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.doAbort();
                }
            });
        }
        return this.abortButton;
    }

    private JPanel getOptionActionMainPanel() {
        if (this.optionActionMainPanel == null) {
            this.optionActionMainPanel = new JPanel();
            this.optionActionMainPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraintsNoLink = new GridBagConstraints();
            constraintsNoLink.gridx = 0;
            constraintsNoLink.gridy = 0;
            constraintsNoLink.gridwidth = 1;
            constraintsNoLink.anchor = 13;
            constraintsNoLink.insets = new Insets(2, 2, 12, 2);
            GridBagConstraints constraintsNextOnly = new GridBagConstraints();
            constraintsNextOnly.gridx = 0;
            constraintsNextOnly.gridy = 1;
            constraintsNextOnly.insets = new Insets(2, 2, 2, 2);
            constraintsNextOnly.anchor = 13;
            GridBagConstraints constraintsPreviousOnly = new GridBagConstraints();
            constraintsPreviousOnly.gridx = 0;
            constraintsPreviousOnly.gridy = 2;
            constraintsPreviousOnly.anchor = 13;
            constraintsPreviousOnly.insets = new Insets(2, 2, 2, 2);
            GridBagConstraints constraintsNextPrevious = new GridBagConstraints();
            constraintsNextPrevious.gridx = 0;
            constraintsNextPrevious.gridy = 3;
            constraintsNextPrevious.anchor = 13;
            constraintsNextPrevious.insets = new Insets(2, 2, 2, 2);
            GridBagConstraints constraintsCircular = new GridBagConstraints();
            constraintsCircular.gridx = 1;
            constraintsCircular.gridy = 1;
            constraintsCircular.gridheight = 3;
            constraintsCircular.anchor = 17;
            constraintsCircular.insets = new Insets(2, 8, 2, 2);
            this.optionActionMainPanel.add((Component)this.getNoLinkButton(), constraintsNoLink);
            this.optionActionMainPanel.add((Component)this.getNextOnlyButton(), constraintsNextOnly);
            this.optionActionMainPanel.add((Component)this.getNextPreviousButton(), constraintsNextPrevious);
            this.optionActionMainPanel.add((Component)this.getPreviousOnlyButton(), constraintsPreviousOnly);
            this.optionActionMainPanel.add((Component)this.getCircularCheckBox(), constraintsCircular);
        }
        return this.optionActionMainPanel;
    }

    private ActiveLabel getNoLinkButton() {
        if (this.noLinkButton == null) {
            this.noLinkButton = new ActiveLabel();
            this.noLinkButton.setHorizontalTextPosition(2);
            this.noLinkButton.setIcon(XissWebUI.getIcon(ICON_NO_LINK));
            this.noLinkButton.setRolloverIcon(XissWebUI.getIcon(ICON_NO_LINK_OVER));
            this.textDisplayer.register(this.noLinkButton, "kind.no.link");
            this.noLinkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.performClearLinks();
                }
            });
        }
        return this.noLinkButton;
    }

    private ActiveLabel getNextOnlyButton() {
        if (this.nextOnlyButton == null) {
            this.nextOnlyButton = new ActiveLabel();
            this.nextOnlyButton.setHorizontalTextPosition(2);
            this.nextOnlyButton.setIcon(XissWebUI.getIcon(ICON_NEXT_LINK));
            this.nextOnlyButton.setRolloverIcon(XissWebUI.getIcon(ICON_NEXT_LINK_OVER));
            this.textDisplayer.register(this.nextOnlyButton, "kind.next.only");
            this.nextOnlyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    LinksManagerDialog.this.performCreateLinks(0);
                }
            });
        }
        return this.nextOnlyButton;
    }

    private ActiveLabel getPreviousOnlyButton() {
        if (this.previousOnlyButton == null) {
            this.previousOnlyButton = new ActiveLabel();
            this.previousOnlyButton.setHorizontalTextPosition(2);
            this.textDisplayer.register(this.previousOnlyButton, "kind.previous.only");
            this.previousOnlyButton.setIcon(XissWebUI.getIcon(ICON_PREVIOUS_LINK));
            this.previousOnlyButton.setRolloverIcon(XissWebUI.getIcon(ICON_PREVIOUS_LINK_OVER));
            this.previousOnlyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.performCreateLinks(1);
                }
            });
        }
        return this.previousOnlyButton;
    }

    private ActiveLabel getNextPreviousButton() {
        if (this.nextPreviousButton == null) {
            this.nextPreviousButton = new ActiveLabel();
            this.nextPreviousButton.setHorizontalTextPosition(2);
            this.nextPreviousButton.setIcon(XissWebUI.getIcon(ICON_NEXT_PERVIOUS_LINK));
            this.nextPreviousButton.setRolloverIcon(XissWebUI.getIcon(ICON_NEXT_PERVIOUS_LINK_OVER));
            this.textDisplayer.register(this.nextPreviousButton, "kind.next.previous");
            this.nextPreviousButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinksManagerDialog.this.performCreateLinks(2);
                }
            });
        }
        return this.nextPreviousButton;
    }

    private JPopupMenu getLinkPopupMenu() {
        if (this.linkPopupMenu == null) {
            this.linkPopupMenu = new JPopupMenu();
            this.linkPopupMenu.add(this.getRemoveLinkMenuItem());
        }
        return this.linkPopupMenu;
    }

    private JMenuItem getRemoveLinkMenuItem() {
        if (this.removeLinkMenuItem == null) {
            this.removeLinkMenuItem = new JMenuItem();
            this.removeLinkMenuItem.setText("delete.link.menu.item");
            this.textDisplayer.register(this.removeLinkMenuItem, "remove.link.menu.item");
            this.removeLinkMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    LinksManagerDialog.this.performRemoveLink();
                }
            });
        }
        return this.removeLinkMenuItem;
    }

    void performRemoveLink() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.currentNodeInAction.getParent();
        SlideShowContentInfo cInfo = (SlideShowContentInfo)parent.getUserObject();
        SlideShowRefInfo refInfo = (SlideShowRefInfo)this.currentNodeInAction.getUserObject();
        cInfo.removeLink(refInfo);
        this.linkNodeChanged(cInfo);
    }

    private JPopupMenu getSlideshoxPopupMenu() {
        if (this.slideshoxPopupMenu == null) {
            this.slideshoxPopupMenu = new JPopupMenu();
            this.slideshoxPopupMenu.add(this.getAddPerviousMenu());
            this.slideshoxPopupMenu.add(this.getAddNextMenu());
        }
        return this.slideshoxPopupMenu;
    }

    private JMenu getAddPerviousMenu() {
        if (this.addPerviousMenu == null) {
            this.addPerviousMenu = new JMenu();
            this.addPerviousMenu.setText("add.previous.menu.item");
            this.textDisplayer.register(this.addPerviousMenu, "add.previous.menu.item");
        }
        return this.addPerviousMenu;
    }

    private JMenu getAddNextMenu() {
        if (this.addNextMenu == null) {
            this.addNextMenu = new JMenu();
            this.addNextMenu.setText("add.next.menu.item");
            this.textDisplayer.register(this.addNextMenu, "add.next.menu.item");
        }
        return this.addNextMenu;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

