/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import org.xissweb.About;
import org.xissweb.gui.NewVersionDialog;
import org.xissweb.gui.XissEditorManager;
import org.xissweb.gui.XissEditorsContainer;
import org.xissweb.gui.XissWeb;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.content.ContentEditorFactory;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorManager;
import org.xissweb.gui.editor.EditorObserver;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.text.TextEditor;
import org.xissweb.gui.editor.text.TextEditorFactory;
import org.xissweb.gui.layout.LayoutEditorFactory;
import org.xissweb.gui.prefs.ConfigurableEditable;
import org.xissweb.gui.prefs.PreferencesEditionManager;
import org.xissweb.gui.prefs.PreferencesEditorFactory;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.properties.PropertiesEditor;
import org.xissweb.gui.properties.PropertiesEditorFactory;
import org.xissweb.gui.properties.PropertyChangeEvent;
import org.xissweb.gui.properties.PropertyChangeListener;
import org.xissweb.gui.skin.simple.SkinEditorFactory;
import org.xissweb.gui.util.OsNameHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.prefs.PreferencesManager;
import org.xissweb.prefs.ui.ComponentConfigurator;
import org.xissweb.project.SlideShowProject;
import org.xissweb.project.SlideShowProperties;
import org.xissweb.xml.XMLHelper;

public class Main
implements EditorObserver,
PropertyChangeListener,
ConfigurableEditable {
    private static final String latestVersionURL = "http://xissweb.free.fr/version/version.properties";
    private static final String downloadURL = "http://sourceforge.net/project/showfiles.php?group_id=127874";
    private static final String PREFS_ID = "org.xissweb.gui.Main";
    public static final int UP_TO_DATE = 0;
    public static final int YES_DOANLOAD_NEW_VERSION = 1;
    public static final int NEW_VERSION_NO_DOWNLOAD = 2;
    private static final String REMIND_ME_DATE_KEY = "reminde.me.date";
    private static final DateFormat remindDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String SLIDESHOW_EXPLORER_KEY = "slideshow.explorer";
    private static final String PROJECT_KEY = "project";
    private static final String defaultWinWebBrowser = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
    private static final String defaultMacWebBrowser = "open";
    private static final String defaultLinuxWebBrowser = "konqueror";
    private static final String defaultSolarisWebBrowser = "konqueror";
    public static PreferencesManager preferences;
    private static Main instance;
    private String webBrowser;
    private XissWeb xissWeb;
    private EditorManager editorManager;
    private SlideShowProject currentProject;
    private List guiConfigurables = new ArrayList();
    static /* synthetic */ Class class$org$xissweb$gui$Main;
    static /* synthetic */ Class class$org$xissweb$prefs$PreferencesManager;
    static /* synthetic */ Class class$org$xissweb$gui$prefs$PreferencesEditorFactory;

    public static File getExemplesDir() {
        return new File(System.getProperty("user.dir"), "examples");
    }

    public static void main(String[] args) {
        Main.loadPreferences();
        XissWebUI.setDefaultUI();
        Main main = new Main();
        main.initialize();
    }

    private Main() {
        PreferencesEditionManager.get().registerConfigurable(this);
        this.webBrowser = this.getDefaultWebBrowser();
        String explorer = preferences.get(SLIDESHOW_EXPLORER_KEY, "org.xissweb.gui.XissWeb", null);
        if (explorer == null) {
            explorer = preferences.get(SLIDESHOW_EXPLORER_KEY, PREFS_ID, null);
        } else {
            preferences.remove(SLIDESHOW_EXPLORER_KEY, "org.xissweb.gui.XissWeb");
            preferences.put(SLIDESHOW_EXPLORER_KEY, PREFS_ID, explorer);
        }
        if (explorer != null) {
            this.webBrowser = explorer;
        } else {
            preferences.put(SLIDESHOW_EXPLORER_KEY, PREFS_ID, this.webBrowser);
        }
        instance = this;
    }

    public static Main get() {
        return instance;
    }

    public void prefrerenceEdited(PreferenceInfo prefInfo, Object value) {
        if (prefInfo.getKey().equals(SLIDESHOW_EXPLORER_KEY)) {
            this.webBrowser = (String)value;
        }
    }

    public String getDefaultValue(PreferenceInfo prefInfo) {
        if (prefInfo.getKey().equals(SLIDESHOW_EXPLORER_KEY)) {
            return this.getDefaultWebBrowser();
        }
        return null;
    }

    public XissWeb getXissWeb() {
        return this.xissWeb;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public EditorsContainer getEditorsContainer() {
        return this.editorManager.getEditorsContainer();
    }

    public SlideShowProject getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(SlideShowProject project) {
        this.currentProject = project;
        if (project != null) {
            preferences.put(PROJECT_KEY, PREFS_ID, project.getLocation().toString());
        }
    }

    public boolean hasCurrentProject() {
        return this.currentProject != null;
    }

    public void editProperties() {
        File f = this.getCurrentProject().getProperties().getPropertiesFile();
        this.editorManager.openEditor(f.getName(), (Object)f);
    }

    public void editProperties(String arg) {
        File f = this.getCurrentProject().getProperties().getPropertiesFile();
        Editor e = this.getEditorsContainer().getEditor(f);
        if (e == null) {
            this.editorManager.openEditor(f.getName(), (Object)f);
            e = this.getEditorsContainer().getEditor(f);
        }
        e.edit(arg);
    }

    public String getWebBrowser() {
        return this.webBrowser;
    }

    public String getDefaultWebBrowser() {
        String webB = null;
        if (OsNameHelper.isMac()) {
            webB = defaultMacWebBrowser;
        } else if (OsNameHelper.isLinux()) {
            webB = "konqueror";
        } else if (OsNameHelper.isWindows()) {
            webB = defaultWinWebBrowser;
        } else if (OsNameHelper.isSolaris()) {
            webB = "konqueror";
        }
        return webB;
    }

    private void initialize() {
        this.xissWeb = new XissWeb();
        try {
            int response;
            if (this.newVersionDetection() == 1 && (response = JOptionPane.showConfirmDialog(this.xissWeb, TextDisplayer.getString("new.version.download.option.quit", class$org$xissweb$gui$Main == null ? (class$org$xissweb$gui$Main = Main.class$(PREFS_ID)) : class$org$xissweb$gui$Main), TextDisplayer.getString("new.version.download.option.quit.title", class$org$xissweb$gui$Main == null ? (class$org$xissweb$gui$Main = Main.class$(PREFS_ID)) : class$org$xissweb$gui$Main), 0, 3, XissWebUI.getIcon("/images/common/dialog-info.png"))) == 1) {
                System.exit(0);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        ContentEditorFactory cef = new ContentEditorFactory();
        LayoutEditorFactory lef = new LayoutEditorFactory();
        SkinEditorFactory sef = new SkinEditorFactory();
        this.editorManager = new XissEditorManager();
        this.editorManager.setObserver(this);
        XissEditorsContainer editorsContainer = new XissEditorsContainer(this.editorManager);
        this.editorManager.registerEditorFactory("editor.text", new TextEditorFactory());
        this.editorManager.registerEditorFactory("xissweb.properties", new PropertiesEditorFactory());
        this.editorManager.registerEditorFactory("slideshow.xml", cef);
        this.editorManager.registerEditorFactory("layout.xml", lef);
        this.editorManager.registerEditorFactory(class$org$xissweb$prefs$PreferencesManager == null ? (class$org$xissweb$prefs$PreferencesManager = Main.class$("org.xissweb.prefs.PreferencesManager")) : class$org$xissweb$prefs$PreferencesManager, new PreferencesEditorFactory());
        this.editorManager.registerEditorFactory("skin.xml", sef);
        this.editorManager.setEditorsContainer(editorsContainer);
        TextEditor.registerTextEditable("slideshow.xml", cef);
        TextEditor.registerTextEditable("layout.xml", lef);
        TextEditor.registerTextEditable("skin.xml", sef);
        editorsContainer.setGuiComponent(this.xissWeb);
        this.editorManager.setObserver(this);
        this.xissWeb.setEditorManager((XissEditorManager)this.editorManager);
        this.openLastOpenedProject();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.this.getXissWeb().setVisible(true);
            }
        });
    }

    private void openLastOpenedProject() {
        SlideShowProject project = null;
        String location = preferences.get(PROJECT_KEY, "org.xissweb.gui.XissWeb", null);
        if (location == null) {
            location = preferences.get(PROJECT_KEY, PREFS_ID, null);
        } else {
            preferences.remove(PROJECT_KEY, "org.xissweb.gui.XissWeb");
        }
        if (location != null) {
            project = new SlideShowProject(new File(location));
        }
        if (project != null) {
            if (!project.getLocation().exists()) {
                preferences.remove(PROJECT_KEY, PREFS_ID);
            }
            this.xissWeb.openProject(project);
        }
    }

    public void registerGuiConfigurable(ConfigurableEditable guiConf) {
        this.guiConfigurables.add(guiConf);
    }

    private static File getPrefsXsltFile() {
        String path = "upgrades" + File.separator + "prefs.xslt";
        return new File(SlideShowProperties.getRsrcDir(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void convertPreferences(File f) throws IOException {
        ByteArrayOutputStream out;
        BufferedReader reader;
        InputStream in;
        block18: {
            Preferences p = Preferences.userRoot();
            p = p.node("org");
            p = p.node("xissweb");
            try {
                p.removeNode();
            }
            catch (BackingStoreException e1) {
                e1.printStackTrace();
            }
            in = null;
            reader = null;
            out = null;
            BufferedWriter writer = null;
            try {
                try {
                    in = new FileInputStream(f);
                    reader = new BufferedReader(new InputStreamReader(in));
                    String line = reader.readLine();
                    String lineDoc = reader.readLine();
                    if (lineDoc.startsWith("<!DOCTYPE")) {
                        out = new ByteArrayOutputStream();
                        writer = new BufferedWriter(new OutputStreamWriter(out));
                        while (line != null) {
                            writer.write(line);
                            line = reader.readLine();
                        }
                        writer.close();
                        writer = null;
                        out.close();
                        ((InputStream)in).close();
                        in = null;
                        in = new ByteArrayInputStream(out.toByteArray());
                        Transformer transformer = XMLHelper.getTransformer(Main.getPrefsXsltFile());
                        XMLHelper.transform(transformer, new StreamSource(in), f);
                        out = null;
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var10_13 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    if (in == null) return;
                    ((InputStream)in).close();
                    return;
                }
                Object var10_12 = null;
                if (writer == null) break block18;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (writer != null) {
                    writer.close();
                }
                if (out != null) {
                    out.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            writer.close();
        }
        if (out != null) {
            out.close();
        }
        if (reader != null) {
            reader.close();
        }
        if (in == null) return;
        ((InputStream)in).close();
    }

    private static void loadPreferences() {
        preferences = new PreferencesManager();
        ComponentConfigurator.setDefaultPreferenceManager((PreferencesManager)preferences);
        File f = Main.getPreferencesFile();
        if (f.exists()) {
            try {
                Main.convertPreferences(f);
                preferences.load(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Main.savePreferences();
            }
        });
    }

    static void savePreferences() {
        try {
            preferences.store(Main.getPreferencesFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getPreferencesFile() {
        File dir = new File(System.getProperty("user.home") + File.separator + ".xissweb");
        if (!dir.exists()) {
            File oldDir = new File(System.getProperty("user.home") + File.separator + "xissweb");
            if (oldDir.exists()) {
                oldDir.renameTo(dir);
            } else {
                dir.mkdir();
            }
        }
        return new File(dir, ".preferences");
    }

    public void openURL(String url) {
        block2: {
            String cmd = this.getWebBrowser() + " " + url;
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
                Object[] options = new Object[]{TextDisplayer.getString("open.url.faild.yes", this.getClass()), TextDisplayer.getString("open.url.faild.ignor", this.getClass())};
                int result = JOptionPane.showOptionDialog(this.xissWeb, TextDisplayer.getString("open.url.faild.message", this.getClass()), TextDisplayer.getString("open.url.faild.title", this.getClass()), 0, 0, XissWebUI.getIcon("/images/common/explorer.png"), options, null);
                if (result != 0) break block2;
                this.editPreferences();
            }
        }
    }

    public void editPreferences() {
        this.getEditorManager().openEditor(class$org$xissweb$gui$prefs$PreferencesEditorFactory == null ? (class$org$xissweb$gui$prefs$PreferencesEditorFactory = Main.class$("org.xissweb.gui.prefs.PreferencesEditorFactory")) : class$org$xissweb$gui$prefs$PreferencesEditorFactory, (Object)PreferencesEditionManager.get());
    }

    public String getLatestVersion() throws IOException {
        Properties latestVersionProp = new Properties();
        URL url = new URL(latestVersionURL);
        HttpURLConnection httpCnx = (HttpURLConnection)url.openConnection();
        InputStream in = httpCnx.getInputStream();
        latestVersionProp.load(in);
        return latestVersionProp.getProperty("latest.version");
    }

    public boolean isUpToDate(String latestVersion) {
        return About.getVersion().equals(latestVersion);
    }

    public int newVersionDetection() throws IOException {
        return this.newVersionDetection(false);
    }

    public int newVersionDetection(boolean explicitDemand) throws IOException {
        return this.newVersionDetection(this.getLatestVersion(), explicitDemand);
    }

    private int newVersionDetection(String latestVersion, boolean explicitDemand) {
        if (this.isUpToDate(latestVersion)) {
            return 0;
        }
        NewVersionDialog dialog = new NewVersionDialog();
        int result = 0;
        int answer = -1;
        String remindDate = preferences.get(REMIND_ME_DATE_KEY, PREFS_ID, null);
        if (explicitDemand) {
            answer = dialog.showDialog(latestVersion, explicitDemand);
        } else if (remindDate == null || remindDate.compareTo(remindDateFormat.format(new Date())) < 0) {
            answer = dialog.showDialog(latestVersion, explicitDemand);
        }
        switch (answer) {
            case 0: {
                result = 1;
                preferences.remove(REMIND_ME_DATE_KEY, PREFS_ID);
                this.openURL(downloadURL);
                break;
            }
            case 1: {
                result = 2;
                if (explicitDemand) break;
                preferences.put(REMIND_ME_DATE_KEY, PREFS_ID, remindDateFormat.format(new Date()));
            }
        }
        return result;
    }

    public void editorClosed(Editor e) {
        if (e instanceof PropertiesEditor) {
            PropertiesEditor pEdit = (PropertiesEditor)e;
            pEdit.removePropertyChangedListener(this);
        }
    }

    public void editorDocumentSaved(Editor e) {
        if (e instanceof PropertiesEditor) {
            this.xissWeb.updateGuiState();
        }
    }

    public void editorOpenned(Editor e) {
        if (e instanceof PropertiesEditor) {
            PropertiesEditor pEdit = (PropertiesEditor)e;
            pEdit.addPropertyChangedListener(this);
        }
    }

    public void propertyValueChange(PropertyChangeEvent event) {
        if (event.getKey().equals("slideshow.lang")) {
            TextDisplayManager.get().langChangedNoticication();
        } else if (event.getKey().equals("src.root.dir") || event.getKey().equals("repository.root.dir") || event.getKey().equals("origin.root.dir") || event.getKey().equals("exclude.dirs")) {
            this.xissWeb.resetFileTree();
            this.xissWeb.updateGuiState();
        } else {
            this.xissWeb.updateGuiState();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

