/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations.http;

import com.totalvalidator.sgml.Piece;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.http.TestLink;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFileLink
implements TestLink {
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private String contentType;
    private String followLink;

    public TestFileLink(String link, Piece tag, String attribute, String urlOrigin, boolean dontFollow, boolean followLinks, Map<String, List<ValidationProblem>> linksTested) {
        GeneralUtils.LOGGER.info("Testing: " + link);
        link = SPACE_PATTERN.matcher(link).replaceAll("%20");
        try {
            File f = new File(new URI(link));
            if (!f.exists()) {
                tag.setProblemValue(new ValidationProblem("File not found: " + link, ValidationProblem.FILE_NOT_FOUND), attribute);
            } else if (f.isDirectory()) {
                tag.setProblemValue(ValidationProblem.NOT_FILE, attribute);
            } else if (!f.canRead()) {
                tag.setProblemValue(ValidationProblem.FILE_NOT_READABLE, attribute);
            } else {
                if (!dontFollow && (followLinks || link.toLowerCase().startsWith(urlOrigin.toLowerCase() + "/"))) {
                    this.followLink = link;
                }
                this.contentType = FileUtils.getContentType(f);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            tag.setProblemValue(ValidationProblem.newLinkError(404, "Problem with link: " + (message != null ? "no details" : message)), attribute);
        }
        linksTested.put(link, tag.getLinkMessages(new ArrayList<ValidationProblem>()));
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getLink() {
        return this.followLink;
    }
}

