/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations;

import com.totalvalidator.Cancellor;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.validations.Validation;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicValidation
implements Validation {
    @Override
    public void validate(List<Piece> pieces, Cancellor cancellor) throws ValidationException, CancelledException {
        for (Piece tag : pieces) {
            cancellor.isCancelled();
            if (!(tag instanceof Tag) || tag.isVirtual()) continue;
            String element = tag.getStrippedElement();
            if (element == null || element.length() == 0) {
                tag.setProblem(ValidationProblem.EMPTY_TAG);
            }
            if (tag.isEndTag()) {
                if (tag.isSingleton()) {
                    int len = tag.getText().length();
                    tag.setProblem(ValidationProblem.ENDTAG_AND_SINGLETON, len - 1, len);
                }
                if (!tag.hasMatchingTag()) {
                    tag.setProblemElement(ValidationProblem.MISSING_TAG);
                }
                if (tag.getAttributes() == null) continue;
                tag.setProblem(ValidationProblem.END_WITH_ATTRIBUTES);
                continue;
            }
            this.badAttributes(tag);
        }
    }

    private void badAttributes(Piece tag) {
        Map<String, RealAttribute> attributes = tag.getAttributes();
        if (attributes != null) {
            for (String name : attributes.keySet()) {
                RealAttribute attr = attributes.get(name);
                String value = attr.getValue();
                if ((name == null || name.equals("") || name.startsWith("NO_NAME")) && !tag.getStrippedElement().equals("!doctype")) {
                    String val;
                    String string = val = name != null && name.length() > 0 ? value : "";
                    if (val.equals("NO_VAL")) {
                        val = "";
                    }
                    if (val.length() == 0) {
                        tag.setProblem(ValidationProblem.MISSING_ATTR_NAME);
                    } else {
                        tag.setProblemValue(ValidationProblem.MISSING_ATTR_NAME, name);
                    }
                }
                if (value == null || value.trim().length() <= 0) continue;
                char ch = value.charAt(0);
                char ch2 = value.charAt(value.length() - 1);
                if (ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r' || ch == '\f') {
                    tag.setProblem(ValidationProblem.EXTRA_WHITESPACE);
                    continue;
                }
                if (ch2 != ' ' && ch2 != '\n' && ch2 != '\t' && ch2 != '\r' && ch2 != '\f') continue;
                tag.setProblem(ValidationProblem.EXTRA_WHITESPACE);
            }
        }
    }
}

