/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.NotLeafNode;
import com.totalvalidator.utils.StringSort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DirSelector
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String s = File.separator;
    private String directory = "";
    private JViewport jViewport;
    private JTextField showDir;
    private JTree jTree;
    private DefaultTreeModel treeModel;
    private Frame parent;
    private static final String ROOT_NAME = "My Computer";

    public DirSelector(Frame parent, String title, String startDir) {
        super(parent, true);
        this.setResizable(false);
        if (!this.validateDir(startDir)) {
            startDir = System.getProperty("user.dir");
        }
        this.setTitle(title);
        this.initComponents(startDir);
        this.setSize(this.getSize().height, this.getSize().height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private void initComponents(String startDir) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DirSelector.this.directory = null;
                DirSelector.this.setVisible(false);
                DirSelector.this.dispose();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        if (GeneralUtils.isMacOSX()) {
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setHorizontalScrollBarPolicy(32);
        }
        scrollPane.setBackground(new Color(255, 255, 255));
        scrollPane.setViewportBorder(new EmptyBorder(2, 2, 2, 2));
        this.jViewport = scrollPane.getViewport();
        this.jViewport.setScrollMode(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        scrollPane.setMinimumSize(new Dimension(200, 200));
        this.getContentPane().add((Component)scrollPane, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Folder:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.showDir = new JTextField();
        this.showDir.setToolTipText("The current folder");
        this.showDir.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.getContentPane().add((Component)this.showDir, gridBagConstraints);
        JPanel jPanel1 = new JPanel();
        jPanel1.add(new JLabel(" "));
        jPanel1.setOpaque(false);
        JButton ok = new JButton();
        if (GeneralUtils.isMacOSX()) {
            ok.setOpaque(false);
        }
        ok.setText("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirSelector.this.setVisible(false);
                DirSelector.this.dispose();
            }
        });
        jPanel1.add(ok);
        jPanel1.add(new JLabel(" "));
        JButton cancel = new JButton();
        if (GeneralUtils.isMacOSX()) {
            cancel.setOpaque(false);
        }
        cancel.setText("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirSelector.this.directory = null;
                DirSelector.this.setVisible(false);
                DirSelector.this.dispose();
            }
        });
        jPanel1.add(cancel);
        jPanel1.add(new JLabel(" "));
        JButton mkDir = new JButton();
        if (GeneralUtils.isMacOSX()) {
            mkDir.setOpaque(false);
        }
        mkDir.setText("Make New Folder");
        mkDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newFolder = JOptionPane.showInputDialog(DirSelector.this.parent, "Enter the name of the new Folder", "Create New Folder", 3);
                boolean valid = true;
                if (newFolder.charAt(0) == '.') {
                    valid = false;
                } else if (newFolder.indexOf(47) != -1) {
                    valid = false;
                } else if (newFolder.indexOf(92) != -1) {
                    valid = false;
                }
                if (valid) {
                    File folder = null;
                    try {
                        folder = new File(DirSelector.this.directory + s + newFolder);
                        valid = folder.mkdirs();
                    }
                    catch (Exception e) {
                        valid = false;
                    }
                    if (!folder.exists()) {
                        valid = false;
                    }
                }
                if (!valid) {
                    JOptionPane.showMessageDialog(DirSelector.this.parent, "Couldn't create folder '" + newFolder + "'", "New Folder Error", 0);
                } else {
                    NotLeafNode currNode = (NotLeafNode)DirSelector.this.jTree.getLastSelectedPathComponent();
                    int position = 0;
                    int childCount = currNode.getChildCount();
                    if (childCount != 0) {
                        int i;
                        String[] children = new String[childCount + 1];
                        for (i = 0; i < childCount; ++i) {
                            children[i] = (String)((NotLeafNode)currNode.getChildAt(i)).getUserObject();
                        }
                        children[i] = newFolder;
                        StringSort.noCaseSortit(children);
                        ++childCount;
                        for (i = 0; i < childCount && !children[i].equals(newFolder); ++i) {
                        }
                        position = i;
                    }
                    NotLeafNode newNode = new NotLeafNode(newFolder);
                    DirSelector.this.treeModel.insertNodeInto(newNode, currNode, position);
                    DirSelector.this.jTree.setSelectionPath(new TreePath(newNode.getPath()));
                    DirSelector.this.setDirectory(DirSelector.this.directory, true);
                }
            }
        });
        jPanel1.add(mkDir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)jPanel1, gridBagConstraints);
        this.setDirectory(startDir, true);
    }

    private void makeTree(String startDir) {
        int i;
        NotLeafNode currNode;
        File current = new File(startDir);
        try {
            startDir = current.getCanonicalPath();
        }
        catch (IOException e) {
            startDir = current.getAbsolutePath();
        }
        current = new File(startDir);
        String currentName = current.getName();
        if ("".equals(currentName)) {
            currentName = startDir;
        }
        NotLeafNode origNode = currNode = new NotLeafNode(currentName);
        String[] dirList = current.list();
        NotLeafNode newNode = null;
        NotLeafNode lastChildNode = null;
        if (dirList != null) {
            StringSort.noCaseSortit(dirList);
            for (int i2 = 0; i2 < dirList.length; ++i2) {
                File newDir = new File(current, dirList[i2]);
                if (!newDir.isDirectory()) continue;
                newNode = new NotLeafNode(dirList[i2]);
                currNode.add(newNode);
                lastChildNode = newNode;
            }
            currNode.setVisited(true);
        }
        while (current.getParentFile() != null) {
            String cachedName = currentName;
            NotLeafNode cachedNode = currNode;
            currentName = (current = current.getParentFile()).getName();
            if ("".equals(currentName)) {
                currentName = GeneralUtils.isWinNT() ? startDir.substring(0, 3) : startDir.substring(0, 1);
            }
            currNode = new NotLeafNode(currentName);
            dirList = current.list();
            StringSort.noCaseSortit(dirList);
            for (i = 0; i < dirList.length; ++i) {
                File newDir = new File(current, dirList[i]);
                if (!newDir.isDirectory()) continue;
                newNode = dirList[i].equals(cachedName) ? cachedNode : new NotLeafNode(dirList[i]);
                currNode.add(newNode);
            }
            currNode.setVisited(true);
        }
        NotLeafNode rootNode = new NotLeafNode(ROOT_NAME);
        if (GeneralUtils.isWinNT()) {
            String[] drives = this.getDrives();
            for (i = 0; i < drives.length; ++i) {
                newNode = drives[i].equals(currentName) ? currNode : new NotLeafNode(drives[i]);
                rootNode.add(newNode);
            }
        } else {
            rootNode.add(currNode);
        }
        rootNode.setVisited(true);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.jTree = new JTree(this.treeModel);
        TreePath selectedPath = new TreePath(origNode.getPath());
        this.jTree.expandPath(selectedPath);
        this.jTree.setSelectionPath(selectedPath);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent evt) {
                TreePath expPath = evt.getPath();
                DirSelector.this.jTree.setSelectionPath(expPath);
                DirSelector.this.setDirFromPath(expPath, true);
            }

            public void treeCollapsed(TreeExpansionEvent evt) {
                TreePath expPath = evt.getPath();
                DirSelector.this.jTree.setSelectionPath(expPath);
            }
        });
        this.jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
            }

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                TreePath expPath = evt.getPath();
                Object[] nodeArray = expPath.getPath();
                if (nodeArray.length < 2) {
                    throw new ExpandVetoException(evt);
                }
            }
        });
        this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                DirSelector.this.setDirFromPath(evt.getPath(), false);
            }
        });
        this.showDir.setText(this.getDirName(startDir));
        this.jViewport.add(this.jTree);
        this.pack();
        if (lastChildNode != null) {
            this.jTree.scrollPathToVisible(new TreePath(lastChildNode.getPath()));
        }
        this.jTree.scrollPathToVisible(selectedPath);
    }

    private void setDirFromPath(TreePath treePath, boolean updateTree) {
        Object[] nodeArray = treePath.getPath();
        if (nodeArray.length < 2) {
            return;
        }
        NotLeafNode nln = (NotLeafNode)nodeArray[1];
        String newDir = (String)nln.getUserObject();
        if (nodeArray.length > 2) {
            newDir = newDir.substring(0, newDir.length() - 1);
        }
        for (int i = 2; i < nodeArray.length; ++i) {
            nln = (NotLeafNode)nodeArray[i];
            newDir = newDir + s + (String)nln.getUserObject();
        }
        this.showDir.setText(this.getDirName(newDir));
        this.setDirectory(newDir, updateTree);
    }

    private void updateTree(String startDir) {
        TreePath startPath = this.jTree.getSelectionPath();
        NotLeafNode currNode = (NotLeafNode)startPath.getLastPathComponent();
        if (currNode.isVisited()) {
            return;
        }
        String[] dirList = new File(startDir).list();
        if (dirList != null) {
            StringSort.noCaseSortit(dirList);
            for (int i = 0; i < dirList.length; ++i) {
                File newDir = new File(startDir + s + dirList[i]);
                if (!newDir.isDirectory()) continue;
                NotLeafNode newNode = new NotLeafNode(dirList[i]);
                this.treeModel.insertNodeInto(newNode, currNode, currNode.getChildCount());
            }
        }
        currNode.setVisited(true);
        this.showDir.setText(this.getDirName(startDir));
        this.jTree.scrollPathToVisible(startPath);
    }

    private String getDirName(String directory) {
        String name = new File(directory).getName();
        if ("".equals(name)) {
            name = directory;
        }
        return name;
    }

    public String getDirectory() {
        return this.directory;
    }

    public final void setDirectory(String newDir, boolean updateTree) {
        if (this.validateDir(newDir)) {
            try {
                newDir = new File(newDir).getCanonicalPath();
            }
            catch (IOException e) {
                newDir = new File(newDir).getAbsolutePath();
            }
            this.directory = newDir;
            if (this.jTree == null) {
                this.makeTree(this.directory);
            } else if (updateTree) {
                this.updateTree(this.directory);
            }
        }
    }

    private boolean validateDir(String dir) {
        try {
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                return false;
            }
            if (!dirFile.isDirectory()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String[] getDrives() {
        File[] roots = File.listRoots();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < roots.length; ++i) {
            String rootDrive = roots[i].getPath();
            if (!this.validateDir(rootDrive)) continue;
            l.add(rootDrive);
        }
        return l.toArray(new String[l.size()]);
    }
}

