/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.hotedit.html.clientside;

import dk.hfalk.db.DBHotSpotGroup;
import dk.hfalk.hotedit.html.clientside.SaveHTMLAction;
import dk.hfalk.hotedit.html.clientside.util.HTMLCompositor;
import dk.hfalk.hotedit.util.HotEditPlugIn;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;

public class JHTMLTextAreaDialog
extends JFrame
implements ActionListener,
KeyListener,
ClipboardOwner {
    public JTextPane textAreaControl;
    JScrollPane scroller;
    String actionCommand = "Cancel";
    String actionText;
    boolean writeable;
    String helpId;
    JFrame frame;
    public static final Border loweredBorder = new SoftBevelBorder(1);
    JButton okButton;
    JButton cancelButton;
    JButton saveButton;
    DBHotSpotGroup group;

    public JHTMLTextAreaDialog(JFrame jFrame, String string, String string2, boolean bl, DBHotSpotGroup dBHotSpotGroup) {
        super(string);
        this.frame = jFrame;
        this.actionText = string2;
        this.writeable = bl;
        this.group = dBHotSpotGroup;
        this.enableEvents(64L);
        this.getContentPane().setLayout(new CardLayout(10, 10));
        this.getContentPane().setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(string2));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(5, 5)));
        this.textAreaControl = new JTextPane();
        this.textAreaControl.setFont(new Font("Courier", 0, 12));
        this.textAreaControl.addKeyListener(this);
        this.scroller = new JScrollPane(20, 30);
        JViewport jViewport = this.scroller.getViewport();
        jViewport.add(this.textAreaControl);
        jViewport.revalidate();
        jViewport.setBackingStoreEnabled(true);
        jPanel2.add(this.scroller);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "JHTMLTextAreaDialogL_CopyToClipboard"));
        jButton.addActionListener(this);
        jButton.addKeyListener(this);
        jPanel3.add(jButton);
        this.saveButton = new JButton(HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "JHTMLTextAreaDialogL_Generate"));
        this.saveButton.addActionListener(this);
        this.saveButton.addKeyListener(this);
        jPanel3.add(this.saveButton);
        this.okButton = new JButton(HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "Common_Close"));
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        jPanel3.add(this.okButton);
        jPanel.add("Center", jPanel2);
        jPanel.add("South", jPanel3);
        this.getContentPane().add("Center", jPanel);
        ((Component)this).setSize(500, 400);
        if (!this.writeable) {
            this.okButton.requestFocus();
        } else {
            this.textAreaControl.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "Common_Close").equals(string)) {
            this.actionCommand = "Cancel";
            ((Component)this).setVisible(false);
            this.dispose();
        }
        if (HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "JHTMLTextAreaDialogL_Generate").equals(string)) {
            this.actionCommand = "Save";
            this.okButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            object = new SaveHTMLAction();
            ((SaveHTMLAction)object).actionPerformed(null);
            JOptionPane.showMessageDialog(this.getContentPane(), HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "JHTMLTextAreaDialogL_GenerateHTML"), HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "Common_InformationMessage"), 1);
            this.okButton.setEnabled(true);
            this.saveButton.setEnabled(true);
        }
        if (string.equals(HotEditPlugIn.getResource("dk.hfalk.hotedit.html.clientside.ClientSideHTMLPlugInL", "JHTMLTextAreaDialogL_CopyToClipboard"))) {
            object = new ByteArrayOutputStream();
            HTMLCompositor hTMLCompositor = new HTMLCompositor();
            hTMLCompositor.compose((ByteArrayOutputStream)object, this.group);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(((ByteArrayOutputStream)object).toString()), this);
            try {
                ((ByteArrayOutputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getCommand() {
        return this.actionCommand;
    }

    public synchronized String getText() {
        return this.textAreaControl.getText();
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.actionCommand = "Cancel";
                ((Component)this).setVisible(false);
                this.dispose();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.actionCommand = "Cancel";
                ((Component)this).setVisible(false);
                this.dispose();
                break;
            }
        }
    }

    public void setCaretPosition(int n) {
        this.textAreaControl.setCaretPosition(n);
    }

    public synchronized void setText(String string) {
        this.textAreaControl.setText(string);
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

