/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GLog;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GLogMouseAdapter;
import net.geocentral.geometria.view.GLogPopupMenu;
import net.geocentral.geometria.view.GToolBarHandler;
import net.geocentral.geometria.view.LogRecordRenderer;
import org.apache.log4j.Logger;

public class GLogPane
extends JPanel {
    private GSolution document;
    private JList actionList;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public void documentChanged(GSolution document) {
        if (document != this.document) {
            this.document = document;
            this.layoutComponents(document.getLog());
        }
    }

    private void layoutComponents(GLog log) {
        logger.info((Object)"");
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JPanel upperPane = new JPanel();
        upperPane.setLayout(new BoxLayout(upperPane, 0));
        upperPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        upperPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        upperPane.add(new JLabel(GDictionary.get("SolutionLog", new String[0])));
        upperPane.add(Box.createHorizontalGlue());
        JToolBar toolBar = GToolBarHandler.getInstance().getToolBar("Log");
        upperPane.add(toolBar);
        this.add(upperPane);
        this.createActionList();
        this.actionList.setModel(log.getModel());
        log.setSelectionModel(this.actionList.getSelectionModel());
        this.actionList.setCellRenderer(new LogRecordRenderer(log));
        JScrollPane sp = new JScrollPane(this.actionList);
        this.add(sp);
    }

    private void createActionList() {
        this.actionList = new JList(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent event) {
                ListModel model = this.getModel();
                if (model.getSize() < 1) {
                    return null;
                }
                int index = this.locationToIndex(event.getPoint());
                GLoggable action = (GLoggable)model.getElementAt(index);
                return action.getComments();
            }
        };
        new GLogMouseAdapter(this, this.actionList);
    }

    public void popupMenu(MouseEvent event) {
        Point point = event.getPoint();
        int index = this.actionList.locationToIndex(point);
        GLoggable action = (GLoggable)this.actionList.getModel().getElementAt(index);
        GLogPopupMenu popup = new GLogPopupMenu(action);
        popup.show(this, point.x, point.y);
    }
}

