/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.event.GDocumentModifiedEvent;
import net.geocentral.geometria.event.GEventHandler;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.view.GFigurePane;
import org.apache.log4j.Logger;

public class GFiguresPane
extends JTabbedPane
implements ChangeListener {
    private GEventHandler eventHandler = new GEventHandler();
    private GDocument document;
    public static final int SCROLL_INCREMENT = 15;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GFiguresPane() {
        this.eventHandler.addListener(GDocumentHandler.getInstance());
        this.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return;
        }
        logger.info((Object)index);
        String title = this.getTitleAt(index);
        this.document.setSelectedFigure(title);
        this.eventHandler.fireEvent(new GDocumentModifiedEvent(this));
    }

    public void documentChanged(GDocument document) {
        this.document = document;
        this.removeChangeListener(this);
        this.removeAll();
        int selectedIndex = -1;
        int i = 0;
        Iterator<GFigure> it = document.getFigureIterator();
        while (it.hasNext()) {
            GFigure figure = it.next();
            this.addFigure(figure);
            if (figure.isSelected()) {
                selectedIndex = i;
            }
            ++i;
        }
        if (selectedIndex >= 0) {
            this.removeChangeListener(this);
            this.setSelectedIndex(selectedIndex);
        }
        this.addChangeListener(this);
    }

    public void selectionChanged() {
        int index = 0;
        Iterator<GFigure> it = this.document.getFigureIterator();
        while (it.hasNext()) {
            GFigure figure = it.next();
            if (figure.isSelected()) {
                this.removeChangeListener(this);
                this.setSelectedIndex(index);
                this.addChangeListener(this);
                return;
            }
            ++index;
        }
    }

    public Component addFigure(GFigure figure, int index) {
        logger.info((Object)(figure.getName() + ", " + index));
        this.removeChangeListener(this);
        GFigurePane figurePane = new GFigurePane(figure);
        JScrollPane sp = new JScrollPane(figurePane);
        sp.getVerticalScrollBar().setUnitIncrement(15);
        sp.getHorizontalScrollBar().setUnitIncrement(15);
        figurePane.setViewPort(sp.getViewport());
        Component tab = this.add((Component)sp, index);
        this.setTitleAt(index, figure.getName());
        this.setSelectedComponent(tab);
        this.addChangeListener(this);
        return tab;
    }

    public Component addFigure(GFigure figure) {
        logger.info((Object)figure.getName());
        return this.addFigure(figure, this.getTabCount());
    }

    public void removeFigure(String figureName) {
        logger.info((Object)figureName);
        this.removeChangeListener(this);
        for (int i = 0; i < this.getTabCount(); ++i) {
            String n = this.getTitleAt(i);
            if (!n.equals(figureName)) continue;
            this.remove(i);
            break;
        }
        this.addChangeListener(this);
    }

    public void removeAllFigures() {
        logger.info((Object)"");
        this.removeChangeListener(this);
        this.removeAll();
        this.addChangeListener(this);
    }

    public void renameFigure(String oldName, String newName) {
        logger.info((Object)(oldName + ", " + newName));
        this.removeChangeListener(this);
        for (int i = 0; i < this.getTabCount(); ++i) {
            String name = this.getTitleAt(i);
            if (!name.equals(oldName)) continue;
            this.setTitleAt(i, newName);
            break;
        }
        this.addChangeListener(this);
    }
}

