/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer.condition;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.condition.GPlaneCondition;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GPointSetUtils;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GNotThroughPointCondition
implements GPlaneCondition {
    private Point3d coords;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("coords");
        if (ns.getLength() != 1) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        String coordsString = ns.item(0).getTextContent();
        this.coords = GStringUtils.coordsFromString(coordsString);
        if (this.coords == null) {
            logger.error((Object)coordsString);
            throw new Exception();
        }
    }

    @Override
    public void validate(String valueString, GDocument document) throws Exception {
        logger.info((Object)valueString);
        GFigure figure = document.getSelectedFigure();
        Point3d[] cs = GPointSetUtils.fromString(valueString, figure);
        if (cs.length < 1) {
            logger.info((Object)cs.length);
            throw new Exception(GDictionary.get("EnterRefPoint", new String[0]));
        }
        if (cs.length > 1) {
            logger.info((Object)cs.length);
            throw new Exception(GDictionary.get("EnterNoMoreThan1RefPoint", new String[0]));
        }
        this.coords = cs[0];
    }

    @Override
    public boolean verify(Point3d[] cs, GDocument document) {
        logger.info(Arrays.asList(cs));
        Vector3d n = GMath.cross(cs[0], cs[1], cs[2]);
        n.normalize();
        return !GMath.isInPlane(this.coords, cs[0], n);
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<condition>");
        buf.append("\n<type>notThroughPoint</type>");
        buf.append("\n<coords>");
        buf.append(GStringUtils.coordsToString(this.coords));
        buf.append("</coords>");
        buf.append("\n</condition>");
    }

    @Override
    public String getStringValue() {
        return GStringUtils.coordsToString(this.coords);
    }

    @Override
    public String getDescription() {
        return GDictionary.get("NotThroughPoint", new String[0]);
    }
}

