/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GToggleTransparencyAction
implements GUndoable {
    private String figureName;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        this.figureName = figure.getName();
        figure.toggleTransparency();
        documentHandler.setDocumentModified(true);
        logger.info((Object)(this.figureName + ", " + figure.isTransparent()));
        return true;
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getFigure(this.figureName);
        figure.toggleTransparency();
        logger.info((Object)(this.figureName + ", " + figure.isTransparent()));
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("toggleTransparency", new String[0]);
    }
}

