/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GMeasurement;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GMeasureDistanceDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GMeasureDistanceAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String p1Label;
    private String p2Label;
    private String variableName;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GMeasureDistanceDialog dialog = new GMeasureDistanceDialog(documentHandler.getOwnerFrame(), this);
            dialog.prefill(this.p1Label, this.p2Label);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        document.setSelectedFigure(this.figureName);
        document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.p1Label + ", " + this.p2Label + ", " + this.variableName));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        GSelectable element;
        logger.info(selection);
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 1 && (element = it.next()) instanceof GStick) {
            this.p1Label = ((GStick)element).label1;
            this.p2Label = ((GStick)element).label2;
        }
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d) {
                this.p1Label = ((GPoint3d)element1).getLabel();
                this.p2Label = ((GPoint3d)element2).getLabel();
            }
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        if (this.p1Label.length() == 0 || this.p2Label.length() == 0) {
            logger.info((Object)("No end points: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
        }
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getFigure(this.figureName);
        GSolid solid = figure.getSolid();
        GPoint3d p1 = solid.getPoint(this.p1Label);
        if (p1 == null) {
            logger.info((Object)("No point: " + this.p1Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p1Label));
        }
        GPoint3d p2 = solid.getPoint(this.p2Label);
        if (p2 == null) {
            logger.info((Object)("No point: " + this.p2Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p2Label));
        }
        if (p1 == p2) {
            logger.info((Object)("Equal points: " + p1 + ", " + p2));
            throw new Exception(GDictionary.get("EndPointsCannotBeEqual", new String[0]));
        }
        Collection<GFace> faces = solid.facesThroughPoints(new String[]{this.p1Label, this.p2Label});
        if (faces.isEmpty()) {
            logger.info((Object)("Not in the same face: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("PointsDoNotBelongToSameFace", this.p1Label, this.p2Label, this.figureName));
        }
        if (this.variableName.length() == 0) {
            logger.info((Object)"No variable");
            throw new Exception(GDictionary.get("EnterVariable", new String[0]));
        }
        if (Arrays.asList(GVariable.RESERVED).contains(this.variableName.toLowerCase())) {
            logger.info((Object)("Reserved variable: " + this.variableName));
            throw new Exception(GDictionary.get("ReservedVariable", this.variableName));
        }
        if (!this.variableName.matches("[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*")) {
            logger.info((Object)("Bad variable: " + this.variableName));
            throw new Exception(GDictionary.get("InvalidVariable", this.variableName));
        }
        if (document.getVariable(this.variableName) != null) {
            logger.info((Object)("Duplicate variable: " + this.variableName));
            throw new Exception(GDictionary.get("DuplicateVariable", this.variableName));
        }
        double distance = p1.coords.distance(p2.coords);
        GNotepadVariable variable = new GNotepadVariable(this.variableName, distance);
        String[] labels = new String[]{this.p1Label, this.p2Label};
        GMeasurement measurement = GMeasurement.newDistance(labels, this.figureName);
        GNotepadRecord record = new GNotepadRecord(variable, measurement);
        GNotepad notepad = document.getNotepad();
        notepad.add(record);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        GNotepad notepad = document.getNotepad();
        notepad.removeLastRecord();
        logger.info((Object)(this.figureName + ", " + this.p1Label + ", " + this.p2Label + ", " + this.variableName));
    }

    @Override
    public GLoggable clone() {
        GMeasureDistanceAction action = new GMeasureDistanceAction();
        action.figureName = this.figureName;
        action.p1Label = this.p1Label;
        action.p2Label = this.p2Label;
        action.variableName = this.variableName;
        return action;
    }

    @Override
    public String toLogString() {
        StringBuffer buf = new StringBuffer();
        buf.append(GDictionary.get("MeasureDistanceInFigure", this.variableName, this.p1Label + this.p2Label, this.figureName));
        return String.valueOf(buf);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figureName");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.p1Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.p2Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("variableName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No variable name");
            throw new Exception();
        }
        this.variableName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p1Label>").append(this.p1Label).append("</p1Label>").append("\n<p2Label>").append(this.p2Label).append("</p2Label>").append("\n<variableName>").append(this.variableName).append("</variableName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p1String, String p2String, String variableName) {
        logger.info((Object)(p1String + ", " + p2String + ", " + variableName));
        this.p1Label = p1String.toUpperCase();
        this.p2Label = p2String.toUpperCase();
        this.variableName = variableName;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("measureDistance", this.p1Label + this.p2Label);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

