/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Set;
import net.geocentral.geometria.action.GDivideAngleAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GDivideAngleDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GDrawBisectorAction
extends GDivideAngleAction {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block6: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    logger.error((Object)GStringUtils.stackTraceToString(exception));
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GDivideAngleDialog dialog = new GDivideAngleDialog(documentHandler.getOwnerFrame(), this, false);
                dialog.prefill(this.pLabels[0], this.pLabels[1], this.pLabels[2], this.numeratorString, this.denominatorString);
                dialog.setVisible(true);
                if (dialog.getResult()) break block6;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        return true;
    }

    @Override
    protected void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        super.prefill(selection);
        this.numeratorString = "1";
        this.denominatorString = "1";
    }

    @Override
    public GLoggable clone() {
        GDrawBisectorAction action = new GDrawBisectorAction();
        action.figureName = this.figureName;
        action.numeratorString = this.numeratorString;
        action.denominatorString = this.denominatorString;
        action.pLabels = new String[3];
        for (int i = 0; i < 3; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("DrawBisectorOfAngle", this.pLabels[1] + this.pLabels[0] + this.pLabels[2], this.figureName);
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        this.numeratorString = "1";
        this.denominatorString = "1";
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>");
        buf.append("\n<className>");
        buf.append(this.getClass().getSimpleName());
        buf.append("</className>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        buf.append("\n<p0Label>");
        buf.append(this.pLabels[0]);
        buf.append("</p0Label>");
        buf.append("\n<p1Label>");
        buf.append(this.pLabels[1]);
        buf.append("</p1Label>");
        buf.append("\n<p2Label>");
        buf.append(this.pLabels[2]);
        buf.append("</p2Label>");
        buf.append("\n</action>");
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("drawBisectorOfAngle", this.pLabels[1] + this.pLabels[0] + this.pLabels[2]);
    }
}

