/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class PolicySecurityController
extends SecurityController {
    private static final byte[] secureCallerImplBytecode = PolicySecurityController.loadBytecode();
    private static final Map<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>> callers = new WeakHashMap<CodeSource, Map<ClassLoader, SoftReference<SecureCaller>>>();

    @Override
    public Class<?> getStaticSecurityDomainClassInternal() {
        return CodeSource.class;
    }

    @Override
    public GeneratedClassLoader createClassLoader(final ClassLoader classLoader, final Object object) {
        return (Loader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Loader(classLoader, (CodeSource)object);
            }
        });
    }

    @Override
    public Object getDynamicSecurityDomain(Object object) {
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callWithDomain(Object object, final Context context, Callable callable, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Map<ClassLoader, SoftReference<SecureCaller>> map;
        final ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getApplicationClassLoader();
            }
        });
        final CodeSource codeSource = (CodeSource)object;
        Object object2 = callers;
        synchronized (object2) {
            map = callers.get(codeSource);
            if (map == null) {
                map = new WeakHashMap<ClassLoader, SoftReference<SecureCaller>>();
                callers.put(codeSource, map);
            }
        }
        Map<ClassLoader, SoftReference<SecureCaller>> map2 = map;
        synchronized (map2) {
            SoftReference<SecureCaller> softReference = map.get(classLoader);
            object2 = softReference != null ? softReference.get() : null;
            if (object2 == null) {
                try {
                    object2 = (SecureCaller)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Loader loader = new Loader(classLoader, codeSource);
                            Class<?> clazz = loader.defineClass(String.valueOf(SecureCaller.class.getName()) + "Impl", secureCallerImplBytecode);
                            return clazz.newInstance();
                        }
                    });
                    map.put(classLoader, new SoftReference<Object>(object2));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new UndeclaredThrowableException(privilegedActionException.getCause());
                }
            }
        }
        return ((SecureCaller)object2).call(callable, context, scriptable, scriptable2, objectArray);
    }

    private static byte[] loadBytecode() {
        String string = SecureCaller.class.getName();
        ClassFileWriter classFileWriter = new ClassFileWriter(String.valueOf(string) + "Impl", string, "<generated>");
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke(183, string, "<init>", "()V");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
        String string2 = "Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;";
        classFileWriter.startMethod("call", "(Lorg/mozilla/javascript/Callable;" + string2, (short)17);
        int n = 1;
        while (n < 6) {
            classFileWriter.addALoad(n);
            ++n;
        }
        classFileWriter.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(" + string2);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)6);
        return classFileWriter.toByteArray();
    }

    private static class Loader
    extends SecureClassLoader
    implements GeneratedClassLoader {
        private final CodeSource codeSource;

        Loader(ClassLoader classLoader, CodeSource codeSource) {
            super(classLoader);
            this.codeSource = codeSource;
        }

        @Override
        public Class<?> defineClass(String string, byte[] byArray) {
            return this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
        }

        @Override
        public void linkClass(Class<?> clazz) {
            this.resolveClass(clazz);
        }
    }

    public static abstract class SecureCaller {
        public abstract Object call(Callable var1, Context var2, Scriptable var3, Scriptable var4, Object[] var5);
    }
}

