/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class JavaMembers {
    private Class<?> cl;
    private Map<String, Object> members;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private Map<String, Object> staticMembers;
    private Map<String, FieldAndMethods> staticFieldAndMethods;
    MemberBox[] ctors;
    private boolean includePrivate;

    JavaMembers(Scriptable scriptable, Class<?> clazz) {
        this(scriptable, clazz, false);
    }

    JavaMembers(Scriptable scriptable, Class<?> clazz, boolean bl) {
        try {
            Context context = ContextFactory.getGlobal().enterContext();
            ClassShutter classShutter = context.getClassShutter();
            if (classShutter != null && !classShutter.visibleToScripts(clazz.getName())) {
                throw Context.reportRuntimeError1("msg.access.prohibited", clazz.getName());
            }
            this.includePrivate = context.hasFeature(13);
            this.members = new HashMap<String, Object>();
            this.staticMembers = new HashMap<String, Object>();
            this.cl = clazz;
            this.reflect(scriptable, bl);
        }
        finally {
            Context.exit();
        }
    }

    boolean has(String string, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object = map.get(string);
        if (object != null) {
            return true;
        }
        return this.findExplicitFunction(string, bl) != null;
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object3 = map.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        Context context = Context.getContext();
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                if (beanProperty.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                object2 = beanProperty.getter.invoke(object, Context.emptyArgs);
                clazz = beanProperty.getter.method().getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrap(context, scriptable, object2, clazz);
    }

    void put(Scriptable scriptable, String string, Object object, Object object2, boolean bl) {
        Object object3;
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object4 = map.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)map.get(string);
            object4 = ((FieldAndMethods)object3).field;
        }
        if (object4 instanceof BeanProperty) {
            object3 = (BeanProperty)object4;
            if (((BeanProperty)object3).setter == null) {
                throw this.reportMemberNotFound(string);
            }
            if (((BeanProperty)object3).setters == null || object2 == null) {
                Class<?> clazz = ((BeanProperty)object3).setter.argTypes[0];
                Object[] objectArray = new Object[]{Context.jsToJava(object2, clazz)};
                try {
                    ((BeanProperty)object3).setter.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    throw Context.throwAsScriptRuntimeEx(exception);
                }
            } else {
                Object[] objectArray = new Object[]{object2};
                ((BeanProperty)object3).setters.call(Context.getContext(), ScriptableObject.getTopLevelScope(scriptable), scriptable, objectArray);
            }
        } else {
            if (!(object4 instanceof Field)) {
                object3 = object4 == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1((String)object3, string);
            }
            object3 = (Field)object4;
            Object object5 = Context.jsToJava(object2, ((Field)object3).getType());
            try {
                ((Field)object3).set(object, object5);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ((((Field)object3).getModifiers() & 0x10) != 0) {
                    return;
                }
                throw Context.throwAsScriptRuntimeEx(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", object2.getClass().getName(), object3, object.getClass().getName());
            }
        }
    }

    Object[] getIds(boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        return map.keySet().toArray(new Object[map.size()]);
    }

    static String javaSignature(Class<?> clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        String string = clazz.getName();
        String string2 = "[]";
        if (n == 1) {
            return string.concat(string2);
        }
        int n2 = string.length() + n * string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        while (n != 0) {
            --n;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String liveConnectSignature(Class<?>[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 != n) {
            if (n2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(JavaMembers.javaSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private MemberBox findExplicitFunction(String string, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        int n = string.indexOf(40);
        if (n < 0) {
            return null;
        }
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        MemberBox[] memberBoxArray = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            memberBoxArray = this.ctors;
        } else {
            String string2 = string.substring(0, n);
            object2 = map.get(string2);
            if (!bl && object2 == null) {
                object2 = this.staticMembers.get(string2);
            }
            if (object2 instanceof NativeJavaMethod) {
                object = (NativeJavaMethod)object2;
                memberBoxArray = ((NativeJavaMethod)object).methods;
            }
        }
        if (memberBoxArray != null) {
            int n2 = 0;
            while (n2 < memberBoxArray.length) {
                object2 = memberBoxArray[n2].argTypes;
                object = JavaMembers.liveConnectSignature(object2);
                if (n + ((String)object).length() == string.length() && string.regionMatches(n, (String)object, 0, ((String)object).length())) {
                    return memberBoxArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Map<String, Object> map = bl ? this.staticMembers : this.members;
        Object object2 = null;
        MemberBox memberBox = this.findExplicitFunction(string, bl);
        if (memberBox != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (memberBox.isCtor()) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor(memberBox);
                nativeJavaConstructor.setPrototype(scriptable2);
                object2 = nativeJavaConstructor;
                map.put(string, nativeJavaConstructor);
            } else {
                String string2 = memberBox.getName();
                object2 = map.get(string2);
                if (object2 instanceof NativeJavaMethod && ((NativeJavaMethod)object2).methods.length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod(memberBox, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    map.put(string, nativeJavaMethod);
                    object2 = nativeJavaMethod;
                }
            }
        }
        return object2;
    }

    private static Method[] discoverAccessibleMethods(Class<?> clazz, boolean bl, boolean bl2) {
        HashMap<MethodSignature, Method> hashMap = new HashMap<MethodSignature, Method>();
        JavaMembers.discoverAccessibleMethods(clazz, hashMap, bl, bl2);
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private static void discoverAccessibleMethods(Class<?> var0, Map<MethodSignature, Method> var1_1, boolean var2_2, boolean var3_3) {
        if (Modifier.isPublic(var0.getModifiers()) || var3_3) {
            try {
                if (var2_2 || var3_3) {
                    while (var0 != null) {
                        try {
                            var4_4 = var0.getDeclaredMethods();
                            var5_7 = 0;
                            while (var5_7 < var4_4.length) {
                                var6_11 = var4_4[var5_7];
                                var7_13 = var6_11.getModifiers();
                                if (Modifier.isPublic(var7_13) || Modifier.isProtected(var7_13) || var3_3) {
                                    if (var3_3) {
                                        var6_11.setAccessible(true);
                                    }
                                    var1_1.put(new MethodSignature(var6_11), var6_11);
                                }
                                ++var5_7;
                            }
                            var0 = var0.getSuperclass();
                            continue;
                        }
                        catch (SecurityException v0) {
                            var4_4 = var0.getMethods();
                            var5_7 = 0;
                            ** while (var5_7 < var4_4.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var6_11 = var4_4[var5_7];
                            var7_14 = new MethodSignature(var6_11);
                            if (var1_1.get(var7_14) == null) {
                                var1_1.put(var7_14, var6_11);
                            }
                            ++var5_7;
                            continue;
lbl31:
                            // 1 sources

                            break;
                        }
                    }
                } else {
                    var4_5 = var0.getMethods();
                    var5_8 = 0;
                    while (var5_8 < var4_5.length) {
                        var6_12 = var4_5[var5_8];
                        var7_15 = new MethodSignature(var6_12);
                        var1_1.put(var7_15, var6_12);
                        ++var5_8;
                    }
                }
                return;
            }
            catch (SecurityException v1) {
                Context.reportWarning("Could not discover accessible methods of class " + var0.getName() + " due to lack of privileges, " + "attemping superclasses/interfaces.");
            }
        }
        var4_6 = var0.getInterfaces();
        var5_9 = 0;
        while (var5_9 < var4_6.length) {
            JavaMembers.discoverAccessibleMethods(var4_6[var5_9], var1_1, var2_2, var3_3);
            ++var5_9;
        }
        var5_10 = var0.getSuperclass();
        if (var5_10 != null) {
            JavaMembers.discoverAccessibleMethods(var5_10, var1_1, var2_2, var3_3);
        }
    }

    private void reflect(Scriptable scriptable, boolean bl) {
        HashMap<String, FieldAndMethods> hashMap;
        int n;
        Serializable serializable;
        Object object;
        MemberBox[] memberBoxArray;
        int n2;
        Method[] methodArray = JavaMembers.discoverAccessibleMethods(this.cl, bl, this.includePrivate);
        int n3 = 0;
        while (n3 < methodArray.length) {
            Method method = methodArray[n3];
            n2 = method.getModifiers();
            boolean bl2 = Modifier.isStatic(n2);
            Map<String, Object> map = bl2 ? this.staticMembers : this.members;
            object = map.get(memberBoxArray = method.getName());
            if (object == null) {
                map.put((String)memberBoxArray, method);
            } else {
                if (object instanceof ObjArray) {
                    serializable = (ObjArray)object;
                } else {
                    if (!(object instanceof Method)) {
                        Kit.codeBug();
                    }
                    serializable = new ObjArray();
                    ((ObjArray)serializable).add(object);
                    map.put((String)memberBoxArray, serializable);
                }
                ((ObjArray)serializable).add(method);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 != 2) {
            boolean bl3 = n3 == 0;
            Map<String, Object> map = bl3 ? this.staticMembers : this.members;
            for (String string : map.keySet()) {
                object = map.get(string);
                if (object instanceof Method) {
                    memberBoxArray = new MemberBox[]{new MemberBox((Method)object)};
                } else {
                    serializable = (ObjArray)object;
                    n = ((ObjArray)serializable).size();
                    if (n < 2) {
                        Kit.codeBug();
                    }
                    memberBoxArray = new MemberBox[n];
                    int n4 = 0;
                    while (n4 != n) {
                        hashMap = (Method)((ObjArray)serializable).get(n4);
                        memberBoxArray[n4] = new MemberBox((Method)((Object)hashMap));
                        ++n4;
                    }
                }
                serializable = new NativeJavaMethod(memberBoxArray);
                if (scriptable != null) {
                    ScriptRuntime.setFunctionProtoAndParent((BaseFunction)serializable, scriptable);
                }
                map.put(string, serializable);
            }
            ++n3;
        }
        Field[] fieldArray = this.getAccessibleFields();
        int n5 = 0;
        while (n5 < fieldArray.length) {
            Field field = fieldArray[n5];
            String string = field.getName();
            int n6 = field.getModifiers();
            if (this.includePrivate || Modifier.isPublic(n6)) {
                try {
                    boolean bl4 = Modifier.isStatic(n6);
                    object = bl4 ? this.staticMembers : this.members;
                    serializable = object.get(string);
                    if (serializable == null) {
                        object.put(string, field);
                    } else if (serializable instanceof NativeJavaMethod) {
                        NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)serializable;
                        FieldAndMethods fieldAndMethods = new FieldAndMethods(scriptable, nativeJavaMethod.methods, field);
                        Map<String, FieldAndMethods> map = hashMap = bl4 ? this.staticFieldAndMethods : this.fieldAndMethods;
                        if (hashMap == null) {
                            hashMap = new HashMap<String, FieldAndMethods>();
                            if (bl4) {
                                this.staticFieldAndMethods = hashMap;
                            } else {
                                this.fieldAndMethods = hashMap;
                            }
                        }
                        hashMap.put(string, fieldAndMethods);
                        object.put(string, fieldAndMethods);
                    } else if (serializable instanceof Field) {
                        Field field2 = (Field)((Object)serializable);
                        if (field2.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) {
                            object.put(string, field);
                        }
                    } else {
                        Kit.codeBug();
                    }
                }
                catch (SecurityException securityException) {
                    Context.reportWarning("Could not access field " + string + " of class " + this.cl.getName() + " due to lack of privileges.");
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 != 2) {
            n2 = n5 == 0 ? 1 : 0;
            Map<String, Object> map = n2 != 0 ? this.staticMembers : this.members;
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            for (String string : map.keySet()) {
                Object object2;
                Object object3;
                boolean bl5 = string.startsWith("get");
                n = string.startsWith("set") ? 1 : 0;
                boolean bl6 = string.startsWith("is");
                if (!bl5 && !bl6 && n == 0 || ((String)((Object)(hashMap = string.substring(bl6 ? 2 : 3)))).length() == 0) continue;
                Object object4 = hashMap;
                char c = ((String)((Object)hashMap)).charAt(0);
                if (Character.isUpperCase(c)) {
                    if (((String)((Object)hashMap)).length() == 1) {
                        object4 = ((String)((Object)hashMap)).toLowerCase();
                    } else {
                        char c2 = ((String)((Object)hashMap)).charAt(1);
                        if (!Character.isUpperCase(c2)) {
                            object4 = String.valueOf(Character.toLowerCase(c)) + ((String)((Object)hashMap)).substring(1);
                        }
                    }
                }
                if (hashMap2.containsKey(object4) || (object3 = map.get(object4)) != null && (!this.includePrivate || !(object3 instanceof Member) || !Modifier.isPrivate(((Member)object3).getModifiers()))) continue;
                MemberBox memberBox = null;
                memberBox = this.findGetter(n2 != 0, map, "get", (String)((Object)hashMap));
                if (memberBox == null) {
                    memberBox = this.findGetter(n2 != 0, map, "is", (String)((Object)hashMap));
                }
                MemberBox memberBox2 = null;
                NativeJavaMethod nativeJavaMethod = null;
                String string2 = "set".concat((String)((Object)hashMap));
                if (map.containsKey(string2) && (object2 = map.get(string2)) instanceof NativeJavaMethod) {
                    NativeJavaMethod nativeJavaMethod2 = (NativeJavaMethod)object2;
                    if (memberBox != null) {
                        Class<?> clazz = memberBox.method().getReturnType();
                        memberBox2 = JavaMembers.extractSetMethod(clazz, nativeJavaMethod2.methods, n2 != 0);
                    } else {
                        memberBox2 = JavaMembers.extractSetMethod(nativeJavaMethod2.methods, n2 != 0);
                    }
                    if (nativeJavaMethod2.methods.length > 1) {
                        nativeJavaMethod = nativeJavaMethod2;
                    }
                }
                object2 = new BeanProperty(memberBox, memberBox2, nativeJavaMethod);
                hashMap2.put(object4, object2);
            }
            for (String string : hashMap2.keySet()) {
                Object v = hashMap2.get(string);
                map.put(string, v);
            }
            ++n5;
        }
        Constructor<?>[] constructorArray = this.getAccessibleConstructors();
        this.ctors = new MemberBox[constructorArray.length];
        n2 = 0;
        while (n2 != constructorArray.length) {
            this.ctors[n2] = new MemberBox(constructorArray[n2]);
            n2 += 1;
        }
    }

    private Constructor<?>[] getAccessibleConstructors() {
        if (this.includePrivate && this.cl != ScriptRuntime.ClassClass) {
            try {
                AccessibleObject[] accessibleObjectArray = this.cl.getDeclaredConstructors();
                Constructor.setAccessible(accessibleObjectArray, true);
                return accessibleObjectArray;
            }
            catch (SecurityException securityException) {
                Context.reportWarning("Could not access constructor  of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        return this.cl.getConstructors();
    }

    private Field[] getAccessibleFields() {
        if (this.includePrivate) {
            try {
                ArrayList<Field> arrayList = new ArrayList<Field>();
                Class<?> clazz = this.cl;
                while (clazz != null) {
                    Field[] fieldArray = clazz.getDeclaredFields();
                    int n = 0;
                    while (n < fieldArray.length) {
                        fieldArray[n].setAccessible(true);
                        arrayList.add(fieldArray[n]);
                        ++n;
                    }
                    clazz = clazz.getSuperclass();
                }
                return arrayList.toArray(new Field[arrayList.size()]);
            }
            catch (SecurityException securityException) {}
        }
        return this.cl.getFields();
    }

    private MemberBox findGetter(boolean bl, Map<String, Object> map, String string, String string2) {
        Object object;
        String string3 = string.concat(string2);
        if (map.containsKey(string3) && (object = map.get(string3)) instanceof NativeJavaMethod) {
            NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)object;
            return JavaMembers.extractGetMethod(nativeJavaMethod.methods, bl);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] memberBoxArray, boolean bl) {
        int n = 0;
        while (n < memberBoxArray.length) {
            MemberBox memberBox = memberBoxArray[n];
            if (memberBox.argTypes.length == 0 && (!bl || memberBox.isStatic())) {
                Class<?> clazz = memberBox.method().getReturnType();
                if (clazz == Void.TYPE) break;
                return memberBox;
            }
            ++n;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class<?> clazz, MemberBox[] memberBoxArray, boolean bl) {
        int n = 1;
        while (n <= 2) {
            int n2 = 0;
            while (n2 < memberBoxArray.length) {
                Class<?>[] classArray;
                MemberBox memberBox = memberBoxArray[n2];
                if ((!bl || memberBox.isStatic()) && (classArray = memberBox.argTypes).length == 1) {
                    if (n == 1) {
                        if (classArray[0] == clazz) {
                            return memberBox;
                        }
                    } else {
                        if (n != 2) {
                            Kit.codeBug();
                        }
                        if (classArray[0].isAssignableFrom(clazz)) {
                            return memberBox;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] memberBoxArray, boolean bl) {
        int n = 0;
        while (n < memberBoxArray.length) {
            MemberBox memberBox = memberBoxArray[n];
            if ((!bl || memberBox.isStatic()) && memberBox.method().getReturnType() == Void.TYPE && memberBox.argTypes.length == 1) {
                return memberBox;
            }
            ++n;
        }
        return null;
    }

    Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Map<String, FieldAndMethods> map;
        Map<String, FieldAndMethods> map2 = map = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (map == null) {
            return null;
        }
        int n = map.size();
        HashMap<String, FieldAndMethods> hashMap = new HashMap<String, FieldAndMethods>(n);
        for (FieldAndMethods fieldAndMethods : map.values()) {
            FieldAndMethods fieldAndMethods2 = new FieldAndMethods(scriptable, fieldAndMethods.methods, fieldAndMethods.field);
            fieldAndMethods2.javaObject = object;
            hashMap.put(fieldAndMethods.field.getName(), fieldAndMethods2);
        }
        return hashMap;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class<?> clazz, Class<?> clazz2, boolean bl) {
        JavaMembers javaMembers;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        ClassCache classCache = ClassCache.get(scriptable);
        Map<Class<?>, JavaMembers> map = classCache.getClassCacheMap();
        Class<?> clazz3 = clazz;
        while (true) {
            if ((javaMembers = map.get(clazz3)) != null) {
                return javaMembers;
            }
            try {
                javaMembers = new JavaMembers(scriptable, clazz3, bl);
            }
            catch (SecurityException securityException) {
                if (clazz2 != null && clazz2.isInterface()) {
                    clazz3 = clazz2;
                    clazz2 = null;
                    continue;
                }
                Class<?> clazz4 = clazz3.getSuperclass();
                if (clazz4 == null) {
                    if (clazz3.isInterface()) {
                        clazz4 = ScriptRuntime.ObjectClass;
                    } else {
                        throw securityException;
                    }
                }
                clazz3 = clazz4;
                continue;
            }
            break;
        }
        if (classCache.isCachingEnabled()) {
            map.put(clazz3, javaMembers);
        }
        return javaMembers;
    }

    RuntimeException reportMemberNotFound(String string) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), string);
    }

    private static final class MethodSignature {
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String string, Class<?>[] classArray) {
            this.name = string;
            this.args = classArray;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object object) {
            if (object instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)object;
                return methodSignature.name.equals(this.name) && Arrays.equals(this.args, methodSignature.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

