/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class IdFunctionObject
extends BaseFunction {
    static final long serialVersionUID = -5332312783643935019L;
    private final IdFunctionCall idcall;
    private final Object tag;
    private final int methodId;
    private int arity;
    private boolean useCallAsConstructor;
    private String functionName;

    public IdFunctionObject(IdFunctionCall idFunctionCall, Object object, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.idcall = idFunctionCall;
        this.tag = object;
        this.methodId = n;
        this.arity = n2;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
    }

    public IdFunctionObject(IdFunctionCall idFunctionCall, Object object, int n, String string, int n2, Scriptable scriptable) {
        super(scriptable, null);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.idcall = idFunctionCall;
        this.tag = object;
        this.methodId = n;
        this.arity = n2;
        this.functionName = string;
    }

    public void initFunction(String string, Scriptable scriptable) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        this.functionName = string;
        this.setParentScope(scriptable);
    }

    public final boolean hasTag(Object object) {
        return this.tag == object;
    }

    public final int methodId() {
        return this.methodId;
    }

    public final void markAsConstructor(Scriptable scriptable) {
        this.useCallAsConstructor = true;
        this.setImmunePrototypeProperty(scriptable);
    }

    public final void addAsProperty(Scriptable scriptable) {
        ScriptableObject.defineProperty(scriptable, this.functionName, this, 2);
    }

    public void exportAsScopeProperty() {
        this.addAsProperty(this.getParentScope());
    }

    @Override
    public Scriptable getPrototype() {
        Scriptable scriptable = super.getPrototype();
        if (scriptable == null) {
            scriptable = IdFunctionObject.getFunctionPrototype(this.getParentScope());
            this.setPrototype(scriptable);
        }
        return scriptable;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.idcall.execIdCall(this, context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable createObject(Context context, Scriptable scriptable) {
        if (this.useCallAsConstructor) {
            return null;
        }
        throw ScriptRuntime.typeError1("msg.not.ctor", this.functionName);
    }

    @Override
    String decompile(int n, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = (n2 & 1) != 0;
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() { ");
        }
        stringBuffer.append("[native code for ");
        if (this.idcall instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)((Object)this.idcall);
            stringBuffer.append(scriptable.getClassName());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append(", arity=");
        stringBuffer.append(this.getArity());
        stringBuffer.append(bl ? "]\n" : "] }\n");
        return stringBuffer.toString();
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public int getLength() {
        return this.getArity();
    }

    @Override
    public String getFunctionName() {
        return this.functionName == null ? "" : this.functionName;
    }

    public final RuntimeException unknown() {
        return new IllegalArgumentException("BAD FUNCTION ID=" + this.methodId + " MASTER=" + this.idcall);
    }
}

