/*
 *  The following code was generated by JFlex 1.3.5 on 2/16/04 6:45 PM
 */
/*
 *  BrowserCommandLexer.java is a generated file.  You probably want to
 *  edit BrowserCommandLexer to make changes.  Use JFlex to generate it.
 *  JFlex may be obtained from
 *  <a href="http://www.jflex.de">the JFlex website</a>.
 *  Once JFlex is in your classpath run<br>
 *  java --skel browser.jflex.skel JFlex.Main BrowserCommandLexer<br>
 *  You will then have a file called BrowserCommandLexer.java
 */
/*
 *  Tokenize a command line into application and arguments.
 *  Copyright (C) 2001 Stephen Ostermiller
 *  http://ostermiller.org/contact.pl?regarding=Java+Utilities
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  See COPYING.TXT for details.
 */
package jtarot;

//package com.Ostermiller.util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Tokenize a command line into application and arguments.
 *
 * @author     Stephen Ostermiller http://ostermiller.org/contact.pl?regarding=Java+Utilities
 * @created    den 2 juli 2004
 * @since      ostermillerutils 1.00.00
 */

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 2/16/04 6:45 PM from the specification file
 * <tt>ostermiller/com/Ostermiller/util/BrowserCommandLexer.lex</tt>
 *
 */
class BrowserCommandLexer {

  /**
   * This character denotes the end of file
   */
  public final static int YYEOF = -1;

  /**
   * initial size of the lookahead buffer
   */
  private final static int YY_BUFFERSIZE = 16384;

  /**
   * lexical states
   */
  public final static int YYINITIAL = 0;

  /**
   * Translates characters to character classes
   */
  private final static String yycmap_packed =
      "\11\0\2\2\1\0\2\2\22\0\1\2\1\0\1\3\36\0\1\0" +
      "\32\0\1\1\uffa3\0";

  /**
   * Translates characters to character classes
   */
  private final static char[] yycmap = yy_unpack_cmap(yycmap_packed);

  /**
   * Translates a state to a row index in the transition table
   */
  private final static int yy_rowMap[] = {
      0, 4, 8, 12, 16, 8, 20, 24, 4, 28,
      16, 32, 12, 24
      };

  /**
   * The packed transition table of the DFA (part 0)
   */
  private final static String yy_packed0 =
      "\1\2\1\3\1\4\1\5\1\2\1\6\1\0\5\2" +
      "\4\0\1\5\1\7\1\10\1\11\1\5\1\12\1\5" +
      "\1\13\1\10\1\14\1\10\1\15\1\5\1\7\1\10" +
      "\1\13\1\10\1\14\1\10\1\16";

  /**
   * The transition table of the DFA
   */
  private final static int yytrans[] = yy_unpack();

  /*
   *  error codes
   */
  private final static int YY_UNKNOWN_ERROR = 0;
  private final static int YY_ILLEGAL_STATE = 1;
  private final static int YY_NO_MATCH = 2;
  private final static int YY_PUSHBACK_2BIG = 3;

  /*
   *  error messages for the codes above
   */
  private final static String YY_ERROR_MSG[] = {
      "Unkown internal scanner error",
      "Internal error: unknown state",
      "Error: could not match input",
      "Error: pushback value was too large"
      };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
      1, 1, 1, 9, 1, 0, 0, 0, 1, 1, 1, 0, 9, 1
      };

  /**
   * the current lexical state
   */
  private int yy_lexical_state = YYINITIAL;

  /**
   * this buffer contains the current text to be matched and is
   *the source of the yytext() string
   */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /**
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /**
   * yy_atEOF == true <=> the scanner is at the EOF
   */
  private boolean yy_atEOF;

  /**
   * the current text position in the buffer
   */
  private int yy_currentPos;

  /**
   * endRead marks the last character in the buffer, that has been read
   *from input
   */
  private int yy_endRead;

  /**
   * the textposition at the last accepting state
   */
  private int yy_markedPos;

  /**
   * the textposition at the last state to be included in yytext
   */
  private int yy_pushbackPos;

  /**
   * the input device
   */
  private java.io.Reader yy_reader;

  /**
   * startRead marks the beginning of the yytext() string in the buffer
   */
  private int yy_startRead;

  /**
   * the current state of the DFA
   */
  private int yy_state;

  /**
   * the number of characters up to the start of the matched text
   */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the
   * matched text
   */
  private int yycolumn;

  /**
   * number of newlines encountered up to the start of the matched text
   */
  private int yyline;


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param  in  the java.io.Reader to read input from.
   */
  BrowserCommandLexer(java.io.Reader in) {
    this.yy_reader = in;
  }


  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param  in  the java.io.Inputstream to read input from.
   */
  BrowserCommandLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return                          the next token
   * @exception  java.io.IOException  Description of the Exception
   */
  public String getNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char[] yy_buffer_l = yy_buffer;
    char[] yycmap_l = yycmap;

    int[] yytrans_l = yytrans;
    int[] yy_rowMap_l = yy_rowMap;
    byte[] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos =
          yy_startRead = yy_markedPos_l;

      yy_state = yy_lexical_state;

      yy_forAction :
       {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l) {
            yy_input = yy_buffer_l[yy_currentPos_l++];
          } else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          } else {
            // store back cached positions
            yy_currentPos = yy_currentPos_l;
            yy_markedPos = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l = yy_currentPos;
            yy_markedPos_l = yy_markedPos;
            yy_buffer_l = yy_buffer;
            yy_endRead_l = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            } else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[yy_rowMap_l[yy_state] + yycmap_l[yy_input]];
          if (yy_next == -1) {
            break yy_forAction;
          }
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ((yy_attributes & 1) == 1) {
            yy_action = yy_state;
            yy_markedPos_l = yy_currentPos_l;
            if ((yy_attributes & 8) == 8) {
              break yy_forAction;
            }
          }
        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 0:
        case 1:
        case 4:
        case 9:
        {
          return unescape(yytext());
        }
        case 15:
          break;
        case 2:
        case 3:
        {
        }
        case 16:
          break;
        case 8:
        case 10:
        case 12:
        case 13:
        {
          return unescape(yytext().substring(1, yytext().length() - 1));
        }
        case 17:
          break;
        default:
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            return null;
          } else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


  /*
   *  user code:
   */
  /**
   * Prints out tokens and line numbers from a file or System.in.
   * If no arguments are given, System.in will be used for input.
   * If more arguments are given, the first argument will be used as
   * the name of the file to use as input
   *
   * @param  args  program arguments, of which the first is a filename
   * @since        ostermillerutils 1.00.00
   */
  private static void main(String[] args) {
    InputStream in;
    try {
      if (args.length > 0) {
        File f = new File(args[0]);
        if (f.exists()) {
          if (f.canRead()) {
            in = new FileInputStream(f);
          } else {
            throw new IOException("Could not open " + args[0]);
          }
        } else {
          throw new IOException("Could not find " + args[0]);
        }
      } else {
        in = System.in;
      }
      BrowserCommandLexer shredder = new BrowserCommandLexer(in);
      String t;
      while ((t = shredder.getNextToken()) != null) {
        System.out.println(t);
      }
    } catch (IOException e) {
      System.out.println(e.getMessage());
    }
  }


  /**
   *  Description of the Method
   *
   * @param  s  Description of the Parameter
   * @return    Description of the Return Value
   */
  private static String unescape(String s) {
    StringBuffer sb = new StringBuffer(s.length());
    for (int i = 0; i < s.length(); i++) {
      if (s.charAt(i) == '\\' && i < s.length()) {
        i++;
      }
      sb.append(s.charAt(i));
    }
    return sb.toString();
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param  errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Refills the input buffer.
   *
   * @return                          <code>false</code>, iff there was new input.
   *
   * @exception  java.io.IOException  Description of the Exception
   */
  private boolean yy_refill() throws java.io.IOException {

    /*
     *  first: make room (if you can)
     */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead,
          yy_buffer, 0,
          yy_endRead - yy_startRead);

      /*
       *  translate stored positions
       */
      yy_endRead -= yy_startRead;
      yy_currentPos -= yy_startRead;
      yy_markedPos -= yy_startRead;
      yy_pushbackPos -= yy_startRead;
      yy_startRead = 0;
    }

    /*
     *  is the buffer big enough?
     */
    if (yy_currentPos >= yy_buffer.length) {
      /*
       *  if not: blow it up
       */
      char newBuffer[] = new char[yy_currentPos * 2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /*
     *  finally: fill the buffer with new input
     */
    int numRead = yy_reader.read(yy_buffer, yy_endRead,
        yy_buffer.length - yy_endRead);

    if (numRead < 0) {
      return true;
    } else {
      yy_endRead += numRead;
      return false;
    }
  }


  /**
   * Unpacks the split, compressed DFA transition table.
   *
   * @return    the unpacked transition table
   */
  private static int[] yy_unpack() {
    int[] trans = new int[36];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }


  /**
   * Unpacks the compressed DFA transition table.
   *
   * @param  packed  the packed transition table
   * @param  offset  Description of the Parameter
   * @param  trans   Description of the Parameter
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int[] trans) {
    int i = 0;
    /*
     *  index in packed string
     */
    int j = offset;
    /*
     *  index in unpacked array
     */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do {
        trans[j++] = value;
      } while (--count > 0);
    }
    return j;
  }


  /**
   * Unpacks the compressed character translation table.
   *
   * @param  packed  the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char[] yy_unpack_cmap(String packed) {
    char[] map = new char[0x10000];
    int i = 0;
    /*
     *  index in packed string
     */
    int j = 0;
    /*
     *  index in unpacked array
     */
    while (i < 26) {
      int count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do {
        map[j++] = value;
      } while (--count > 0);
    }
    return map;
  }


  /**
   * Enters a new lexical state
   *
   * @param  newState  the new lexical state
   */
  public final void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param  pos  the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   * @return      the character at position pos
   */
  public final char yycharat(int pos) {
    return yy_buffer[yy_startRead + pos];
  }


  /**
   * Closes the input stream.
   *
   * @exception  java.io.IOException  Description of the Exception
   */
  public final void yyclose() throws java.io.IOException {
    yy_atEOF = true;
    /*
     *  indicate end of file
     */
    yy_endRead = yy_startRead;
    /*
     *  invalidate buffer
     */
    if (yy_reader != null) {
      yy_reader.close();
    }
  }


  /**
   * Returns the length of the matched text region.
   *
   * @return    Description of the Return Value
   */
  public final int yylength() {
    return yy_markedPos - yy_startRead;
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param  number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number) {
    if (number > yylength()) {
      yy_ScanError(YY_PUSHBACK_2BIG);
    }

    yy_markedPos -= number;
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param  reader                   the new input stream
   * @exception  java.io.IOException  Description of the Exception
   */
  public final void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL = true;
    yy_atEOF = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   *
   * @return    Description of the Return Value
   */
  public final int yystate() {
    return yy_lexical_state;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return    Description of the Return Value
   */
  public final String yytext() {
    return new String(yy_buffer, yy_startRead, yy_markedPos - yy_startRead);
  }

}

