/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

class CircuitFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Thread engine = null;
    Dimension winSize;
    Image dbimage;
    Random random;
    public static final int sourceRadius = 7;
    public static final double freqMult = 25.1327412;
    Container main;
    Label titleLabel;
    Button resetButton;
    Button dumpMatrixButton;
    MenuItem exportItem;
    MenuItem importItem;
    MenuItem exitItem;
    Menu optionsMenu;
    Checkbox stoppedCheck;
    CheckboxMenuItem dotsCheckItem;
    CheckboxMenuItem voltsCheckItem;
    CheckboxMenuItem powerCheckItem;
    CheckboxMenuItem smallGridCheckItem;
    CheckboxMenuItem showValuesCheckItem;
    CheckboxMenuItem euroResistorCheckItem;
    CheckboxMenuItem printableCheckItem;
    CheckboxMenuItem conventionCheckItem;
    Scrollbar speedBar;
    Scrollbar currentBar;
    Label powerLabel;
    Scrollbar powerBar;
    double currentMult;
    double powerMult;
    PopupMenu elmMenu;
    MenuItem elmEditMenuItem;
    MenuItem elmDeleteMenuItem;
    MenuItem elmScopeMenuItem;
    PopupMenu scopeMenu;
    PopupMenu transScopeMenu;
    PopupMenu mainMenu;
    CheckboxMenuItem scopeVMenuItem;
    CheckboxMenuItem scopeIMenuItem;
    CheckboxMenuItem scopeMaxMenuItem;
    CheckboxMenuItem scopeFreqMenuItem;
    CheckboxMenuItem scopePowerMenuItem;
    CheckboxMenuItem scopeIbMenuItem;
    CheckboxMenuItem scopeIcMenuItem;
    CheckboxMenuItem scopeIeMenuItem;
    CheckboxMenuItem scopeVbeMenuItem;
    CheckboxMenuItem scopeVbcMenuItem;
    CheckboxMenuItem scopeVceMenuItem;
    CheckboxMenuItem scopeVIMenuItem;
    CheckboxMenuItem scopeXYMenuItem;
    CheckboxMenuItem scopeResistMenuItem;
    MenuItem scopeSelectYMenuItem;
    Class addingClass;
    int mouseMode = -1;
    String mouseModeStr = "hello";
    Font unitsFont;
    static final double pi = Math.PI;
    static final int MODE_ADD_ELM = 0;
    static final int MODE_DRAG_ALL = 1;
    static final int MODE_DRAG_ROW = 2;
    static final int MODE_DRAG_COLUMN = 3;
    static final int MODE_DRAG_SELECTED = 4;
    static final int MODE_DRAG_POST = 5;
    static final int infoWidth = 120;
    static final int SCOPEVAL_POWER = 1;
    static final int SCOPEVAL_IB = 1;
    static final int SCOPEVAL_IC = 2;
    static final int SCOPEVAL_IE = 3;
    static final int SCOPEVAL_VBE = 4;
    static final int SCOPEVAL_VBC = 5;
    static final int SCOPEVAL_VCE = 6;
    static final int SCOPEVAL_R = 2;
    int dragX;
    int dragY;
    int selectedSource;
    int gridSize;
    int gridMask;
    int gridRound;
    boolean dragging;
    boolean analyzeFlag;
    boolean dumpMatrix;
    boolean useBufferedImage;
    double t;
    int pause = 10;
    int colorScaleCount = 32;
    Color[] colorScale;
    Color whiteColor;
    Color selectColor;
    Color lightGrayColor;
    int scopeSelected = -1;
    int menuScope = -1;
    int hintType = -1;
    int hintItem1;
    int hintItem2;
    String stopMessage;
    double timeStep;
    static final int HINT_LC = 1;
    static final int HINT_RC = 2;
    static final int HINT_3DB_C = 3;
    static final int HINT_TWINT = 4;
    static final int HINT_3DB_L = 5;
    Vector elmList;
    Vector setupList;
    CircuitElm dragElm;
    CircuitElm menuElm;
    CircuitElm mouseElm;
    CircuitElm stopElm;
    int mousePost = -1;
    CircuitElm plotXElm;
    CircuitElm plotYElm;
    int draggingPost;
    SwitchElm heldSwitchElm;
    double[][] circuitMatrix;
    double[] circuitRightSide;
    double[] origRightSide;
    double[][] origMatrix;
    RowInfo[] circuitRowInfo;
    int[] circuitPermute;
    boolean circuitNonLinear;
    int voltageSourceCount;
    double voltageRange = 5.0;
    int circuitMatrixSize;
    int circuitMatrixFullSize;
    boolean circuitNeedsMap;
    public boolean useFrame;
    int scopeCount;
    Scope[] scopes;
    int[] scopeColCount;
    EditDialog editDialog;
    ImportDialog impDialog;
    Class[] dumpTypes;
    String muString = "u";
    String ohmString = "ohm";
    Rectangle circuitArea;
    Point ps1;
    Point ps2;
    CircuitCanvas cv;
    Circuit applet;
    NumberFormat showFormat;
    NumberFormat shortFormat;
    NumberFormat noCommaFormat;
    boolean shown = false;
    static final int resct = 6;
    long lastTime = 0L;
    long lastFrameTime;
    long lastIterTime;
    long secTime = 0L;
    int frames = 0;
    int steps = 0;
    int framerate = 0;
    int steprate = 0;
    Vector nodeList;
    CircuitElm[] voltageSources;
    static final int FPI_INDUCT = 1;
    static final int FPI_VOLTAGE = 2;
    static final int FPI_SHORT = 3;
    static final int FPI_CAP_V = 4;
    boolean converged;
    int subIterations;
    static /* synthetic */ Class class$CircuitFrame$Scope;
    static /* synthetic */ Class class$java$util$StringTokenizer;

    public String getAppletInfo() {
        return "Circuit by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    CircuitFrame(Circuit circuit) {
        super("Circuit Simulator v1.3g");
        this.applet = circuit;
        this.useFrame = false;
    }

    public void init() {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            String string6 = this.applet.getParameter("PAUSE");
            if (string6 != null) {
                this.pause = Integer.parseInt(string6);
            }
            string2 = this.applet.getParameter("startCircuit");
            string3 = this.applet.getParameter("startLabel");
            string4 = this.applet.getParameter("euroResistors");
            string5 = this.applet.getParameter("useFrame");
            string = this.applet.getParameter("whiteBackground");
            if (string != null && string.equalsIgnoreCase("true")) {
                bl = true;
            }
            if ((string = this.applet.getParameter("conventionalCurrent")) != null && string.equalsIgnoreCase("true")) {
                bl2 = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = "LRC Circuit";
        }
        if (string2 == null) {
            string2 = "lrc.txt";
        }
        boolean bl3 = string4 != null && string4.equalsIgnoreCase("true");
        this.useFrame = string5 == null || !string5.equalsIgnoreCase("false");
        this.main = this.useFrame ? this : this.applet;
        this.unitsFont = new Font("SansSerif", 0, 10);
        string = System.getProperty("os.name");
        String string7 = System.getProperty("java.class.version");
        double d = new Double(string7);
        if (d >= 48.0) {
            this.muString = "\u03bc";
            this.ohmString = "\u03a9";
            this.useBufferedImage = true;
        }
        this.dumpTypes = new Class[300];
        this.dumpTypes[111] = class$CircuitFrame$Scope == null ? (class$CircuitFrame$Scope = CircuitFrame.class$("CircuitFrame$Scope")) : class$CircuitFrame$Scope;
        this.dumpTypes[104] = class$CircuitFrame$Scope == null ? (class$CircuitFrame$Scope = CircuitFrame.class$("CircuitFrame$Scope")) : class$CircuitFrame$Scope;
        this.dumpTypes[36] = class$CircuitFrame$Scope == null ? (class$CircuitFrame$Scope = CircuitFrame.class$("CircuitFrame$Scope")) : class$CircuitFrame$Scope;
        this.main.setLayout(new CircuitLayout());
        this.cv = new CircuitCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.main.add(this.cv);
        this.mainMenu = new PopupMenu();
        MenuBar menuBar = null;
        if (this.useFrame) {
            menuBar = new MenuBar();
        }
        Menu menu = new Menu("File");
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        this.importItem = this.getMenuItem("Import");
        menu.add(this.importItem);
        this.exportItem = this.getMenuItem("Export");
        menu.add(this.exportItem);
        menu.addSeparator();
        this.exitItem = this.getMenuItem("Exit");
        menu.add(this.exitItem);
        menu = new Menu("Scope");
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        menu.add(this.getMenuItem("Stack All", "stackAll"));
        menu.add(this.getMenuItem("Unstack All", "unstackAll"));
        this.optionsMenu = menu = new Menu("Options");
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        this.dotsCheckItem = this.getCheckItem("Show Current");
        menu.add(this.dotsCheckItem);
        this.dotsCheckItem.setState(true);
        this.voltsCheckItem = this.getCheckItem("Show Voltage");
        menu.add(this.voltsCheckItem);
        this.voltsCheckItem.setState(true);
        this.powerCheckItem = this.getCheckItem("Show Power");
        menu.add(this.powerCheckItem);
        this.showValuesCheckItem = this.getCheckItem("Show Values");
        menu.add(this.showValuesCheckItem);
        this.showValuesCheckItem.setState(true);
        this.smallGridCheckItem = this.getCheckItem("Small Grid");
        menu.add(this.smallGridCheckItem);
        this.euroResistorCheckItem = this.getCheckItem("European Resistors");
        menu.add(this.euroResistorCheckItem);
        this.euroResistorCheckItem.setState(bl3);
        this.printableCheckItem = this.getCheckItem("White Background");
        menu.add(this.printableCheckItem);
        this.printableCheckItem.setState(bl);
        this.conventionCheckItem = this.getCheckItem("Conventional Current Motion");
        menu.add(this.conventionCheckItem);
        this.conventionCheckItem.setState(bl2);
        Menu menu2 = new Menu("Circuits");
        if (this.useFrame) {
            menuBar.add(menu2);
        } else {
            this.mainMenu.add(menu2);
        }
        this.mainMenu.add(this.getClassCheckItem("Add Wire", "WireElm"));
        this.mainMenu.add(this.getClassCheckItem("Add Resistor", "ResistorElm"));
        Menu menu3 = new Menu("Passive Components");
        this.mainMenu.add(menu3);
        menu3.add(this.getClassCheckItem("Add Capacitor", "CapacitorElm"));
        menu3.add(this.getClassCheckItem("Add Inductor", "InductorElm"));
        menu3.add(this.getClassCheckItem("Add Switch", "SwitchElm"));
        menu3.add(this.getClassCheckItem("Add Push Switch", "PushSwitchElm"));
        menu3.add(this.getClassCheckItem("Add DPST Switch", "Switch2Elm"));
        menu3.add(this.getClassCheckItem("Add Transformer", "TransformerElm"));
        menu3.add(this.getClassCheckItem("Add Tapped Transformer", "TappedTransformerElm"));
        menu3.add(this.getClassCheckItem("Add Transmission Line", "TransLineElm"));
        menu3.add(this.getClassCheckItem("Add Memristor", "MemristorElm"));
        Menu menu4 = new Menu("Inputs/Outputs");
        this.mainMenu.add(menu4);
        menu4.add(this.getClassCheckItem("Add Ground", "GroundElm"));
        menu4.add(this.getClassCheckItem("Add Voltage Source (2-terminal)", "DCVoltageElm"));
        menu4.add(this.getClassCheckItem("Add A/C Source (2-terminal)", "ACVoltageElm"));
        menu4.add(this.getClassCheckItem("Add Voltage Source (1-terminal)", "RailElm"));
        menu4.add(this.getClassCheckItem("Add A/C Source (1-terminal)", "ACRailElm"));
        menu4.add(this.getClassCheckItem("Add Square Wave (1-terminal)", "SquareRailElm"));
        menu4.add(this.getClassCheckItem("Add Analog Output", "OutputElm"));
        menu4.add(this.getClassCheckItem("Add Logic Input", "LogicInputElm"));
        menu4.add(this.getClassCheckItem("Add Logic Output", "LogicOutputElm"));
        menu4.add(this.getClassCheckItem("Add Clock", "ClockElm"));
        menu4.add(this.getClassCheckItem("Add A/C Sweep", "SweepElm"));
        menu4.add(this.getClassCheckItem("Add Var. Voltage", "VarRailElm"));
        menu4.add(this.getClassCheckItem("Add Antenna", "AntennaElm"));
        menu4.add(this.getClassCheckItem("Add Current Source", "CurrentElm"));
        menu4.add(this.getClassCheckItem("Add LED", "LEDElm"));
        Menu menu5 = new Menu("Active Components");
        this.mainMenu.add(menu5);
        menu5.add(this.getClassCheckItem("Add Diode", "DiodeElm"));
        menu5.add(this.getClassCheckItem("Add Zener Diode", "ZenerElm"));
        menu5.add(this.getClassCheckItem("Add Transistor (bipolar, NPN)", "NTransistorElm"));
        menu5.add(this.getClassCheckItem("Add Transistor (bipolar, PNP)", "PTransistorElm"));
        menu5.add(this.getClassCheckItem("Add Op Amp (- on top)", "OpAmpElm"));
        menu5.add(this.getClassCheckItem("Add Op Amp (+ on top)", "OpAmpSwapElm"));
        menu5.add(this.getClassCheckItem("Add MOSFET (n-channel)", "NMosfetElm"));
        menu5.add(this.getClassCheckItem("Add MOSFET (p-channel)", "PMosfetElm"));
        menu5.add(this.getClassCheckItem("Add JFET (n-channel)", "NJfetElm"));
        menu5.add(this.getClassCheckItem("Add Analog Switch (SPST)", "AnalogSwitchElm"));
        menu5.add(this.getClassCheckItem("Add Analog Switch (SPDT)", "AnalogSwitch2Elm"));
        Menu menu6 = new Menu("Logic Gates");
        this.mainMenu.add(menu6);
        menu6.add(this.getClassCheckItem("Add Inverter", "InverterElm"));
        menu6.add(this.getClassCheckItem("Add NAND Gate", "NandGateElm"));
        menu6.add(this.getClassCheckItem("Add NOR Gate", "NorGateElm"));
        menu6.add(this.getClassCheckItem("Add AND Gate", "AndGateElm"));
        menu6.add(this.getClassCheckItem("Add OR Gate", "OrGateElm"));
        menu6.add(this.getClassCheckItem("Add XOR Gate", "XorGateElm"));
        Menu menu7 = new Menu("Chips");
        this.mainMenu.add(menu7);
        menu7.add(this.getClassCheckItem("Add D Flip-Flop", "DFlipFlopElm"));
        menu7.add(this.getClassCheckItem("Add JK Flip-Flop", "JKFlipFlopElm"));
        menu7.add(this.getClassCheckItem("Add 7 Segment LED", "SevenSegElm"));
        menu7.add(this.getClassCheckItem("Add VCO", "VCOElm"));
        menu7.add(this.getClassCheckItem("Add Phase Comparator", "PhaseCompElm"));
        menu7.add(this.getClassCheckItem("Add Counter", "CounterElm"));
        menu7.add(this.getClassCheckItem("Add Decade Counter", "DecadeElm"));
        menu7.add(this.getClassCheckItem("Add 555 Timer", "TimerElm"));
        menu7.add(this.getClassCheckItem("Add DAC", "DACElm"));
        menu7.add(this.getClassCheckItem("Add ADC", "ADCElm"));
        menu7.add(this.getClassCheckItem("Add Latch", "LatchElm"));
        Menu menu8 = new Menu("Other");
        this.mainMenu.add(menu8);
        menu8.add(this.getClassCheckItem("Add Text", "TextElm"));
        menu8.add(this.getClassCheckItem("Add Scope Probe", "ProbeElm"));
        menu8.add(this.getCheckItem("Drag All", "DragAll"));
        menu8.add(this.getCheckItem("Drag Row", "DragRow"));
        menu8.add(this.getCheckItem("Drag Column", "DragColumn"));
        menu8.add(this.getCheckItem("Drag Selected", "DragSelected"));
        menu8.add(this.getCheckItem("Drag Post", "DragPost"));
        this.main.add(this.mainMenu);
        this.resetButton = new Button("Reset");
        this.main.add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.dumpMatrixButton = new Button("Dump Matrix");
        this.dumpMatrixButton.addActionListener(this);
        this.stoppedCheck = new Checkbox("Stopped");
        this.stoppedCheck.addItemListener(this);
        this.main.add(this.stoppedCheck);
        this.main.add(new Label("Simulation Speed", 1));
        this.speedBar = new Scrollbar(0, 3, 1, 0, 260);
        this.main.add(this.speedBar);
        this.speedBar.addAdjustmentListener(this);
        this.main.add(new Label("Current Speed", 1));
        this.currentBar = new Scrollbar(0, 50, 1, 1, 100);
        this.currentBar.addAdjustmentListener(this);
        this.main.add(this.currentBar);
        this.powerLabel = new Label("Power Brightness", 1);
        this.main.add(this.powerLabel);
        this.powerBar = new Scrollbar(0, 50, 1, 1, 100);
        this.main.add(this.powerBar);
        this.powerBar.addAdjustmentListener(this);
        this.powerBar.disable();
        this.powerLabel.disable();
        this.main.add(new Label("www.falstad.com"));
        if (this.useFrame) {
            this.main.add(new Label(""));
        }
        Font font = new Font("SansSerif", 0, 10);
        Label label = new Label("Current Circuit:");
        label.setFont(font);
        this.titleLabel = new Label("Label");
        this.titleLabel.setFont(font);
        if (this.useFrame) {
            this.main.add(label);
            this.main.add(this.titleLabel);
        }
        this.setGrid();
        this.elmList = new Vector();
        this.setupList = new Vector();
        this.colorScale = new Color[this.colorScaleCount];
        int n = 0;
        while (n != this.colorScaleCount) {
            int n2;
            int n3;
            double d2 = (double)n * 2.0 / (double)this.colorScaleCount - 1.0;
            if (d2 < 0.0) {
                n3 = (int)(128.0 * -d2) + 127;
                n2 = (int)(127.0 * (1.0 + d2));
                this.colorScale[n] = new Color(n3, n2, n2);
            } else {
                n3 = (int)(128.0 * d2) + 127;
                n2 = (int)(127.0 * (1.0 - d2));
                this.colorScale[n] = new Color(n2, n3, n2);
            }
            ++n;
        }
        this.scopes = new Scope[20];
        this.scopeColCount = new int[20];
        this.scopeCount = 0;
        this.random = new Random();
        this.ps1 = new Point();
        this.ps2 = new Point();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.showFormat = NumberFormat.getInstance();
        this.showFormat.setMaximumFractionDigits(2);
        this.shortFormat = NumberFormat.getInstance();
        this.shortFormat.setMaximumFractionDigits(1);
        this.noCommaFormat = NumberFormat.getInstance();
        this.noCommaFormat.setMaximumFractionDigits(10);
        this.noCommaFormat.setGroupingUsed(false);
        this.elmMenu = new PopupMenu();
        this.elmEditMenuItem = this.getMenuItem("Edit");
        this.elmMenu.add(this.elmEditMenuItem);
        this.elmDeleteMenuItem = this.getMenuItem("Delete");
        this.elmMenu.add(this.elmDeleteMenuItem);
        this.elmScopeMenuItem = this.getMenuItem("View in Scope");
        this.elmMenu.add(this.elmScopeMenuItem);
        this.main.add(this.elmMenu);
        this.scopeMenu = this.buildScopeMenu(false);
        this.transScopeMenu = this.buildScopeMenu(true);
        this.getSetupList(menu2, false);
        if (this.useFrame) {
            this.setMenuBar(menuBar);
        }
        if (this.stopMessage == null) {
            this.readSetupFile(string2, string3);
        }
        if (this.useFrame) {
            Dimension dimension = this.getToolkit().getScreenSize();
            this.resize(800, 640);
            this.handleResize();
            Dimension dimension2 = this.getSize();
            ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.show();
        } else {
            if (!this.powerCheckItem.getState()) {
                this.main.remove(this.powerBar);
                this.main.remove(this.powerLabel);
                this.main.validate();
            }
            this.hide();
            this.handleResize();
            this.applet.validate();
        }
        this.main.requestFocus();
    }

    public void triggerShow() {
        if (!this.shown) {
            this.show();
        }
        this.shown = true;
    }

    PopupMenu buildScopeMenu(boolean bl) {
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(this.getMenuItem("Remove", "remove"));
        popupMenu.add(this.getMenuItem("Speed 2x", "speed2"));
        popupMenu.add(this.getMenuItem("Speed 1/2x", "speed1/2"));
        popupMenu.add(this.getMenuItem("Scale 2x", "scale"));
        popupMenu.add(this.getMenuItem("Stack", "stack"));
        popupMenu.add(this.getMenuItem("Unstack", "unstack"));
        if (bl) {
            this.scopeIbMenuItem = this.getCheckItem("Show Ib");
            popupMenu.add(this.scopeIbMenuItem);
            this.scopeIcMenuItem = this.getCheckItem("Show Ic");
            popupMenu.add(this.scopeIcMenuItem);
            this.scopeIeMenuItem = this.getCheckItem("Show Ie");
            popupMenu.add(this.scopeIeMenuItem);
            this.scopeVbeMenuItem = this.getCheckItem("Show Vbe");
            popupMenu.add(this.scopeVbeMenuItem);
            this.scopeVbcMenuItem = this.getCheckItem("Show Vbc");
            popupMenu.add(this.scopeVbcMenuItem);
            this.scopeVceMenuItem = this.getCheckItem("Show Vce");
            popupMenu.add(this.scopeVceMenuItem);
        } else {
            this.scopeVMenuItem = this.getCheckItem("Show Voltage");
            popupMenu.add(this.scopeVMenuItem);
            this.scopeIMenuItem = this.getCheckItem("Show Current");
            popupMenu.add(this.scopeIMenuItem);
            this.scopePowerMenuItem = this.getCheckItem("Show Power Consumed");
            popupMenu.add(this.scopePowerMenuItem);
            this.scopeMaxMenuItem = this.getCheckItem("Show Peak Value");
            popupMenu.add(this.scopeMaxMenuItem);
            this.scopeFreqMenuItem = this.getCheckItem("Show Frequency");
            popupMenu.add(this.scopeFreqMenuItem);
            this.scopeVIMenuItem = this.getCheckItem("Show V versus I");
            popupMenu.add(this.scopeVIMenuItem);
            this.scopeXYMenuItem = this.getCheckItem("Plot X/Y");
            popupMenu.add(this.scopeXYMenuItem);
            this.scopeSelectYMenuItem = this.getMenuItem("Select Y", "selecty");
            popupMenu.add(this.scopeSelectYMenuItem);
            this.scopeResistMenuItem = this.getCheckItem("Show Resistance");
            popupMenu.add(this.scopeResistMenuItem);
        }
        this.main.add(popupMenu);
        return popupMenu;
    }

    MenuItem getMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    MenuItem getMenuItem(String string, String string2) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand(string2);
        menuItem.addActionListener(this);
        return menuItem;
    }

    CheckboxMenuItem getCheckItem(String string) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(this);
        checkboxMenuItem.setActionCommand("");
        return checkboxMenuItem;
    }

    CheckboxMenuItem getClassCheckItem(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("CircuitFrame$" + string2);
            CircuitElm circuitElm = this.constructElement(clazz, 0, 0);
            this.register(clazz, circuitElm);
            circuitElm.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.getCheckItem(string, string2);
    }

    CheckboxMenuItem getCheckItem(String string, String string2) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(this);
        checkboxMenuItem.setActionCommand(string2);
        return checkboxMenuItem;
    }

    void register(Class clazz, CircuitElm circuitElm) {
        int n = circuitElm.getDumpType();
        if (n == 0) {
            System.out.println("no dump type: " + clazz);
            return;
        }
        Class clazz2 = circuitElm.getDumpClass();
        if (this.dumpTypes[n] == clazz2) {
            return;
        }
        if (this.dumpTypes[n] != null) {
            System.out.println("dump type conflict: " + clazz + " " + this.dumpTypes[n]);
            return;
        }
        this.dumpTypes[n] = clazz2;
    }

    void handleResize() {
        this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = this.main.createImage(this.winSize.width, this.winSize.height);
        int n = this.winSize.height / 5;
        this.circuitArea = new Rectangle(0, 0, this.winSize.width, this.winSize.height - n);
        int n2 = 1000;
        int n3 = 0;
        int n4 = 1000;
        int n5 = 0;
        int n6 = 0;
        while (n6 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n6);
            if (!circuitElm.isCenteredText()) {
                n2 = this.min(circuitElm.x, this.min(circuitElm.x2, n2));
                n3 = this.max(circuitElm.x, this.max(circuitElm.x2, n3));
            }
            n4 = this.min(circuitElm.y, this.min(circuitElm.y2, n4));
            n5 = this.max(circuitElm.y, this.max(circuitElm.y2, n5));
            ++n6;
        }
        int n7 = this.gridMask & (this.circuitArea.width - (n3 - n2)) / 2 - n2;
        int n8 = this.gridMask & (this.circuitArea.height - (n5 - n4)) / 2 - n4;
        if (n7 + n2 < 0) {
            n7 = this.gridMask & -n2;
        }
        if (n8 + n4 < 0) {
            n8 = this.gridMask & -n4;
        }
        n6 = 0;
        while (n6 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n6);
            circuitElm.move(n7, n8);
            ++n6;
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    void centerString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, (this.winSize.width - fontMetrics.stringWidth(string)) / 2, n);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateCircuit(Graphics graphics) {
        int n;
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        if (this.analyzeFlag) {
            this.analyzeCircuit();
            this.analyzeFlag = false;
        }
        if (this.editDialog != null) {
            this.mouseElm = this.editDialog.elm;
        }
        CircuitElm circuitElm = this.mouseElm;
        if (this.mouseElm == null) {
            this.mouseElm = this.stopElm;
        }
        this.setupScopes();
        Graphics graphics2 = null;
        graphics2 = this.dbimage.getGraphics();
        this.selectColor = Color.cyan;
        if (this.printableCheckItem.getState()) {
            this.whiteColor = Color.black;
            this.lightGrayColor = Color.black;
            graphics2.setColor(Color.white);
        } else {
            this.whiteColor = Color.white;
            this.lightGrayColor = Color.lightGray;
            graphics2.setColor(Color.black);
        }
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        if (!this.stoppedCheck.getState()) {
            try {
                this.runCircuit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.analyzeFlag = true;
                this.cv.repaint();
                return;
            }
        }
        if (!this.stoppedCheck.getState()) {
            long l = System.currentTimeMillis();
            if (this.lastTime != 0L) {
                n = (int)(l - this.lastTime);
                double d = this.currentBar.getValue();
                d = Math.exp(d / 3.5 - 14.2);
                this.currentMult = 1.7 * (double)n * d;
                if (!this.conventionCheckItem.getState()) {
                    this.currentMult = -this.currentMult;
                }
            }
            if (l - this.secTime >= 1000L) {
                this.framerate = this.frames;
                this.steprate = this.steps;
                this.frames = 0;
                this.steps = 0;
                this.secTime = l;
            }
            this.lastTime = l;
        } else {
            this.lastTime = 0L;
        }
        this.powerMult = Math.exp((double)this.powerBar.getValue() / 4.762 - 7.0);
        Font font = graphics2.getFont();
        int n2 = 0;
        while (n2 != this.elmList.size()) {
            if (this.powerCheckItem.getState()) {
                graphics2.setColor(Color.gray);
            }
            this.getElm(n2).draw(graphics2);
            ++n2;
        }
        if (this.mouseMode == 2 || this.mouseMode == 3) {
            n2 = 0;
            while (n2 != this.elmList.size()) {
                CircuitElm circuitElm2 = this.getElm(n2);
                circuitElm2.drawPost(graphics2, circuitElm2.x, circuitElm2.y);
                circuitElm2.drawPost(graphics2, circuitElm2.x2, circuitElm2.y2);
                ++n2;
            }
        }
        if (this.dragElm != null && (this.dragElm.x != this.dragElm.x2 || this.dragElm.y != this.dragElm.y2)) {
            this.dragElm.draw(graphics2);
        }
        graphics2.setFont(font);
        n = this.scopeCount;
        if (this.stopMessage != null) {
            n = 0;
        }
        n2 = 0;
        while (n2 != n) {
            this.scopes[n2].draw(graphics2);
            ++n2;
        }
        graphics2.setColor(this.whiteColor);
        int n3 = this.circuitArea.height;
        if (this.stopMessage != null) {
            graphics2.drawString(this.stopMessage, 10, n3 + 15);
        } else {
            String[] stringArray = new String[10];
            if (this.mouseElm != null) {
                if (this.mousePost == -1) {
                    this.mouseElm.getInfo(stringArray);
                } else {
                    stringArray[0] = "V = " + this.getUnitText(this.mouseElm.getPostVoltage(this.mousePost), "V");
                }
            } else {
                this.showFormat.setMinimumFractionDigits(2);
                stringArray[0] = "t = " + this.getUnitText(this.t, "s");
                this.showFormat.setMinimumFractionDigits(0);
            }
            if (this.hintType != -1) {
                n2 = 0;
                while (stringArray[n2] != null) {
                    ++n2;
                }
                String string = this.getHint();
                if (string == null) {
                    this.hintType = -1;
                } else {
                    stringArray[n2] = string;
                }
            }
            int n4 = 0;
            if (n != 0) {
                n4 = this.scopes[n - 1].rightEdge() + 20;
            }
            n4 = this.max(n4, this.winSize.width * 2 / 3);
            n2 = 0;
            while (stringArray[n2] != null) {
                graphics2.drawString(stringArray[n2], n4, n3 + 15 * (n2 + 1));
                ++n2;
            }
        }
        this.mouseElm = circuitElm;
        ++this.frames;
        this.lastFrameTime = this.lastTime;
        graphics.drawImage(this.dbimage, 0, 0, this);
        if (!this.stoppedCheck.getState() && this.circuitMatrix != null) {
            this.cv.repaint(this.pause);
        }
    }

    void setupScopes() {
        int n;
        int n2;
        int n3;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.scopeCount) {
            if (this.locateElm(this.scopes[n5].elm) < 0) {
                this.scopes[n5].setElm(null);
            }
            if (this.scopes[n5].elm == null) {
                n3 = n5;
                while (n3 != this.scopeCount) {
                    this.scopes[n3] = this.scopes[n3 + 1];
                    ++n3;
                }
                --this.scopeCount;
                --n5;
            } else {
                if (this.scopes[n5].position > n4 + 1) {
                    this.scopes[n5].position = n4 + 1;
                }
                n4 = this.scopes[n5].position;
            }
            ++n5;
        }
        while (this.scopeCount > 0 && this.scopes[this.scopeCount - 1].elm == null) {
            --this.scopeCount;
        }
        n3 = this.winSize.height - this.circuitArea.height;
        n4 = 0;
        n5 = 0;
        while (n5 != this.scopeCount) {
            this.scopeColCount[n5] = 0;
            ++n5;
        }
        n5 = 0;
        while (n5 != this.scopeCount) {
            n4 = this.max(this.scopes[n5].position, n4);
            int n6 = this.scopes[n5].position;
            this.scopeColCount[n6] = this.scopeColCount[n6] + 1;
            ++n5;
        }
        int n7 = n4 + 1;
        int n8 = 120;
        if (n7 <= 2) {
            n8 = n8 * 3 / 2;
        }
        if ((n2 = (this.winSize.width - n8) / n7) < (n = 10) * 2) {
            n2 = n * 2;
        }
        n4 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        n5 = 0;
        while (n5 != this.scopeCount) {
            Scope scope = this.scopes[n5];
            if (scope.position > n4) {
                n4 = scope.position;
                n9 = n3 / this.scopeColCount[n4];
                n10 = 0;
                n11 = scope.speed;
            }
            if (scope.speed != n11) {
                scope.speed = n11;
                scope.resetGraph();
            }
            Rectangle rectangle = new Rectangle(n4 * n2, this.winSize.height - n3 + n9 * n10, n2 - n, n9);
            ++n10;
            if (!rectangle.equals(scope.rect)) {
                scope.setRect(rectangle);
            }
            ++n5;
        }
    }

    String getHint() {
        CircuitElm circuitElm = this.getElm(this.hintItem1);
        CircuitElm circuitElm2 = this.getElm(this.hintItem2);
        if (circuitElm == null || circuitElm2 == null) {
            return null;
        }
        if (this.hintType == 1) {
            if (!(circuitElm instanceof InductorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            InductorElm inductorElm = (InductorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "res.f = " + this.getUnitText(1.0 / (Math.PI * 2 * Math.sqrt(inductorElm.inductance * capacitorElm.capacitance)), "Hz");
        }
        if (this.hintType == 2) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "RC = " + this.getUnitText(resistorElm.resistance * capacitorElm.capacitance, "s");
        }
        if (this.hintType == 3) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "f.3db = " + this.getUnitText(1.0 / (Math.PI * 2 * resistorElm.resistance * capacitorElm.capacitance), "Hz");
        }
        if (this.hintType == 5) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof InductorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            InductorElm inductorElm = (InductorElm)circuitElm2;
            return "f.3db = " + this.getUnitText(resistorElm.resistance / (Math.PI * 2 * inductorElm.inductance), "Hz");
        }
        if (this.hintType == 4) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "fc = " + this.getUnitText(1.0 / (Math.PI * 2 * resistorElm.resistance * capacitorElm.capacitance), "Hz");
        }
        return null;
    }

    public void toggleSwitch(int n) {
        int n2 = 0;
        while (n2 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n2);
            if (circuitElm instanceof SwitchElm && --n == 0) {
                ((SwitchElm)circuitElm).toggle();
                this.analyzeFlag = true;
                this.cv.repaint();
                return;
            }
            ++n2;
        }
    }

    void needAnalyze() {
        this.analyzeFlag = true;
        this.cv.repaint();
    }

    CircuitNode getCircuitNode(int n) {
        if (n >= this.nodeList.size()) {
            return null;
        }
        return (CircuitNode)this.nodeList.elementAt(n);
    }

    CircuitElm getElm(int n) {
        if (n >= this.elmList.size()) {
            return null;
        }
        return (CircuitElm)this.elmList.elementAt(n);
    }

    /*
     * Unable to fully structure code
     */
    void analyzeCircuit() {
        if (this.elmList.isEmpty()) {
            return;
        }
        this.stopMessage = null;
        this.stopElm = null;
        var3_1 = 0;
        this.nodeList = new Vector<E>();
        var4_2 = false;
        var5_3 = false;
        var6_4 = null;
        var1_5 = 0;
        while (var1_5 != this.elmList.size()) {
            var7_6 = this.getElm(var1_5);
            if (var7_6 instanceof GroundElm) {
                var4_2 = true;
                break;
            }
            if (var7_6 instanceof RailElm) {
                var5_3 = true;
            }
            if (var6_4 == null && var7_6 instanceof VoltageElm) {
                var6_4 = var7_6;
            }
            ++var1_5;
        }
        if (!var4_2 && var6_4 != null && !var5_3) {
            var7_6 = new CircuitNode();
            var8_8 = var6_4.getPost(0);
            var7_6.x = var8_8.x;
            var7_6.y = var8_8.y;
            this.nodeList.addElement(var7_6);
        } else {
            var7_6 = new CircuitNode();
            var7_6.y = -1;
            var7_6.x = -1;
            this.nodeList.addElement(var7_6);
        }
        var1_5 = 0;
        while (var1_5 != this.elmList.size()) {
            var7_6 = this.getElm(var1_5);
            var8_9 = var7_6.getInternalNodeCount();
            var9_13 = var7_6.getVoltageSourceCount();
            var10_16 = var7_6.getPostCount();
            var2_12 = 0;
            while (var2_12 != var10_16) {
                var11_18 = var7_6.getPost(var2_12);
                var12_20 = 0;
                while (var12_20 != this.nodeList.size()) {
                    var13_26 = this.getCircuitNode(var12_20);
                    if (var11_18.x == var13_26.x && var11_18.y == var13_26.y) break;
                    ++var12_20;
                }
                if (var12_20 == this.nodeList.size()) {
                    var13_26 = new CircuitNode();
                    var13_26.x = var11_18.x;
                    var13_26.y = var11_18.y;
                    var14_37 = new CircuitNodeLink();
                    var14_37.num = var2_12;
                    var14_37.elm = var7_6;
                    var13_26.links.addElement(var14_37);
                    var7_6.setNode(var2_12, this.nodeList.size());
                    this.nodeList.addElement(var13_26);
                } else {
                    var13_26 = new CircuitNodeLink();
                    var13_26.num = var2_12;
                    var13_26.elm = var7_6;
                    this.getCircuitNode((int)var12_20).links.addElement(var13_26);
                    var7_6.setNode(var2_12, var12_20);
                    if (var12_20 == 0) {
                        var7_6.setNodeVoltage(var2_12, 0.0);
                    }
                }
                ++var2_12;
            }
            var2_12 = 0;
            while (var2_12 != var8_9) {
                var11_18 = new CircuitNode();
                var11_18.y = -1;
                var11_18.x = -1;
                var11_18.internal = true;
                var12_21 = new CircuitNodeLink();
                var12_21.num = var2_12 + var10_16;
                var12_21.elm = var7_6;
                var11_18.links.addElement(var12_21);
                var7_6.setNode(var12_21.num, this.nodeList.size());
                this.nodeList.addElement(var11_18);
                ++var2_12;
            }
            var3_1 += var9_13;
            ++var1_5;
        }
        this.voltageSources = new CircuitElm[var3_1];
        var3_1 = 0;
        this.circuitNonLinear = false;
        var1_5 = 0;
        while (var1_5 != this.elmList.size()) {
            var7_6 = this.getElm(var1_5);
            if (var7_6.nonLinear()) {
                this.circuitNonLinear = true;
            }
            var8_10 = var7_6.getVoltageSourceCount();
            var2_12 = 0;
            while (var2_12 != var8_10) {
                this.voltageSources[var3_1] = var7_6;
                var7_6.setVoltageSource(var2_12, var3_1++);
                ++var2_12;
            }
            ++var1_5;
        }
        this.voltageSourceCount = var3_1;
        var7_7 = this.nodeList.size() - 1 + var3_1;
        this.circuitMatrix = new double[var7_7][var7_7];
        this.circuitRightSide = new double[var7_7];
        this.origMatrix = new double[var7_7][var7_7];
        this.origRightSide = new double[var7_7];
        this.circuitMatrixSize = this.circuitMatrixFullSize = var7_7;
        this.circuitRowInfo = new RowInfo[var7_7];
        this.circuitPermute = new int[var7_7];
        var8_11 = false;
        var1_5 = 0;
        while (var1_5 != var7_7) {
            this.circuitRowInfo[var1_5] = new RowInfo();
            ++var1_5;
        }
        this.circuitNeedsMap = false;
        var1_5 = 0;
        while (var1_5 != this.elmList.size()) {
            var9_14 = this.getElm(var1_5);
            var9_14.stamp();
            ++var1_5;
        }
        var9_15 = new boolean[this.nodeList.size()];
        var10_17 = new boolean[this.nodeList.size()];
        var11_19 = true;
        var9_15[0] = true;
        block9: while (var11_19) {
            var11_19 = false;
            var1_5 = 0;
            while (var1_5 != this.elmList.size()) {
                var12_22 = this.getElm(var1_5);
                var2_12 = 0;
                while (var2_12 < var12_22.getPostCount()) {
                    if (!var9_15[var12_22.getNode(var2_12)]) {
                        if (var12_22.hasGroundConnection(var2_12)) {
                            var11_19 = true;
                            var9_15[var12_22.getNode((int)var2_12)] = true;
                        }
                    } else {
                        var13_28 = 0;
                        while (var13_28 != var12_22.getPostCount()) {
                            if (var2_12 != var13_28) {
                                var14_38 = var12_22.getNode(var13_28);
                                if (var12_22.getConnection(var2_12, var13_28) && !var9_15[var14_38]) {
                                    var9_15[var14_38] = true;
                                    var11_19 = true;
                                }
                            }
                            ++var13_28;
                        }
                    }
                    ++var2_12;
                }
                ++var1_5;
            }
            if (var11_19) continue;
            var1_5 = 0;
            while (var1_5 != this.nodeList.size()) {
                if (!var9_15[var1_5] && !this.getCircuitNode((int)var1_5).internal) {
                    System.out.println("node " + var1_5 + " unconnected");
                    this.stampResistor(0, var1_5, 1.0E8);
                    var9_15[var1_5] = true;
                    var11_19 = true;
                    continue block9;
                }
                ++var1_5;
            }
        }
        var1_5 = 0;
        while (var1_5 != this.elmList.size()) {
            var12_23 = this.getElm(var1_5);
            if (var12_23 instanceof InductorElm && !(var13_29 = new FindPathInfo(1, var12_23, var12_23.getNode(1))).findPath(var12_23.getNode(0))) {
                System.out.println(var12_23 + " no path");
                var12_23.reset();
            }
            if (var12_23 instanceof CurrentElm && !(var13_30 = new FindPathInfo(1, var12_23, var12_23.getNode(1))).findPath(var12_23.getNode(0))) {
                this.stop("No path for current source!", var12_23);
                return;
            }
            if (var12_23 instanceof VoltageElm && var12_23.getPostCount() == 2 && (var13_31 = new FindPathInfo(2, var12_23, var12_23.getNode(1))).findPath(var12_23.getNode(0))) {
                this.stop("Voltage source loop with no resistance!", var12_23);
                return;
            }
            if (var12_23 instanceof CapacitorElm) {
                var13_32 = new FindPathInfo(3, var12_23, var12_23.getNode(1));
                if (var13_32.findPath(var12_23.getNode(0))) {
                    System.out.println(var12_23 + " shorted");
                    var12_23.reset();
                } else {
                    var13_32 = new FindPathInfo(4, var12_23, var12_23.getNode(1));
                    if (var13_32.findPath(var12_23.getNode(0))) {
                        this.stop("Capacitor loop with no resistance!", var12_23);
                        return;
                    }
                }
            }
            ++var1_5;
        }
        var1_5 = 0;
        while (var1_5 != var7_7) {
            block73: {
                block74: {
                    var12_24 = -1;
                    var13_33 = -1;
                    var14_39 = 0.0;
                    var16_40 = this.circuitRowInfo[var1_5];
                    if (var16_40.lsChanges || var16_40.dropRow || var16_40.rsChanges) break block73;
                    var17_42 = 0.0;
                    var2_12 = 0;
                    while (var2_12 != var7_7) {
                        var19_45 = this.circuitMatrix[var1_5][var2_12];
                        if (this.circuitRowInfo[var2_12].type == 1) {
                            var17_42 -= this.circuitRowInfo[var2_12].value * var19_45;
                        } else if (var19_45 != 0.0) {
                            if (var13_33 == -1) {
                                var13_33 = var2_12;
                                var14_39 = var19_45;
                            } else {
                                if (var12_24 != -1 || var19_45 != -var14_39) break;
                                var12_24 = var2_12;
                            }
                        }
                        ++var2_12;
                    }
                    if (var2_12 != var7_7) break block73;
                    if (var13_33 == -1) {
                        this.stop("Matrix error", null);
                        return;
                    }
                    var19_46 = this.circuitRowInfo[var13_33];
                    if (var12_24 != -1) break block74;
                    var20_47 = 0;
                    while (var19_46.type == 2 && var20_47 < 100) {
                        var13_33 = var19_46.nodeEq;
                        var19_46 = this.circuitRowInfo[var13_33];
                        ++var20_47;
                    }
                    if (var19_46.type == 2) {
                        var19_46.type = 0;
                    } else if (var19_46.type != 0) {
                        System.out.println("type already " + var19_46.type + " for " + var13_33 + "!");
                    } else {
                        var19_46.type = 1;
                        var19_46.value = (this.circuitRightSide[var1_5] + var17_42) / var14_39;
                        this.circuitRowInfo[var1_5].dropRow = true;
                        var1_5 = -1;
                    }
                    break block73;
                }
                if (this.circuitRightSide[var1_5] + var17_42 != 0.0) break block73;
                if (var19_46.type == 0) ** GOTO lbl-1000
                var20_47 = var12_24;
                var12_24 = var13_33;
                var13_33 = var20_47;
                var19_46 = this.circuitRowInfo[var13_33];
                if (var19_46.type != 0) {
                    System.out.println("swap failed");
                } else lbl-1000:
                // 2 sources

                {
                    var19_46.type = 2;
                    var19_46.nodeEq = var12_24;
                    this.circuitRowInfo[var1_5].dropRow = true;
                }
            }
            ++var1_5;
        }
        var12_25 = 0;
        var1_5 = 0;
        while (var1_5 != var7_7) {
            var13_34 = this.circuitRowInfo[var1_5];
            if (var13_34.type == 0) {
                var13_34.mapCol = var12_25++;
            } else {
                if (var13_34.type == 2) {
                    var14_37 = null;
                    var2_12 = 0;
                    while (var2_12 != 100) {
                        var14_37 = this.circuitRowInfo[var13_34.nodeEq];
                        if (var14_37.type != 2 || var1_5 == var14_37.nodeEq) break;
                        var13_34.nodeEq = var14_37.nodeEq;
                        ++var2_12;
                    }
                }
                if (var13_34.type == 1) {
                    var13_34.mapCol = -1;
                }
            }
            ++var1_5;
        }
        var1_5 = 0;
        while (var1_5 != var7_7) {
            var13_35 = this.circuitRowInfo[var1_5];
            if (var13_35.type == 2) {
                var14_37 = this.circuitRowInfo[var13_35.nodeEq];
                if (var14_37.type == 1) {
                    var13_35.type = var14_37.type;
                    var13_35.value = var14_37.value;
                    var13_35.mapCol = -1;
                } else {
                    var13_35.mapCol = var14_37.mapCol;
                }
            }
            ++var1_5;
        }
        var13_36 = var12_25;
        var14_37 = new double[var13_36][var13_36];
        var15_48 = new double[var13_36];
        var16_41 = 0;
        var1_5 = 0;
        while (var1_5 != var7_7) {
            var17_44 = this.circuitRowInfo[var1_5];
            if (var17_44.dropRow) {
                var17_44.mapRow = -1;
            } else {
                var15_48[var16_41] = this.circuitRightSide[var1_5];
                var17_44.mapRow = var16_41;
                var2_12 = 0;
                while (var2_12 != var7_7) {
                    var18_49 = this.circuitRowInfo[var2_12];
                    if (var18_49.type == 1) {
                        v0 = var16_41;
                        var15_48[v0] = var15_48[v0] - var18_49.value * this.circuitMatrix[var1_5][var2_12];
                    } else {
                        v1 = var14_37[var16_41];
                        v2 = var18_49.mapCol;
                        v1[v2] = v1[v2] + this.circuitMatrix[var1_5][var2_12];
                    }
                    ++var2_12;
                }
                ++var16_41;
            }
            ++var1_5;
        }
        this.circuitMatrix = (double[][])var14_37;
        this.circuitRightSide = var15_48;
        var7_7 = this.circuitMatrixSize = var13_36;
        var1_5 = 0;
        while (var1_5 != var7_7) {
            this.origRightSide[var1_5] = this.circuitRightSide[var1_5];
            ++var1_5;
        }
        var1_5 = 0;
        while (var1_5 != var7_7) {
            var2_12 = 0;
            while (var2_12 != var7_7) {
                this.origMatrix[var1_5][var2_12] = this.circuitMatrix[var1_5][var2_12];
                ++var2_12;
            }
            ++var1_5;
        }
        this.circuitNeedsMap = true;
        if (!this.circuitNonLinear && !this.lu_factor(this.circuitMatrix, this.circuitMatrixSize, this.circuitPermute)) {
            this.stop("Singular matrix!", null);
            return;
        }
    }

    void stop(String string, CircuitElm circuitElm) {
        this.stopMessage = string;
        this.circuitMatrix = null;
        this.stopElm = circuitElm;
        this.stoppedCheck.setState(true);
        this.analyzeFlag = false;
        this.cv.repaint();
    }

    void stampVoltageSource(int n, int n2, int n3, double d) {
        int n4 = this.nodeList.size() + n3;
        this.stampMatrix(n4, n, -1.0);
        this.stampMatrix(n4, n2, 1.0);
        this.stampRightSide(n4, d);
        this.stampMatrix(n, n4, 1.0);
        this.stampMatrix(n2, n4, -1.0);
    }

    void stampVoltageSource(int n, int n2, int n3) {
        int n4 = this.nodeList.size() + n3;
        this.stampMatrix(n4, n, -1.0);
        this.stampMatrix(n4, n2, 1.0);
        this.stampRightSide(n4);
        this.stampMatrix(n, n4, 1.0);
        this.stampMatrix(n2, n4, -1.0);
    }

    void updateVoltageSource(int n, int n2, int n3, double d) {
        int n4 = this.nodeList.size() + n3;
        this.stampRightSide(n4, d);
    }

    void stampResistor(int n, int n2, double d) {
        double d2 = 1.0 / d;
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            System.out.print("bad resistance " + d + " " + d2 + "\n");
            int n3 = 0;
            n3 /= n3;
        }
        this.stampMatrix(n, n, d2);
        this.stampMatrix(n2, n2, d2);
        this.stampMatrix(n, n2, -d2);
        this.stampMatrix(n2, n, -d2);
    }

    void stampConductance(int n, int n2, double d) {
        this.stampMatrix(n, n, d);
        this.stampMatrix(n2, n2, d);
        this.stampMatrix(n, n2, -d);
        this.stampMatrix(n2, n, -d);
    }

    void stampVCCurrentSource(int n, int n2, int n3, int n4, double d) {
        this.stampMatrix(n, n3, d);
        this.stampMatrix(n2, n4, d);
        this.stampMatrix(n, n4, -d);
        this.stampMatrix(n2, n3, -d);
    }

    void stampCurrentSource(int n, int n2, double d) {
        this.stampRightSide(n, -d);
        this.stampRightSide(n2, d);
    }

    void stampMatrix(int n, int n2, double d) {
        if (n > 0 && n2 > 0) {
            if (this.circuitNeedsMap) {
                n = this.circuitRowInfo[n - 1].mapRow;
                RowInfo rowInfo = this.circuitRowInfo[n2 - 1];
                if (rowInfo.type == 1) {
                    int n3 = n;
                    this.circuitRightSide[n3] = this.circuitRightSide[n3] - d * rowInfo.value;
                    return;
                }
                n2 = rowInfo.mapCol;
            } else {
                --n;
            }
            double[] dArray = this.circuitMatrix[n];
            int n4 = --n2;
            dArray[n4] = dArray[n4] + d;
        }
    }

    void stampRightSide(int n, double d) {
        if (n > 0) {
            if (this.circuitNeedsMap) {
                n = this.circuitRowInfo[n - 1].mapRow;
            }
            int n2 = --n;
            this.circuitRightSide[n2] = this.circuitRightSide[n2] + d;
        }
    }

    void stampRightSide(int n) {
        if (n > 0) {
            this.circuitRowInfo[n - 1].rsChanges = true;
        }
    }

    void stampNonLinear(int n) {
        if (n > 0) {
            this.circuitRowInfo[n - 1].lsChanges = true;
        }
    }

    double getIterCount() {
        if (this.speedBar.getValue() == 0) {
            return 0.0;
        }
        return 0.1 * Math.exp((double)(this.speedBar.getValue() - 61) / 24.0);
    }

    void runCircuit() {
        if (this.circuitMatrix == null || this.elmList.size() == 0) {
            this.circuitMatrix = null;
            return;
        }
        boolean bl = this.dumpMatrix;
        this.dumpMatrix = false;
        long l = (long)(160.0 * this.getIterCount());
        long l2 = System.currentTimeMillis();
        long l3 = this.lastIterTime;
        if (1000L >= l * (l2 - this.lastIterTime)) {
            return;
        }
        int n = 1;
        while (true) {
            int n2 = 0;
            while (n2 != this.elmList.size()) {
                CircuitElm circuitElm = this.getElm(n2);
                circuitElm.startIteration();
                ++n2;
            }
            ++this.steps;
            int n3 = 0;
            while (n3 != 5000) {
                int n4;
                this.converged = true;
                this.subIterations = n3;
                n2 = 0;
                while (n2 != this.circuitMatrixSize) {
                    this.circuitRightSide[n2] = this.origRightSide[n2];
                    ++n2;
                }
                if (this.circuitNonLinear) {
                    n2 = 0;
                    while (n2 != this.circuitMatrixSize) {
                        n4 = 0;
                        while (n4 != this.circuitMatrixSize) {
                            this.circuitMatrix[n2][n4] = this.origMatrix[n2][n4];
                            ++n4;
                        }
                        ++n2;
                    }
                }
                n2 = 0;
                while (n2 != this.elmList.size()) {
                    CircuitElm circuitElm = this.getElm(n2);
                    circuitElm.doStep();
                    ++n2;
                }
                if (this.stopMessage != null) {
                    return;
                }
                boolean bl2 = bl;
                bl = false;
                n4 = 0;
                while (n4 != this.circuitMatrixSize) {
                    n2 = 0;
                    while (n2 != this.circuitMatrixSize) {
                        double d = this.circuitMatrix[n2][n4];
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            this.stop("nan/infinite matrix!", null);
                            return;
                        }
                        ++n2;
                    }
                    ++n4;
                }
                if (bl2) {
                    n4 = 0;
                    while (n4 != this.circuitMatrixSize) {
                        n2 = 0;
                        while (n2 != this.circuitMatrixSize) {
                            System.out.print(this.circuitMatrix[n4][n2] + ",");
                            ++n2;
                        }
                        System.out.print("  " + this.circuitRightSide[n4] + "\n");
                        ++n4;
                    }
                    System.out.print("\n");
                }
                if (this.circuitNonLinear) {
                    if (this.converged && n3 > 0) break;
                    if (!this.lu_factor(this.circuitMatrix, this.circuitMatrixSize, this.circuitPermute)) {
                        this.stop("Singular matrix!", null);
                        return;
                    }
                }
                this.lu_solve(this.circuitMatrix, this.circuitMatrixSize, this.circuitPermute, this.circuitRightSide);
                n4 = 0;
                while (n4 != this.circuitMatrixFullSize) {
                    RowInfo rowInfo = this.circuitRowInfo[n4];
                    double d = 0.0;
                    d = rowInfo.type == 1 ? rowInfo.value : this.circuitRightSide[rowInfo.mapCol];
                    if (Double.isNaN(d)) {
                        this.converged = false;
                        break;
                    }
                    if (n4 < this.nodeList.size() - 1) {
                        CircuitNode circuitNode = this.getCircuitNode(n4 + 1);
                        int n5 = 0;
                        while (n5 != circuitNode.links.size()) {
                            CircuitNodeLink circuitNodeLink = (CircuitNodeLink)circuitNode.links.elementAt(n5);
                            circuitNodeLink.elm.setNodeVoltage(circuitNodeLink.num, d);
                            ++n5;
                        }
                    } else {
                        int n6 = n4 - (this.nodeList.size() - 1);
                        this.voltageSources[n6].setCurrent(n6, d);
                    }
                    ++n4;
                }
                if (!this.circuitNonLinear) break;
                ++n3;
            }
            if (n3 > 5) {
                System.out.print("converged after " + n3 + " iterations\n");
            }
            if (n3 == 5000) {
                this.stop("Convergence failed!", null);
                break;
            }
            this.t += this.timeStep;
            n2 = 0;
            while (n2 != this.scopeCount) {
                this.scopes[n2].timeStep();
                ++n2;
            }
            l3 = l2 = System.currentTimeMillis();
            if ((long)(n * 1000) >= l * (l2 - this.lastIterTime) || l2 - this.lastFrameTime > 500L) break;
            ++n;
        }
        this.lastIterTime = l3;
    }

    int abs(int n) {
        return n < 0 ? -n : n;
    }

    int sign(int n) {
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    void editFuncPoint(int n, int n2) {
        this.cv.repaint(this.pause);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(100L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.resetButton) {
            this.dbimage = this.main.createImage(this.winSize.width, this.winSize.height);
            n = 0;
            while (n != this.elmList.size()) {
                this.getElm(n).reset();
                ++n;
            }
            n = 0;
            while (n != this.scopeCount) {
                this.scopes[n].resetGraph();
                ++n;
            }
            this.analyzeFlag = true;
            this.t = 0.0;
            this.stoppedCheck.setState(false);
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.dumpMatrixButton) {
            this.dumpMatrix = true;
        }
        if (actionEvent.getSource() == this.exportItem) {
            this.doImport(false);
        }
        if (actionEvent.getSource() == this.importItem) {
            this.doImport(true);
        }
        if (actionEvent.getSource() == this.exitItem) {
            this.applet.destroyFrame();
            return;
        }
        if (string.compareTo("stackAll") == 0) {
            this.stackAll();
        }
        if (string.compareTo("unstackAll") == 0) {
            this.unstackAll();
        }
        if (actionEvent.getSource() == this.elmEditMenuItem) {
            this.doEdit();
        }
        if (actionEvent.getSource() == this.elmDeleteMenuItem && this.menuElm != null) {
            this.deleteElm(this.menuElm);
        }
        if (actionEvent.getSource() == this.elmScopeMenuItem && this.menuElm != null) {
            n = 0;
            while (n != this.scopeCount) {
                if (this.scopes[n].elm == null) break;
                ++n;
            }
            if (n == this.scopeCount) {
                if (this.scopeCount == this.scopes.length) {
                    return;
                }
                ++this.scopeCount;
                this.scopes[n] = new Scope();
                this.scopes[n].position = n;
                this.handleResize();
            }
            this.scopes[n].setElm(this.menuElm);
        }
        if (this.menuScope != -1) {
            if (string.compareTo("remove") == 0) {
                this.scopes[this.menuScope].setElm(null);
            }
            if (string.compareTo("speed2") == 0) {
                this.scopes[this.menuScope].speedUp();
            }
            if (string.compareTo("speed1/2") == 0) {
                this.scopes[this.menuScope].slowDown();
            }
            if (string.compareTo("scale") == 0) {
                this.scopes[this.menuScope].adjustScale(0.5);
            }
            if (string.compareTo("stack") == 0) {
                this.stackScope(this.menuScope);
            }
            if (string.compareTo("unstack") == 0) {
                this.unstackScope(this.menuScope);
            }
            if (string.compareTo("selecty") == 0) {
                this.scopes[this.menuScope].selectY();
            }
            this.cv.repaint();
        }
        if (string.indexOf("setup ") == 0) {
            this.readSetupFile(string.substring(6), ((MenuItem)actionEvent.getSource()).getLabel());
        }
    }

    void stackScope(int n) {
        if (n == 0) {
            if (this.scopeCount < 2) {
                return;
            }
            n = 1;
        }
        if (this.scopes[n].position == this.scopes[n - 1].position) {
            return;
        }
        this.scopes[n].position = this.scopes[n - 1].position;
        ++n;
        while (n < this.scopeCount) {
            --this.scopes[n].position;
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    void unstackScope(int var1_1) {
        if (var1_1 == 0) {
            if (this.scopeCount < 2) {
                return;
            }
            var1_1 = 1;
        }
        if (this.scopes[var1_1].position == this.scopes[var1_1 - 1].position) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            ++this.scopes[var1_1].position;
            ++var1_1;
lbl9:
            // 2 sources

            ** while (var1_1 < this.scopeCount)
        }
lbl10:
        // 1 sources

    }

    void stackAll() {
        int n = 0;
        while (n != this.scopeCount) {
            this.scopes[n].position = 0;
            this.scopes[n].showMax = false;
            ++n;
        }
    }

    void unstackAll() {
        int n = 0;
        while (n != this.scopeCount) {
            this.scopes[n].position = n;
            this.scopes[n].showMax = true;
            ++n;
        }
    }

    void doEdit() {
        if (this.editDialog != null) {
            this.requestFocus();
            ((Component)this.editDialog).setVisible(false);
            this.editDialog = null;
        }
        this.editDialog = new EditDialog(this.menuElm, this);
        this.editDialog.show();
    }

    void doImport(boolean bl) {
        if (this.impDialog != null) {
            this.requestFocus();
            ((Component)this.impDialog).setVisible(false);
            this.impDialog = null;
        }
        String string = "";
        if (!bl) {
            int n = this.dotsCheckItem.getState() ? 1 : 0;
            n |= this.smallGridCheckItem.getState() ? 2 : 0;
            n |= this.voltsCheckItem.getState() ? 0 : 4;
            n |= this.powerCheckItem.getState() ? 8 : 0;
            string = "$ " + (n |= this.showValuesCheckItem.getState() ? 0 : 16) + " " + this.timeStep + " " + this.getIterCount() + " " + this.currentBar.getValue() + " " + this.voltageRange + " " + this.powerBar.getValue() + "\n";
            int n2 = 0;
            while (n2 != this.elmList.size()) {
                string = string + this.getElm(n2).dump() + "\n";
                ++n2;
            }
            n2 = 0;
            while (n2 != this.scopeCount) {
                String string2 = this.scopes[n2].dump();
                if (string2 != null) {
                    string = string + string2 + "\n";
                }
                ++n2;
            }
            if (this.hintType != -1) {
                string = string + "h " + this.hintType + " " + this.hintItem1 + " " + this.hintItem2 + "\n";
            }
        }
        this.impDialog = new ImportDialog(this, string);
        this.impDialog.show();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        System.out.print(((Scrollbar)adjustmentEvent.getSource()).getValue() + "\n");
    }

    ByteArrayOutputStream readUrlData(URL uRL) throws IOException {
        int n;
        Object object = uRL.getContent();
        FilterInputStream filterInputStream = (FilterInputStream)object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(filterInputStream.available());
        int n2 = 1024;
        byte[] byArray = new byte[n2];
        while ((n = filterInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream;
    }

    void getSetupList(Menu menu, boolean bl) {
        System.out.println("getsetuplist " + bl);
        Menu[] menuArray = new Menu[6];
        int n = 0;
        menuArray[n++] = menu;
        try {
            URL uRL = new URL(this.applet.getCodeBase() + "setuplist.txt");
            ByteArrayOutputStream byteArrayOutputStream = this.readUrlData(uRL);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n2 = byteArrayOutputStream.size();
            if (n2 == 0 || byArray[0] != 35) {
                this.getSetupList(menu, true);
                return;
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 != n2 - n3) {
                    if (byArray[n4 + n3] == 10) {
                        ++n4;
                        break;
                    }
                    ++n4;
                }
                String string = new String(byArray, n3, n4 - 1);
                if (string.charAt(0) != '#') {
                    if (string.charAt(0) == '+') {
                        Menu menu2 = new Menu(string.substring(1));
                        menu.add(menu2);
                        int n5 = n++;
                        Menu menu3 = menu2;
                        menuArray[n5] = menu3;
                        menu = menu3;
                    } else if (string.charAt(0) == '-') {
                        menu = menuArray[--n - 1];
                    } else {
                        int n6 = string.indexOf(32);
                        if (n6 > 0) {
                            menu.add(this.getMenuItem(string.substring(n6 + 1), "setup " + string.substring(0, n6)));
                        }
                    }
                }
                n3 += n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop("Can't read setuplist.txt!", null);
        }
    }

    void readSetup(String string) {
        this.readSetup(string.getBytes(), string.length());
        this.titleLabel.setText("untitled");
    }

    void readSetupFile(String string, String string2) {
        this.t = 0.0;
        System.out.println(string);
        try {
            URL uRL = new URL(this.applet.getCodeBase() + "circuits/" + string);
            ByteArrayOutputStream byteArrayOutputStream = this.readUrlData(uRL);
            this.readSetup(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop("Unable to read " + string + "!", null);
        }
        this.titleLabel.setText(string2);
    }

    void readSetup(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n2);
            circuitElm.delete();
            ++n2;
        }
        this.elmList.removeAllElements();
        this.hintType = -1;
        this.timeStep = 5.0E-6;
        this.dotsCheckItem.setState(true);
        this.smallGridCheckItem.setState(false);
        this.powerCheckItem.setState(false);
        this.voltsCheckItem.setState(true);
        this.showValuesCheckItem.setState(true);
        this.setGrid();
        this.speedBar.setValue(117);
        this.currentBar.setValue(50);
        this.powerBar.setValue(50);
        this.voltageRange = 5.0;
        this.cv.repaint();
        this.scopeCount = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            int n5 = 0;
            while (n5 != n - n3) {
                if (byArray[n5 + n3] == 10 || byArray[n5 + n3] == 13) {
                    n4 = n5++;
                    if (n5 + n3 >= byArray.length || byArray[n5 + n3] != 10) break;
                    ++n5;
                    break;
                }
                ++n5;
            }
            String string = new String(byArray, n3, n4);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n6 = string2.charAt(0);
                try {
                    if (n6 == 111) {
                        Scope scope = new Scope();
                        scope.position = this.scopeCount;
                        scope.undump(stringTokenizer);
                        this.scopes[this.scopeCount++] = scope;
                    }
                    if (n6 == 104) {
                        this.readHint(stringTokenizer);
                    }
                    if (n6 == 36) {
                        this.readOptions(stringTokenizer);
                    }
                    if (n6 >= 48 && n6 <= 57) {
                        n6 = new Integer(string2);
                    }
                    int n7 = new Integer(stringTokenizer.nextToken());
                    int n8 = new Integer(stringTokenizer.nextToken());
                    int n9 = new Integer(stringTokenizer.nextToken());
                    int n10 = new Integer(stringTokenizer.nextToken());
                    int n11 = new Integer(stringTokenizer.nextToken());
                    CircuitElm circuitElm = null;
                    Class clazz = this.dumpTypes[n6];
                    if (clazz == null) {
                        System.out.println("unrecognized dump type: " + string2);
                    }
                    Class[] classArray = new Class[7];
                    classArray[0] = this.getClass();
                    classArray[4] = classArray[5] = Integer.TYPE;
                    classArray[3] = classArray[5];
                    classArray[2] = classArray[5];
                    classArray[1] = classArray[5];
                    classArray[6] = class$java$util$StringTokenizer == null ? CircuitFrame.class$("java.util.StringTokenizer") : class$java$util$StringTokenizer;
                    Constructor constructor = null;
                    constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{this, new Integer(n7), new Integer(n8), new Integer(n9), new Integer(n10), new Integer(n11), stringTokenizer};
                    circuitElm = (CircuitElm)constructor.newInstance(objectArray);
                    circuitElm.setPoints();
                    this.elmList.addElement(circuitElm);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            n3 += n5;
        }
        this.enableItems();
        this.handleResize();
        this.analyzeCircuit();
    }

    void readHint(StringTokenizer stringTokenizer) {
        this.hintType = new Integer(stringTokenizer.nextToken());
        this.hintItem1 = new Integer(stringTokenizer.nextToken());
        this.hintItem2 = new Integer(stringTokenizer.nextToken());
    }

    void readOptions(StringTokenizer stringTokenizer) {
        int n = new Integer(stringTokenizer.nextToken());
        this.dotsCheckItem.setState((n & 1) != 0);
        this.smallGridCheckItem.setState((n & 2) != 0);
        this.voltsCheckItem.setState((n & 4) == 0);
        this.powerCheckItem.setState((n & 8) == 8);
        this.showValuesCheckItem.setState((n & 0x10) == 0);
        this.timeStep = new Double(stringTokenizer.nextToken());
        double d = new Double(stringTokenizer.nextToken());
        int n2 = (int)(Math.log(10.0 * d) * 24.0 + 61.5);
        this.speedBar.setValue(n2);
        this.currentBar.setValue(new Integer(stringTokenizer.nextToken()));
        this.voltageRange = new Double(stringTokenizer.nextToken());
        try {
            this.powerBar.setValue(new Integer(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setGrid();
    }

    int snapGrid(int n) {
        return n + this.gridRound & this.gridMask;
    }

    boolean doSwitch(int n, int n2) {
        if (this.mouseElm == null || !(this.mouseElm instanceof SwitchElm)) {
            return false;
        }
        SwitchElm switchElm = (SwitchElm)this.mouseElm;
        switchElm.toggle();
        if (switchElm.momentary) {
            this.heldSwitchElm = switchElm;
        }
        this.analyzeCircuit();
        return true;
    }

    void deleteElm(CircuitElm circuitElm) {
        int n = this.locateElm(circuitElm);
        if (n >= 0) {
            circuitElm.delete();
            this.elmList.removeElementAt(n);
            this.analyzeCircuit();
        }
    }

    int locateElm(CircuitElm circuitElm) {
        int n = 0;
        while (n != this.elmList.size()) {
            if (circuitElm == this.elmList.elementAt(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.circuitArea.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        if (this.dragElm != null) {
            this.dragElm.drag(mouseEvent.getX(), mouseEvent.getY());
        }
        switch (this.mouseMode) {
            case 1: {
                this.dragAll(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 2: {
                this.dragRow(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 3: {
                this.dragColumn(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 5: {
                if (this.mouseElm == null) break;
                this.dragPost(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 4: {
                if (this.mouseElm == null) break;
                this.dragItem(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        this.dragging = true;
        if (this.mouseMode == 4 && this.mouseElm instanceof TextElm) {
            this.dragX = mouseEvent.getX();
            this.dragY = mouseEvent.getY();
        } else {
            this.dragX = this.snapGrid(mouseEvent.getX());
            this.dragY = this.snapGrid(mouseEvent.getY());
        }
        this.cv.repaint(this.pause);
    }

    void dragAll(int n, int n2) {
        int n3 = n - this.dragX;
        int n4 = n2 - this.dragY;
        if (n3 == 0 && n4 == 0) {
            return;
        }
        int n5 = 0;
        while (n5 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n5);
            circuitElm.move(n3, n4);
            ++n5;
        }
        this.removeZeroLengthElements();
    }

    void dragRow(int n, int n2) {
        int n3 = n2 - this.dragY;
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        while (n4 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n4);
            if (circuitElm.y == this.dragY) {
                circuitElm.movePoint(0, 0, n3);
            }
            if (circuitElm.y2 == this.dragY) {
                circuitElm.movePoint(1, 0, n3);
            }
            ++n4;
        }
        this.removeZeroLengthElements();
    }

    void dragColumn(int n, int n2) {
        int n3 = n - this.dragX;
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        while (n4 != this.elmList.size()) {
            CircuitElm circuitElm = this.getElm(n4);
            if (circuitElm.x == this.dragX) {
                circuitElm.movePoint(0, n3, 0);
            }
            if (circuitElm.x2 == this.dragX) {
                circuitElm.movePoint(1, n3, 0);
            }
            ++n4;
        }
        this.removeZeroLengthElements();
    }

    void dragItem(int n, int n2) {
        if (!(this.mouseElm instanceof TextElm)) {
            n = this.snapGrid(n);
            n2 = this.snapGrid(n2);
        }
        int n3 = n - this.dragX;
        int n4 = n2 - this.dragY;
        if (n3 == 0 && n4 == 0) {
            return;
        }
        this.mouseElm.movePoint(0, n3, n4);
        this.mouseElm.movePoint(1, n3, n4);
        this.analyzeCircuit();
    }

    void dragPost(int n, int n2) {
        if (this.draggingPost == -1) {
            this.draggingPost = this.distanceSq(this.mouseElm.x, this.mouseElm.y, n, n2) > this.distanceSq(this.mouseElm.x2, this.mouseElm.y2, n, n2) ? 1 : 0;
        }
        int n3 = n - this.dragX;
        int n4 = n2 - this.dragY;
        if (n3 == 0 && n4 == 0) {
            return;
        }
        this.mouseElm.movePoint(this.draggingPost, n3, n4);
        this.analyzeCircuit();
    }

    void removeZeroLengthElements() {
        boolean bl = false;
        int n = this.elmList.size() - 1;
        while (n >= 0) {
            CircuitElm circuitElm = this.getElm(n);
            if (circuitElm.x == circuitElm.x2 && circuitElm.y == circuitElm.y2) {
                this.elmList.removeElementAt(n);
                bl = true;
            }
            --n;
        }
        this.analyzeCircuit();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2;
        Object object;
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            return;
        }
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        this.dragX = this.snapGrid(n3);
        this.dragY = this.snapGrid(n4);
        this.draggingPost = -1;
        CircuitElm circuitElm = this.mouseElm;
        this.mouseElm = null;
        this.mousePost = -1;
        this.plotYElm = null;
        this.plotXElm = null;
        int n5 = 100000;
        int n6 = 100000;
        int n7 = 0;
        while (n7 != this.elmList.size()) {
            object = this.getElm(n7);
            if (((CircuitElm)object).boundingBox.contains(n3, n4)) {
                n2 = ((CircuitElm)object).boundingBox.width * ((CircuitElm)object).boundingBox.height;
                int n8 = ((CircuitElm)object).getPostCount();
                if (n8 > 2) {
                    n8 = 2;
                }
                n = 0;
                while (n != n8) {
                    Point point = ((CircuitElm)object).getPost(n);
                    int n9 = this.distanceSq(n3, n4, point.x, point.y);
                    if (n9 <= n5 && n2 <= n6) {
                        n5 = n9;
                        n6 = n2;
                        this.mouseElm = object;
                    }
                    ++n;
                }
                if (((CircuitElm)object).getPostCount() == 0) {
                    this.mouseElm = object;
                }
            }
            ++n7;
        }
        this.scopeSelected = -1;
        if (this.mouseElm == null) {
            n7 = 0;
            while (n7 != this.scopeCount) {
                object = this.scopes[n7];
                if (((Scope)object).rect.contains(n3, n4)) {
                    ((Scope)object).select();
                    this.scopeSelected = n7;
                }
                ++n7;
            }
            n7 = 0;
            while (n7 != this.elmList.size()) {
                object = this.getElm(n7);
                n2 = ((CircuitElm)object).getPostCount();
                n = 0;
                while (n != n2) {
                    Point point = ((CircuitElm)object).getPost(n);
                    int n10 = this.distanceSq(n3, n4, point.x, point.y);
                    if (this.distanceSq(point.x, point.y, n3, n4) < 26) {
                        this.mouseElm = object;
                        this.mousePost = n;
                        break;
                    }
                    ++n;
                }
                ++n7;
            }
        } else {
            this.mousePost = -1;
            n7 = 0;
            while (n7 != this.mouseElm.getPostCount()) {
                object = this.mouseElm.getPost(n7);
                if (this.distanceSq(((Point)object).x, ((Point)object).y, n3, n4) < 26) {
                    this.mousePost = n7;
                }
                ++n7;
            }
        }
        if (this.mouseElm != circuitElm) {
            this.cv.repaint();
        }
    }

    int distanceSq(int n, int n2, int n3, int n4) {
        return (n3 -= n) * n3 + (n4 -= n2) * n4;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.scopeSelected = -1;
        this.plotYElm = null;
        this.plotXElm = null;
        this.mouseElm = null;
        this.cv.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger()) {
            this.doPopupMenu(mouseEvent);
            return;
        }
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.doSwitch(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        this.dragging = true;
        if (this.mouseMode != 0 || this.addingClass == null) {
            return;
        }
        int n2 = this.snapGrid(mouseEvent.getX());
        if (!this.circuitArea.contains(n2, n = this.snapGrid(mouseEvent.getY()))) {
            return;
        }
        this.dragElm = this.constructElement(this.addingClass, n2, n);
    }

    CircuitElm constructElement(Class clazz, int n, int n2) {
        Class[] classArray = new Class[3];
        classArray[0] = this.getClass();
        classArray[1] = classArray[2] = Integer.TYPE;
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Object[] objectArray = new Object[]{this, new Integer(n), new Integer(n2)};
        try {
            return (CircuitElm)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void doPopupMenu(MouseEvent mouseEvent) {
        this.menuElm = this.mouseElm;
        this.menuScope = -1;
        if (this.scopeSelected != -1) {
            PopupMenu popupMenu = this.scopes[this.scopeSelected].getMenu();
            this.menuScope = this.scopeSelected;
            if (popupMenu != null) {
                popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (this.mouseElm != null) {
            this.elmEditMenuItem.setEnabled(this.mouseElm.getEditInfo(0) != null);
            this.elmScopeMenuItem.setEnabled(this.mouseElm.canViewInScope());
            this.elmMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.doMainMenuChecks(this.mainMenu);
            this.mainMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void doMainMenuChecks(Menu menu) {
        if (menu == this.optionsMenu) {
            return;
        }
        int n = 0;
        while (n != menu.getItemCount()) {
            MenuItem menuItem = menu.getItem(n);
            if (menuItem instanceof Menu) {
                this.doMainMenuChecks((Menu)menuItem);
            }
            if (menuItem instanceof CheckboxMenuItem) {
                CheckboxMenuItem checkboxMenuItem;
                checkboxMenuItem.setState(this.mouseModeStr.compareTo((checkboxMenuItem = (CheckboxMenuItem)menuItem).getActionCommand()) == 0);
            }
            ++n;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopupMenu(mouseEvent);
            return;
        }
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.dragging = false;
        boolean bl = false;
        if (this.heldSwitchElm != null) {
            this.heldSwitchElm.mouseUp();
            this.heldSwitchElm = null;
            bl = true;
        }
        if (this.dragElm != null && (this.dragElm.x != this.dragElm.x2 || this.dragElm.y != this.dragElm.y2)) {
            this.elmList.addElement(this.dragElm);
            this.dragElm = null;
            bl = true;
        }
        if (bl) {
            this.analyzeCircuit();
        }
        if (this.dragElm != null) {
            this.dragElm.delete();
        }
        this.dragElm = null;
        this.cv.repaint();
    }

    void enableItems() {
        if (this.powerCheckItem.getState()) {
            this.powerBar.enable();
            this.powerLabel.enable();
        } else {
            this.powerBar.disable();
            this.powerLabel.disable();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        this.cv.repaint(this.pause);
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.stoppedCheck) {
            return;
        }
        if (itemSelectable == this.smallGridCheckItem) {
            this.setGrid();
        }
        if (itemSelectable == this.powerCheckItem) {
            if (this.powerCheckItem.getState()) {
                this.voltsCheckItem.setState(false);
            } else {
                this.voltsCheckItem.setState(true);
            }
        }
        if (itemSelectable == this.voltsCheckItem && this.voltsCheckItem.getState()) {
            this.powerCheckItem.setState(false);
        }
        this.enableItems();
        if (this.menuScope != -1) {
            object = this.scopes[this.menuScope];
            ((Scope)object).handleMenu(itemEvent, itemSelectable);
        }
        if (itemSelectable instanceof CheckboxMenuItem) {
            object = (MenuItem)((Object)itemSelectable);
            this.mouseMode = 0;
            String string = ((MenuItem)object).getActionCommand();
            if (string.length() > 0) {
                this.mouseModeStr = string;
            }
            if (string.compareTo("DragAll") == 0) {
                this.mouseMode = 1;
            } else if (string.compareTo("DragRow") == 0) {
                this.mouseMode = 2;
            } else if (string.compareTo("DragColumn") == 0) {
                this.mouseMode = 3;
            } else if (string.compareTo("DragSelected") == 0) {
                this.mouseMode = 4;
            } else if (string.compareTo("DragPost") == 0) {
                this.mouseMode = 5;
            } else if (string.length() > 0) {
                try {
                    this.addingClass = Class.forName("CircuitFrame$" + string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    void setGrid() {
        this.gridSize = this.smallGridCheckItem.getState() ? 8 : 16;
        this.gridMask = ~(this.gridSize - 1);
        this.gridRound = this.gridSize / 2 - 1;
    }

    String getVoltageDText(double d) {
        return this.getUnitText(Math.abs(d), "V");
    }

    String getVoltageText(double d) {
        return this.getUnitText(d, "V");
    }

    String getUnitText(double d, String string) {
        double d2 = Math.abs(d);
        if (d2 < 1.0E-12) {
            return "0 " + string;
        }
        if (d2 < 1.0E-9) {
            return this.showFormat.format(d * 1.0E12) + " p" + string;
        }
        if (d2 < 1.0E-6) {
            return this.showFormat.format(d * 1.0E9) + " n" + string;
        }
        if (d2 < 0.001) {
            return this.showFormat.format(d * 1000000.0) + " " + this.muString + string;
        }
        if (d2 < 1.0) {
            return this.showFormat.format(d * 1000.0) + " m" + string;
        }
        if (d2 < 1000.0) {
            return this.showFormat.format(d) + " " + string;
        }
        if (d2 < 1000000.0) {
            return this.showFormat.format(d * 0.001) + " k" + string;
        }
        if (d2 < 1.0E9) {
            return this.showFormat.format(d * 1.0E-6) + " M" + string;
        }
        return this.showFormat.format(d * 1.0E-9) + " G" + string;
    }

    String getShortUnitText(double d, String string) {
        double d2 = Math.abs(d);
        if (d2 < 1.0E-12) {
            return null;
        }
        if (d2 < 1.0E-9) {
            return this.shortFormat.format(d * 1.0E12) + "p" + string;
        }
        if (d2 < 1.0E-6) {
            return this.shortFormat.format(d * 1.0E9) + "n" + string;
        }
        if (d2 < 0.001) {
            return this.shortFormat.format(d * 1000000.0) + this.muString + string;
        }
        if (d2 < 1.0) {
            return this.shortFormat.format(d * 1000.0) + "m" + string;
        }
        if (d2 < 1000.0) {
            return this.shortFormat.format(d) + string;
        }
        if (d2 < 1000000.0) {
            return this.shortFormat.format(d * 0.001) + "k" + string;
        }
        if (d2 < 1.0E9) {
            return this.shortFormat.format(d * 1.0E-6) + "M" + string;
        }
        return this.shortFormat.format(d * 1.0E-9) + "G" + string;
    }

    String getCurrentText(double d) {
        return this.getUnitText(d, "A");
    }

    String getCurrentDText(double d) {
        return this.getUnitText(Math.abs(d), "A");
    }

    void drawThickLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n + 1, n2, n3 + 1, n4);
        graphics.drawLine(n, n2 + 1, n3, n4 + 1);
        graphics.drawLine(n + 1, n2 + 1, n3 + 1, n4 + 1);
    }

    void drawThickLine(Graphics graphics, Point point, Point point2) {
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.drawLine(point.x + 1, point.y, point2.x + 1, point2.y);
        graphics.drawLine(point.x, point.y + 1, point2.x, point2.y + 1);
        graphics.drawLine(point.x + 1, point.y + 1, point2.x + 1, point2.y + 1);
    }

    void drawThickPolygon(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 != n - 1) {
            this.drawThickLine(graphics, nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1]);
            ++n2;
        }
        this.drawThickLine(graphics, nArray[n2], nArray2[n2], nArray[0], nArray2[0]);
    }

    void drawThickPolygon(Graphics graphics, Polygon polygon) {
        this.drawThickPolygon(graphics, polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    void drawThickCircle(Graphics graphics, int n, int n2, int n3) {
        double d = Math.PI / 180;
        double d2 = (double)n3 * 0.98;
        int n4 = 0;
        while (n4 != 360) {
            double d3 = Math.cos((double)n4 * d) * d2 + (double)n;
            double d4 = Math.sin((double)n4 * d) * d2 + (double)n2;
            double d5 = Math.cos((double)(n4 + 20) * d) * d2 + (double)n;
            double d6 = Math.sin((double)(n4 + 20) * d) * d2 + (double)n2;
            this.drawThickLine(graphics, (int)d3, (int)d4, (int)d5, (int)d6);
            n4 += 20;
        }
    }

    boolean lu_factor(double[][] dArray, int n, int[] nArray) {
        int n2;
        double d;
        double[] dArray2 = new double[n];
        int n3 = 0;
        while (n3 != n) {
            d = 0.0;
            n2 = 0;
            while (n2 != n) {
                double d2 = Math.abs(dArray[n3][n2]);
                if (d2 > d) {
                    d = d2;
                }
                ++n2;
            }
            if (d == 0.0) {
                return false;
            }
            dArray2[n3] = 1.0 / d;
            ++n3;
        }
        n2 = 0;
        while (n2 != n) {
            double d3;
            int n4;
            n3 = 0;
            while (n3 != n2) {
                d = dArray[n3][n2];
                n4 = 0;
                while (n4 != n3) {
                    d -= dArray[n3][n4] * dArray[n4][n2];
                    ++n4;
                }
                dArray[n3][n2] = d;
                ++n3;
            }
            d = 0.0;
            int n5 = -1;
            n3 = n2;
            while (n3 != n) {
                d3 = dArray[n3][n2];
                n4 = 0;
                while (n4 != n2) {
                    d3 -= dArray[n3][n4] * dArray[n4][n2];
                    ++n4;
                }
                dArray[n3][n2] = d3;
                double d4 = Math.abs(d3);
                if (d4 >= d) {
                    d = d4;
                    n5 = n3;
                }
                ++n3;
            }
            if (n2 != n5) {
                n4 = 0;
                while (n4 != n) {
                    d3 = dArray[n5][n4];
                    dArray[n5][n4] = dArray[n2][n4];
                    dArray[n2][n4] = d3;
                    ++n4;
                }
                dArray2[n5] = dArray2[n2];
            }
            nArray[n2] = n5;
            if (dArray[n2][n2] == 0.0) {
                System.out.println("avoided zero");
                dArray[n2][n2] = 1.0E-18;
            }
            if (n2 != n - 1) {
                d3 = 1.0 / dArray[n2][n2];
                n3 = n2 + 1;
                while (n3 != n) {
                    double[] dArray3 = dArray[n3];
                    int n6 = n2;
                    dArray3[n6] = dArray3[n6] * d3;
                    ++n3;
                }
            }
            ++n2;
        }
        return true;
    }

    void lu_solve(double[][] dArray, int n, int[] nArray, double[] dArray2) {
        double d;
        int n2;
        int n3 = 0;
        while (n3 != n) {
            n2 = nArray[n3];
            d = dArray2[n2];
            dArray2[n2] = dArray2[n3];
            dArray2[n3] = d;
            if (d != 0.0) break;
            ++n3;
        }
        n2 = n3++;
        while (n3 < n) {
            int n4 = nArray[n3];
            double d2 = dArray2[n4];
            dArray2[n4] = dArray2[n3];
            int n5 = n2;
            while (n5 < n3) {
                d2 -= dArray[n3][n5] * dArray2[n5];
                ++n5;
            }
            dArray2[n3] = d2;
            ++n3;
        }
        n3 = n - 1;
        while (n3 >= 0) {
            d = dArray2[n3];
            int n6 = n3 + 1;
            while (n6 != n) {
                d -= dArray[n3][n6] * dArray2[n6];
                ++n6;
            }
            dArray2[n3] = d / dArray[n3][n3];
            --n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ImportDialog
    extends Dialog
    implements ActionListener {
        CircuitFrame cframe;
        Button importButton;
        Button closeButton;
        TextArea text;

        ImportDialog(CircuitFrame circuitFrame2, String string) {
            super(circuitFrame2, string.length() > 0 ? "Export" : "Import", false);
            this.cframe = circuitFrame2;
            this.setLayout(new ImportDialogLayout());
            this.text = new TextArea(string, 10, 60, 0);
            this.add(this.text);
            this.importButton = new Button("Import");
            this.add(this.importButton);
            this.importButton.addActionListener(this);
            this.closeButton = new Button("Close");
            this.add(this.closeButton);
            this.closeButton.addActionListener(this);
            Point point = CircuitFrame.this.main.getLocationOnScreen();
            this.resize(400, 300);
            Dimension dimension = this.getSize();
            ((Component)this).setLocation(point.x + (CircuitFrame.this.winSize.width - dimension.width) / 2, point.y + (CircuitFrame.this.winSize.height - dimension.height) / 2);
            this.show();
            if (string.length() > 0) {
                this.text.selectAll();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.importButton) {
                this.cframe.readSetup(this.text.getText());
                ((Component)this).setVisible(false);
            }
            if (object == this.closeButton) {
                ((Component)this).setVisible(false);
            }
        }

        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                CircuitFrame.this.main.requestFocus();
                ((Component)this).setVisible(false);
                CircuitFrame.this.editDialog = null;
                return true;
            }
            return super.handleEvent(event);
        }
    }

    class ImportDialogLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(500, 500);
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(100, 100);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.insets();
            int n = container.size().width - insets.left - insets.right;
            int n2 = container.size().height - (insets.top + insets.bottom);
            int n3 = 300;
            if (container.getComponentCount() == 0) {
                return;
            }
            Component component = container.getComponent(container.getComponentCount() - 1);
            Dimension dimension = component.getPreferredSize();
            container.getComponent(0).move(insets.left, insets.top);
            int n4 = container.size().width - insets.left - insets.right;
            int n5 = container.size().height - insets.top - insets.bottom - dimension.height;
            container.getComponent(0).resize(n4, n5);
            int n6 = n5 + insets.top;
            int n7 = 0;
            int n8 = 1;
            while (n8 < container.getComponentCount()) {
                Component component2 = container.getComponent(n8);
                if (component2.isVisible()) {
                    Dimension dimension2 = component2.getPreferredSize();
                    component2.move(insets.left + n7, n6);
                    component2.resize(dimension2.width, dimension2.height);
                    n7 += dimension2.width;
                }
                ++n8;
            }
        }
    }

    class EditDialog
    extends Dialog
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        CircuitElm elm;
        CircuitFrame cframe;
        Button applyButton;
        Button okButton;
        EditInfo[] einfos;
        int einfocount;
        final int barmax = 1000;

        EditDialog(CircuitElm circuitElm, CircuitFrame circuitFrame2) {
            super(circuitFrame2, "Edit Component", false);
            Object object;
            this.cframe = circuitFrame2;
            this.elm = circuitElm;
            this.setLayout(new EditDialogLayout());
            this.einfos = new EditInfo[10];
            int n = 0;
            while (true) {
                this.einfos[n] = this.elm.getEditInfo(n);
                if (this.einfos[n] == null) break;
                object = this.einfos[n];
                this.add(new Label(((EditInfo)object).name));
                if (((EditInfo)object).choice != null) {
                    this.add(((EditInfo)object).choice);
                    ((EditInfo)object).choice.addItemListener(this);
                } else if (((EditInfo)object).checkbox != null) {
                    this.add(((EditInfo)object).checkbox);
                    ((EditInfo)object).checkbox.addItemListener(this);
                } else {
                    ((EditInfo)object).textf = new TextField(CircuitFrame.this.noCommaFormat.format(((EditInfo)object).value), 10);
                    this.add(((EditInfo)object).textf);
                    if (((EditInfo)object).text != null) {
                        ((EditInfo)object).textf.setText(((EditInfo)object).text);
                    }
                    ((EditInfo)object).textf.addActionListener(this);
                    if (((EditInfo)object).text == null) {
                        ((EditInfo)object).bar = new Scrollbar(0, 50, 10, 0, 1002);
                        this.add(((EditInfo)object).bar);
                        this.setBar((EditInfo)object);
                        ((EditInfo)object).bar.addAdjustmentListener(this);
                    }
                }
                ++n;
            }
            this.einfocount = n;
            this.applyButton = new Button("Apply");
            this.add(this.applyButton);
            this.applyButton.addActionListener(this);
            this.okButton = new Button("OK");
            this.add(this.okButton);
            this.okButton.addActionListener(this);
            object = CircuitFrame.this.main.getLocationOnScreen();
            Dimension dimension = this.getSize();
            ((Component)this).setLocation(((Point)object).x + (CircuitFrame.this.winSize.width - dimension.width) / 2, ((Point)object).y + (CircuitFrame.this.winSize.height - dimension.height) / 2);
        }

        void apply() {
            int n = 0;
            while (n != this.einfocount) {
                EditInfo editInfo = this.einfos[n];
                if (editInfo.textf != null) {
                    if (editInfo.text == null) {
                        try {
                            double d;
                            editInfo.value = d = CircuitFrame.this.noCommaFormat.parse(editInfo.textf.getText()).doubleValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.elm.setEditValue(n, editInfo);
                    if (editInfo.text == null) {
                        this.setBar(editInfo);
                    }
                }
                ++n;
            }
            this.cframe.needAnalyze();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            while (n != this.einfocount) {
                EditInfo editInfo = this.einfos[n];
                if (object == editInfo.textf) {
                    if (editInfo.text == null) {
                        try {
                            double d;
                            editInfo.value = d = CircuitFrame.this.noCommaFormat.parse(editInfo.textf.getText()).doubleValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.elm.setEditValue(n, editInfo);
                    if (editInfo.text == null) {
                        this.setBar(editInfo);
                    }
                    this.cframe.needAnalyze();
                }
                ++n;
            }
            if (actionEvent.getSource() == this.okButton) {
                this.apply();
                CircuitFrame.this.main.requestFocus();
                ((Component)this).setVisible(false);
                CircuitFrame.this.editDialog = null;
            }
            if (actionEvent.getSource() == this.applyButton) {
                this.apply();
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            int n = 0;
            while (n != this.einfocount) {
                EditInfo editInfo = this.einfos[n];
                if (editInfo.bar == object) {
                    double d = (double)editInfo.bar.getValue() / 1000.0;
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    if (d > 1.0) {
                        d = 1.0;
                    }
                    editInfo.value = (editInfo.maxval - editInfo.minval) * d + editInfo.minval;
                    editInfo.value = editInfo.maxval - editInfo.minval > 100.0 ? (double)Math.round(editInfo.value) : (double)Math.round(editInfo.value * 100.0) / 100.0;
                    this.elm.setEditValue(n, editInfo);
                    editInfo.textf.setText(CircuitFrame.this.noCommaFormat.format(editInfo.value));
                    this.cframe.needAnalyze();
                }
                ++n;
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = false;
            int n = 0;
            while (n != this.einfocount) {
                EditInfo editInfo = this.einfos[n];
                if (editInfo.choice == itemSelectable || editInfo.checkbox == itemSelectable) {
                    this.elm.setEditValue(n, editInfo);
                    if (editInfo.newDialog) {
                        bl = true;
                    }
                    this.cframe.needAnalyze();
                }
                ++n;
            }
            if (bl) {
                ((Component)this).setVisible(false);
                CircuitFrame.this.editDialog = new EditDialog(this.elm, this.cframe);
                CircuitFrame.this.editDialog.show();
            }
        }

        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                CircuitFrame.this.main.requestFocus();
                ((Component)this).setVisible(false);
                CircuitFrame.this.editDialog = null;
                return true;
            }
            return super.handleEvent(event);
        }

        void setBar(EditInfo editInfo) {
            int n = (int)(1000.0 * (editInfo.value - editInfo.minval) / (editInfo.maxval - editInfo.minval));
            editInfo.bar.setValue(n);
        }
    }

    class EditInfo {
        String name;
        String text;
        double value;
        double minval;
        double maxval;
        TextField textf;
        Scrollbar bar;
        Choice choice;
        Checkbox checkbox;
        boolean newDialog;

        EditInfo(String string, double d, double d2, double d3) {
            this.name = string;
            this.value = d;
            if (this.minval == 0.0 && this.maxval == 0.0 && d > 0.0) {
                this.minval = 1.0E10;
                while (this.minval > d / 100.0) {
                    this.minval /= 10.0;
                }
                this.maxval = this.minval * 1000.0;
            } else {
                this.minval = d2;
                this.maxval = d3;
            }
        }
    }

    class EditDialogLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(500, 500);
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(100, 100);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.insets();
            int n = container.size().width - insets.left - insets.right;
            int n2 = container.size().height - (insets.top + insets.bottom);
            int n3 = insets.top;
            int n4 = 300;
            int n5 = 0;
            int n6 = 0;
            while (n6 < container.getComponentCount()) {
                Component component = container.getComponent(n6);
                boolean bl = true;
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    if (n4 < dimension.width) {
                        n4 = dimension.width;
                    }
                    if (component instanceof Scrollbar) {
                        n3 += 10;
                        dimension.width = n - n5;
                    }
                    if (component instanceof Choice && dimension.width > n) {
                        dimension.width = n - n5;
                    }
                    if (component instanceof Label) {
                        Dimension dimension2 = container.getComponent(n6 + 1).getPreferredSize();
                        if (dimension.height < dimension2.height) {
                            dimension.height = dimension2.height;
                        }
                        n3 += dimension.height / 5;
                        bl = false;
                    }
                    if (component instanceof Button) {
                        if (n5 == 0) {
                            n3 += 20;
                        }
                        if (n6 != container.getComponentCount() - 1) {
                            bl = false;
                        }
                    }
                    component.move(insets.left + n5, n3);
                    component.resize(dimension.width, dimension.height);
                    if (bl) {
                        n3 += dimension.height;
                        n5 = 0;
                    } else {
                        n5 += dimension.width;
                    }
                }
                ++n6;
            }
            if (container.size().height < n3) {
                container.resize(n4 + insets.right, n3 + insets.bottom);
            }
        }
    }

    class MemristorElm
    extends CircuitElm {
        double r_on;
        double r_off;
        double dopeWidth;
        double totalWidth;
        double mobility;
        double resistance;
        Point ps3;
        Point ps4;

        public MemristorElm(int n, int n2) {
            super(n, n2);
            this.r_on = 100.0;
            this.r_off = 160.0 * this.r_on;
            this.dopeWidth = 0.0;
            this.totalWidth = 1.0E-8;
            this.mobility = 1.0E-10;
            this.resistance = 100.0;
        }

        public MemristorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.r_on = new Double(stringTokenizer.nextToken());
            this.r_off = new Double(stringTokenizer.nextToken());
            this.dopeWidth = new Double(stringTokenizer.nextToken());
            this.totalWidth = new Double(stringTokenizer.nextToken());
            this.mobility = new Double(stringTokenizer.nextToken());
            this.resistance = 100.0;
        }

        int getDumpType() {
            return 109;
        }

        String dump() {
            return super.dump() + " " + this.r_on + " " + this.r_off + " " + this.dopeWidth + " " + this.totalWidth + " " + this.mobility;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
            this.ps3 = new Point();
            this.ps4 = new Point();
        }

        void draw(Graphics graphics) {
            int n = 6;
            int n2 = 0;
            double d = this.volts[0];
            double d2 = this.volts[1];
            int n3 = 2 + (int)(8.0 * (1.0 - this.dopeWidth / this.totalWidth));
            this.setBbox(this.point1, this.point2, n3);
            this.draw2Leads(graphics);
            this.setPowerColor(graphics, true);
            double d3 = 1.0 / (double)n;
            int n4 = 0;
            while (n4 <= n) {
                int n5;
                int n6 = n5 = (n4 & 1) == 0 ? 1 : -1;
                if (n4 == n) {
                    n5 = 0;
                }
                double d4 = d + (d2 - d) * (double)n4 / (double)n;
                this.setVoltageColor(graphics, d4);
                this.interpPoint(this.lead1, this.lead2, CircuitFrame.this.ps1, (double)n4 * d3, n3 * n2);
                this.interpPoint(this.lead1, this.lead2, CircuitFrame.this.ps2, (double)n4 * d3, n3 * n5);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                if (n4 == n) break;
                this.interpPoint(this.lead1, this.lead2, CircuitFrame.this.ps1, (double)(n4 + 1) * d3, n3 * n5);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                n2 = n5;
                ++n4;
            }
            this.doDots(graphics);
            this.drawPosts(graphics);
        }

        boolean nonLinear() {
            return true;
        }

        void calculateCurrent() {
            this.current = (this.volts[0] - this.volts[1]) / this.resistance;
        }

        void reset() {
            this.dopeWidth = 0.0;
        }

        void startIteration() {
            double d = this.dopeWidth / this.totalWidth;
            this.dopeWidth += CircuitFrame.this.timeStep * this.mobility * this.r_on * this.current / this.totalWidth;
            if (this.dopeWidth < 0.0) {
                this.dopeWidth = 0.0;
            }
            if (this.dopeWidth > this.totalWidth) {
                this.dopeWidth = this.totalWidth;
            }
            this.resistance = this.r_on * d + this.r_off * (1.0 - d);
        }

        void stamp() {
            CircuitFrame.this.stampNonLinear(this.nodes[0]);
            CircuitFrame.this.stampNonLinear(this.nodes[1]);
        }

        void doStep() {
            CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "memristor";
            this.getBasicInfo(stringArray);
            stringArray[3] = "R = " + CircuitFrame.this.getUnitText(this.resistance, CircuitFrame.this.ohmString);
            stringArray[4] = "P = " + CircuitFrame.this.getUnitText(this.getPower(), "W");
        }

        double getScopeValue(int n) {
            return n == 2 ? this.resistance : (n == 1 ? this.getPower() : this.getVoltageDiff());
        }

        String getScopeUnits(int n) {
            return n == 2 ? CircuitFrame.this.ohmString : (n == 1 ? "W" : "V");
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Max Resistance (ohms)", this.r_on, 0.0, 0.0);
            }
            if (n == 1) {
                return new EditInfo("Min Resistance (ohms)", this.r_off, 0.0, 0.0);
            }
            if (n == 2) {
                return new EditInfo("Width of Doped Region (nm)", this.dopeWidth * 1.0E9, 0.0, 0.0);
            }
            if (n == 3) {
                return new EditInfo("Total Width (nm)", this.totalWidth * 1.0E9, 0.0, 0.0);
            }
            if (n == 4) {
                return new EditInfo("Mobility (nm^2/(s*V))", this.mobility * 1.0E12, 0.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.r_on = editInfo.value;
            }
            if (n == 1) {
                this.r_off = editInfo.value;
            }
            if (n == 2) {
                this.dopeWidth = editInfo.value * 1.0E-9;
            }
            if (n == 3) {
                this.totalWidth = editInfo.value * 1.0E-9;
            }
            if (n == 4) {
                this.mobility = editInfo.value * 1.0E-12;
            }
        }
    }

    class TransLineElm
    extends CircuitElm {
        double delay;
        double imped;
        double[] voltageL;
        double[] voltageR;
        int lenSteps;
        int ptr;
        int width;
        Point[] posts;
        Point[] inner;
        int voltSource1;
        int voltSource2;
        double current1;
        double current2;
        double curCount1;
        double curCount2;

        public TransLineElm(int n, int n2) {
            super(n, n2);
            this.delay = 1000.0 * CircuitFrame.this.timeStep;
            this.imped = 75.0;
            this.noDiagonal = true;
            this.reset();
        }

        public TransLineElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.delay = new Double(stringTokenizer.nextToken());
            this.imped = new Double(stringTokenizer.nextToken());
            this.width = new Integer(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            this.noDiagonal = true;
            this.reset();
        }

        int getDumpType() {
            return 171;
        }

        int getPostCount() {
            return 4;
        }

        int getInternalNodeCount() {
            return 2;
        }

        String dump() {
            return super.dump() + " " + this.delay + " " + this.imped + " " + this.width + " " + 0.0;
        }

        void drag(int n, int n2) {
            int n3;
            n = CircuitFrame.this.snapGrid(n);
            int n4 = CircuitFrame.this.max(CircuitFrame.this.gridSize, CircuitFrame.this.abs((n2 = CircuitFrame.this.snapGrid(n2)) - this.y));
            if (n4 > (n3 = CircuitFrame.this.max(CircuitFrame.this.gridSize, CircuitFrame.this.abs(n - this.x)))) {
                n = this.x;
                this.width = n3;
            } else {
                n2 = this.y;
                this.width = n4;
            }
            this.x2 = n;
            this.y2 = n2;
            this.setPoints();
        }

        void reset() {
            if (CircuitFrame.this.timeStep == 0.0) {
                return;
            }
            this.lenSteps = (int)(this.delay / CircuitFrame.this.timeStep);
            System.out.println(this.lenSteps + " steps");
            if (this.lenSteps > 100000) {
                this.voltageR = null;
                this.voltageL = null;
            } else {
                this.voltageL = new double[this.lenSteps];
                this.voltageR = new double[this.lenSteps];
            }
            this.ptr = 0;
            super.reset();
        }

        void setPoints() {
            super.setPoints();
            int n = this.dy == 0 ? CircuitFrame.this.sign(this.dx) : -CircuitFrame.this.sign(this.dy);
            Point point = this.interpPoint(this.point1, this.point2, 0.0, (double)(-this.width * n));
            Point point2 = this.interpPoint(this.point1, this.point2, 1.0, (double)(-this.width * n));
            int n2 = CircuitFrame.this.gridSize / 2;
            Point point3 = this.interpPoint(this.point1, this.point2, 0.0, (double)(-(this.width / 2 - n2) * n));
            Point point4 = this.interpPoint(this.point1, this.point2, 1.0, (double)(-(this.width / 2 - n2) * n));
            Point point5 = this.interpPoint(this.point1, this.point2, 0.0, (double)(-(this.width / 2 + n2) * n));
            Point point6 = this.interpPoint(this.point1, this.point2, 1.0, (double)(-(this.width / 2 + n2) * n));
            this.posts = new Point[]{point, point2, this.point1, this.point2};
            this.inner = new Point[]{point5, point6, point3, point4};
        }

        void draw(Graphics graphics) {
            this.setBbox(this.posts[0], this.posts[3], 0.0);
            int n = (int)(this.dn / 2.0);
            int n2 = this.ptr - 1 + this.lenSteps;
            double d = 1.0 / (double)n;
            graphics.setColor(Color.darkGray);
            graphics.fillRect(this.inner[2].x, this.inner[2].y, this.inner[1].x - this.inner[2].x + 2, this.inner[1].y - this.inner[2].y + 2);
            int n3 = 0;
            while (n3 != 4) {
                this.setVoltageColor(graphics, this.volts[n3]);
                CircuitFrame.this.drawThickLine(graphics, this.posts[n3], this.inner[n3]);
                ++n3;
            }
            if (this.voltageL != null) {
                n3 = 0;
                while (n3 != n) {
                    int n4 = (n2 - this.lenSteps * n3 / n) % this.lenSteps;
                    int n5 = (n2 - this.lenSteps * (n - 1 - n3) / n) % this.lenSteps;
                    double d2 = (this.voltageL[n4] + this.voltageR[n5]) / 2.0;
                    this.setVoltageColor(graphics, d2);
                    this.interpPoint(this.inner[0], this.inner[1], CircuitFrame.this.ps1, (double)n3 * d);
                    this.interpPoint(this.inner[2], this.inner[3], CircuitFrame.this.ps2, (double)n3 * d);
                    graphics.drawLine(CircuitFrame.this.ps1.x, CircuitFrame.this.ps1.y, CircuitFrame.this.ps2.x, CircuitFrame.this.ps2.y);
                    this.interpPoint(this.inner[2], this.inner[3], CircuitFrame.this.ps1, (double)(n3 + 1) * d);
                    CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                    ++n3;
                }
            }
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.inner[0], this.inner[1]);
            this.drawPosts(graphics);
            this.curCount1 = this.updateDotCount(-this.current1, this.curCount1);
            this.curCount2 = this.updateDotCount(this.current2, this.curCount2);
            if (CircuitFrame.this.dragElm != this) {
                this.drawDots(graphics, this.posts[0], this.inner[0], this.curCount1);
                this.drawDots(graphics, this.posts[2], this.inner[2], -this.curCount1);
                this.drawDots(graphics, this.posts[1], this.inner[1], -this.curCount2);
                this.drawDots(graphics, this.posts[3], this.inner[3], this.curCount2);
            }
        }

        void setVoltageSource(int n, int n2) {
            if (n == 0) {
                this.voltSource1 = n2;
            } else {
                this.voltSource2 = n2;
            }
        }

        void setCurrent(int n, double d) {
            if (n == this.voltSource1) {
                this.current1 = d;
            } else {
                this.current2 = d;
            }
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(this.nodes[4], this.nodes[0], this.voltSource1);
            CircuitFrame.this.stampVoltageSource(this.nodes[5], this.nodes[1], this.voltSource2);
            CircuitFrame.this.stampResistor(this.nodes[2], this.nodes[4], this.imped);
            CircuitFrame.this.stampResistor(this.nodes[3], this.nodes[5], this.imped);
        }

        void startIteration() {
            if (this.voltageL == null) {
                CircuitFrame.this.stop("Transmission line delay too large!", this);
                return;
            }
            this.voltageL[this.ptr] = this.volts[2] - this.volts[0] + this.imped * this.current1;
            this.voltageR[this.ptr] = this.volts[3] - this.volts[1] + this.imped * this.current2;
            this.ptr = (this.ptr + 1) % this.lenSteps;
        }

        void doStep() {
            if (this.voltageL == null) {
                CircuitFrame.this.stop("Transmission line delay too large!", this);
                return;
            }
            CircuitFrame.this.updateVoltageSource(this.nodes[4], this.nodes[0], this.voltSource1, -this.voltageR[this.ptr]);
            CircuitFrame.this.updateVoltageSource(this.nodes[5], this.nodes[1], this.voltSource2, -this.voltageL[this.ptr]);
            if (Math.abs(this.volts[0]) > 1.0E-5 || Math.abs(this.volts[1]) > 1.0E-5) {
                CircuitFrame.this.stop("Need to ground transmission line!", this);
                return;
            }
        }

        Point getPost(int n) {
            return this.posts[n];
        }

        int getVoltageSourceCount() {
            return 2;
        }

        boolean hasGroundConnection(int n) {
            return false;
        }

        boolean getConnection(int n, int n2) {
            return false;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "transmission line";
            stringArray[1] = CircuitFrame.this.getUnitText(this.imped, CircuitFrame.this.ohmString);
            stringArray[2] = "length = " + CircuitFrame.this.getUnitText(2.9979E8 * this.delay, "m");
            stringArray[3] = "delay = " + CircuitFrame.this.getUnitText(this.delay, "s");
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Delay (ns)", this.delay * 1.0E9, 0.0, 0.0);
            }
            if (n == 1) {
                return new EditInfo("Impedance (ohms)", this.imped, 0.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.delay = editInfo.value * 1.0E-9;
                this.reset();
            }
            if (n == 1) {
                this.imped = editInfo.value;
                this.reset();
            }
        }
    }

    class SweepElm
    extends CircuitElm {
        double maxV;
        double maxF;
        double minF;
        double sweepTime;
        double frequency;
        final int FLAG_LOG = 1;
        final int FLAG_BIDIR = 2;
        final int circleSize = 17;
        double fadd;
        double fmul;
        double freqTime;
        int dir = 1;
        double v;

        public SweepElm(int n, int n2) {
            super(n, n2);
            this.minF = 20.0;
            this.maxF = 4000.0;
            this.maxV = 5.0;
            this.sweepTime = 0.1;
            this.flags = 2;
            this.reset();
        }

        public SweepElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.minF = new Double(stringTokenizer.nextToken());
            this.maxF = new Double(stringTokenizer.nextToken());
            this.maxV = new Double(stringTokenizer.nextToken());
            this.sweepTime = new Double(stringTokenizer.nextToken());
            this.reset();
        }

        int getDumpType() {
            return 170;
        }

        int getPostCount() {
            return 1;
        }

        String dump() {
            return super.dump() + " " + this.minF + " " + this.maxF + " " + this.maxV + " " + this.sweepTime;
        }

        void setPoints() {
            super.setPoints();
            this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 17.0 / this.dn);
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 17.0);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : Color.gray);
            this.setPowerColor(graphics, false);
            int n = this.point2.x;
            int n2 = this.point2.y;
            CircuitFrame.this.drawThickCircle(graphics, n, n2, 17);
            int n3 = 8;
            this.adjustBbox(n - 17, n2 - 17, n + 17, n2 + 17);
            int n4 = 10;
            int n5 = -1;
            int n6 = -1;
            long l = System.currentTimeMillis();
            if ((l %= 2000L) > 1000L) {
                l = 2000L - l;
            }
            double d = 1.0 + (double)l * 0.002;
            if (!CircuitFrame.this.stoppedCheck.getState()) {
                d = 1.0 + 2.0 * (this.frequency - this.minF) / (this.maxF - this.minF);
            }
            int n7 = -n4;
            while (n7 <= n4) {
                int n8 = n2 + (int)(0.95 * Math.sin((double)n7 * Math.PI * d / (double)n4) * (double)n3);
                if (n5 != -1) {
                    CircuitFrame.this.drawThickLine(graphics, n5, n6, n + n7, n8);
                }
                n5 = n + n7;
                n6 = n8;
                ++n7;
            }
            if (CircuitFrame.this.showValuesCheckItem.getState()) {
                String string = CircuitFrame.this.getShortUnitText(this.frequency, "Hz");
                if (this.dx == 0 || this.dy == 0) {
                    this.drawValues(graphics, string, 17.0);
                }
            }
            this.drawPosts(graphics);
            this.curcount = this.updateDotCount(-this.current, this.curcount);
            if (CircuitFrame.this.dragElm != this) {
                this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            }
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(0, this.nodes[0], this.voltSource);
        }

        void setParams() {
            if (this.frequency < this.minF || this.frequency > this.maxF) {
                this.frequency = this.minF;
                this.freqTime = 0.0;
                this.dir = 1;
            }
            if ((this.flags & 1) == 0) {
                this.fadd = (double)this.dir * CircuitFrame.this.timeStep * (this.maxF - this.minF) / this.sweepTime;
                this.fmul = 1.0;
            } else {
                this.fadd = 0.0;
                this.fmul = Math.pow(this.maxF / this.minF, (double)this.dir * CircuitFrame.this.timeStep / this.sweepTime);
            }
        }

        void reset() {
            this.frequency = this.minF;
            this.freqTime = 0.0;
            this.dir = 1;
            this.setParams();
        }

        void startIteration() {
            this.v = Math.sin(this.freqTime) * this.maxV;
            this.freqTime += this.frequency * 2.0 * Math.PI * CircuitFrame.this.timeStep;
            this.frequency = this.frequency * this.fmul + this.fadd;
            if (this.frequency >= this.maxF && this.dir == 1) {
                if ((this.flags & 2) != 0) {
                    this.fadd = -this.fadd;
                    this.fmul = 1.0 / this.fmul;
                    this.dir = -1;
                } else {
                    this.frequency = this.minF;
                }
            }
            if (this.frequency <= this.minF && this.dir == -1) {
                this.fadd = -this.fadd;
                this.fmul = 1.0 / this.fmul;
                this.dir = 1;
            }
        }

        void doStep() {
            CircuitFrame.this.updateVoltageSource(0, this.nodes[0], this.voltSource, this.v);
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        int getVoltageSourceCount() {
            return 1;
        }

        boolean hasGroundConnection(int n) {
            return true;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "sweep " + ((this.flags & 1) == 0 ? "(linear)" : "(log)");
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
            stringArray[2] = "V = " + CircuitFrame.this.getVoltageText(this.volts[0]);
            stringArray[3] = "f = " + CircuitFrame.this.getUnitText(this.frequency, "Hz");
            stringArray[4] = "range = " + CircuitFrame.this.getUnitText(this.minF, "Hz") + " .. " + CircuitFrame.this.getUnitText(this.maxF, "Hz");
            stringArray[5] = "time = " + CircuitFrame.this.getUnitText(this.sweepTime, "s");
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Min Frequency (Hz)", this.minF, 0.0, 0.0);
            }
            if (n == 1) {
                return new EditInfo("Max Frequency (Hz)", this.maxF, 0.0, 0.0);
            }
            if (n == 2) {
                return new EditInfo("Sweep Time (s)", this.sweepTime, 0.0, 0.0);
            }
            if (n == 3) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Logarithmic", (this.flags & 1) != 0);
                return editInfo;
            }
            if (n == 4) {
                return new EditInfo("Max Voltage", this.maxV, 0.0, 0.0);
            }
            if (n == 5) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Bidirectional", (this.flags & 2) != 0);
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.minF = editInfo.value;
            }
            if (n == 1) {
                this.maxF = editInfo.value;
            }
            if (n == 2) {
                this.sweepTime = editInfo.value;
            }
            if (n == 3) {
                this.flags &= 0xFFFFFFFE;
                if (editInfo.checkbox.getState()) {
                    this.flags |= 1;
                }
            }
            if (n == 4) {
                this.maxV = editInfo.value;
            }
            if (n == 5) {
                this.flags &= 0xFFFFFFFD;
                if (editInfo.checkbox.getState()) {
                    this.flags |= 2;
                }
            }
            this.setParams();
        }
    }

    class AnalogSwitch2Elm
    extends AnalogSwitchElm {
        final int openhs = 16;
        Point[] swposts;
        Point[] swpoles;
        Point ctlPoint;

        public AnalogSwitch2Elm(int n, int n2) {
            super(n, n2);
        }

        public AnalogSwitch2Elm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
            this.swposts = this.newPointArray(2);
            this.swpoles = this.newPointArray(2);
            this.interpPoint2(this.lead1, this.lead2, this.swpoles[0], this.swpoles[1], 1.0, 16.0);
            this.interpPoint2(this.point1, this.point2, this.swposts[0], this.swposts[1], 1.0, 16.0);
            this.ctlPoint = this.interpPoint(this.point1, this.point2, 0.5, 16.0);
        }

        int getPostCount() {
            return 4;
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 16.0);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.swpoles[0], this.swposts[0]);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.swpoles[1], this.swposts[1]);
            graphics.setColor(CircuitFrame.this.lightGrayColor);
            int n = this.open ? 1 : 0;
            CircuitFrame.this.drawThickLine(graphics, this.lead1, this.swpoles[n]);
            this.updateDotCount();
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            this.drawDots(graphics, this.swpoles[n], this.swposts[n], this.curcount);
            this.drawPosts(graphics);
        }

        Point getPost(int n) {
            return n == 0 ? this.point1 : (n == 3 ? this.ctlPoint : this.swposts[n - 1]);
        }

        int getDumpType() {
            return 160;
        }

        void calculateCurrent() {
            this.current = this.open ? (this.volts[0] - this.volts[2]) / 20.0 : (this.volts[0] - this.volts[1]) / 20.0;
        }

        void stamp() {
            CircuitFrame.this.stampNonLinear(this.nodes[0]);
            CircuitFrame.this.stampNonLinear(this.nodes[1]);
            CircuitFrame.this.stampNonLinear(this.nodes[2]);
        }

        void doStep() {
            boolean bl = this.open = this.volts[3] < 2.5;
            if ((this.flags & 1) != 0) {
                boolean bl2 = this.open = !this.open;
            }
            if (this.open) {
                CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[2], 20.0);
                CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], 1.0E10);
            } else {
                CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], 20.0);
                CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[2], 1.0E10);
            }
        }

        boolean getConnection(int n, int n2) {
            return n != 3 && n2 != 3;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "analog switch (DPST)";
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
        }
    }

    class AnalogSwitchElm
    extends CircuitElm {
        final int FLAG_INVERT = 1;
        boolean open;
        Point ps;
        Point point3;
        Point lead3;
        final double resistance = 20.0;

        public AnalogSwitchElm(int n, int n2) {
            super(n, n2);
        }

        public AnalogSwitchElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
        }

        int getDumpType() {
            return 159;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
            this.ps = new Point();
            int n = 16;
            this.point3 = this.interpPoint(this.point1, this.point2, 0.5, (double)(-n));
            this.lead3 = this.interpPoint(this.point1, this.point2, 0.5, (double)(-n / 2));
        }

        void draw(Graphics graphics) {
            int n = 16;
            int n2 = this.open ? n : 0;
            this.setBbox(this.point1, this.point2, n);
            this.draw2Leads(graphics);
            graphics.setColor(CircuitFrame.this.lightGrayColor);
            this.interpPoint(this.lead1, this.lead2, this.ps, 1.0, n2);
            CircuitFrame.this.drawThickLine(graphics, this.lead1, this.ps);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.point3, this.lead3);
            if (!this.open) {
                this.doDots(graphics);
            }
            this.drawPosts(graphics);
        }

        void calculateCurrent() {
            this.current = this.open ? 0.0 : (this.volts[0] - this.volts[1]) / 20.0;
        }

        boolean nonLinear() {
            return true;
        }

        void stamp() {
            CircuitFrame.this.stampNonLinear(this.nodes[0]);
            CircuitFrame.this.stampNonLinear(this.nodes[1]);
        }

        void doStep() {
            boolean bl = this.open = this.volts[2] < 2.5;
            if ((this.flags & 1) != 0) {
                boolean bl2 = this.open = !this.open;
            }
            if (!this.open) {
                CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], 20.0);
            } else {
                CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], 1.0E10);
            }
        }

        void drag(int n, int n2) {
            n = CircuitFrame.this.snapGrid(n);
            n2 = CircuitFrame.this.snapGrid(n2);
            if (CircuitFrame.this.abs(this.x - n) < CircuitFrame.this.abs(this.y - n2)) {
                n = this.x;
            } else {
                n2 = this.y;
            }
            int n3 = CircuitFrame.this.abs(this.x - n) + CircuitFrame.this.abs(this.y - n2);
            int n4 = n3 / 2 % CircuitFrame.this.gridSize;
            if (n4 != 0) {
                return;
            }
            this.x2 = n;
            this.y2 = n2;
            this.setPoints();
        }

        int getPostCount() {
            return 3;
        }

        Point getPost(int n) {
            return n == 0 ? this.point1 : (n == 1 ? this.point2 : this.point3);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "analog switch";
            stringArray[1] = this.open ? "open" : "closed";
            stringArray[2] = "Vd = " + CircuitFrame.this.getVoltageDText(this.getVoltageDiff());
            stringArray[3] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
            stringArray[4] = "Vc = " + CircuitFrame.this.getVoltageText(this.volts[2]);
        }

        boolean getConnection(int n, int n2) {
            return n != 2 && n2 != 2;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Normally closed", (this.flags & 1) != 0);
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.flags = editInfo.checkbox.getState() ? this.flags | 1 : this.flags & 0xFFFFFFFE;
            }
        }
    }

    class ProbeElm
    extends CircuitElm {
        Point center;

        public ProbeElm(int n, int n2) {
            super(n, n2);
        }

        public ProbeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
        }

        int getDumpType() {
            return 112;
        }

        void setPoints() {
            super.setPoints();
            if (this.point2.y < this.point1.y) {
                Point point = this.point1;
                this.point1 = this.point2;
                this.point2 = point;
            }
            this.center = this.interpPoint(this.point1, this.point2, 0.5);
        }

        void draw(Graphics graphics) {
            int n = 8;
            this.setBbox(this.point1, this.point2, n);
            boolean bl = CircuitFrame.this.mouseElm == this || CircuitFrame.this.plotYElm == this;
            double d = bl || CircuitFrame.this.dragElm == this ? 16.0 : this.dn - 32.0;
            this.calcLeads((int)d);
            this.setVoltageColor(graphics, this.volts[0]);
            if (bl) {
                graphics.setColor(CircuitFrame.this.selectColor);
            }
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.setVoltageColor(graphics, this.volts[1]);
            if (bl) {
                graphics.setColor(CircuitFrame.this.selectColor);
            }
            CircuitFrame.this.drawThickLine(graphics, this.lead2, this.point2);
            Font font = new Font("SansSerif", 1, 14);
            graphics.setFont(font);
            if (this == CircuitFrame.this.plotXElm) {
                this.drawCenteredText(graphics, "X", this.center.x, this.center.y, true);
            }
            if (this == CircuitFrame.this.plotYElm) {
                this.drawCenteredText(graphics, "Y", this.center.x, this.center.y, true);
            }
            this.drawPosts(graphics);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "scope probe";
            stringArray[1] = "Vd = " + CircuitFrame.this.getVoltageText(this.getVoltageDiff());
        }

        boolean getConnection(int n, int n2) {
            return false;
        }
    }

    class TextElm
    extends CircuitElm {
        String text;
        Vector lines;
        int size;
        final int FLAG_CENTER = 1;
        final int FLAG_BAR = 2;

        public TextElm(int n, int n2) {
            super(n, n2);
            this.text = "hello";
            this.lines = new Vector();
            this.lines.add(this.text);
            this.size = 24;
        }

        public TextElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.size = new Integer(stringTokenizer.nextToken());
            this.text = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                this.text = this.text + ' ' + stringTokenizer.nextToken();
            }
            this.split();
        }

        void split() {
            this.lines = new Vector();
            StringBuffer stringBuffer = new StringBuffer(this.text);
            int n = 0;
            while (n < stringBuffer.length()) {
                char c = stringBuffer.charAt(n);
                if (c == '\\') {
                    stringBuffer.deleteCharAt(n);
                    c = stringBuffer.charAt(n);
                    if (c == 'n') {
                        this.lines.add(stringBuffer.substring(0, n));
                        stringBuffer.delete(0, n + 1);
                        n = -1;
                    }
                }
                ++n;
            }
            this.lines.add(stringBuffer.toString());
        }

        String dump() {
            return super.dump() + " " + this.size + " " + this.text;
        }

        int getDumpType() {
            return 120;
        }

        void drag(int n, int n2) {
            this.x = n;
            this.y = n2;
            this.x2 = n + 16;
            this.y2 = n2;
        }

        void draw(Graphics graphics) {
            int n;
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            Font font = new Font("SansSerif", 0, this.size);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = -1;
            int n3 = 0;
            while (n3 != this.lines.size()) {
                n = fontMetrics.stringWidth((String)this.lines.elementAt(n3));
                if (n > n2) {
                    n2 = n;
                }
                ++n3;
            }
            n = this.y;
            this.setBbox(this.x, this.y, this.x, this.y);
            n3 = 0;
            while (n3 != this.lines.size()) {
                String string = (String)this.lines.elementAt(n3);
                if ((this.flags & 1) != 0) {
                    this.x = (CircuitFrame.this.winSize.width - fontMetrics.stringWidth(string)) / 2;
                }
                graphics.drawString(string, this.x, n);
                if ((this.flags & 2) != 0) {
                    int n4 = n - fontMetrics.getAscent();
                    graphics.drawLine(this.x, n4, this.x + fontMetrics.stringWidth(string) - 1, n4);
                }
                this.adjustBbox(this.x, n - fontMetrics.getAscent(), this.x + fontMetrics.stringWidth(string), n + fontMetrics.getDescent());
                n += fontMetrics.getHeight();
                ++n3;
            }
            this.x2 = this.boundingBox.x + this.boundingBox.width;
            this.y2 = this.boundingBox.y + this.boundingBox.height;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                EditInfo editInfo = new EditInfo("Text", 0.0, -1.0, -1.0);
                editInfo.text = this.text;
                return editInfo;
            }
            if (n == 1) {
                return new EditInfo("Size", this.size, 5.0, 100.0);
            }
            if (n == 2) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Center", (this.flags & 1) != 0);
                return editInfo;
            }
            if (n == 3) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Draw Bar On Top", (this.flags & 2) != 0);
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.text = editInfo.textf.getText();
                this.split();
            }
            if (n == 1) {
                this.size = (int)editInfo.value;
            }
            if (n == 3) {
                this.flags = editInfo.checkbox.getState() ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            }
            if (n == 2) {
                this.flags = editInfo.checkbox.getState() ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
            }
        }

        boolean isCenteredText() {
            return (this.flags & 1) != 0;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = this.text;
        }

        int getPostCount() {
            return 0;
        }
    }

    class LatchElm
    extends ChipElm {
        int loadPin;
        boolean lastLoad = false;

        public LatchElm(int n, int n2) {
            super(n, n2);
        }

        public LatchElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "Latch";
        }

        boolean needsBits() {
            return true;
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = this.bits + 1;
            this.pins = new ChipElm.Pin[this.getPostCount()];
            int n = 0;
            while (n != this.bits) {
                this.pins[n] = new ChipElm.Pin(this.bits - 1 - n, 2, "I" + n);
                ++n;
            }
            n = 0;
            while (n != this.bits) {
                this.pins[n + this.bits] = new ChipElm.Pin(this.bits - 1 - n, 3, "O");
                this.pins[n + this.bits].output = true;
                ++n;
            }
            this.loadPin = this.bits * 2;
            this.pins[this.loadPin] = new ChipElm.Pin(this.bits, 2, "Ld");
            this.allocNodes();
        }

        void execute() {
            if (this.pins[this.loadPin].value && !this.lastLoad) {
                int n = 0;
                while (n != this.bits) {
                    this.pins[n + this.bits].value = this.pins[n].value;
                    ++n;
                }
            }
            this.lastLoad = this.pins[this.loadPin].value;
        }

        int getVoltageSourceCount() {
            return this.bits;
        }

        int getPostCount() {
            return this.bits * 2 + 1;
        }

        int getDumpType() {
            return 168;
        }
    }

    class ADCElm
    extends ChipElm {
        public ADCElm(int n, int n2) {
            super(n, n2);
        }

        public ADCElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "ADC";
        }

        boolean needsBits() {
            return true;
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = this.bits > 2 ? this.bits : 2;
            this.pins = new ChipElm.Pin[this.getPostCount()];
            int n = 0;
            while (n != this.bits) {
                this.pins[n] = new ChipElm.Pin(this.bits - 1 - n, 3, "D" + n);
                this.pins[n].output = true;
                ++n;
            }
            this.pins[this.bits] = new ChipElm.Pin(0, 2, "In");
            this.pins[this.bits + 1] = new ChipElm.Pin(this.sizeY - 1, 2, "V+");
            this.allocNodes();
        }

        void execute() {
            int n = (1 << this.bits) - 1;
            double d = (double)n * this.volts[this.bits] / this.volts[this.bits + 1];
            int n2 = (int)d;
            n2 = CircuitFrame.this.min(n, CircuitFrame.this.max(0, n2));
            int n3 = 0;
            while (n3 != this.bits) {
                this.pins[n3].value = (n2 & 1 << n3) != 0;
                ++n3;
            }
        }

        int getVoltageSourceCount() {
            return this.bits;
        }

        int getPostCount() {
            return this.bits + 2;
        }

        int getDumpType() {
            return 167;
        }
    }

    class DACElm
    extends ChipElm {
        public DACElm(int n, int n2) {
            super(n, n2);
        }

        public DACElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "DAC";
        }

        boolean needsBits() {
            return true;
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = this.bits > 2 ? this.bits : 2;
            this.pins = new ChipElm.Pin[this.getPostCount()];
            int n = 0;
            while (n != this.bits) {
                this.pins[n] = new ChipElm.Pin(this.bits - 1 - n, 2, "D" + n);
                ++n;
            }
            this.pins[this.bits] = new ChipElm.Pin(0, 3, "O");
            this.pins[this.bits].output = true;
            this.pins[this.bits + 1] = new ChipElm.Pin(this.sizeY - 1, 3, "V+");
            this.allocNodes();
        }

        void doStep() {
            int n = 0;
            int n2 = 0;
            while (n2 != this.bits) {
                if (this.volts[n2] > 2.5) {
                    n |= 1 << n2;
                }
                ++n2;
            }
            int n3 = (1 << this.bits) - 1;
            double d = (double)n * this.volts[this.bits + 1] / (double)n3;
            CircuitFrame.this.updateVoltageSource(0, this.nodes[this.bits], this.pins[this.bits].voltSource, d);
        }

        int getVoltageSourceCount() {
            return 1;
        }

        int getPostCount() {
            return this.bits + 2;
        }

        int getDumpType() {
            return 166;
        }
    }

    class PhaseCompElm
    extends ChipElm {
        boolean ff1;
        boolean ff2;

        public PhaseCompElm(int n, int n2) {
            super(n, n2);
        }

        public PhaseCompElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "phase comparator";
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = 2;
            this.pins = new ChipElm.Pin[3];
            this.pins[0] = new ChipElm.Pin(0, 2, "I1");
            this.pins[1] = new ChipElm.Pin(1, 2, "I2");
            this.pins[2] = new ChipElm.Pin(0, 3, "O");
            this.pins[2].output = true;
        }

        boolean nonLinear() {
            return true;
        }

        void stamp() {
            int n = CircuitFrame.this.nodeList.size() + this.pins[2].voltSource;
            CircuitFrame.this.stampNonLinear(n);
            CircuitFrame.this.stampNonLinear(0);
            CircuitFrame.this.stampNonLinear(this.nodes[2]);
        }

        void doStep() {
            double d;
            boolean bl;
            boolean bl2 = this.volts[0] > 2.5;
            boolean bl3 = bl = this.volts[1] > 2.5;
            if (bl2 && !this.pins[0].value) {
                this.ff1 = true;
            }
            if (bl && !this.pins[1].value) {
                this.ff2 = true;
            }
            if (this.ff1 && this.ff2) {
                this.ff2 = false;
                this.ff1 = false;
            }
            double d2 = this.ff1 ? 5.0 : (d = this.ff2 ? 0.0 : -1.0);
            if (d != -1.0) {
                CircuitFrame.this.stampVoltageSource(0, this.nodes[2], this.pins[2].voltSource, d);
            } else {
                int n = CircuitFrame.this.nodeList.size() + this.pins[2].voltSource;
                CircuitFrame.this.stampMatrix(n, n, 1.0);
            }
            this.pins[0].value = bl2;
            this.pins[1].value = bl;
        }

        int getPostCount() {
            return 3;
        }

        int getVoltageSourceCount() {
            return 1;
        }

        int getDumpType() {
            return 161;
        }
    }

    class TimerElm
    extends ChipElm {
        final int FLAG_RESET = 2;
        boolean out;

        int getDefaultFlags() {
            return 2;
        }

        public TimerElm(int n, int n2) {
            super(n, n2);
        }

        public TimerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "555 Timer";
        }

        void setupPins() {
            this.sizeX = 3;
            this.sizeY = 5;
            this.pins = new ChipElm.Pin[7];
            this.pins[0] = new ChipElm.Pin(1, 2, "dis");
            this.pins[1] = new ChipElm.Pin(3, 2, "tr");
            this.pins[1].lineOver = true;
            this.pins[2] = new ChipElm.Pin(4, 2, "th");
            this.pins[3] = new ChipElm.Pin(1, 0, "Vin");
            this.pins[4] = new ChipElm.Pin(1, 1, "ctl");
            this.pins[5] = new ChipElm.Pin(2, 3, "out");
            this.pins[5].state = true;
            this.pins[5].output = true;
            this.pins[6] = new ChipElm.Pin(1, 3, "rst");
        }

        boolean nonLinear() {
            return true;
        }

        boolean hasReset() {
            return (this.flags & 2) != 0;
        }

        void stamp() {
            CircuitFrame.this.stampResistor(this.nodes[3], this.nodes[4], 5000.0);
            CircuitFrame.this.stampResistor(this.nodes[4], 0, 10000.0);
            CircuitFrame.this.stampVoltageSource(0, this.nodes[5], this.pins[5].voltSource);
            CircuitFrame.this.stampNonLinear(0);
            CircuitFrame.this.stampNonLinear(this.nodes[0]);
        }

        void calculateCurrent() {
            this.pins[3].current = (this.volts[4] - this.volts[3]) / 5000.0;
            this.pins[4].current = -this.volts[4] / 10000.0 - this.pins[3].current;
            this.pins[0].current = this.out ? 0.0 : -this.volts[0] / 10.0;
        }

        void startIteration() {
            boolean bl = this.out = this.volts[5] > this.volts[3] / 2.0;
            if (this.volts[4] / 2.0 > this.volts[1]) {
                this.out = true;
            }
            if (this.volts[2] > this.volts[4] || this.hasReset() && this.volts[6] < 0.7) {
                this.out = false;
            }
        }

        void doStep() {
            if (!this.out) {
                CircuitFrame.this.stampResistor(this.nodes[0], 0, 10.0);
            }
            CircuitFrame.this.updateVoltageSource(0, this.nodes[5], this.pins[5].voltSource, this.out ? this.volts[3] : 0.0);
        }

        int getPostCount() {
            return this.hasReset() ? 7 : 6;
        }

        int getVoltageSourceCount() {
            return 1;
        }

        int getDumpType() {
            return 165;
        }
    }

    class VCOElm
    extends ChipElm {
        final double cResistance = 1000000.0;
        double cCurrent;
        int cDir;

        public VCOElm(int n, int n2) {
            super(n, n2);
        }

        public VCOElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "VCO";
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = 4;
            this.pins = new ChipElm.Pin[6];
            this.pins[0] = new ChipElm.Pin(0, 2, "Vi");
            this.pins[1] = new ChipElm.Pin(3, 2, "Vo");
            this.pins[1].output = true;
            this.pins[2] = new ChipElm.Pin(0, 3, "C");
            this.pins[3] = new ChipElm.Pin(1, 3, "C");
            this.pins[4] = new ChipElm.Pin(2, 3, "R1");
            this.pins[4].output = true;
            this.pins[5] = new ChipElm.Pin(3, 3, "R2");
            this.pins[5].output = true;
        }

        boolean nonLinear() {
            return true;
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(0, this.nodes[1], this.pins[1].voltSource);
            CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[4], this.pins[4].voltSource, 0.0);
            CircuitFrame.this.stampVoltageSource(0, this.nodes[5], this.pins[5].voltSource, 5.0);
            CircuitFrame.this.stampResistor(this.nodes[2], this.nodes[3], 1000000.0);
            CircuitFrame.this.stampNonLinear(this.nodes[2]);
            CircuitFrame.this.stampNonLinear(this.nodes[3]);
        }

        void doStep() {
            int n;
            double d = this.volts[3] - this.volts[2];
            double d2 = this.volts[1];
            int n2 = n = d2 < 2.5 ? 1 : -1;
            if (d2 < 2.5 && d > 4.5) {
                d2 = 5.0;
                n = -1;
            }
            if (d2 > 2.5 && d < 0.5) {
                d2 = 0.0;
                n = 1;
            }
            CircuitFrame.this.updateVoltageSource(0, this.nodes[1], this.pins[1].voltSource, d2);
            int n3 = CircuitFrame.this.nodeList.size() + this.pins[4].voltSource;
            int n4 = CircuitFrame.this.nodeList.size() + this.pins[5].voltSource;
            CircuitFrame.this.stampMatrix(this.nodes[2], n3, n);
            CircuitFrame.this.stampMatrix(this.nodes[2], n4, n);
            CircuitFrame.this.stampMatrix(this.nodes[3], n3, -n);
            CircuitFrame.this.stampMatrix(this.nodes[3], n4, -n);
            this.cDir = n;
        }

        void computeCurrent() {
            double d = (double)this.cDir * (this.pins[4].current + this.pins[5].current) + (this.volts[3] - this.volts[2]) / 1000000.0;
            this.pins[2].current = -d;
            this.pins[3].current = d;
            this.pins[0].current = -this.pins[4].current;
        }

        void draw(Graphics graphics) {
            this.computeCurrent();
            this.drawChip(graphics);
        }

        int getPostCount() {
            return 6;
        }

        int getVoltageSourceCount() {
            return 3;
        }

        int getDumpType() {
            return 158;
        }
    }

    class SevenSegElm
    extends ChipElm {
        Color darkred;

        public SevenSegElm(int n, int n2) {
            super(n, n2);
        }

        public SevenSegElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "7-segment driver/display";
        }

        void setupPins() {
            this.darkred = new Color(30, 0, 0);
            this.sizeX = 4;
            this.sizeY = 4;
            this.pins = new ChipElm.Pin[7];
            this.pins[0] = new ChipElm.Pin(0, 2, "a");
            this.pins[1] = new ChipElm.Pin(1, 2, "b");
            this.pins[2] = new ChipElm.Pin(2, 2, "c");
            this.pins[3] = new ChipElm.Pin(3, 2, "d");
            this.pins[4] = new ChipElm.Pin(1, 1, "e");
            this.pins[5] = new ChipElm.Pin(2, 1, "f");
            this.pins[6] = new ChipElm.Pin(3, 1, "g");
        }

        void draw(Graphics graphics) {
            this.drawChip(graphics);
            graphics.setColor(Color.red);
            int n = this.x + this.cspc * 5;
            int n2 = this.y + this.cspc;
            this.setColor(graphics, 0);
            CircuitFrame.this.drawThickLine(graphics, n, n2, n + this.cspc, n2);
            this.setColor(graphics, 1);
            CircuitFrame.this.drawThickLine(graphics, n + this.cspc, n2, n + this.cspc, n2 + this.cspc);
            this.setColor(graphics, 2);
            CircuitFrame.this.drawThickLine(graphics, n + this.cspc, n2 + this.cspc, n + this.cspc, n2 + this.cspc2);
            this.setColor(graphics, 3);
            CircuitFrame.this.drawThickLine(graphics, n, n2 + this.cspc2, n + this.cspc, n2 + this.cspc2);
            this.setColor(graphics, 4);
            CircuitFrame.this.drawThickLine(graphics, n, n2 + this.cspc, n, n2 + this.cspc2);
            this.setColor(graphics, 5);
            CircuitFrame.this.drawThickLine(graphics, n, n2, n, n2 + this.cspc);
            this.setColor(graphics, 6);
            CircuitFrame.this.drawThickLine(graphics, n, n2 + this.cspc, n + this.cspc, n2 + this.cspc);
        }

        void setColor(Graphics graphics, int n) {
            graphics.setColor(this.pins[n].value ? Color.red : (CircuitFrame.this.printableCheckItem.getState() ? Color.white : this.darkred));
        }

        int getPostCount() {
            return 7;
        }

        int getVoltageSourceCount() {
            return 0;
        }

        int getDumpType() {
            return 157;
        }
    }

    class CounterElm
    extends ChipElm {
        final int FLAG_ENABLE = 2;

        public CounterElm(int n, int n2) {
            super(n, n2);
        }

        public CounterElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        boolean needsBits() {
            return true;
        }

        String getChipName() {
            return "Counter";
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = this.bits > 2 ? this.bits : 2;
            this.pins = new ChipElm.Pin[this.getPostCount()];
            this.pins[0] = new ChipElm.Pin(0, 2, "");
            this.pins[0].clock = true;
            this.pins[1] = new ChipElm.Pin(this.sizeY - 1, 2, "R");
            this.pins[1].bubble = true;
            int n = 0;
            while (n != this.bits) {
                int n2 = n + 2;
                this.pins[n2] = new ChipElm.Pin(n, 3, "Q" + (this.bits - n - 1));
                this.pins[n2].state = true;
                this.pins[n2].output = true;
                ++n;
            }
            if (this.hasEnable()) {
                this.pins[this.bits + 2] = new ChipElm.Pin(this.sizeY - 2, 2, "En");
            }
            this.allocNodes();
        }

        int getPostCount() {
            if (this.hasEnable()) {
                return this.bits + 3;
            }
            return this.bits + 2;
        }

        boolean hasEnable() {
            return (this.flags & 2) != 0;
        }

        int getVoltageSourceCount() {
            return this.bits;
        }

        void execute() {
            int n;
            boolean bl = true;
            if (this.hasEnable()) {
                bl = this.pins[this.bits + 2].value;
            }
            if (this.pins[0].value && !this.lastClock && bl) {
                n = this.bits - 1;
                while (n >= 0) {
                    int n2 = n + 2;
                    if (!this.pins[n2].value) {
                        this.pins[n2].value = true;
                        break;
                    }
                    this.pins[n2].value = false;
                    --n;
                }
            }
            if (!this.pins[1].value) {
                n = 0;
                while (n != this.bits) {
                    this.pins[n + 2].value = false;
                    ++n;
                }
            }
            this.lastClock = this.pins[0].value;
        }

        int getDumpType() {
            return 164;
        }
    }

    class DecadeElm
    extends ChipElm {
        public DecadeElm(int n, int n2) {
            super(n, n2);
        }

        public DecadeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getChipName() {
            return "decade counter";
        }

        boolean needsBits() {
            return true;
        }

        void setupPins() {
            this.sizeX = this.bits > 2 ? this.bits : 2;
            this.sizeY = 2;
            this.pins = new ChipElm.Pin[this.getPostCount()];
            this.pins[0] = new ChipElm.Pin(1, 2, "");
            this.pins[0].clock = true;
            this.pins[1] = new ChipElm.Pin(this.sizeX - 1, 1, "R");
            this.pins[1].bubble = true;
            int n = 0;
            while (n != this.bits) {
                int n2 = n + 2;
                this.pins[n2] = new ChipElm.Pin(n, 0, "Q" + n);
                this.pins[n2].state = true;
                this.pins[n2].output = true;
                ++n;
            }
            this.allocNodes();
        }

        int getPostCount() {
            return this.bits + 2;
        }

        int getVoltageSourceCount() {
            return this.bits;
        }

        void execute() {
            int n;
            if (this.pins[0].value && !this.lastClock) {
                n = 0;
                while (n != this.bits) {
                    if (this.pins[n + 2].value) break;
                    ++n;
                }
                if (n < this.bits) {
                    this.pins[n++ + 2].value = false;
                }
                this.pins[(n %= this.bits) + 2].value = true;
            }
            if (!this.pins[1].value) {
                n = 1;
                while (n != this.bits) {
                    this.pins[n + 2].value = false;
                    ++n;
                }
                this.pins[2].value = true;
            }
            this.lastClock = this.pins[0].value;
        }

        int getDumpType() {
            return 163;
        }
    }

    class JKFlipFlopElm
    extends ChipElm {
        public JKFlipFlopElm(int n, int n2) {
            super(n, n2);
        }

        public JKFlipFlopElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.pins[4].value = !this.pins[3].value;
        }

        String getChipName() {
            return "JK flip-flop";
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = 3;
            this.pins = new ChipElm.Pin[5];
            this.pins[0] = new ChipElm.Pin(0, 2, "J");
            this.pins[1] = new ChipElm.Pin(1, 2, "");
            this.pins[1].clock = true;
            this.pins[1].bubble = true;
            this.pins[2] = new ChipElm.Pin(2, 2, "K");
            this.pins[3] = new ChipElm.Pin(0, 3, "Q");
            this.pins[3].state = true;
            this.pins[3].output = true;
            this.pins[4] = new ChipElm.Pin(2, 3, "Q");
            this.pins[4].output = true;
            this.pins[4].lineOver = true;
        }

        int getPostCount() {
            return 5;
        }

        int getVoltageSourceCount() {
            return 2;
        }

        void execute() {
            if (!this.pins[1].value && this.lastClock) {
                boolean bl = this.pins[3].value;
                if (this.pins[0].value) {
                    bl = this.pins[2].value ? !bl : true;
                } else if (this.pins[2].value) {
                    bl = false;
                }
                this.pins[3].value = bl;
                this.pins[4].value = !bl;
            }
            this.lastClock = this.pins[1].value;
        }

        int getDumpType() {
            return 156;
        }
    }

    class DFlipFlopElm
    extends ChipElm {
        final int FLAG_RESET = 2;

        public DFlipFlopElm(int n, int n2) {
            super(n, n2);
        }

        public DFlipFlopElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.pins[2].value = !this.pins[1].value;
        }

        String getChipName() {
            return "D flip-flop";
        }

        void setupPins() {
            this.sizeX = 2;
            this.sizeY = 3;
            this.pins = new ChipElm.Pin[this.getPostCount()];
            this.pins[0] = new ChipElm.Pin(0, 2, "D");
            this.pins[1] = new ChipElm.Pin(0, 3, "Q");
            this.pins[1].state = true;
            this.pins[1].output = true;
            this.pins[2] = new ChipElm.Pin(2, 3, "Q");
            this.pins[2].output = true;
            this.pins[2].lineOver = true;
            this.pins[3] = new ChipElm.Pin(1, 2, "");
            this.pins[3].clock = true;
            if ((this.flags & 2) != 0) {
                this.pins[4] = new ChipElm.Pin(2, 2, "R");
            }
        }

        int getPostCount() {
            return (this.flags & 2) != 0 ? 5 : 4;
        }

        int getVoltageSourceCount() {
            return 2;
        }

        void execute() {
            if (this.pins[3].value && !this.lastClock) {
                this.pins[1].value = this.pins[0].value;
                boolean bl = this.pins[2].value = !this.pins[0].value;
            }
            if (this.pins.length > 4 && this.pins[4].value) {
                this.pins[1].value = false;
                this.pins[2].value = true;
            }
            this.lastClock = this.pins[3].value;
        }

        int getDumpType() {
            return 155;
        }
    }

    abstract class ChipElm
    extends CircuitElm {
        int csize;
        int cspc;
        int cspc2;
        int bits;
        final int FLAG_SMALL = 1;
        int[] rectPointsX;
        int[] rectPointsY;
        int[] clockPointsX;
        int[] clockPointsY;
        Pin[] pins;
        int sizeX;
        int sizeY;
        boolean lastClock;
        final int SIDE_N = 0;
        final int SIDE_S = 1;
        final int SIDE_W = 2;
        final int SIDE_E = 3;

        public ChipElm(int n, int n2) {
            super(n, n2);
            if (this.needsBits()) {
                this.bits = this instanceof DecadeElm ? 10 : 4;
            }
            this.noDiagonal = true;
            this.setupPins();
            this.setSize(CircuitFrame.this.smallGridCheckItem.getState() ? 1 : 2);
        }

        public ChipElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            if (this.needsBits()) {
                this.bits = new Integer(stringTokenizer.nextToken());
            }
            this.noDiagonal = true;
            this.setupPins();
            this.setSize((n5 & 1) != 0 ? 1 : 2);
            int n6 = 0;
            while (n6 != this.getPostCount()) {
                if (this.pins[n6].state) {
                    this.volts[n6] = new Double(stringTokenizer.nextToken());
                    this.pins[n6].value = this.volts[n6] > 2.5;
                }
                ++n6;
            }
        }

        boolean needsBits() {
            return false;
        }

        void setSize(int n) {
            this.csize = n;
            this.cspc = 8 * n;
            this.cspc2 = this.cspc * 2;
            this.flags &= 0xFFFFFFFE;
            this.flags |= n == 1 ? 1 : 0;
        }

        abstract void setupPins();

        void draw(Graphics graphics) {
            this.drawChip(graphics);
        }

        void drawChip(Graphics graphics) {
            Font font = new Font("SansSerif", 0, 10 * this.csize);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = 0;
            while (n != this.getPostCount()) {
                Pin pin = this.pins[n];
                this.setVoltageColor(graphics, this.volts[n]);
                Point point = pin.post;
                Point point2 = pin.stub;
                CircuitFrame.this.drawThickLine(graphics, point, point2);
                pin.curcount = this.updateDotCount(pin.current, pin.curcount);
                this.drawDots(graphics, point2, point, pin.curcount);
                if (pin.bubble) {
                    graphics.setColor(CircuitFrame.this.printableCheckItem.getState() ? Color.white : Color.black);
                    CircuitFrame.this.drawThickCircle(graphics, pin.bubbleX, pin.bubbleY, 1);
                    graphics.setColor(CircuitFrame.this.lightGrayColor);
                    CircuitFrame.this.drawThickCircle(graphics, pin.bubbleX, pin.bubbleY, 3);
                }
                graphics.setColor(CircuitFrame.this.whiteColor);
                int n2 = fontMetrics.stringWidth(pin.text);
                graphics.drawString(pin.text, pin.textloc.x - n2 / 2, pin.textloc.y + fontMetrics.getAscent() / 2);
                if (pin.lineOver) {
                    int n3 = pin.textloc.y - fontMetrics.getAscent() / 2;
                    graphics.drawLine(pin.textloc.x - n2 / 2, n3, pin.textloc.x + n2 / 2, n3);
                }
                ++n;
            }
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            CircuitFrame.this.drawThickPolygon(graphics, this.rectPointsX, this.rectPointsY, 4);
            if (this.clockPointsX != null) {
                graphics.drawPolyline(this.clockPointsX, this.clockPointsY, 3);
            }
            n = 0;
            while (n != this.getPostCount()) {
                this.drawPost(graphics, this.pins[n].post.x, this.pins[n].post.y, this.nodes[n]);
                ++n;
            }
        }

        void drag(int n, int n2) {
            n2 = CircuitFrame.this.snapGrid(n2);
            if (n < this.x) {
                n = this.x;
                n2 = this.y;
            } else {
                this.y = this.y2 = n2;
                this.x2 = CircuitFrame.this.snapGrid(n);
            }
            this.setPoints();
        }

        void setPoints() {
            if (this.x2 - this.x > this.sizeX * this.cspc2 && this == CircuitFrame.this.dragElm) {
                this.setSize(2);
            }
            int n = this.cspc;
            int n2 = this.x + this.cspc2;
            int n3 = this.y;
            int n4 = n2 - this.cspc;
            int n5 = n3 - this.cspc;
            int n6 = this.sizeX * this.cspc2;
            int n7 = this.sizeY * this.cspc2;
            this.rectPointsX = new int[]{n4, n4 + n6, n4 + n6, n4};
            this.rectPointsY = new int[]{n5, n5, n5 + n7, n5 + n7};
            this.setBbox(n4, n5, this.rectPointsX[2], this.rectPointsY[2]);
            int n8 = 0;
            while (n8 != this.getPostCount()) {
                Pin pin = this.pins[n8];
                switch (pin.side) {
                    case 0: {
                        pin.setPoint(n2, n3, 1, 0, 0, -1, 0, 0);
                        break;
                    }
                    case 1: {
                        pin.setPoint(n2, n3, 1, 0, 0, 1, 0, n7 - this.cspc2);
                        break;
                    }
                    case 2: {
                        pin.setPoint(n2, n3, 0, 1, -1, 0, 0, 0);
                        break;
                    }
                    case 3: {
                        pin.setPoint(n2, n3, 0, 1, 1, 0, n6 - this.cspc2, 0);
                    }
                }
                ++n8;
            }
        }

        Point getPost(int n) {
            return this.pins[n].post;
        }

        abstract int getVoltageSourceCount();

        void setVoltageSource(int n, int n2) {
            int n3 = 0;
            while (n3 != this.getPostCount()) {
                Pin pin = this.pins[n3];
                if (pin.output && n-- == 0) {
                    pin.voltSource = n2;
                    return;
                }
                ++n3;
            }
            System.out.println("setVoltageSource failed for " + this);
        }

        void stamp() {
            int n = 0;
            while (n != this.getPostCount()) {
                Pin pin = this.pins[n];
                if (pin.output) {
                    CircuitFrame.this.stampVoltageSource(0, this.nodes[n], pin.voltSource);
                }
                ++n;
            }
        }

        void execute() {
        }

        void doStep() {
            Pin pin;
            int n = 0;
            while (n != this.getPostCount()) {
                pin = this.pins[n];
                if (!pin.output) {
                    pin.value = this.volts[n] > 2.5;
                }
                ++n;
            }
            this.execute();
            n = 0;
            while (n != this.getPostCount()) {
                pin = this.pins[n];
                if (pin.output) {
                    CircuitFrame.this.updateVoltageSource(0, this.nodes[n], pin.voltSource, pin.value ? 5.0 : 0.0);
                }
                ++n;
            }
        }

        void reset() {
            int n = 0;
            while (n != this.getPostCount()) {
                this.pins[n].value = false;
                this.pins[n].curcount = 0.0;
                this.volts[n] = 0.0;
                ++n;
            }
            this.lastClock = false;
        }

        String dump() {
            int n = this.getDumpType();
            String string = super.dump();
            if (this.needsBits()) {
                string = string + " " + this.bits;
            }
            int n2 = 0;
            while (n2 != this.getPostCount()) {
                if (this.pins[n2].state) {
                    string = string + " " + this.volts[n2];
                }
                ++n2;
            }
            return string;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = this.getChipName();
            int n = 1;
            int n2 = 0;
            while (n2 != this.getPostCount()) {
                Pin pin = this.pins[n2];
                if (stringArray[n] != null) {
                    int n3 = n;
                    stringArray[n3] = stringArray[n3] + "; ";
                } else {
                    stringArray[n] = "";
                }
                String string = pin.text;
                if (pin.lineOver) {
                    string = string + '\'';
                }
                if (pin.clock) {
                    string = "Clk";
                }
                int n4 = n++;
                stringArray[n4] = stringArray[n4] + string + " = " + CircuitFrame.this.getVoltageText(this.volts[n2]);
                if (n2 % 2 == 1) {
                    // empty if block
                }
                ++n2;
            }
        }

        void setCurrent(int n, double d) {
            int n2 = 0;
            while (n2 != this.getPostCount()) {
                if (this.pins[n2].output && this.pins[n2].voltSource == n) {
                    this.pins[n2].current = d;
                }
                ++n2;
            }
        }

        String getChipName() {
            return "chip";
        }

        boolean getConnection(int n, int n2) {
            return false;
        }

        boolean hasGroundConnection(int n) {
            return this.pins[n].output;
        }

        class Pin {
            Point post;
            Point stub;
            Point textloc;
            int pos;
            int side;
            int voltSource;
            int bubbleX;
            int bubbleY;
            String text;
            boolean lineOver;
            boolean bubble;
            boolean clock;
            boolean output;
            boolean value;
            boolean state;
            double curcount;
            double current;

            Pin(int n, int n2, String string) {
                this.pos = n;
                this.side = n2;
                this.text = string;
            }

            void setPoint(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                int n9 = n + ChipElm.this.cspc2 * n3 * this.pos + n7;
                int n10 = n2 + ChipElm.this.cspc2 * n4 * this.pos + n8;
                this.post = new Point(n9 + n5 * ChipElm.this.cspc2, n10 + n6 * ChipElm.this.cspc2);
                this.stub = new Point(n9 + n5 * ChipElm.this.cspc, n10 + n6 * ChipElm.this.cspc);
                this.textloc = new Point(n9, n10);
                if (this.bubble) {
                    this.bubbleX = n9 + n5 * 10 * ChipElm.this.csize;
                    this.bubbleY = n10 + n6 * 10 * ChipElm.this.csize;
                }
                if (this.clock) {
                    ChipElm.this.clockPointsX = new int[3];
                    ChipElm.this.clockPointsY = new int[3];
                    ChipElm.this.clockPointsX[0] = n9 + n5 * ChipElm.this.cspc - n3 * ChipElm.this.cspc / 2;
                    ChipElm.this.clockPointsY[0] = n10 + n6 * ChipElm.this.cspc - n4 * ChipElm.this.cspc / 2;
                    ChipElm.this.clockPointsX[1] = n9;
                    ChipElm.this.clockPointsY[1] = n10;
                    ChipElm.this.clockPointsX[2] = n9 + n5 * ChipElm.this.cspc + n3 * ChipElm.this.cspc / 2;
                    ChipElm.this.clockPointsY[2] = n10 + n6 * ChipElm.this.cspc + n4 * ChipElm.this.cspc / 2;
                }
            }
        }
    }

    class InverterElm
    extends CircuitElm {
        double slewRate;
        Polygon gatePoly;
        Point pcircle;

        public InverterElm(int n, int n2) {
            super(n, n2);
            this.noDiagonal = true;
            this.slewRate = 0.5;
        }

        public InverterElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.noDiagonal = true;
            try {
                this.slewRate = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                this.slewRate = 0.5;
            }
        }

        String dump() {
            return super.dump() + " " + this.slewRate;
        }

        int getDumpType() {
            return 73;
        }

        void draw(Graphics graphics) {
            this.drawPosts(graphics);
            this.draw2Leads(graphics);
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            CircuitFrame.this.drawThickPolygon(graphics, this.gatePoly);
            CircuitFrame.this.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, 3);
            this.curcount = this.updateDotCount(this.current, this.curcount);
            this.drawDots(graphics, this.lead2, this.point2, this.curcount);
        }

        void setPoints() {
            super.setPoints();
            int n = 16;
            int n2 = 16;
            if ((double)n2 > this.dn / 2.0) {
                n2 = (int)(this.dn / 2.0);
            }
            this.lead1 = this.interpPoint(this.point1, this.point2, 0.5 - (double)n2 / this.dn);
            this.lead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 + 2) / this.dn);
            this.pcircle = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 2) / this.dn);
            Point[] pointArray = this.newPointArray(3);
            this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, n);
            pointArray[2] = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 5) / this.dn);
            this.gatePoly = this.createPolygon(pointArray);
            this.setBbox(this.point1, this.point2, n);
        }

        int getVoltageSourceCount() {
            return 1;
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(0, this.nodes[1], this.voltSource);
        }

        void doStep() {
            double d = this.volts[1];
            double d2 = this.volts[0] > 2.5 ? 0.0 : 5.0;
            double d3 = this.slewRate * CircuitFrame.this.timeStep * 1.0E9;
            d2 = Math.max(Math.min(d + d3, d2), d - d3);
            CircuitFrame.this.updateVoltageSource(0, this.nodes[1], this.voltSource, d2);
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "inverter";
            stringArray[1] = "Vi = " + CircuitFrame.this.getVoltageText(this.volts[0]);
            stringArray[2] = "Vo = " + CircuitFrame.this.getVoltageText(this.volts[1]);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Slew Rate (V/ns)", this.slewRate, 0.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.slewRate = editInfo.value;
        }

        boolean getConnection(int n, int n2) {
            return false;
        }

        boolean hasGroundConnection(int n) {
            return n == 1;
        }
    }

    class OutputElm
    extends CircuitElm {
        final int FLAG_VALUE = 1;

        public OutputElm(int n, int n2) {
            super(n, n2);
        }

        public OutputElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
        }

        int getDumpType() {
            return 79;
        }

        int getPostCount() {
            return 1;
        }

        void setPoints() {
            super.setPoints();
            this.lead1 = new Point();
        }

        void draw(Graphics graphics) {
            boolean bl = CircuitFrame.this.mouseElm == this || CircuitFrame.this.plotYElm == this;
            Font font = new Font("SansSerif", bl ? 1 : 0, 14);
            graphics.setFont(font);
            graphics.setColor(bl ? CircuitFrame.this.selectColor : CircuitFrame.this.whiteColor);
            String string = (this.flags & 1) != 0 ? CircuitFrame.this.getVoltageText(this.volts[0]) : "out";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this == CircuitFrame.this.plotXElm) {
                string = "X";
            }
            if (this == CircuitFrame.this.plotYElm) {
                string = "Y";
            }
            this.interpPoint(this.point1, this.point2, this.lead1, 1.0 - (double)(fontMetrics.stringWidth(string) / 2 + 8) / this.dn);
            this.setBbox(this.point1, this.lead1, 0.0);
            this.drawCenteredText(graphics, string, this.x2, this.y2, true);
            this.setVoltageColor(graphics, this.volts[0]);
            if (bl) {
                graphics.setColor(CircuitFrame.this.selectColor);
            }
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.drawPosts(graphics);
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "output";
            stringArray[1] = "V = " + CircuitFrame.this.getVoltageText(this.volts[0]);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Show Voltage", (this.flags & 1) != 0);
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.flags = editInfo.checkbox.getState() ? this.flags | 1 : this.flags & 0xFFFFFFFE;
            }
        }
    }

    class LogicOutputElm
    extends CircuitElm {
        final int FLAG_TERNARY = 1;
        final int FLAG_NUMERIC = 2;
        double threshold;
        String value;

        public LogicOutputElm(int n, int n2) {
            super(n, n2);
            this.threshold = 2.5;
        }

        public LogicOutputElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            try {
                this.threshold = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                this.threshold = 2.5;
            }
        }

        String dump() {
            return super.dump() + " " + this.threshold;
        }

        int getDumpType() {
            return 77;
        }

        int getPostCount() {
            return 1;
        }

        boolean isTernary() {
            return (this.flags & 1) != 0;
        }

        boolean isNumeric() {
            return (this.flags & 3) != 0;
        }

        void setPoints() {
            super.setPoints();
            this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 12.0 / this.dn);
        }

        void draw(Graphics graphics) {
            String string;
            Font font = new Font("SansSerif", 1, 20);
            graphics.setFont(font);
            graphics.setColor(CircuitFrame.this.lightGrayColor);
            String string2 = string = this.volts[0] < this.threshold ? "L" : "H";
            if (this.isTernary()) {
                string = this.volts[0] > 3.75 ? "2" : (this.volts[0] > 1.25 ? "1" : "0");
            } else if (this.isNumeric()) {
                string = this.volts[0] < this.threshold ? "0" : "1";
            }
            this.value = string;
            this.setBbox(this.point1, this.lead1, 0.0);
            this.drawCenteredText(graphics, string, this.x2, this.y2, true);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.drawPosts(graphics);
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "logic output";
            String string = stringArray[1] = this.volts[0] < this.threshold ? "low" : "high";
            if (this.isNumeric()) {
                stringArray[1] = this.value;
            }
            stringArray[2] = "V = " + CircuitFrame.this.getVoltageText(this.volts[0]);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Threshold", this.threshold, 10.0, -10.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.threshold = editInfo.value;
            }
        }
    }

    class LogicInputElm
    extends SwitchElm {
        final int FLAG_TERNARY = 1;
        final int FLAG_NUMERIC = 2;
        double hiV;
        double loV;

        public LogicInputElm(int n, int n2) {
            super(n, n2, false);
            this.hiV = 5.0;
            this.loV = 0.0;
        }

        public LogicInputElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            try {
                this.hiV = new Double(stringTokenizer.nextToken());
                this.loV = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                this.hiV = 5.0;
                this.loV = 0.0;
            }
            if (this.isTernary()) {
                this.posCount = 3;
            }
        }

        boolean isTernary() {
            return (this.flags & 1) != 0;
        }

        boolean isNumeric() {
            return (this.flags & 3) != 0;
        }

        int getDumpType() {
            return 76;
        }

        String dump() {
            return super.dump() + " " + this.hiV + " " + this.loV;
        }

        int getPostCount() {
            return 1;
        }

        void setPoints() {
            super.setPoints();
            this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 12.0 / this.dn);
        }

        void draw(Graphics graphics) {
            String string;
            Font font = new Font("SansSerif", 1, 20);
            graphics.setFont(font);
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.whiteColor);
            String string2 = string = this.position == 0 ? "L" : "H";
            if (this.isNumeric()) {
                string = "" + this.position;
            }
            this.setBbox(this.point1, this.lead1, 0.0);
            this.drawCenteredText(graphics, string, this.x2, this.y2, true);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.updateDotCount();
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            this.drawPosts(graphics);
        }

        void setCurrent(int n, double d) {
            this.current = -d;
        }

        void stamp() {
            double d;
            double d2 = d = this.position == 0 ? this.loV : this.hiV;
            if (this.isTernary()) {
                d = (double)this.position * 2.5;
            }
            CircuitFrame.this.stampVoltageSource(0, this.nodes[0], this.voltSource, d);
        }

        int getVoltageSourceCount() {
            return 1;
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "logic input";
            String string = stringArray[1] = this.position == 0 ? "low" : "high";
            if (this.isNumeric()) {
                stringArray[1] = "" + this.position;
            }
            stringArray[1] = stringArray[1] + " (" + CircuitFrame.this.getVoltageText(this.volts[0]) + ")";
            stringArray[2] = "I = " + CircuitFrame.this.getCurrentText(this.getCurrent());
        }

        boolean hasGroundConnection(int n) {
            return true;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                EditInfo editInfo = new EditInfo("", 0.0, 0.0, 0.0);
                editInfo.checkbox = new Checkbox("Momentary Switch", this.momentary);
                return editInfo;
            }
            if (n == 1) {
                return new EditInfo("High Voltage", this.hiV, 10.0, -10.0);
            }
            if (n == 2) {
                return new EditInfo("Low Voltage", this.loV, 10.0, -10.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.momentary = editInfo.checkbox.getState();
            }
            if (n == 1) {
                this.hiV = editInfo.value;
            }
            if (n == 2) {
                this.loV = editInfo.value;
            }
        }
    }

    class AntennaElm
    extends RailElm {
        double fmphase;

        public AntennaElm(int n, int n2) {
            super(n, n2, 0);
        }

        public AntennaElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.waveform = 0;
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(0, this.nodes[0], this.voltSource);
        }

        void doStep() {
            CircuitFrame.this.updateVoltageSource(0, this.nodes[0], this.voltSource, this.getVoltage());
        }

        double getVoltage() {
            this.fmphase += Math.PI * 2 * (2200.0 + Math.sin(Math.PI * 2 * CircuitFrame.this.t * 13.0) * 100.0) * CircuitFrame.this.timeStep;
            double d = 3.0 * Math.sin(this.fmphase);
            return Math.sin(Math.PI * 2 * CircuitFrame.this.t * 3000.0) * (1.3 + Math.sin(Math.PI * 2 * CircuitFrame.this.t * 12.0)) * 3.0 + Math.sin(Math.PI * 2 * CircuitFrame.this.t * 2710.0) * (1.3 + Math.sin(Math.PI * 2 * CircuitFrame.this.t * 13.0)) * 3.0 + Math.sin(Math.PI * 2 * CircuitFrame.this.t * 2433.0) * (1.3 + Math.sin(Math.PI * 2 * CircuitFrame.this.t * 14.0)) * 3.0 + d;
        }

        int getDumpType() {
            return 65;
        }
    }

    class GroundElm
    extends CircuitElm {
        public GroundElm(int n, int n2) {
            super(n, n2);
        }

        public GroundElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
        }

        int getDumpType() {
            return 103;
        }

        int getPostCount() {
            return 1;
        }

        void draw(Graphics graphics) {
            this.setVoltageColor(graphics, 0.0);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.point2);
            int n = 0;
            while (n != 3) {
                int n2 = 10 - n * 4;
                int n3 = n * 5;
                this.interpPoint2(this.point1, this.point2, CircuitFrame.this.ps1, CircuitFrame.this.ps2, 1.0 + (double)n3 / this.dn, n2);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                ++n;
            }
            this.doDots(graphics);
            this.interpPoint(this.point1, this.point2, CircuitFrame.this.ps2, 1.0 + 11.0 / this.dn);
            this.setBbox(this.point1, CircuitFrame.this.ps2, 11.0);
            this.drawPost(graphics, this.x, this.y, this.nodes[0]);
        }

        void setCurrent(int n, double d) {
            this.current = -d;
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(0, this.nodes[0], this.voltSource, 0.0);
        }

        double getVoltageDiff() {
            return 0.0;
        }

        int getVoltageSourceCount() {
            return 1;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "ground";
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentText(this.getCurrent());
        }

        boolean hasGroundConnection(int n) {
            return true;
        }
    }

    class VarRailElm
    extends RailElm {
        Scrollbar slider;
        Label label;
        String sliderText;

        public VarRailElm(int n, int n2) {
            super(n, n2, 6);
            this.sliderText = "Voltage";
            this.frequency = this.maxVoltage;
            this.createSlider();
        }

        public VarRailElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.sliderText = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                this.sliderText = this.sliderText + ' ' + stringTokenizer.nextToken();
            }
            this.createSlider();
        }

        String dump() {
            return super.dump() + " " + this.sliderText;
        }

        int getDumpType() {
            return 172;
        }

        void createSlider() {
            this.waveform = 6;
            this.label = new Label(this.sliderText, 1);
            CircuitFrame.this.main.add(this.label);
            int n = (int)((this.frequency - this.bias) * 100.0 / (this.maxVoltage - this.bias));
            this.slider = new Scrollbar(0, n, 1, 0, 101);
            CircuitFrame.this.main.add(this.slider);
            CircuitFrame.this.main.validate();
        }

        double getVoltage() {
            this.frequency = (double)this.slider.getValue() * (this.maxVoltage - this.bias) / 100.0 + this.bias;
            return this.frequency;
        }

        void delete() {
            CircuitFrame.this.main.remove(this.label);
            CircuitFrame.this.main.remove(this.slider);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Min Voltage", this.bias, -20.0, 20.0);
            }
            if (n == 1) {
                return new EditInfo("Max Voltage", this.maxVoltage, -20.0, 20.0);
            }
            if (n == 2) {
                EditInfo editInfo = new EditInfo("Slider Text", 0.0, -1.0, -1.0);
                editInfo.text = this.sliderText;
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.bias = editInfo.value;
            }
            if (n == 1) {
                this.maxVoltage = editInfo.value;
            }
            if (n == 2) {
                this.sliderText = editInfo.textf.getText();
                this.label.setText(this.sliderText);
            }
        }
    }

    class RailElm
    extends VoltageElm {
        final int FLAG_CLOCK = 1;

        public RailElm(int n, int n2) {
            super(n, n2, 0);
        }

        RailElm(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public RailElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        int getDumpType() {
            return 82;
        }

        int getPostCount() {
            return 1;
        }

        void setPoints() {
            super.setPoints();
            this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 17.0 / this.dn);
        }

        void draw(Graphics graphics) {
            boolean bl;
            this.setBbox(this.point1, this.point2, 17.0);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            boolean bl2 = bl = this.waveform == 2 && (this.flags & 1) != 0;
            if (this.waveform == 0 || this.waveform == 6 || bl) {
                Font font = new Font("SansSerif", 0, 12);
                graphics.setFont(font);
                graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.whiteColor);
                this.setPowerColor(graphics, false);
                String string = CircuitFrame.this.showFormat.format(this.getVoltage()) + "V";
                if (this.getVoltage() > 0.0) {
                    string = "+" + string;
                }
                if (this instanceof AntennaElm) {
                    string = "Ant";
                }
                if (bl) {
                    string = "CLK";
                }
                this.drawCenteredText(graphics, string, this.x2, this.y2, true);
            } else {
                this.drawWaveform(graphics, this.point2);
            }
            this.drawPosts(graphics);
            this.curcount = this.updateDotCount(-this.current, this.curcount);
            if (CircuitFrame.this.dragElm != this) {
                this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            }
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        void stamp() {
            if (this.waveform == 0) {
                CircuitFrame.this.stampVoltageSource(0, this.nodes[0], this.voltSource, this.getVoltage());
            } else {
                CircuitFrame.this.stampVoltageSource(0, this.nodes[0], this.voltSource);
            }
        }

        void doStep() {
            if (this.waveform != 0) {
                CircuitFrame.this.updateVoltageSource(0, this.nodes[0], this.voltSource, this.getVoltage());
            }
        }

        boolean hasGroundConnection(int n) {
            return true;
        }
    }

    class ClockElm
    extends RailElm {
        static /* synthetic */ Class class$CircuitFrame$RailElm;

        public ClockElm(int n, int n2) {
            super(n, n2, 2);
            this.maxVoltage = 2.5;
            this.bias = 2.5;
            this.frequency = 100.0;
            this.flags |= 1;
        }

        Class getDumpClass() {
            return class$CircuitFrame$RailElm == null ? (class$CircuitFrame$RailElm = ClockElm.class$("CircuitFrame$RailElm")) : class$CircuitFrame$RailElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class SquareRailElm
    extends RailElm {
        static /* synthetic */ Class class$CircuitFrame$RailElm;

        public SquareRailElm(int n, int n2) {
            super(n, n2, 2);
        }

        Class getDumpClass() {
            return class$CircuitFrame$RailElm == null ? (class$CircuitFrame$RailElm = SquareRailElm.class$("CircuitFrame$RailElm")) : class$CircuitFrame$RailElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ACRailElm
    extends RailElm {
        static /* synthetic */ Class class$CircuitFrame$RailElm;

        public ACRailElm(int n, int n2) {
            super(n, n2, 1);
        }

        Class getDumpClass() {
            return class$CircuitFrame$RailElm == null ? (class$CircuitFrame$RailElm = ACRailElm.class$("CircuitFrame$RailElm")) : class$CircuitFrame$RailElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class TappedTransformerElm
    extends CircuitElm {
        double inductance;
        double ratio;
        Point[] ptEnds;
        Point[] ptCoil;
        Point[] ptCore;
        double[] current;
        double[] curcount;
        double[] a;
        double[] curSourceValue;
        double[] voltdiff;

        public TappedTransformerElm(int n, int n2) {
            super(n, n2);
            this.inductance = 4.0;
            this.ratio = 1.0;
            this.noDiagonal = true;
            this.current = new double[4];
            this.curcount = new double[4];
        }

        public TappedTransformerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.inductance = new Double(stringTokenizer.nextToken());
            this.ratio = new Double(stringTokenizer.nextToken());
            this.current = new double[2];
            this.curcount = new double[2];
            this.current[0] = new Double(stringTokenizer.nextToken());
            this.current[1] = new Double(stringTokenizer.nextToken());
            this.noDiagonal = true;
        }

        int getDumpType() {
            return 169;
        }

        String dump() {
            return super.dump() + " " + this.inductance + " " + this.ratio + " " + this.current[0] + " " + this.current[1];
        }

        void draw(Graphics graphics) {
            int n = 0;
            while (n != 5) {
                this.setVoltageColor(graphics, this.volts[n]);
                CircuitFrame.this.drawThickLine(graphics, this.ptEnds[n], this.ptCoil[n]);
                ++n;
            }
            n = 0;
            while (n != 4) {
                if (n != 1) {
                    this.setPowerColor(graphics, this.current[n] * (this.volts[n] - this.volts[n + 1]));
                    this.drawCoil(graphics, n > 1 ? -6 : 6, this.ptCoil[n], this.ptCoil[n + 1], this.volts[n], this.volts[n + 1]);
                }
                ++n;
            }
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            n = 0;
            while (n != 4) {
                CircuitFrame.this.drawThickLine(graphics, this.ptCore[n], this.ptCore[n + 1]);
                n += 2;
            }
            this.drawPosts(graphics);
            this.setBbox(this.ptEnds[0], this.ptEnds[4], 0.0);
        }

        void setPoints() {
            super.setPoints();
            int n = 32;
            this.ptEnds = this.newPointArray(5);
            this.ptCoil = this.newPointArray(5);
            this.ptCore = this.newPointArray(4);
            this.ptEnds[0] = this.point1;
            this.ptEnds[2] = this.point2;
            this.interpPoint(this.point1, this.point2, this.ptEnds[1], 0.0, -n * 2);
            this.interpPoint(this.point1, this.point2, this.ptEnds[3], 1.0, -n);
            this.interpPoint(this.point1, this.point2, this.ptEnds[4], 1.0, -n * 2);
            double d = 0.5 - 12.0 / this.dn;
            double d2 = 0.5 - 2.0 / this.dn;
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[0], d);
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[1], d, -n * 2);
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[2], 1.0 - d);
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[3], 1.0 - d, -n);
            this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCoil[4], 1.0 - d, -n * 2);
            int n2 = 0;
            while (n2 != 2) {
                int n3 = -n * n2 * 2;
                this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCore[n2], d2, n3);
                this.interpPoint(this.ptEnds[0], this.ptEnds[2], this.ptCore[n2 + 2], 1.0 - d2, n3);
                ++n2;
            }
        }

        Point getPost(int n) {
            return this.ptEnds[n];
        }

        int getPostCount() {
            return 5;
        }

        void reset() {
            this.curcount[1] = 0.0;
            this.curcount[0] = 0.0;
            this.volts[3] = 0.0;
            this.volts[2] = 0.0;
            this.volts[1] = 0.0;
            this.volts[0] = 0.0;
            this.current[1] = 0.0;
            this.current[0] = 0.0;
        }

        void stamp() {
            double d = this.inductance;
            double d2 = this.inductance * this.ratio * this.ratio / 4.0;
            double d3 = 0.99;
            this.a = new double[9];
            this.a[0] = (1.0 + d3) / (d * (1.0 + d3 - 2.0 * d3 * d3));
            this.a[3] = this.a[6] = 2.0 * d3 / ((2.0 * d3 * d3 - d3 - 1.0) * this.inductance * this.ratio);
            this.a[2] = this.a[6];
            this.a[1] = this.a[6];
            this.a[4] = this.a[8] = -4.0 * (1.0 + d3) / ((2.0 * d3 * d3 - d3 - 1.0) * d * this.ratio * this.ratio);
            this.a[5] = this.a[7] = 4.0 * d3 / ((2.0 * d3 * d3 - d3 - 1.0) * d * this.ratio * this.ratio);
            int n = 0;
            while (n != 9) {
                int n2 = n++;
                this.a[n2] = this.a[n2] * (CircuitFrame.this.timeStep / 2.0);
            }
            CircuitFrame.this.stampConductance(this.nodes[0], this.nodes[1], this.a[0]);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[0], this.nodes[1], this.nodes[2], this.nodes[3], this.a[1]);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[0], this.nodes[1], this.nodes[3], this.nodes[4], this.a[2]);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[2], this.nodes[3], this.nodes[0], this.nodes[1], this.a[3]);
            CircuitFrame.this.stampConductance(this.nodes[2], this.nodes[3], this.a[4]);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[2], this.nodes[3], this.nodes[3], this.nodes[4], this.a[5]);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[3], this.nodes[4], this.nodes[0], this.nodes[1], this.a[6]);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[3], this.nodes[4], this.nodes[2], this.nodes[3], this.a[7]);
            CircuitFrame.this.stampConductance(this.nodes[3], this.nodes[4], this.a[8]);
            n = 0;
            while (n != 5) {
                CircuitFrame.this.stampRightSide(this.nodes[n]);
                ++n;
            }
            this.voltdiff = new double[3];
            this.curSourceValue = new double[3];
        }

        void startIteration() {
            this.voltdiff[0] = this.volts[0] - this.volts[1];
            this.voltdiff[1] = this.volts[2] - this.volts[3];
            this.voltdiff[2] = this.volts[3] - this.volts[4];
            int n = 0;
            while (n != 3) {
                this.curSourceValue[n] = this.current[n];
                int n2 = 0;
                while (n2 != 3) {
                    int n3 = n;
                    this.curSourceValue[n3] = this.curSourceValue[n3] + this.a[n * 3 + n2] * this.voltdiff[n2];
                    ++n2;
                }
                ++n;
            }
        }

        void doStep() {
            CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[1], this.curSourceValue[0]);
            CircuitFrame.this.stampCurrentSource(this.nodes[2], this.nodes[3], this.curSourceValue[1]);
            CircuitFrame.this.stampCurrentSource(this.nodes[3], this.nodes[4], this.curSourceValue[2]);
        }

        void calculateCurrent() {
            this.voltdiff[0] = this.volts[0] - this.volts[1];
            this.voltdiff[1] = this.volts[2] - this.volts[3];
            this.voltdiff[2] = this.volts[3] - this.volts[4];
            int n = 0;
            while (n != 3) {
                this.current[n] = this.curSourceValue[n];
                int n2 = 0;
                while (n2 != 3) {
                    int n3 = n;
                    this.current[n3] = this.current[n3] + this.a[n * 3 + n2] * this.voltdiff[n2];
                    ++n2;
                }
                ++n;
            }
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "transformer";
            stringArray[1] = "L = " + CircuitFrame.this.getUnitText(this.inductance, "H");
            stringArray[2] = "Ratio = " + this.ratio;
            stringArray[3] = "Vd1 = " + CircuitFrame.this.getVoltageText(this.volts[0] - this.volts[2]);
            stringArray[4] = "Vd2 = " + CircuitFrame.this.getVoltageText(this.volts[1] - this.volts[3]);
        }

        boolean getConnection(int n, int n2) {
            if (this.comparePair(n, n2, 0, 1)) {
                return true;
            }
            if (this.comparePair(n, n2, 2, 3)) {
                return true;
            }
            if (this.comparePair(n, n2, 3, 4)) {
                return true;
            }
            return this.comparePair(n, n2, 2, 4);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Inductance (H)", this.inductance, 0.01, 5.0);
            }
            if (n == 1) {
                return new EditInfo("Ratio", this.ratio, 1.0, 10.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.inductance = editInfo.value;
            }
            if (n == 1) {
                this.ratio = editInfo.value;
            }
        }
    }

    class TransformerElm
    extends CircuitElm {
        double inductance;
        double ratio;
        Point[] ptEnds;
        Point[] ptCoil;
        Point[] ptCore;
        double[] current;
        double[] curcount;
        int width;
        double a1;
        double a2;
        double a3;
        double a4;
        double curSourceValue1;
        double curSourceValue2;

        public TransformerElm(int n, int n2) {
            super(n, n2);
            this.inductance = 4.0;
            this.ratio = 1.0;
            this.width = 32;
            this.noDiagonal = true;
            this.current = new double[2];
            this.curcount = new double[2];
        }

        public TransformerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.width = 32;
            this.inductance = new Double(stringTokenizer.nextToken());
            this.ratio = new Double(stringTokenizer.nextToken());
            this.current = new double[2];
            this.curcount = new double[2];
            this.current[0] = new Double(stringTokenizer.nextToken());
            this.current[1] = new Double(stringTokenizer.nextToken());
            this.noDiagonal = true;
        }

        void drag(int n, int n2) {
            n = CircuitFrame.this.snapGrid(n);
            n2 = CircuitFrame.this.snapGrid(n2);
            this.width = CircuitFrame.this.max(32, CircuitFrame.this.abs(n2 - this.y));
            n2 = this.y;
            this.x2 = n;
            this.y2 = n2;
            this.setPoints();
        }

        int getDumpType() {
            return 84;
        }

        String dump() {
            return super.dump() + " " + this.inductance + " " + this.ratio + " " + this.current[0] + " " + this.current[1];
        }

        void draw(Graphics graphics) {
            int n = 0;
            while (n != 4) {
                this.setVoltageColor(graphics, this.volts[n]);
                CircuitFrame.this.drawThickLine(graphics, this.ptEnds[n], this.ptCoil[n]);
                ++n;
            }
            n = 0;
            while (n != 2) {
                this.setPowerColor(graphics, this.current[n] * (this.volts[n] - this.volts[n + 2]));
                this.drawCoil(graphics, this.dsign * (n == 1 ? -6 : 6), this.ptCoil[n], this.ptCoil[n + 2], this.volts[n], this.volts[n + 2]);
                ++n;
            }
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            n = 0;
            while (n != 2) {
                CircuitFrame.this.drawThickLine(graphics, this.ptCore[n], this.ptCore[n + 2]);
                this.curcount[n] = this.updateDotCount(this.current[n], this.curcount[n]);
                ++n;
            }
            n = 0;
            while (n != 2) {
                this.drawDots(graphics, this.ptEnds[n], this.ptCoil[n], this.curcount[n]);
                this.drawDots(graphics, this.ptCoil[n], this.ptCoil[n + 2], this.curcount[n]);
                this.drawDots(graphics, this.ptEnds[n + 2], this.ptCoil[n + 2], -this.curcount[n]);
                ++n;
            }
            this.drawPosts(graphics);
            this.setBbox(this.ptEnds[0], this.ptEnds[3], 0.0);
        }

        void setPoints() {
            super.setPoints();
            this.ptEnds = this.newPointArray(4);
            this.ptCoil = this.newPointArray(4);
            this.ptCore = this.newPointArray(4);
            this.ptEnds[0] = this.point1;
            this.ptEnds[1] = this.point2;
            this.interpPoint(this.point1, this.point2, this.ptEnds[2], 0.0, -this.dsign * this.width);
            this.interpPoint(this.point1, this.point2, this.ptEnds[3], 1.0, -this.dsign * this.width);
            double d = 0.5 - 12.0 / this.dn;
            double d2 = 0.5 - 2.0 / this.dn;
            int n = 0;
            while (n != 4) {
                this.interpPoint(this.ptEnds[n], this.ptEnds[n + 1], this.ptCoil[n], d);
                this.interpPoint(this.ptEnds[n], this.ptEnds[n + 1], this.ptCoil[n + 1], 1.0 - d);
                this.interpPoint(this.ptEnds[n], this.ptEnds[n + 1], this.ptCore[n], d2);
                this.interpPoint(this.ptEnds[n], this.ptEnds[n + 1], this.ptCore[n + 1], 1.0 - d2);
                n += 2;
            }
        }

        Point getPost(int n) {
            return this.ptEnds[n];
        }

        int getPostCount() {
            return 4;
        }

        void reset() {
            this.curcount[1] = 0.0;
            this.curcount[0] = 0.0;
            this.volts[3] = 0.0;
            this.volts[2] = 0.0;
            this.volts[1] = 0.0;
            this.volts[0] = 0.0;
            this.current[1] = 0.0;
            this.current[0] = 0.0;
        }

        void stamp() {
            double d = this.inductance;
            double d2 = this.inductance * this.ratio * this.ratio;
            double d3 = 0.999 * Math.sqrt(d * d2);
            double d4 = 1.0 / (d * d2 - d3 * d3);
            this.a1 = d2 * d4 * CircuitFrame.this.timeStep / 2.0;
            this.a2 = -d3 * d4 * CircuitFrame.this.timeStep / 2.0;
            this.a3 = -d3 * d4 * CircuitFrame.this.timeStep / 2.0;
            this.a4 = d * d4 * CircuitFrame.this.timeStep / 2.0;
            CircuitFrame.this.stampConductance(this.nodes[0], this.nodes[2], this.a1);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[0], this.nodes[2], this.nodes[1], this.nodes[3], this.a2);
            CircuitFrame.this.stampVCCurrentSource(this.nodes[1], this.nodes[3], this.nodes[0], this.nodes[2], this.a3);
            CircuitFrame.this.stampConductance(this.nodes[1], this.nodes[3], this.a4);
            CircuitFrame.this.stampRightSide(this.nodes[0]);
            CircuitFrame.this.stampRightSide(this.nodes[1]);
            CircuitFrame.this.stampRightSide(this.nodes[2]);
            CircuitFrame.this.stampRightSide(this.nodes[3]);
        }

        void startIteration() {
            double d = this.volts[0] - this.volts[2];
            double d2 = this.volts[1] - this.volts[3];
            this.curSourceValue1 = d * this.a1 + d2 * this.a2 + this.current[0];
            this.curSourceValue2 = d * this.a3 + d2 * this.a4 + this.current[1];
        }

        void doStep() {
            CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[2], this.curSourceValue1);
            CircuitFrame.this.stampCurrentSource(this.nodes[1], this.nodes[3], this.curSourceValue2);
        }

        void calculateCurrent() {
            double d = this.volts[0] - this.volts[2];
            double d2 = this.volts[1] - this.volts[3];
            this.current[0] = d * this.a1 + d2 * this.a2 + this.curSourceValue1;
            this.current[1] = d * this.a3 + d2 * this.a4 + this.curSourceValue2;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "transformer";
            stringArray[1] = "L = " + CircuitFrame.this.getUnitText(this.inductance, "H");
            stringArray[2] = "Ratio = 1:" + this.ratio;
            stringArray[3] = "Vd1 = " + CircuitFrame.this.getVoltageText(this.volts[0] - this.volts[2]);
            stringArray[4] = "Vd2 = " + CircuitFrame.this.getVoltageText(this.volts[1] - this.volts[3]);
        }

        boolean getConnection(int n, int n2) {
            if (this.comparePair(n, n2, 0, 2)) {
                return true;
            }
            return this.comparePair(n, n2, 1, 3);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Inductance (H)", this.inductance, 0.01, 5.0);
            }
            if (n == 1) {
                return new EditInfo("Ratio", this.ratio, 1.0, 10.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.inductance = editInfo.value;
            }
            if (n == 1) {
                this.ratio = editInfo.value;
            }
        }
    }

    class XorGateElm
    extends OrGateElm {
        public XorGateElm(int n, int n2) {
            super(n, n2);
        }

        public XorGateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getGateName() {
            return "XOR gate";
        }

        boolean calcFunction() {
            boolean bl = false;
            int n = 0;
            while (n != this.inputCount) {
                bl ^= this.getInput(n);
                ++n;
            }
            return bl;
        }

        int getDumpType() {
            return 154;
        }
    }

    class NorGateElm
    extends OrGateElm {
        public NorGateElm(int n, int n2) {
            super(n, n2);
        }

        public NorGateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getGateName() {
            return "NOR gate";
        }

        boolean isInverting() {
            return true;
        }

        int getDumpType() {
            return 153;
        }
    }

    class OrGateElm
    extends GateElm {
        public OrGateElm(int n, int n2) {
            super(n, n2);
        }

        public OrGateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        String getGateName() {
            return "OR gate";
        }

        void setPoints() {
            double d;
            double d2;
            super.setPoints();
            Point[] pointArray = this.newPointArray(38);
            if (this instanceof XorGateElm) {
                this.linePoints = new Point[5];
            }
            int n = 0;
            while (n != 16) {
                d2 = (double)n / 16.0;
                d = 1.0 - d2 * d2;
                this.interpPoint2(this.lead1, this.lead2, pointArray[n], pointArray[32 - n], 0.5 + d2 / 2.0, d * (double)this.hs2);
                ++n;
            }
            d2 = this.ww == 0 ? this.dn * 2.0 : (double)(this.ww * 2);
            n = 0;
            while (n != 5) {
                d = (double)(n - 2) / 2.0;
                double d3 = 4.0 * (1.0 - d * d) - 2.0;
                this.interpPoint(this.lead1, this.lead2, pointArray[33 + n], d3 / d2, d * (double)this.hs2);
                if (this instanceof XorGateElm) {
                    this.linePoints[n] = this.interpPoint(this.lead1, this.lead2, (d3 - 5.0) / d2, d * (double)this.hs2);
                }
                ++n;
            }
            pointArray[16] = new Point(this.lead2);
            if (this.isInverting()) {
                this.pcircle = this.interpPoint(this.point1, this.point2, 0.5 + (double)(this.ww + 4) / this.dn);
                this.lead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)(this.ww + 8) / this.dn);
            }
            this.gatePoly = this.createPolygon(pointArray);
        }

        boolean calcFunction() {
            boolean bl = false;
            int n = 0;
            while (n != this.inputCount) {
                bl |= this.getInput(n);
                ++n;
            }
            return bl;
        }

        int getDumpType() {
            return 152;
        }
    }

    class NandGateElm
    extends AndGateElm {
        public NandGateElm(int n, int n2) {
            super(n, n2);
        }

        public NandGateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        boolean isInverting() {
            return true;
        }

        String getGateName() {
            return "NAND gate";
        }

        int getDumpType() {
            return 151;
        }
    }

    class AndGateElm
    extends GateElm {
        public AndGateElm(int n, int n2) {
            super(n, n2);
        }

        public AndGateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
        }

        void setPoints() {
            super.setPoints();
            Point[] pointArray = this.newPointArray(23);
            this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[22], 0.0, this.hs2);
            int n = 0;
            while (n != 10) {
                double d = (double)n * 0.1;
                double d2 = Math.sqrt(1.0 - d * d);
                this.interpPoint2(this.lead1, this.lead2, pointArray[n + 1], pointArray[21 - n], 0.5 + d / 2.0, d2 * (double)this.hs2);
                ++n;
            }
            pointArray[11] = new Point(this.lead2);
            if (this.isInverting()) {
                this.pcircle = this.interpPoint(this.point1, this.point2, 0.5 + (double)(this.ww + 4) / this.dn);
                this.lead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)(this.ww + 8) / this.dn);
            }
            this.gatePoly = this.createPolygon(pointArray);
        }

        String getGateName() {
            return "AND gate";
        }

        boolean calcFunction() {
            boolean bl = true;
            int n = 0;
            while (n != this.inputCount) {
                bl &= this.getInput(n);
                ++n;
            }
            return bl;
        }

        int getDumpType() {
            return 150;
        }
    }

    abstract class GateElm
    extends CircuitElm {
        final int FLAG_SMALL = 1;
        int inputCount = 2;
        boolean lastOutput;
        int gsize;
        int gwidth;
        int gwidth2;
        int gheight;
        int hs2;
        Point[] inPosts;
        Point[] inGates;
        int ww;
        Polygon gatePoly;
        Point pcircle;
        Point[] linePoints;

        public GateElm(int n, int n2) {
            super(n, n2);
            this.noDiagonal = true;
            this.inputCount = 2;
            this.setSize(CircuitFrame.this.smallGridCheckItem.getState() ? 1 : 2);
        }

        public GateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.inputCount = new Integer(stringTokenizer.nextToken());
            this.lastOutput = new Double(stringTokenizer.nextToken()) > 2.5;
            this.noDiagonal = true;
            this.setSize((n5 & 1) != 0 ? 1 : 2);
        }

        boolean isInverting() {
            return false;
        }

        void setSize(int n) {
            this.gsize = n;
            this.gwidth = 7 * n;
            this.gwidth2 = 14 * n;
            this.gheight = 8 * n;
            this.flags = n == 1 ? 1 : 0;
        }

        String dump() {
            return super.dump() + " " + this.inputCount + " " + this.volts[this.inputCount];
        }

        void setPoints() {
            super.setPoints();
            if (this.dn > 150.0 && this == CircuitFrame.this.dragElm) {
                this.setSize(2);
            }
            int n = this.gheight;
            this.ww = this.gwidth2;
            if ((double)this.ww > this.dn / 2.0) {
                this.ww = (int)(this.dn / 2.0);
            }
            if (this.isInverting() && (double)(this.ww + 8) > this.dn / 2.0) {
                this.ww = (int)(this.dn / 2.0 - 8.0);
            }
            this.calcLeads(this.ww * 2);
            this.inPosts = new Point[this.inputCount];
            this.inGates = new Point[this.inputCount];
            this.allocNodes();
            int n2 = -this.inputCount / 2;
            int n3 = 0;
            while (n3 != this.inputCount) {
                if (n2 == 0 && (this.inputCount & 1) == 0) {
                    ++n2;
                }
                this.inPosts[n3] = this.interpPoint(this.point1, this.point2, 0.0, (double)(n * n2));
                this.inGates[n3] = this.interpPoint(this.lead1, this.lead2, 0.0, (double)(n * n2));
                this.volts[n3] = this.lastOutput ^ this.isInverting() ? 5.0 : 0.0;
                ++n3;
                ++n2;
            }
            this.hs2 = this.gwidth * (this.inputCount / 2 + 1);
            this.setBbox(this.point1, this.point2, this.hs2);
        }

        void draw(Graphics graphics) {
            int n = 0;
            while (n != this.inputCount) {
                this.setVoltageColor(graphics, this.volts[n]);
                CircuitFrame.this.drawThickLine(graphics, this.inPosts[n], this.inGates[n]);
                ++n;
            }
            this.setVoltageColor(graphics, this.volts[this.inputCount]);
            CircuitFrame.this.drawThickLine(graphics, this.lead2, this.point2);
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            CircuitFrame.this.drawThickPolygon(graphics, this.gatePoly);
            if (this.linePoints != null) {
                n = 0;
                while (n != this.linePoints.length - 1) {
                    CircuitFrame.this.drawThickLine(graphics, this.linePoints[n], this.linePoints[n + 1]);
                    ++n;
                }
            }
            if (this.isInverting()) {
                CircuitFrame.this.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, 3);
            }
            this.curcount = this.updateDotCount(this.current, this.curcount);
            this.drawDots(graphics, this.lead2, this.point2, this.curcount);
            this.drawPosts(graphics);
        }

        int getPostCount() {
            return this.inputCount + 1;
        }

        Point getPost(int n) {
            if (n == this.inputCount) {
                return this.point2;
            }
            return this.inPosts[n];
        }

        int getVoltageSourceCount() {
            return 1;
        }

        abstract String getGateName();

        void getInfo(String[] stringArray) {
            stringArray[0] = this.getGateName();
            stringArray[1] = "Vout = " + CircuitFrame.this.getVoltageText(this.volts[this.inputCount]);
            stringArray[2] = "Iout = " + CircuitFrame.this.getCurrentText(this.getCurrent());
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(0, this.nodes[this.inputCount], this.voltSource);
        }

        boolean getInput(int n) {
            return this.volts[n] > 2.5;
        }

        abstract boolean calcFunction();

        void doStep() {
            boolean bl = this.calcFunction();
            if (this.isInverting()) {
                bl = !bl;
            }
            this.lastOutput = bl;
            double d = bl ? 5.0 : 0.0;
            CircuitFrame.this.updateVoltageSource(0, this.nodes[this.inputCount], this.voltSource, d);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Inputs", this.inputCount, 1.0, 8.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.inputCount = (int)editInfo.value;
            this.setPoints();
        }

        boolean getConnection(int n, int n2) {
            return false;
        }

        boolean hasGroundConnection(int n) {
            return n == this.inputCount;
        }
    }

    class OpAmpElm
    extends CircuitElm {
        int opsize;
        int opheight;
        int opwidth;
        int opaddtext;
        double maxOut;
        double minOut;
        double gain;
        boolean reset;
        final int FLAG_SWAP = 1;
        final int FLAG_SMALL = 2;
        final int FLAG_LOWGAIN = 4;
        Point[] in1p;
        Point[] in2p;
        Point[] textp;
        Polygon triangle;
        Font plusFont;
        double lastvd;

        public OpAmpElm(int n, int n2) {
            super(n, n2);
            this.noDiagonal = true;
            this.maxOut = 15.0;
            this.minOut = -15.0;
            this.setSize(CircuitFrame.this.smallGridCheckItem.getState() ? 1 : 2);
            this.setGain();
        }

        public OpAmpElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            try {
                this.maxOut = new Double(stringTokenizer.nextToken());
                this.minOut = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                this.maxOut = 15.0;
                this.minOut = -15.0;
            }
            this.noDiagonal = true;
            this.setSize((n5 & 2) != 0 ? 1 : 2);
            this.setGain();
        }

        void setGain() {
            this.gain = (this.flags & 4) != 0 ? 1000.0 : 100000.0;
        }

        String dump() {
            return super.dump() + " " + this.maxOut + " " + this.minOut;
        }

        boolean nonLinear() {
            return true;
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, this.opheight * 2);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.in1p[0], this.in1p[1]);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.in2p[0], this.in2p[1]);
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : CircuitFrame.this.lightGrayColor);
            this.setPowerColor(graphics, true);
            CircuitFrame.this.drawThickPolygon(graphics, this.triangle);
            graphics.setFont(this.plusFont);
            this.drawCenteredText(graphics, "-", this.textp[0].x, this.textp[0].y - 2, true);
            this.drawCenteredText(graphics, "+", this.textp[1].x, this.textp[1].y, true);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.lead2, this.point2);
            this.curcount = this.updateDotCount(this.current, this.curcount);
            this.drawDots(graphics, this.point2, this.lead2, this.curcount);
            this.drawPosts(graphics);
        }

        double getPower() {
            return this.volts[2] * this.current;
        }

        void setSize(int n) {
            this.opsize = n;
            this.opheight = 8 * n;
            this.opwidth = 13 * n;
            this.flags = this.flags & 0xFFFFFFFD | (n == 1 ? 2 : 0);
        }

        void setPoints() {
            int n;
            super.setPoints();
            if (this.dn > 150.0 && this == CircuitFrame.this.dragElm) {
                this.setSize(2);
            }
            if ((double)(n = this.opwidth) > this.dn / 2.0) {
                n = (int)(this.dn / 2.0);
            }
            this.calcLeads(n * 2);
            int n2 = this.opheight * this.dsign;
            if ((this.flags & 1) != 0) {
                n2 = -n2;
            }
            this.in1p = this.newPointArray(2);
            this.in2p = this.newPointArray(2);
            this.textp = this.newPointArray(2);
            this.interpPoint2(this.point1, this.point2, this.in1p[0], this.in2p[0], 0.0, n2);
            this.interpPoint2(this.lead1, this.lead2, this.in1p[1], this.in2p[1], 0.0, n2);
            this.interpPoint2(this.lead1, this.lead2, this.textp[0], this.textp[1], 0.2, n2);
            Point[] pointArray = this.newPointArray(2);
            this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, n2 * 2);
            this.triangle = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
            this.plusFont = new Font("SansSerif", 0, this.opsize == 2 ? 14 : 10);
        }

        int getPostCount() {
            return 3;
        }

        Point getPost(int n) {
            return n == 0 ? this.in1p[0] : (n == 1 ? this.in2p[0] : this.point2);
        }

        int getVoltageSourceCount() {
            return 1;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "op-amp";
            stringArray[1] = "V+ = " + CircuitFrame.this.getVoltageText(this.volts[1]);
            stringArray[2] = "V- = " + CircuitFrame.this.getVoltageText(this.volts[0]);
            double d = Math.max(Math.min(this.volts[2], this.maxOut), this.minOut);
            stringArray[3] = "Vout = " + CircuitFrame.this.getVoltageText(d);
            stringArray[4] = "Iout = " + CircuitFrame.this.getCurrentText(this.getCurrent());
            stringArray[5] = "range = " + CircuitFrame.this.getVoltageText(this.minOut) + " to " + CircuitFrame.this.getVoltageText(this.maxOut);
        }

        void stamp() {
            int n = CircuitFrame.this.nodeList.size() + this.voltSource;
            CircuitFrame.this.stampNonLinear(n);
            CircuitFrame.this.stampMatrix(this.nodes[2], n, 1.0);
        }

        void doStep() {
            double d = this.volts[1] - this.volts[0];
            if (Math.abs(this.lastvd - d) > 0.1) {
                CircuitFrame.this.converged = false;
            } else if (this.volts[2] > this.maxOut + 0.1 || this.volts[2] < this.minOut - 0.1) {
                CircuitFrame.this.converged = false;
            }
            double d2 = 0.0;
            int n = CircuitFrame.this.nodeList.size() + this.voltSource;
            double d3 = 0.0;
            if (d >= this.maxOut / this.gain && (this.lastvd >= 0.0 || CircuitFrame.this.getrand(4) == 1)) {
                d3 = 1.0E-4;
                d2 = this.maxOut - d3 * this.maxOut / this.gain;
            } else if (d <= this.minOut / this.gain && (this.lastvd <= 0.0 || CircuitFrame.this.getrand(4) == 1)) {
                d3 = 1.0E-4;
                d2 = this.minOut - d3 * this.minOut / this.gain;
            } else {
                d3 = this.gain;
            }
            CircuitFrame.this.stampMatrix(n, this.nodes[0], d3);
            CircuitFrame.this.stampMatrix(n, this.nodes[1], -d3);
            CircuitFrame.this.stampMatrix(n, this.nodes[2], 1.0);
            CircuitFrame.this.stampRightSide(n, d2);
            this.lastvd = d;
        }

        boolean getConnection(int n, int n2) {
            return false;
        }

        boolean hasGroundConnection(int n) {
            return n == 2;
        }

        double getVoltageDiff() {
            return this.volts[2] - this.volts[1];
        }

        int getDumpType() {
            return 97;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Max Output (V)", this.maxOut, 1.0, 20.0);
            }
            if (n == 1) {
                return new EditInfo("Min Output (V)", this.minOut, -20.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.maxOut = editInfo.value;
            }
            if (n == 1) {
                this.minOut = editInfo.value;
            }
        }
    }

    class OpAmpSwapElm
    extends OpAmpElm {
        static /* synthetic */ Class class$CircuitFrame$OpAmpElm;

        public OpAmpSwapElm(int n, int n2) {
            super(n, n2);
            this.flags |= 1;
        }

        Class getDumpClass() {
            return class$CircuitFrame$OpAmpElm == null ? (class$CircuitFrame$OpAmpElm = OpAmpSwapElm.class$("CircuitFrame$OpAmpElm")) : class$CircuitFrame$OpAmpElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class JfetElm
    extends MosfetElm {
        Polygon gatePoly;
        Polygon arrowPoly;
        Point gatePt;

        JfetElm(int n, int n2, boolean bl) {
            super(n, n2, bl);
            this.noDiagonal = true;
        }

        public JfetElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.noDiagonal = true;
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 16.0);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.src[0], this.src[1]);
            CircuitFrame.this.drawThickLine(graphics, this.src[1], this.src[2]);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.drn[0], this.drn[1]);
            CircuitFrame.this.drawThickLine(graphics, this.drn[1], this.drn[2]);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.gatePt);
            graphics.fillPolygon(this.arrowPoly);
            this.setPowerColor(graphics, true);
            graphics.fillPolygon(this.gatePoly);
            this.curcount = this.updateDotCount(-this.ids, this.curcount);
            if (this.curcount != 0.0) {
                this.drawDots(graphics, this.src[0], this.src[1], this.curcount);
                this.drawDots(graphics, this.src[1], this.src[2], this.curcount + 8.0);
                this.drawDots(graphics, this.drn[0], this.drn[1], -this.curcount);
                this.drawDots(graphics, this.drn[1], this.drn[2], -(this.curcount + 8.0));
            }
            this.drawPosts(graphics);
        }

        void setPoints() {
            super.setPoints();
            int n = 16 * this.dsign;
            this.src = this.newPointArray(3);
            this.drn = this.newPointArray(3);
            this.interpPoint2(this.point1, this.point2, this.src[0], this.drn[0], 1.0, n);
            this.interpPoint2(this.point1, this.point2, this.src[1], this.drn[1], 1.0, n / 2);
            this.interpPoint2(this.point1, this.point2, this.src[2], this.drn[2], 1.0 - 10.0 / this.dn, n / 2);
            this.gatePt = this.interpPoint(this.point1, this.point2, 1.0 - 14.0 / this.dn);
            Point[] pointArray = this.newPointArray(4);
            this.interpPoint2(this.point1, this.point2, pointArray[0], pointArray[1], 1.0 - 13.0 / this.dn, 16.0);
            this.interpPoint2(this.point1, this.point2, pointArray[2], pointArray[3], 1.0 - 10.0 / this.dn, 16.0);
            this.gatePoly = this.createPolygon(pointArray[0], pointArray[1], pointArray[3], pointArray[2]);
            this.arrowPoly = this.calcArrow(this.point1, this.gatePt, 8.0, 3.0);
        }

        int getDumpType() {
            return 106;
        }

        double getDefaultThreshold() {
            return -4.0;
        }

        double getBeta() {
            return 0.00125;
        }

        void getInfo(String[] stringArray) {
            this.getFetInfo(stringArray, "JFET");
        }
    }

    class NJfetElm
    extends JfetElm {
        static /* synthetic */ Class class$CircuitFrame$JfetElm;

        public NJfetElm(int n, int n2) {
            super(n, n2, false);
        }

        Class getDumpClass() {
            return class$CircuitFrame$JfetElm == null ? (class$CircuitFrame$JfetElm = NJfetElm.class$("CircuitFrame$JfetElm")) : class$CircuitFrame$JfetElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class MosfetElm
    extends CircuitElm {
        int pnp;
        int FLAG_PNP = 1;
        int FLAG_SHOWVT = 2;
        int FLAG_DIGITAL = 4;
        double vt;
        final int hs = 16;
        int pcircler;
        Point[] src;
        Point[] drn;
        Point[] gate;
        Point pcircle;
        Polygon arrowPoly;
        double lastv1;
        double lastv2;
        double ids;
        int mode = 0;
        double gm = 0.0;

        MosfetElm(int n, int n2, boolean bl) {
            super(n, n2);
            this.pnp = bl ? -1 : 1;
            this.flags = bl ? this.FLAG_PNP : 0;
            this.noDiagonal = true;
            this.vt = this.getDefaultThreshold();
        }

        public MosfetElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.pnp = (n5 & this.FLAG_PNP) != 0 ? -1 : 1;
            this.noDiagonal = true;
            this.vt = this.getDefaultThreshold();
            try {
                this.vt = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        double getDefaultThreshold() {
            return 1.5;
        }

        double getBeta() {
            return 0.02;
        }

        boolean nonLinear() {
            return true;
        }

        boolean drawDigital() {
            return (this.flags & this.FLAG_DIGITAL) != 0;
        }

        void reset() {
            this.curcount = 0.0;
            this.volts[2] = 0.0;
            this.volts[1] = 0.0;
            this.volts[0] = 0.0;
            this.lastv2 = 0.0;
            this.lastv1 = 0.0;
        }

        String dump() {
            return super.dump() + " " + this.vt;
        }

        int getDumpType() {
            return 102;
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 16.0);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.src[0], this.src[1]);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.drn[0], this.drn[1]);
            int n = 6;
            this.setPowerColor(graphics, true);
            double d = 1.0 / (double)n;
            int n2 = 0;
            while (n2 != n) {
                double d2 = this.volts[1] + (this.volts[2] - this.volts[1]) * (double)n2 / (double)n;
                this.setVoltageColor(graphics, d2);
                this.interpPoint(this.src[1], this.drn[1], CircuitFrame.this.ps1, (double)n2 * d);
                this.interpPoint(this.src[1], this.drn[1], CircuitFrame.this.ps2, (double)(n2 + 1) * d);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                ++n2;
            }
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.src[1], this.src[2]);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.drn[1], this.drn[2]);
            if (!this.drawDigital()) {
                this.setVoltageColor(graphics, this.pnp == 1 ? this.volts[1] : this.volts[2]);
                graphics.fillPolygon(this.arrowPoly);
            }
            if (CircuitFrame.this.powerCheckItem.getState()) {
                graphics.setColor(Color.gray);
            }
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.gate[1]);
            CircuitFrame.this.drawThickLine(graphics, this.gate[0], this.gate[2]);
            if (this.drawDigital() && this.pnp == -1) {
                CircuitFrame.this.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, this.pcircler);
            }
            if ((this.flags & this.FLAG_SHOWVT) != 0) {
                String string = "" + this.vt * (double)this.pnp;
                graphics.setColor(CircuitFrame.this.whiteColor);
                graphics.setFont(CircuitFrame.this.unitsFont);
                this.drawCenteredText(graphics, string, this.x2 + 2, this.y2, false);
            }
            if ((CircuitFrame.this.mouseElm == this || CircuitFrame.this.dragElm == this) && this.dy == 0) {
                graphics.setColor(Color.white);
                graphics.setFont(CircuitFrame.this.unitsFont);
                int n3 = CircuitFrame.this.sign(this.dx);
                graphics.drawString("G", this.gate[1].x - 10 * n3, this.gate[1].y - 5);
                graphics.drawString(this.pnp == -1 ? "D" : "S", this.src[0].x - 3 + 9 * n3, this.src[0].y + 4);
                graphics.drawString(this.pnp == -1 ? "S" : "D", this.drn[0].x - 3 + 9 * n3, this.drn[0].y + 4);
            }
            this.curcount = this.updateDotCount(-this.ids, this.curcount);
            this.drawDots(graphics, this.src[0], this.src[1], this.curcount);
            this.drawDots(graphics, this.src[1], this.drn[1], this.curcount);
            this.drawDots(graphics, this.drn[1], this.drn[0], this.curcount);
            this.drawPosts(graphics);
        }

        Point getPost(int n) {
            return n == 0 ? this.point1 : (n == 1 ? this.src[0] : this.drn[0]);
        }

        double getCurrent() {
            return this.ids;
        }

        double getPower() {
            return this.ids * (this.volts[2] - this.volts[1]);
        }

        int getPostCount() {
            return 3;
        }

        void setPoints() {
            super.setPoints();
            int n = 16 * this.dsign;
            this.src = this.newPointArray(3);
            this.drn = this.newPointArray(3);
            this.interpPoint2(this.point1, this.point2, this.src[0], this.drn[0], 1.0, -n);
            this.interpPoint2(this.point1, this.point2, this.src[1], this.drn[1], 1.0 - 22.0 / this.dn, -n);
            this.interpPoint2(this.point1, this.point2, this.src[2], this.drn[2], 1.0 - 22.0 / this.dn, -n * 4 / 3);
            this.gate = this.newPointArray(3);
            this.interpPoint2(this.point1, this.point2, this.gate[0], this.gate[2], 1.0 - 28.0 / this.dn, n / 2);
            this.interpPoint(this.gate[0], this.gate[2], this.gate[1], 0.5);
            if (!this.drawDigital()) {
                this.arrowPoly = this.pnp == 1 ? this.calcArrow(this.src[1], this.src[0], 10.0, 4.0) : this.calcArrow(this.drn[0], this.drn[1], 12.0, 5.0);
            } else if (this.pnp == -1) {
                this.interpPoint(this.point1, this.point2, this.gate[1], 1.0 - 36.0 / this.dn);
                int n2 = this.dsign < 0 ? 32 : 31;
                this.pcircle = this.interpPoint(this.point1, this.point2, 1.0 - (double)n2 / this.dn);
                this.pcircler = 3;
            }
        }

        void stamp() {
            CircuitFrame.this.stampNonLinear(this.nodes[1]);
            CircuitFrame.this.stampNonLinear(this.nodes[2]);
        }

        void doStep() {
            double[] dArray = new double[]{this.volts[0], this.volts[1], this.volts[2]};
            if (dArray[1] > this.lastv1 + 0.5) {
                dArray[1] = this.lastv1 + 0.5;
            }
            if (dArray[1] < this.lastv1 - 0.5) {
                dArray[1] = this.lastv1 - 0.5;
            }
            if (dArray[2] > this.lastv2 + 0.5) {
                dArray[2] = this.lastv2 + 0.5;
            }
            if (dArray[2] < this.lastv2 - 0.5) {
                dArray[2] = this.lastv2 - 0.5;
            }
            int n = 1;
            int n2 = 2;
            if ((double)this.pnp * dArray[1] > (double)this.pnp * dArray[2]) {
                n = 2;
                n2 = 1;
            }
            int n3 = 0;
            double d = dArray[n3] - dArray[n];
            double d2 = dArray[n2] - dArray[n];
            if (Math.abs(this.lastv1 - dArray[1]) > 0.01 || Math.abs(this.lastv2 - dArray[2]) > 0.01) {
                CircuitFrame.this.converged = false;
            }
            this.lastv1 = dArray[1];
            this.lastv2 = dArray[2];
            double d3 = d;
            double d4 = d2;
            d *= (double)this.pnp;
            d2 *= (double)this.pnp;
            this.ids = 0.0;
            this.gm = 0.0;
            double d5 = 0.0;
            double d6 = this.getBeta();
            if (d > 0.5 && this instanceof JfetElm) {
                CircuitFrame.this.stop("JFET is reverse biased!", this);
                return;
            }
            if (d < this.vt) {
                d5 = 1.0E-8;
                this.ids = d2 * d5;
                this.mode = 0;
            } else if (d2 < d - this.vt) {
                this.ids = d6 * ((d - this.vt) * d2 - d2 * d2 * 0.5);
                this.gm = d6 * d2;
                d5 = d6 * (d - d2 - this.vt);
                this.mode = 1;
            } else {
                this.gm = d6 * (d - this.vt);
                d5 = 1.0E-8;
                this.ids = 0.5 * d6 * (d - this.vt) * (d - this.vt) + (d2 - (d - this.vt)) * d5;
                this.mode = 2;
            }
            double d7 = (double)(-this.pnp) * this.ids + d5 * d4 + this.gm * d3;
            CircuitFrame.this.stampMatrix(this.nodes[n2], this.nodes[n2], d5);
            CircuitFrame.this.stampMatrix(this.nodes[n2], this.nodes[n], -d5 - this.gm);
            CircuitFrame.this.stampMatrix(this.nodes[n2], this.nodes[n3], this.gm);
            CircuitFrame.this.stampMatrix(this.nodes[n], this.nodes[n2], -d5);
            CircuitFrame.this.stampMatrix(this.nodes[n], this.nodes[n], d5 + this.gm);
            CircuitFrame.this.stampMatrix(this.nodes[n], this.nodes[n3], -this.gm);
            CircuitFrame.this.stampRightSide(this.nodes[n2], d7);
            CircuitFrame.this.stampRightSide(this.nodes[n], -d7);
            if (n == 2 && this.pnp == 1 || n == 1 && this.pnp == -1) {
                this.ids = -this.ids;
            }
        }

        void getFetInfo(String[] stringArray, String string) {
            stringArray[0] = (this.pnp == -1 ? "p-" : "n-") + string;
            stringArray[0] = stringArray[0] + " (Vt = " + CircuitFrame.this.getVoltageText((double)this.pnp * this.vt) + ")";
            stringArray[1] = (this.pnp == 1 ? "Ids = " : "Isd = ") + CircuitFrame.this.getCurrentText(this.ids);
            stringArray[2] = "Vgs = " + CircuitFrame.this.getVoltageText(this.volts[0] - this.volts[this.pnp == -1 ? 2 : 1]);
            stringArray[3] = (this.pnp == 1 ? "Vds = " : "Vsd = ") + CircuitFrame.this.getVoltageText(this.volts[2] - this.volts[1]);
            stringArray[4] = this.mode == 0 ? "off" : (this.mode == 1 ? "linear" : "saturation");
            stringArray[5] = "gm = " + CircuitFrame.this.getUnitText(this.gm, "A/V");
        }

        void getInfo(String[] stringArray) {
            this.getFetInfo(stringArray, "MOSFET");
        }

        boolean canViewInScope() {
            return true;
        }

        double getVoltageDiff() {
            return this.volts[2] - this.volts[1];
        }

        boolean getConnection(int n, int n2) {
            return n != 0 && n2 != 0;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Threshold Voltage", (double)this.pnp * this.vt, 0.01, 5.0);
            }
            if (n == 1) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Digital Symbol", this.drawDigital());
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.vt = (double)this.pnp * editInfo.value;
            }
            if (n == 1) {
                this.flags = editInfo.checkbox.getState() ? this.flags | this.FLAG_DIGITAL : this.flags & ~this.FLAG_DIGITAL;
                this.setPoints();
            }
        }
    }

    class PMosfetElm
    extends MosfetElm {
        static /* synthetic */ Class class$CircuitFrame$MosfetElm;

        public PMosfetElm(int n, int n2) {
            super(n, n2, true);
        }

        Class getDumpClass() {
            return class$CircuitFrame$MosfetElm == null ? (class$CircuitFrame$MosfetElm = PMosfetElm.class$("CircuitFrame$MosfetElm")) : class$CircuitFrame$MosfetElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class NMosfetElm
    extends MosfetElm {
        static /* synthetic */ Class class$CircuitFrame$MosfetElm;

        public NMosfetElm(int n, int n2) {
            super(n, n2, false);
        }

        Class getDumpClass() {
            return class$CircuitFrame$MosfetElm == null ? (class$CircuitFrame$MosfetElm = NMosfetElm.class$("CircuitFrame$MosfetElm")) : class$CircuitFrame$MosfetElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class Scope {
        final int FLAG_YELM = 32;
        double[] minV;
        double[] maxV;
        double minMaxV;
        double[] minI;
        double[] maxI;
        double minMaxI;
        int scopePointCount = 128;
        int ptr;
        int ctr;
        int speed;
        int position;
        int value;
        String text;
        Rectangle rect = new Rectangle();
        boolean showI;
        boolean showV;
        boolean showMax;
        boolean showFreq;
        boolean lockScale;
        boolean plot2d;
        boolean plotXY;
        CircuitElm elm;
        CircuitElm xElm;
        CircuitElm yElm;
        MemoryImageSource imageSource;
        Image image;
        int[] pixels;
        int draw_ox;
        int draw_oy;
        float[] dpixels;

        Scope() {
            this.reset();
        }

        void showCurrent(boolean bl) {
            this.showI = bl;
            this.value = 0;
        }

        void showVoltage(boolean bl) {
            this.showV = bl;
            this.value = 0;
        }

        void showMax(boolean bl) {
            this.showMax = bl;
        }

        void showFreq(boolean bl) {
            this.showFreq = bl;
        }

        void setLockScale(boolean bl) {
            this.lockScale = bl;
        }

        void resetGraph() {
            this.scopePointCount = 1;
            while (this.scopePointCount < this.rect.width) {
                this.scopePointCount *= 2;
            }
            this.minV = new double[this.scopePointCount];
            this.maxV = new double[this.scopePointCount];
            this.minI = new double[this.scopePointCount];
            this.maxI = new double[this.scopePointCount];
            this.ctr = 0;
            this.ptr = 0;
            this.allocImage();
        }

        boolean active() {
            return this.elm != null;
        }

        void reset() {
            this.resetGraph();
            this.minMaxV = 5.0;
            this.minMaxI = 0.1;
            this.speed = 64;
            this.showMax = true;
            this.showV = true;
            this.showI = true;
            this.lockScale = false;
            this.showFreq = false;
            if (this.elm != null && (this.elm instanceof OutputElm || this.elm instanceof LogicOutputElm || this.elm instanceof ProbeElm)) {
                this.showI = false;
            }
            this.value = 0;
            if (this.elm instanceof TransistorElm) {
                this.value = 6;
            }
        }

        void setRect(Rectangle rectangle) {
            this.rect = rectangle;
            this.resetGraph();
        }

        int getWidth() {
            return this.rect.width;
        }

        int rightEdge() {
            return this.rect.x + this.rect.width;
        }

        void setElm(CircuitElm circuitElm) {
            this.elm = circuitElm;
            this.reset();
        }

        void timeStep() {
            if (this.elm == null) {
                return;
            }
            double d = this.elm.getScopeValue(this.value);
            if (d < this.minV[this.ptr]) {
                this.minV[this.ptr] = d;
            }
            if (d > this.maxV[this.ptr]) {
                this.maxV[this.ptr] = d;
            }
            double d2 = 0.0;
            if (this.value == 0) {
                d2 = this.elm.getCurrent();
                if (d2 < this.minI[this.ptr]) {
                    this.minI[this.ptr] = d2;
                }
                if (d2 > this.maxI[this.ptr]) {
                    this.maxI[this.ptr] = d2;
                }
            }
            if (this.plot2d && this.dpixels != null) {
                boolean bl = false;
                while (d > this.minMaxV || d < -this.minMaxV) {
                    this.minMaxV *= 2.0;
                    bl = true;
                }
                double d3 = d2;
                if (this.plotXY) {
                    d3 = this.yElm == null ? 0.0 : this.yElm.getVoltageDiff();
                }
                while (d3 > this.minMaxI || d3 < -this.minMaxI) {
                    this.minMaxI *= 2.0;
                    bl = true;
                }
                if (bl) {
                    this.clear2dView();
                }
                double d4 = d / this.minMaxV;
                double d5 = d3 / this.minMaxI;
                int n = (int)((double)this.rect.width * (1.0 + d4) * 0.499);
                int n2 = (int)((double)this.rect.height * (1.0 - d5) * 0.499);
                this.drawTo(n, n2);
            } else {
                ++this.ctr;
                if (this.ctr >= this.speed) {
                    this.ptr = this.ptr + 1 & this.scopePointCount - 1;
                    this.minV[this.ptr] = this.maxV[this.ptr] = d;
                    this.minI[this.ptr] = this.maxI[this.ptr] = d2;
                    this.ctr = 0;
                }
            }
        }

        void drawTo(int n, int n2) {
            if (this.draw_ox == -1) {
                this.draw_ox = n;
                this.draw_oy = n2;
            }
            if (this.draw_ox == n && this.draw_oy == n2) {
                this.dpixels[n + this.rect.width * n2] = 1.0f;
            } else if (CircuitFrame.this.abs(n2 - this.draw_oy) > CircuitFrame.this.abs(n - this.draw_ox)) {
                double d = CircuitFrame.this.sign(n2 - this.draw_oy);
                int n3 = this.draw_oy;
                while ((double)n3 != (double)n2 + d) {
                    int n4 = this.draw_ox + (n - this.draw_ox) * (n3 - this.draw_oy) / (n2 - this.draw_oy);
                    this.dpixels[n4 + this.rect.width * n3] = 1.0f;
                    n3 = (int)((double)n3 + d);
                }
            } else {
                double d = CircuitFrame.this.sign(n - this.draw_ox);
                int n5 = this.draw_ox;
                while ((double)n5 != (double)n + d) {
                    int n6 = this.draw_oy + (n2 - this.draw_oy) * (n5 - this.draw_ox) / (n - this.draw_ox);
                    this.dpixels[n5 + this.rect.width * n6] = 1.0f;
                    n5 = (int)((double)n5 + d);
                }
            }
            this.draw_ox = n;
            this.draw_oy = n2;
        }

        void clear2dView() {
            int n = 0;
            while (n != this.dpixels.length) {
                this.dpixels[n] = 0.0f;
                ++n;
            }
            this.draw_oy = -1;
            this.draw_ox = -1;
        }

        void adjustScale(double d) {
            this.minMaxV *= d;
            this.minMaxI *= d;
        }

        void draw2d(Graphics graphics) {
            int n;
            if (this.pixels == null || this.dpixels == null) {
                return;
            }
            int n2 = CircuitFrame.this.printableCheckItem.getState() ? -1 : 0;
            int n3 = 0;
            while (n3 != this.pixels.length) {
                this.pixels[n3] = n2;
                ++n3;
            }
            n3 = 0;
            while (n3 != this.rect.width) {
                this.pixels[n3 + this.rect.width * (this.rect.height / 2)] = -16711936;
                ++n3;
            }
            int n4 = this.plotXY ? -16711936 : -256;
            n3 = 0;
            while (n3 != this.rect.height) {
                this.pixels[this.rect.width / 2 + this.rect.width * n3] = n4;
                ++n3;
            }
            n3 = 0;
            while (n3 != this.pixels.length) {
                n = (int)(255.0f * this.dpixels[n3]);
                if (n > 0) {
                    this.pixels[n3] = 0xFF000000 | 65793 * n;
                }
                int n5 = n3++;
                this.dpixels[n5] = (float)((double)this.dpixels[n5] * 0.99);
            }
            graphics.drawImage(this.image, this.rect.x, this.rect.y, null);
            graphics.setColor(CircuitFrame.this.whiteColor);
            graphics.fillOval(this.rect.x + this.draw_ox - 2, this.rect.y + this.draw_oy - 2, 5, 5);
            n = this.rect.y + 10;
            int n6 = this.rect.x;
            if (this.text != null && this.rect.y + this.rect.height > n + 5) {
                graphics.drawString(this.text, n6, n);
                n += 15;
            }
        }

        void draw(Graphics graphics) {
            int n;
            double d;
            int n2;
            double d2;
            double d3;
            boolean bl;
            boolean bl2;
            int n3;
            int n4;
            block73: {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                block70: {
                    if (this.elm == null) {
                        return;
                    }
                    if (this.plot2d) {
                        this.draw2d(graphics);
                        return;
                    }
                    if (this.pixels == null) {
                        return;
                    }
                    int n12 = CircuitFrame.this.printableCheckItem.getState() ? -1 : 0;
                    n4 = 0;
                    while (n4 != this.pixels.length) {
                        this.pixels[n4] = n12;
                        ++n4;
                    }
                    n3 = 0;
                    int n13 = n11 = (this.rect.height - 1) / 2;
                    bl2 = false;
                    bl = false;
                    n10 = 4;
                    d3 = -1.0E8;
                    d2 = -1.0E8;
                    int n14 = -256;
                    int n15 = n9 = this.value > 0 ? -1 : -16711936;
                    if (CircuitFrame.this.scopeSelected == -1 && this.elm == CircuitFrame.this.mouseElm) {
                        n9 = -16711681;
                        n14 = -16711681;
                    }
                    n2 = this.ptr + this.scopePointCount - this.rect.width;
                    n4 = 0;
                    while (n4 != this.rect.width) {
                        int n16 = n4 + n2 & this.scopePointCount - 1;
                        while (this.maxV[n16] > this.minMaxV) {
                            this.minMaxV *= 2.0;
                        }
                        while (this.minV[n16] < -this.minMaxV) {
                            this.minMaxV *= 2.0;
                        }
                        while (this.maxI[n16] > this.minMaxI) {
                            this.minMaxI *= 2.0;
                        }
                        while (this.minI[n16] < -this.minMaxI) {
                            this.minMaxI *= 2.0;
                        }
                        ++n4;
                    }
                    double d4 = 1.0E-8;
                    double d5 = this.showI ? this.minMaxI : this.minMaxV;
                    while (d4 * 100.0 < d5) {
                        d4 *= 10.0;
                    }
                    if ((double)n11 * d4 / d5 < 0.3) {
                        d4 = 0.0;
                    }
                    boolean bl3 = (double)n11 * d4 / d5 > 3.0;
                    int n17 = -100;
                    while (n17 <= 100) {
                        block68: {
                            block69: {
                                int n18;
                                if (n17 != 0 && (this.showI && this.showV || d4 == 0.0) || (n18 = n11 - (int)((double)(n11 * n17) * d4 / d5)) < 0 || n18 >= this.rect.height - 1) break block68;
                                int n19 = n12 = n17 == 0 ? -7303024 : -12566464;
                                if (n17 % 10 == 0) break block69;
                                n12 = -15724528;
                                if (!bl3) break block68;
                            }
                            n4 = 0;
                            while (n4 != this.rect.width) {
                                this.pixels[n4 + n18 * this.rect.width] = n12;
                                ++n4;
                            }
                        }
                        ++n17;
                    }
                    d4 = 1.0E-15;
                    double d6 = CircuitFrame.this.timeStep * (double)this.speed;
                    while (d4 < d6 * 5.0) {
                        d4 *= 10.0;
                    }
                    double d7 = CircuitFrame.this.t - CircuitFrame.this.timeStep * (double)this.speed * (double)this.rect.width;
                    double d8 = CircuitFrame.this.t - CircuitFrame.this.t % d4;
                    boolean bl4 = true;
                    n17 = 0;
                    while ((n8 = (int)(((d = d8 - d4 * (double)n17) - d7) / d6)) >= 0) {
                        if (n8 < this.rect.width && !(d < 0.0)) {
                            n12 = -14671840;
                            bl4 = false;
                            if ((d + d4 / 4.0) % (d4 * 10.0) < d4) {
                                n12 = -7303024;
                                if ((d + d4 / 4.0) % (d4 * 100.0) < d4) {
                                    n12 = -12566320;
                                }
                            }
                            n4 = 0;
                            while (n4 < this.pixels.length) {
                                this.pixels[n4 + n8] = n12;
                                n4 += this.rect.width;
                            }
                        }
                        ++n17;
                    }
                    if (this.value != 0 || !this.showI) break block70;
                    int n20 = -1;
                    n7 = -1;
                    n4 = 0;
                    while (n4 != this.rect.width) {
                        block71: {
                            block72: {
                                n6 = n4 + n2 & this.scopePointCount - 1;
                                n = (int)((double)n11 / this.minMaxI * this.minI[n6]);
                                n5 = (int)((double)n11 / this.minMaxI * this.maxI[n6]);
                                if (this.maxI[n6] > d2) {
                                    d2 = this.maxI[n6];
                                }
                                if (n > n11) break block71;
                                if (n < -n10 || n5 > n10) {
                                    bl2 = true;
                                }
                                if (n20 == -1) break block72;
                                if (n == n7 && n5 == n7) break block71;
                                n8 = n20;
                                while (n8 != n3 + n4) {
                                    this.pixels[n8 + this.rect.width * (n13 - n7)] = n14;
                                    ++n8;
                                }
                                n7 = -1;
                                n20 = -1;
                            }
                            if (n == n5) {
                                n20 = n3 + n4;
                                n7 = n;
                            } else {
                                n8 = n;
                                while (n8 <= n5) {
                                    this.pixels[n3 + n4 + this.rect.width * (n13 - n8)] = n14;
                                    ++n8;
                                }
                            }
                        }
                        ++n4;
                    }
                    if (n20 != -1) {
                        n8 = n20;
                        while (n8 != n3 + n4) {
                            this.pixels[n8 + this.rect.width * (n13 - n7)] = n14;
                            ++n8;
                        }
                    }
                }
                if (this.value == 0 && !this.showV) break block73;
                int n21 = -1;
                n7 = -1;
                n4 = 0;
                while (n4 != this.rect.width) {
                    block74: {
                        block75: {
                            n6 = n4 + n2 & this.scopePointCount - 1;
                            n = (int)((double)n11 / this.minMaxV * this.minV[n6]);
                            n5 = (int)((double)n11 / this.minMaxV * this.maxV[n6]);
                            if (this.maxV[n6] > d3) {
                                d3 = this.maxV[n6];
                            }
                            if (this.value == 0 && !this.showV || n > n11) break block74;
                            if (n < -n10 || n5 > n10) {
                                bl = true;
                            }
                            if (n21 == -1) break block75;
                            if (n == n7 && n5 == n7) break block74;
                            n8 = n21;
                            while (n8 != n3 + n4) {
                                this.pixels[n8 + this.rect.width * (n13 - n7)] = n9;
                                ++n8;
                            }
                            n7 = -1;
                            n21 = -1;
                        }
                        if (n == n5) {
                            n21 = n3 + n4;
                            n7 = n;
                        } else {
                            n8 = n;
                            while (n8 <= n5) {
                                this.pixels[n3 + n4 + this.rect.width * (n13 - n8)] = n9;
                                ++n8;
                            }
                        }
                    }
                    ++n4;
                }
                if (n21 != -1) {
                    n8 = n21;
                    while (n8 != n3 + n4) {
                        this.pixels[n8 + this.rect.width * (n13 - n7)] = n9;
                        ++n8;
                    }
                }
            }
            d = 0.0;
            if (this.showFreq) {
                double d9 = 0.0;
                n4 = 0;
                while (n4 != this.rect.width) {
                    n = n4 + n2 & this.scopePointCount - 1;
                    d9 += this.minV[n] + this.maxV[n];
                    ++n4;
                }
                n = 0;
                double d10 = (d9 /= (double)(n4 * 2)) * 0.05;
                int n22 = 0;
                double d11 = 0.0;
                int n23 = -1;
                double d12 = 0.0;
                n4 = 0;
                while (n4 != this.rect.width) {
                    int n24 = n4 + n2 & this.scopePointCount - 1;
                    double d13 = this.maxV[n24] - d9;
                    int n25 = n;
                    if (d13 < d10) {
                        n = 1;
                    } else if (d13 > -d10) {
                        n = 2;
                    }
                    if (n == 2 && n25 == 1) {
                        int n26 = n4 - n22;
                        n22 = n4;
                        if (n26 >= 12) {
                            if (n23 >= 0) {
                                d11 += (double)n26;
                                d12 += (double)(n26 * n26);
                            }
                            ++n23;
                        }
                    }
                    ++n4;
                }
                double d14 = Math.sqrt((d12 /= (double)n23) - (d11 /= (double)n23) * d11);
                d = 1.0 / (d11 * CircuitFrame.this.timeStep * (double)this.speed);
                if (n23 < 1 || d14 > 2.0) {
                    d = 0.0;
                }
            }
            graphics.drawImage(this.image, this.rect.x, this.rect.y, null);
            graphics.setColor(CircuitFrame.this.whiteColor);
            int n27 = this.rect.y + 10;
            n3 += this.rect.x;
            if (this.showMax) {
                if (this.value != 0) {
                    graphics.drawString(CircuitFrame.this.getUnitText(d3, this.elm.getScopeUnits(this.value)), n3, n27);
                } else if (this.showV) {
                    graphics.drawString(CircuitFrame.this.getVoltageText(d3), n3, n27);
                } else if (this.showI) {
                    graphics.drawString(CircuitFrame.this.getCurrentText(d2), n3, n27);
                }
                n27 += 15;
            }
            if (this.text != null && this.rect.y + this.rect.height > n27 + 5) {
                graphics.drawString(this.text, n3, n27);
                n27 += 15;
            }
            if (this.showFreq && d != 0.0 && this.rect.y + this.rect.height > n27 + 5) {
                graphics.drawString(CircuitFrame.this.getUnitText(d, "Hz"), n3, n27);
            }
            if (this.ptr > 5 && !this.lockScale) {
                if (!bl2 && this.minMaxI > 1.0E-4) {
                    this.minMaxI /= 2.0;
                }
                if (!bl && this.minMaxV > 1.0E-4) {
                    this.minMaxV /= 2.0;
                }
            }
        }

        void speedUp() {
            if (this.speed > 1) {
                this.speed /= 2;
                this.resetGraph();
            }
        }

        void slowDown() {
            this.speed *= 2;
            this.resetGraph();
        }

        PopupMenu getMenu() {
            if (this.elm == null) {
                return null;
            }
            if (this.elm instanceof TransistorElm) {
                CircuitFrame.this.scopeIbMenuItem.setState(this.value == 1);
                CircuitFrame.this.scopeIcMenuItem.setState(this.value == 2);
                CircuitFrame.this.scopeIeMenuItem.setState(this.value == 3);
                CircuitFrame.this.scopeVbeMenuItem.setState(this.value == 4);
                CircuitFrame.this.scopeVbcMenuItem.setState(this.value == 5);
                CircuitFrame.this.scopeVceMenuItem.setState(this.value == 6);
                return CircuitFrame.this.transScopeMenu;
            }
            CircuitFrame.this.scopeVMenuItem.setState(this.showV && this.value == 0);
            CircuitFrame.this.scopeIMenuItem.setState(this.showI && this.value == 0);
            CircuitFrame.this.scopeMaxMenuItem.setState(this.showMax);
            CircuitFrame.this.scopeFreqMenuItem.setState(this.showFreq);
            CircuitFrame.this.scopePowerMenuItem.setState(this.value == 1);
            CircuitFrame.this.scopeVIMenuItem.setState(this.plot2d && !this.plotXY);
            CircuitFrame.this.scopeXYMenuItem.setState(this.plotXY);
            CircuitFrame.this.scopeSelectYMenuItem.setEnabled(this.plotXY);
            CircuitFrame.this.scopeResistMenuItem.setState(this.value == 2);
            CircuitFrame.this.scopeResistMenuItem.setEnabled(this.elm instanceof MemristorElm);
            return CircuitFrame.this.scopeMenu;
        }

        void setValue(int n) {
            this.reset();
            this.value = n;
        }

        String dump() {
            if (this.elm == null) {
                return null;
            }
            int n = (this.showI ? 1 : 0) | (this.showV ? 2 : 0) | (this.showMax ? 0 : 4) | (this.showFreq ? 8 : 0) | (this.lockScale ? 16 : 0) | (this.plot2d ? 64 : 0) | (this.plotXY ? 128 : 0);
            n |= 0x20;
            int n2 = CircuitFrame.this.locateElm(this.elm);
            if (n2 < 0) {
                return null;
            }
            int n3 = this.yElm == null ? -1 : CircuitFrame.this.locateElm(this.yElm);
            String string = "o " + n2 + " " + this.speed + " " + this.value + " " + n + " " + this.minMaxV + " " + this.minMaxI + " " + this.position + " " + n3;
            if (this.text != null) {
                string = string + " " + this.text;
            }
            return string;
        }

        void undump(StringTokenizer stringTokenizer) {
            this.reset();
            int n = new Integer(stringTokenizer.nextToken());
            if (n == -1) {
                return;
            }
            this.elm = CircuitFrame.this.getElm(n);
            this.speed = new Integer(stringTokenizer.nextToken());
            this.value = new Integer(stringTokenizer.nextToken());
            int n2 = new Integer(stringTokenizer.nextToken());
            this.minMaxV = new Double(stringTokenizer.nextToken());
            this.minMaxI = new Double(stringTokenizer.nextToken());
            if (this.minMaxV == 0.0) {
                this.minMaxV = 0.5;
            }
            if (this.minMaxI == 0.0) {
                this.minMaxI = 1.0;
            }
            this.text = null;
            this.yElm = null;
            try {
                this.position = new Integer(stringTokenizer.nextToken());
                int n3 = -1;
                if ((n2 & 0x20) != 0 && (n3 = new Integer(stringTokenizer.nextToken()).intValue()) != -1) {
                    this.yElm = CircuitFrame.this.getElm(n3);
                }
                while (stringTokenizer.hasMoreTokens()) {
                    this.text = this.text == null ? stringTokenizer.nextToken() : this.text + " " + stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.showI = (n2 & 1) != 0;
            this.showV = (n2 & 2) != 0;
            this.showMax = (n2 & 4) == 0;
            this.showFreq = (n2 & 8) != 0;
            this.lockScale = (n2 & 0x10) != 0;
            this.plot2d = (n2 & 0x40) != 0;
            this.plotXY = (n2 & 0x80) != 0;
        }

        void allocImage() {
            this.pixels = null;
            int n = this.rect.width;
            int n2 = this.rect.height;
            if (n == 0 || n2 == 0) {
                return;
            }
            if (CircuitFrame.this.useBufferedImage) {
                try {
                    Class<?> clazz = Class.forName("java.awt.image.BufferedImage");
                    Class<?> clazz2 = Class.forName("java.awt.image.DataBufferInt");
                    Class<?> clazz3 = Class.forName("java.awt.image.Raster");
                    Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    this.image = (Image)constructor.newInstance(new Integer(n), new Integer(n2), new Integer(1));
                    Method method = clazz.getMethod("getRaster", null);
                    Object object = method.invoke((Object)this.image, null);
                    Object object2 = clazz3.getMethod("getDataBuffer", null).invoke(object, null);
                    this.pixels = (int[])clazz2.getMethod("getData", null).invoke(object2, null);
                }
                catch (Exception exception) {
                    System.out.println("BufferedImage failed");
                }
            }
            if (this.pixels == null) {
                this.pixels = new int[n * n2];
                int n3 = 0;
                while (n3 != n * n2) {
                    this.pixels[n3] = -16777216;
                    ++n3;
                }
                this.imageSource = new MemoryImageSource(n, n2, this.pixels, 0, n);
                this.imageSource.setAnimated(true);
                this.imageSource.setFullBufferUpdates(true);
                this.image = CircuitFrame.this.cv.createImage(this.imageSource);
            }
            this.dpixels = new float[n * n2];
            this.draw_oy = -1;
            this.draw_ox = -1;
        }

        void handleMenu(ItemEvent itemEvent, Object object) {
            if (object == CircuitFrame.this.scopeVMenuItem) {
                this.showVoltage(CircuitFrame.this.scopeVMenuItem.getState());
            }
            if (object == CircuitFrame.this.scopeIMenuItem) {
                this.showCurrent(CircuitFrame.this.scopeIMenuItem.getState());
            }
            if (object == CircuitFrame.this.scopeMaxMenuItem) {
                this.showMax(CircuitFrame.this.scopeMaxMenuItem.getState());
            }
            if (object == CircuitFrame.this.scopeFreqMenuItem) {
                this.showFreq(CircuitFrame.this.scopeFreqMenuItem.getState());
            }
            if (object == CircuitFrame.this.scopePowerMenuItem) {
                this.setValue(1);
            }
            if (object == CircuitFrame.this.scopeIbMenuItem) {
                this.setValue(1);
            }
            if (object == CircuitFrame.this.scopeIcMenuItem) {
                this.setValue(2);
            }
            if (object == CircuitFrame.this.scopeIeMenuItem) {
                this.setValue(3);
            }
            if (object == CircuitFrame.this.scopeVbeMenuItem) {
                this.setValue(4);
            }
            if (object == CircuitFrame.this.scopeVbcMenuItem) {
                this.setValue(5);
            }
            if (object == CircuitFrame.this.scopeVceMenuItem) {
                this.setValue(6);
            }
            if (object == CircuitFrame.this.scopeVIMenuItem) {
                this.plot2d = CircuitFrame.this.scopeVIMenuItem.getState();
                this.plotXY = false;
                this.resetGraph();
            }
            if (object == CircuitFrame.this.scopeXYMenuItem) {
                this.plotXY = this.plot2d = CircuitFrame.this.scopeXYMenuItem.getState();
                if (this.yElm == null) {
                    this.selectY();
                }
                this.resetGraph();
            }
            if (object == CircuitFrame.this.scopeResistMenuItem) {
                this.setValue(2);
            }
        }

        void select() {
            CircuitFrame.this.mouseElm = this.elm;
            if (this.plotXY) {
                CircuitFrame.this.plotXElm = this.elm;
                CircuitFrame.this.plotYElm = this.yElm;
            }
        }

        void selectY() {
            int n;
            int n2 = n = this.yElm == null ? -1 : CircuitFrame.this.locateElm(this.yElm);
            while (true) {
                ++n;
                while (n < CircuitFrame.this.elmList.size()) {
                    CircuitElm circuitElm = CircuitFrame.this.getElm(n);
                    if ((circuitElm instanceof OutputElm || circuitElm instanceof ProbeElm) && circuitElm != this.elm) {
                        this.yElm = circuitElm;
                        return;
                    }
                    ++n;
                }
                if (n2 == -1) {
                    return;
                }
                n2 = -1;
                n = -1;
            }
        }
    }

    class TransistorElm
    extends CircuitElm {
        int pnp;
        double beta;
        double fgain;
        final int FLAG_FLIP = 1;
        double ic;
        double ie;
        double ib;
        double curcount_c;
        double curcount_e;
        double curcount_b;
        Polygon rectPoly;
        Polygon arrowPoly;
        Point[] rect;
        Point[] coll;
        Point[] emit;
        Point base;
        static final double leakage = 1.0E-13;
        static final double vt = 0.025;
        static final double vdcoef = 40.0;
        static final double rgain = 0.5;
        double vcrit;
        double lastvbc;
        double lastvbe;

        TransistorElm(int n, int n2, boolean bl) {
            super(n, n2);
            this.pnp = bl ? -1 : 1;
            this.beta = 100.0;
            this.setup();
        }

        public TransistorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.pnp = new Integer(stringTokenizer.nextToken());
            this.beta = 100.0;
            try {
                this.lastvbe = new Double(stringTokenizer.nextToken());
                this.lastvbc = new Double(stringTokenizer.nextToken());
                this.volts[0] = 0.0;
                this.volts[1] = -this.lastvbe;
                this.volts[2] = -this.lastvbc;
                this.beta = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setup();
        }

        void setup() {
            this.vcrit = 0.025 * Math.log(0.025 / (Math.sqrt(2.0) * 1.0E-13));
            this.fgain = this.beta / (this.beta + 1.0);
            this.noDiagonal = true;
        }

        boolean nonLinear() {
            return true;
        }

        void reset() {
            this.volts[2] = 0.0;
            this.volts[1] = 0.0;
            this.volts[0] = 0.0;
            this.curcount = 0.0;
            this.lastvbe = 0.0;
            this.lastvbc = 0.0;
        }

        int getDumpType() {
            return 116;
        }

        String dump() {
            return super.dump() + " " + this.pnp + " " + (this.volts[0] - this.volts[1]) + " " + (this.volts[0] - this.volts[2]) + " " + this.beta;
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 16.0);
            this.setPowerColor(graphics, true);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.coll[0], this.coll[1]);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.emit[0], this.emit[1]);
            graphics.setColor(CircuitFrame.this.lightGrayColor);
            graphics.fillPolygon(this.arrowPoly);
            this.setVoltageColor(graphics, this.volts[0]);
            if (CircuitFrame.this.powerCheckItem.getState()) {
                graphics.setColor(Color.gray);
            }
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.base);
            this.curcount_b = this.updateDotCount(-this.ib, this.curcount_b);
            this.drawDots(graphics, this.base, this.point1, this.curcount_b);
            this.curcount_c = this.updateDotCount(-this.ic, this.curcount_c);
            this.drawDots(graphics, this.coll[1], this.coll[0], this.curcount_c);
            this.curcount_e = this.updateDotCount(-this.ie, this.curcount_e);
            this.drawDots(graphics, this.emit[1], this.emit[0], this.curcount_e);
            this.setVoltageColor(graphics, this.volts[0]);
            this.setPowerColor(graphics, true);
            graphics.fillPolygon(this.rectPoly);
            if ((CircuitFrame.this.mouseElm == this || CircuitFrame.this.dragElm == this) && this.dy == 0) {
                graphics.setColor(Color.white);
                graphics.setFont(CircuitFrame.this.unitsFont);
                int n = CircuitFrame.this.sign(this.dx);
                graphics.drawString("B", this.base.x - 10 * n, this.base.y - 5);
                graphics.drawString("C", this.coll[0].x - 3 + 9 * n, this.coll[0].y + 4);
                graphics.drawString("E", this.emit[0].x - 3 + 9 * n, this.emit[0].y + 4);
            }
            this.drawPosts(graphics);
        }

        Point getPost(int n) {
            return n == 0 ? this.point1 : (n == 1 ? this.coll[0] : this.emit[0]);
        }

        int getPostCount() {
            return 3;
        }

        double getPower() {
            return (this.volts[0] - this.volts[2]) * this.ib + (this.volts[1] - this.volts[2]) * this.ic;
        }

        void setPoints() {
            super.setPoints();
            int n = 16;
            if ((this.flags & 1) != 0) {
                this.dsign = -this.dsign;
            }
            int n2 = n * this.dsign * this.pnp;
            this.coll = this.newPointArray(2);
            this.emit = this.newPointArray(2);
            this.interpPoint2(this.point1, this.point2, this.coll[0], this.emit[0], 1.0, n2);
            this.rect = this.newPointArray(4);
            this.interpPoint2(this.point1, this.point2, this.rect[0], this.rect[1], 1.0 - 16.0 / this.dn, n);
            this.interpPoint2(this.point1, this.point2, this.rect[2], this.rect[3], 1.0 - 13.0 / this.dn, n);
            this.interpPoint2(this.point1, this.point2, this.coll[1], this.emit[1], 1.0 - 13.0 / this.dn, 6 * this.dsign * this.pnp);
            this.base = new Point();
            this.interpPoint(this.point1, this.point2, this.base, 1.0 - 16.0 / this.dn);
            this.rectPoly = this.createPolygon(this.rect[0], this.rect[2], this.rect[3], this.rect[1]);
            if (this.pnp == 1) {
                this.arrowPoly = this.calcArrow(this.emit[1], this.emit[0], 8.0, 4.0);
            } else {
                Point point = this.interpPoint(this.point1, this.point2, 1.0 - 11.0 / this.dn, (double)(-5 * this.dsign * this.pnp));
                this.arrowPoly = this.calcArrow(this.emit[0], point, 8.0, 4.0);
            }
        }

        double limitStep(double d, double d2) {
            double d3 = d;
            if (d > this.vcrit && Math.abs(d - d2) > 0.05) {
                double d4;
                d = d2 > 0.0 ? ((d4 = 1.0 + (d - d2) / 0.025) > 0.0 ? d2 + 0.025 * Math.log(d4) : this.vcrit) : 0.025 * Math.log(d / 0.025);
                CircuitFrame.this.converged = false;
            }
            return d;
        }

        void stamp() {
            CircuitFrame.this.stampNonLinear(this.nodes[0]);
            CircuitFrame.this.stampNonLinear(this.nodes[1]);
            CircuitFrame.this.stampNonLinear(this.nodes[2]);
        }

        void doStep() {
            double d = this.volts[0] - this.volts[1];
            double d2 = this.volts[0] - this.volts[2];
            if (Math.abs(d - this.lastvbc) > 0.01 || Math.abs(d2 - this.lastvbe) > 0.01) {
                CircuitFrame.this.converged = false;
            }
            d = (double)this.pnp * this.limitStep((double)this.pnp * d, (double)this.pnp * this.lastvbc);
            d2 = (double)this.pnp * this.limitStep((double)this.pnp * d2, (double)this.pnp * this.lastvbe);
            this.lastvbc = d;
            this.lastvbe = d2;
            double d3 = 40.0 * (double)this.pnp;
            double d4 = Math.exp(d * d3);
            double d5 = Math.exp(d2 * d3);
            if (d5 < 1.0) {
                d5 = 1.0;
            }
            this.ie = (double)this.pnp * 1.0E-13 * (-(d5 - 1.0) + 0.5 * (d4 - 1.0));
            this.ic = (double)this.pnp * 1.0E-13 * (this.fgain * (d5 - 1.0) - (d4 - 1.0));
            this.ib = -(this.ie + this.ic);
            double d6 = -4.0E-12 * d5;
            double d7 = 2.0E-12 * d4;
            double d8 = -d6 * this.fgain;
            double d9 = -d7 * 2.0;
            CircuitFrame.this.stampMatrix(this.nodes[0], this.nodes[0], -d6 - d7 - d8 - d9);
            CircuitFrame.this.stampMatrix(this.nodes[0], this.nodes[1], d7 + d9);
            CircuitFrame.this.stampMatrix(this.nodes[0], this.nodes[2], d6 + d8);
            CircuitFrame.this.stampMatrix(this.nodes[1], this.nodes[0], d8 + d9);
            CircuitFrame.this.stampMatrix(this.nodes[1], this.nodes[1], -d9);
            CircuitFrame.this.stampMatrix(this.nodes[1], this.nodes[2], -d8);
            CircuitFrame.this.stampMatrix(this.nodes[2], this.nodes[0], d6 + d7);
            CircuitFrame.this.stampMatrix(this.nodes[2], this.nodes[1], -d7);
            CircuitFrame.this.stampMatrix(this.nodes[2], this.nodes[2], -d6);
            CircuitFrame.this.stampRightSide(this.nodes[0], -this.ib - (d7 + d9) * d - (d6 + d8) * d2);
            CircuitFrame.this.stampRightSide(this.nodes[1], -this.ic + d8 * d2 + d9 * d);
            CircuitFrame.this.stampRightSide(this.nodes[2], -this.ie + d6 * d2 + d7 * d);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "transistor (" + (this.pnp == -1 ? "PNP)" : "NPN)") + " beta=" + CircuitFrame.this.showFormat.format(this.beta);
            double d = this.volts[0] - this.volts[1];
            double d2 = this.volts[0] - this.volts[2];
            double d3 = this.volts[1] - this.volts[2];
            stringArray[1] = d * (double)this.pnp > 0.2 ? (d2 * (double)this.pnp > 0.2 ? "saturation" : "reverse active") : (d2 * (double)this.pnp > 0.2 ? "fwd active" : "cutoff");
            stringArray[2] = "Ic = " + CircuitFrame.this.getCurrentText(this.ic);
            stringArray[3] = "Ib = " + CircuitFrame.this.getCurrentText(this.ib);
            stringArray[4] = "Vbe = " + CircuitFrame.this.getVoltageText(d2);
            stringArray[5] = "Vbc = " + CircuitFrame.this.getVoltageText(d);
            stringArray[6] = "Vce = " + CircuitFrame.this.getVoltageText(d3);
        }

        double getScopeValue(int n) {
            switch (n) {
                case 1: {
                    return this.ib;
                }
                case 2: {
                    return this.ic;
                }
                case 3: {
                    return this.ie;
                }
                case 4: {
                    return this.volts[0] - this.volts[2];
                }
                case 5: {
                    return this.volts[0] - this.volts[1];
                }
                case 6: {
                    return this.volts[1] - this.volts[2];
                }
            }
            return 0.0;
        }

        String getScopeUnits(int n) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    return "A";
                }
            }
            return "V";
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Beta/hFE", this.beta, 10.0, 1000.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.beta = editInfo.value;
            this.setup();
        }

        boolean canViewInScope() {
            return true;
        }
    }

    class PTransistorElm
    extends TransistorElm {
        static /* synthetic */ Class class$CircuitFrame$TransistorElm;

        public PTransistorElm(int n, int n2) {
            super(n, n2, true);
        }

        Class getDumpClass() {
            return class$CircuitFrame$TransistorElm == null ? (class$CircuitFrame$TransistorElm = PTransistorElm.class$("CircuitFrame$TransistorElm")) : class$CircuitFrame$TransistorElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class NTransistorElm
    extends TransistorElm {
        static /* synthetic */ Class class$CircuitFrame$TransistorElm;

        public NTransistorElm(int n, int n2) {
            super(n, n2, false);
        }

        Class getDumpClass() {
            return class$CircuitFrame$TransistorElm == null ? (class$CircuitFrame$TransistorElm = NTransistorElm.class$("CircuitFrame$TransistorElm")) : class$CircuitFrame$TransistorElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class LEDElm
    extends DiodeElm {
        double colorR;
        double colorG;
        double colorB;
        Point ledLead1;
        Point ledLead2;
        Point ledCenter;

        public LEDElm(int n, int n2) {
            super(n, n2);
            this.fwdrop = 2.1024259;
            this.setup();
            this.colorR = 1.0;
            this.colorB = 0.0;
            this.colorG = 0.0;
        }

        public LEDElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            if ((n5 & 1) == 0) {
                this.fwdrop = 2.1024259;
            }
            this.setup();
            this.colorR = new Double(stringTokenizer.nextToken());
            this.colorG = new Double(stringTokenizer.nextToken());
            this.colorB = new Double(stringTokenizer.nextToken());
        }

        int getDumpType() {
            return 162;
        }

        String dump() {
            return super.dump() + " " + this.colorR + " " + this.colorG + " " + this.colorB;
        }

        void setPoints() {
            super.setPoints();
            int n = 12;
            this.ledLead1 = this.interpPoint(this.point1, this.point2, 0.5 - (double)n / this.dn);
            this.ledLead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)n / this.dn);
            this.ledCenter = this.interpPoint(this.point1, this.point2, 0.5);
        }

        void draw(Graphics graphics) {
            if (this == CircuitFrame.this.mouseElm || this == CircuitFrame.this.dragElm) {
                super.draw(graphics);
                return;
            }
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.ledLead1);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.ledLead2, this.point2);
            graphics.setColor(Color.gray);
            int n = 12;
            CircuitFrame.this.drawThickCircle(graphics, this.ledCenter.x, this.ledCenter.y, n);
            n -= 4;
            double d = 255.0 * this.current / 0.01;
            if (d > 255.0) {
                d = 255.0;
            }
            Color color = new Color((int)(this.colorR * d), (int)(this.colorG * d), (int)(this.colorB * d));
            graphics.setColor(color);
            graphics.fillOval(this.ledCenter.x - n, this.ledCenter.y - n, n * 2, n * 2);
            this.setBbox(this.point1, this.point2, n);
            this.updateDotCount();
            this.drawDots(graphics, this.point1, this.ledLead1, this.curcount);
            this.drawDots(graphics, this.point2, this.ledLead2, -this.curcount);
            this.drawPosts(graphics);
        }

        void getInfo(String[] stringArray) {
            super.getInfo(stringArray);
            stringArray[0] = "LED";
        }
    }

    class ZenerElm
    extends DiodeElm {
        final int hs = 8;
        Polygon poly;
        Point[] cathode;
        Point[] wing;
        double zvoltage;
        double zoffset;
        final double default_zvoltage = 5.6;
        boolean my_debug = false;

        public ZenerElm(int n, int n2) {
            super(n, n2);
            this.zvoltage = 5.6;
            this.setup();
        }

        public ZenerElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.zvoltage = new Double(stringTokenizer.nextToken());
            this.setup();
        }

        void setup() {
            super.setup();
            this.leakage = 5.0E-6;
            double d = -0.005;
            this.zoffset = this.zvoltage - Math.log(-(1.0 + d / this.leakage)) / this.vdcoef;
        }

        int getDumpType() {
            return 122;
        }

        String dump() {
            return super.dump() + " " + this.zvoltage;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(16);
            this.cathode = this.newPointArray(2);
            this.wing = this.newPointArray(2);
            Point[] pointArray = this.newPointArray(2);
            this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, 8.0);
            this.interpPoint2(this.lead1, this.lead2, this.cathode[0], this.cathode[1], 1.0, 8.0);
            this.interpPoint(this.cathode[0], this.cathode[1], this.wing[0], -0.2, -8.0);
            this.interpPoint(this.cathode[1], this.cathode[0], this.wing[1], -0.2, -8.0);
            this.poly = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 8.0);
            double d = this.volts[0];
            double d2 = this.volts[1];
            this.draw2Leads(graphics);
            this.setPowerColor(graphics, true);
            this.setVoltageColor(graphics, d);
            graphics.fillPolygon(this.poly);
            this.setVoltageColor(graphics, d2);
            CircuitFrame.this.drawThickLine(graphics, this.cathode[0], this.cathode[1]);
            CircuitFrame.this.drawThickLine(graphics, this.wing[0], this.cathode[0]);
            CircuitFrame.this.drawThickLine(graphics, this.wing[1], this.cathode[1]);
            this.doDots(graphics);
            this.drawPosts(graphics);
        }

        double limitStep(double d, double d2) {
            double d3 = d;
            if (d >= 0.0) {
                if (d > this.vcrit && Math.abs(d - d2) > this.vt + this.vt) {
                    if (d2 > 0.0) {
                        double d4 = 1.0 + (d - d2) / this.vt;
                        if (d4 > 0.0) {
                            d = d2 + this.vt * Math.log(d4);
                            double d5 = Math.log(1.0E-6 / this.leakage) * this.vt;
                            d = Math.max(d5, d);
                        } else {
                            d = this.vcrit;
                        }
                    } else {
                        d = this.vt * Math.log(d / this.vt);
                    }
                    CircuitFrame.this.converged = false;
                }
                return d;
            }
            if (this.my_debug) {
                System.out.println(d + " " + d2);
            }
            d = -d - this.zoffset;
            d2 = -d2 - this.zoffset;
            if (d > this.vcrit && Math.abs(d - d2) > this.vt + this.vt) {
                if (d2 > 0.0) {
                    double d6 = 1.0 + (d - d2) / this.vt;
                    if (d6 > 0.0) {
                        d = d2 + this.vt * Math.log(d6);
                        double d7 = Math.log(1.0E-6 / this.leakage) * this.vt;
                        d = Math.max(d7, d);
                    } else {
                        d = this.vcrit;
                    }
                } else {
                    d = this.vt * Math.log(d / this.vt);
                }
                CircuitFrame.this.converged = false;
            }
            d = -(d + this.zoffset);
            return d;
        }

        void doStep() {
            double d = this.volts[0] - this.volts[1];
            if (this.my_debug) {
                System.out.println("Voltdiff: " + this.volts[0] + " - " + this.volts[1] + " = " + d);
            }
            if (Math.abs(d - this.lastvoltdiff) > 0.01) {
                CircuitFrame.this.converged = false;
            }
            this.lastvoltdiff = d = this.limitStep(d, this.lastvoltdiff);
            if (d >= 0.0) {
                double d2 = Math.exp(d * this.vdcoef);
                double d3 = this.vdcoef * this.leakage * d2;
                double d4 = (d2 - 1.0) * this.leakage + d3 * -d;
                CircuitFrame.this.stampConductance(this.nodes[0], this.nodes[1], d3);
                CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[1], d4);
            } else {
                double d5 = this.leakage * this.vdcoef * (Math.exp(d * this.vdcoef) + Math.exp((-d - this.zoffset) * this.vdcoef));
                double d6 = this.leakage * (Math.exp(d * this.vdcoef) - Math.exp((-d - this.zoffset) * this.vdcoef) - 1.0) + d5 * -d;
                CircuitFrame.this.stampConductance(this.nodes[0], this.nodes[1], d5);
                CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[1], d6);
            }
        }

        void calculateCurrent() {
            double d = this.volts[0] - this.volts[1];
            this.current = d >= 0.0 ? this.leakage * (Math.exp(d * this.vdcoef) - 1.0) : this.leakage * (Math.exp(d * this.vdcoef) - Math.exp((-d - this.zoffset) * this.vdcoef) - 1.0);
        }

        void getInfo(String[] stringArray) {
            super.getInfo(stringArray);
            stringArray[0] = "Zener diode";
            stringArray[5] = "Vz = " + CircuitFrame.this.getVoltageText(this.zvoltage);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Fwd Voltage @ 1A", this.fwdrop, 10.0, 1000.0);
            }
            if (n == 1) {
                return new EditInfo("Zener Voltage @ 5mA", this.zvoltage, 1.0, 25.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.fwdrop = editInfo.value;
            }
            if (n == 1) {
                this.zvoltage = editInfo.value;
            }
            this.setup();
        }
    }

    class DiodeElm
    extends CircuitElm {
        static final int FLAG_FWDROP = 1;
        final int hs = 8;
        Polygon poly;
        Point[] cathode;
        double leakage = 1.0E-14;
        final double defaultdrop = 0.805904783;
        double vt;
        double vdcoef;
        double fwdrop = 0.805904783;
        double lastvoltdiff;
        double vcrit;

        public DiodeElm(int n, int n2) {
            super(n, n2);
            this.setup();
        }

        public DiodeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            if ((n5 & 1) > 0) {
                try {
                    this.fwdrop = new Double(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setup();
        }

        boolean nonLinear() {
            return true;
        }

        void setup() {
            this.vdcoef = Math.log(1.0 / this.leakage + 1.0) / this.fwdrop;
            this.vt = 1.0 / this.vdcoef;
            this.vcrit = this.vt * Math.log(this.vt / (Math.sqrt(2.0) * this.leakage));
        }

        int getDumpType() {
            return 100;
        }

        String dump() {
            this.flags |= 1;
            return super.dump() + " " + this.fwdrop;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(16);
            this.cathode = this.newPointArray(2);
            Point[] pointArray = this.newPointArray(2);
            this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, 8.0);
            this.interpPoint2(this.lead1, this.lead2, this.cathode[0], this.cathode[1], 1.0, 8.0);
            this.poly = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
        }

        void draw(Graphics graphics) {
            this.drawDiode(graphics);
            this.doDots(graphics);
            this.drawPosts(graphics);
        }

        void reset() {
            this.curcount = 0.0;
            this.volts[1] = 0.0;
            this.volts[0] = 0.0;
            this.lastvoltdiff = 0.0;
        }

        void drawDiode(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 8.0);
            double d = this.volts[0];
            double d2 = this.volts[1];
            this.draw2Leads(graphics);
            this.setPowerColor(graphics, true);
            this.setVoltageColor(graphics, d);
            graphics.fillPolygon(this.poly);
            this.setVoltageColor(graphics, d2);
            CircuitFrame.this.drawThickLine(graphics, this.cathode[0], this.cathode[1]);
        }

        double limitStep(double d, double d2) {
            double d3 = d;
            if (d > this.vcrit && Math.abs(d - d2) > this.vt + this.vt) {
                if (d2 > 0.0) {
                    double d4 = 1.0 + (d - d2) / this.vt;
                    if (d4 > 0.0) {
                        d = d2 + this.vt * Math.log(d4);
                        double d5 = Math.log(1.0E-6 / this.leakage) * this.vt;
                        d = Math.max(d5, d);
                    } else {
                        d = this.vcrit;
                    }
                } else {
                    d = this.vt * Math.log(d / this.vt);
                }
                CircuitFrame.this.converged = false;
            }
            return d;
        }

        void stamp() {
            CircuitFrame.this.stampNonLinear(this.nodes[0]);
            CircuitFrame.this.stampNonLinear(this.nodes[1]);
        }

        void doStep() {
            double d = this.volts[0] - this.volts[1];
            if (Math.abs(d - this.lastvoltdiff) > 0.01) {
                CircuitFrame.this.converged = false;
            }
            this.lastvoltdiff = d = this.limitStep(d, this.lastvoltdiff);
            double d2 = Math.exp(d * this.vdcoef);
            if (d < 0.0) {
                d2 = 1.0;
            }
            double d3 = this.vdcoef * this.leakage * d2;
            double d4 = (d2 - 1.0) * this.leakage - d3 * d;
            CircuitFrame.this.stampConductance(this.nodes[0], this.nodes[1], d3);
            CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[1], d4);
        }

        void calculateCurrent() {
            double d = this.volts[0] - this.volts[1];
            this.current = this.leakage * (Math.exp(d * this.vdcoef) - 1.0);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "diode";
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentText(this.getCurrent());
            stringArray[2] = "Vd = " + CircuitFrame.this.getVoltageText(this.getVoltageDiff());
            stringArray[3] = "P = " + CircuitFrame.this.getUnitText(this.getPower(), "W");
            stringArray[4] = "Vf = " + CircuitFrame.this.getVoltageText(this.fwdrop);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Fwd Voltage @ 1A", this.fwdrop, 10.0, 1000.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.fwdrop = editInfo.value;
            this.setup();
        }
    }

    class Switch2Elm
    extends SwitchElm {
        int link;
        final int openhs = 16;
        Point[] swposts;
        Point[] swpoles;

        public Switch2Elm(int n, int n2) {
            super(n, n2, false);
            this.noDiagonal = true;
        }

        Switch2Elm(int n, int n2, boolean bl) {
            super(n, n2, bl);
            this.noDiagonal = true;
        }

        public Switch2Elm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5, stringTokenizer);
            this.link = new Integer(stringTokenizer.nextToken());
            this.noDiagonal = true;
        }

        int getDumpType() {
            return 83;
        }

        String dump() {
            return super.dump() + " " + this.position + " " + this.momentary + " " + this.link;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
            this.swposts = this.newPointArray(2);
            this.swpoles = this.newPointArray(2);
            this.interpPoint2(this.lead1, this.lead2, this.swpoles[0], this.swpoles[1], 1.0, 16.0);
            this.interpPoint2(this.point1, this.point2, this.swposts[0], this.swposts[1], 1.0, 16.0);
        }

        void draw(Graphics graphics) {
            this.setBbox(this.point1, this.point2, 16.0);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.swpoles[0], this.swposts[0]);
            this.setVoltageColor(graphics, this.volts[2]);
            CircuitFrame.this.drawThickLine(graphics, this.swpoles[1], this.swposts[1]);
            if (CircuitFrame.this.mouseElm != this) {
                graphics.setColor(CircuitFrame.this.whiteColor);
            }
            CircuitFrame.this.drawThickLine(graphics, this.lead1, this.swpoles[this.position]);
            this.updateDotCount();
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            this.drawDots(graphics, this.swpoles[this.position], this.swposts[this.position], this.curcount);
            this.drawPosts(graphics);
        }

        Point getPost(int n) {
            return n == 0 ? this.point1 : this.swposts[n - 1];
        }

        int getPostCount() {
            return 3;
        }

        void calculateCurrent() {
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[this.position + 1], this.voltSource, 0.0);
        }

        int getVoltageSourceCount() {
            return 1;
        }

        void toggle() {
            super.toggle();
            if (this.link != 0) {
                int n = 0;
                while (n != CircuitFrame.this.elmList.size()) {
                    Object e = CircuitFrame.this.elmList.elementAt(n);
                    if (e instanceof Switch2Elm) {
                        Switch2Elm switch2Elm = (Switch2Elm)e;
                        if (switch2Elm.link == this.link) {
                            switch2Elm.position = this.position;
                        }
                    }
                    ++n;
                }
            }
        }

        boolean getConnection(int n, int n2) {
            return this.comparePair(n, n2, 0, 1 + this.position);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = this.link == 0 ? "switch (DPST)" : "switch (DPDT)";
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
        }
    }

    class SwitchElm
    extends CircuitElm {
        boolean momentary;
        int position;
        int posCount;
        Point ps;

        public SwitchElm(int n, int n2) {
            super(n, n2);
            this.momentary = false;
            this.position = 0;
            this.posCount = 2;
        }

        SwitchElm(int n, int n2, boolean bl) {
            super(n, n2);
            this.position = bl ? 1 : 0;
            this.momentary = bl;
            this.posCount = 2;
        }

        public SwitchElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            String string = stringTokenizer.nextToken();
            this.position = string.compareTo("true") == 0 ? (this instanceof LogicInputElm ? 0 : 1) : (string.compareTo("false") == 0 ? (this instanceof LogicInputElm ? 1 : 0) : new Integer(string));
            this.momentary = new Boolean(stringTokenizer.nextToken());
            this.posCount = 2;
        }

        int getDumpType() {
            return 115;
        }

        String dump() {
            return super.dump() + " " + this.position + " " + this.momentary;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
            this.ps = new Point();
        }

        void draw(Graphics graphics) {
            int n = 16;
            int n2 = this.position == 1 ? n : 0;
            this.setBbox(this.point1, this.point2, n);
            this.draw2Leads(graphics);
            if (this.position == 0) {
                this.doDots(graphics);
            }
            if (CircuitFrame.this.mouseElm != this) {
                graphics.setColor(CircuitFrame.this.whiteColor);
            }
            this.interpPoint(this.lead1, this.lead2, this.ps, 1.0, n2);
            CircuitFrame.this.drawThickLine(graphics, this.lead1, this.ps);
            this.drawPosts(graphics);
        }

        void calculateCurrent() {
            if (this.position == 1) {
                this.current = 0.0;
            }
        }

        void stamp() {
            if (this.position == 0) {
                CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, 0.0);
            }
        }

        int getVoltageSourceCount() {
            return this.position == 1 ? 0 : 1;
        }

        void mouseUp() {
            if (this.momentary) {
                this.toggle();
            }
        }

        void toggle() {
            ++this.position;
            if (this.position >= this.posCount) {
                this.position = 0;
            }
        }

        void getInfo(String[] stringArray) {
            String string = stringArray[0] = this.momentary ? "push switch (SPST)" : "switch (SPST)";
            if (this.position == 1) {
                stringArray[1] = "open";
                stringArray[2] = "Vd = " + CircuitFrame.this.getVoltageDText(this.getVoltageDiff());
            } else {
                stringArray[1] = "closed";
                stringArray[2] = "V = " + CircuitFrame.this.getVoltageText(this.volts[0]);
                stringArray[3] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
            }
        }

        boolean getConnection(int n, int n2) {
            return this.position == 0;
        }

        boolean isWire() {
            return true;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Momentary Switch", this.momentary);
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.momentary = editInfo.checkbox.getState();
            }
        }
    }

    class PushSwitchElm
    extends SwitchElm {
        static /* synthetic */ Class class$CircuitFrame$SwitchElm;

        public PushSwitchElm(int n, int n2) {
            super(n, n2, true);
        }

        Class getDumpClass() {
            return class$CircuitFrame$SwitchElm == null ? (class$CircuitFrame$SwitchElm = PushSwitchElm.class$("CircuitFrame$SwitchElm")) : class$CircuitFrame$SwitchElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class CurrentElm
    extends CircuitElm {
        double currentValue;
        Polygon arrow;
        Point ashaft1;
        Point ashaft2;
        Point center;

        public CurrentElm(int n, int n2) {
            super(n, n2);
            this.currentValue = 0.01;
        }

        public CurrentElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            try {
                this.currentValue = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                this.currentValue = 0.01;
            }
        }

        String dump() {
            return super.dump() + " " + this.currentValue;
        }

        int getDumpType() {
            return 105;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(26);
            this.ashaft1 = this.interpPoint(this.lead1, this.lead2, 0.25);
            this.ashaft2 = this.interpPoint(this.lead1, this.lead2, 0.6);
            this.center = this.interpPoint(this.lead1, this.lead2, 0.5);
            Point point = this.interpPoint(this.lead1, this.lead2, 0.75);
            this.arrow = this.calcArrow(this.center, point, 4.0, 4.0);
        }

        void draw(Graphics graphics) {
            int n = 12;
            this.draw2Leads(graphics);
            this.setVoltageColor(graphics, (this.volts[0] + this.volts[1]) / 2.0);
            this.setPowerColor(graphics, false);
            CircuitFrame.this.drawThickCircle(graphics, this.center.x, this.center.y, n);
            CircuitFrame.this.drawThickLine(graphics, this.ashaft1, this.ashaft2);
            graphics.fillPolygon(this.arrow);
            this.setBbox(this.point1, this.point2, n);
            this.doDots(graphics);
            if (CircuitFrame.this.showValuesCheckItem.getState()) {
                String string = CircuitFrame.this.getShortUnitText(this.currentValue, "A");
                if (this.dx == 0 || this.dy == 0) {
                    this.drawValues(graphics, string, n);
                }
            }
            this.drawPosts(graphics);
        }

        void stamp() {
            this.current = this.currentValue;
            CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[1], this.current);
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Current (A)", this.currentValue, 0.0, 0.1);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.currentValue = editInfo.value;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "current source";
            this.getBasicInfo(stringArray);
        }

        double getVoltageDiff() {
            return this.volts[1] - this.volts[0];
        }
    }

    class VoltageElm
    extends CircuitElm {
        static final int FLAG_COS = 2;
        int waveform;
        static final int WF_DC = 0;
        static final int WF_AC = 1;
        static final int WF_SQUARE = 2;
        static final int WF_TRIANGLE = 3;
        static final int WF_SAWTOOTH = 4;
        static final int WF_PULSE = 5;
        static final int WF_VAR = 6;
        double frequency;
        double maxVoltage;
        double freqTimeZero;
        double bias;
        double phaseShift;
        double dutyCycle;
        final int circleSize = 17;

        VoltageElm(int n, int n2, int n3) {
            super(n, n2);
            this.waveform = n3;
            this.maxVoltage = 5.0;
            this.frequency = 40.0;
            this.dutyCycle = 0.5;
            this.reset();
        }

        public VoltageElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.maxVoltage = 5.0;
            this.frequency = 40.0;
            this.waveform = 0;
            this.dutyCycle = 0.5;
            try {
                this.waveform = new Integer(stringTokenizer.nextToken());
                this.frequency = new Double(stringTokenizer.nextToken());
                this.maxVoltage = new Double(stringTokenizer.nextToken());
                this.bias = new Double(stringTokenizer.nextToken());
                this.phaseShift = new Double(stringTokenizer.nextToken());
                this.dutyCycle = new Double(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((this.flags & 2) != 0) {
                this.flags &= 0xFFFFFFFD;
                this.phaseShift = 1.5707963267948966;
            }
            this.reset();
        }

        int getDumpType() {
            return 118;
        }

        String dump() {
            return super.dump() + " " + this.waveform + " " + this.frequency + " " + this.maxVoltage + " " + this.bias + " " + this.phaseShift + " " + this.dutyCycle;
        }

        void reset() {
            this.freqTimeZero = 0.0;
            this.curcount = 0.0;
        }

        double triangleFunc(double d) {
            if (d < Math.PI) {
                return d * 0.6366197723675814 - 1.0;
            }
            return 1.0 - (d - Math.PI) * 0.6366197723675814;
        }

        void stamp() {
            if (this.waveform == 0) {
                CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, this.getVoltage());
            } else {
                CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource);
            }
        }

        void doStep() {
            if (this.waveform != 0) {
                CircuitFrame.this.updateVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, this.getVoltage());
            }
        }

        double getVoltage() {
            double d = Math.PI * 2 * (CircuitFrame.this.t - this.freqTimeZero) * this.frequency + this.phaseShift;
            switch (this.waveform) {
                case 0: {
                    return this.maxVoltage + this.bias;
                }
                case 1: {
                    return Math.sin(d) * this.maxVoltage + this.bias;
                }
                case 2: {
                    return this.bias + (d % (Math.PI * 2) > Math.PI * 2 * this.dutyCycle ? -this.maxVoltage : this.maxVoltage);
                }
                case 3: {
                    return this.bias + this.triangleFunc(d % (Math.PI * 2)) * this.maxVoltage;
                }
                case 4: {
                    return this.bias + d % (Math.PI * 2) * (this.maxVoltage / Math.PI) - this.maxVoltage;
                }
                case 5: {
                    return d % (Math.PI * 2) < 1.0 ? this.maxVoltage + this.bias : this.bias;
                }
            }
            return 0.0;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(this.waveform == 0 || this.waveform == 6 ? 8 : 34);
        }

        void draw(Graphics graphics) {
            this.setBbox(this.x, this.y, this.x2, this.y2);
            this.draw2Leads(graphics);
            if (this.waveform == 0) {
                this.setPowerColor(graphics, false);
                this.setVoltageColor(graphics, this.volts[0]);
                this.interpPoint2(this.lead1, this.lead2, CircuitFrame.this.ps1, CircuitFrame.this.ps2, 0.0, 10.0);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                this.setVoltageColor(graphics, this.volts[1]);
                int n = 16;
                this.setBbox(this.point1, this.point2, n);
                this.interpPoint2(this.lead1, this.lead2, CircuitFrame.this.ps1, CircuitFrame.this.ps2, 1.0, n);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
            } else {
                this.setBbox(this.point1, this.point2, 17.0);
                this.interpPoint(this.lead1, this.lead2, CircuitFrame.this.ps1, 0.5);
                this.drawWaveform(graphics, CircuitFrame.this.ps1);
            }
            this.updateDotCount();
            if (CircuitFrame.this.dragElm != this) {
                if (this.waveform == 0) {
                    this.drawDots(graphics, this.point1, this.point2, this.curcount);
                } else {
                    this.drawDots(graphics, this.point1, this.lead1, this.curcount);
                    this.drawDots(graphics, this.point2, this.lead2, -this.curcount);
                }
            }
            this.drawPosts(graphics);
        }

        void drawWaveform(Graphics graphics, Point point) {
            graphics.setColor(this == CircuitFrame.this.mouseElm ? CircuitFrame.this.selectColor : Color.gray);
            this.setPowerColor(graphics, false);
            int n = point.x;
            int n2 = point.y;
            CircuitFrame.this.drawThickCircle(graphics, n, n2, 17);
            int n3 = 8;
            this.adjustBbox(n - 17, n2 - 17, n + 17, n2 + 17);
            switch (this.waveform) {
                case 0: {
                    break;
                }
                case 2: {
                    int n4 = (int)((double)(n3 * 2) * this.dutyCycle - (double)n3 + (double)n);
                    n4 = CircuitFrame.this.max(n - n3 + 3, CircuitFrame.this.min(n + n3 - 3, n4));
                    CircuitFrame.this.drawThickLine(graphics, n - n3, n2 - n3, n - n3, n2);
                    CircuitFrame.this.drawThickLine(graphics, n - n3, n2 - n3, n4, n2 - n3);
                    CircuitFrame.this.drawThickLine(graphics, n4, n2 - n3, n4, n2 + n3);
                    CircuitFrame.this.drawThickLine(graphics, n + n3, n2 + n3, n4, n2 + n3);
                    CircuitFrame.this.drawThickLine(graphics, n + n3, n2, n + n3, n2 + n3);
                    break;
                }
                case 5: {
                    CircuitFrame.this.drawThickLine(graphics, n - n3, (n2 += n3 / 2) - n3, n - n3, n2);
                    CircuitFrame.this.drawThickLine(graphics, n - n3, n2 - n3, n - n3 / 2, n2 - n3);
                    CircuitFrame.this.drawThickLine(graphics, n - n3 / 2, n2 - n3, n - n3 / 2, n2);
                    CircuitFrame.this.drawThickLine(graphics, n - n3 / 2, n2, n + n3, n2);
                    break;
                }
                case 4: {
                    CircuitFrame.this.drawThickLine(graphics, n, n2 - n3, n - n3, n2);
                    CircuitFrame.this.drawThickLine(graphics, n, n2 - n3, n, n2 + n3);
                    CircuitFrame.this.drawThickLine(graphics, n, n2 + n3, n + n3, n2);
                    break;
                }
                case 3: {
                    int n5 = 5;
                    CircuitFrame.this.drawThickLine(graphics, n - n5 * 2, n2, n - n5, n2 - n3);
                    CircuitFrame.this.drawThickLine(graphics, n - n5, n2 - n3, n, n2);
                    CircuitFrame.this.drawThickLine(graphics, n, n2, n + n5, n2 + n3);
                    CircuitFrame.this.drawThickLine(graphics, n + n5, n2 + n3, n + n5 * 2, n2);
                    break;
                }
                case 1: {
                    int n6 = 10;
                    int n7 = -1;
                    int n8 = -1;
                    int n5 = -n6;
                    while (n5 <= n6) {
                        int n9 = n2 + (int)(0.95 * Math.sin((double)n5 * Math.PI / (double)n6) * (double)n3);
                        if (n7 != -1) {
                            CircuitFrame.this.drawThickLine(graphics, n7, n8, n + n5, n9);
                        }
                        n7 = n + n5;
                        n8 = n9;
                        ++n5;
                    }
                    break;
                }
            }
            if (CircuitFrame.this.showValuesCheckItem.getState()) {
                String string = CircuitFrame.this.getShortUnitText(this.frequency, "Hz");
                if (this.dx == 0 || this.dy == 0) {
                    this.drawValues(graphics, string, 17.0);
                }
            }
        }

        int getVoltageSourceCount() {
            return 1;
        }

        double getPower() {
            return -this.getVoltageDiff() * this.current;
        }

        double getVoltageDiff() {
            return this.volts[1] - this.volts[0];
        }

        void getInfo(String[] stringArray) {
            switch (this.waveform) {
                case 0: 
                case 6: {
                    stringArray[0] = "voltage source";
                    break;
                }
                case 1: {
                    stringArray[0] = "A/C source";
                    break;
                }
                case 2: {
                    stringArray[0] = "square wave gen";
                    break;
                }
                case 5: {
                    stringArray[0] = "pulse gen";
                    break;
                }
                case 4: {
                    stringArray[0] = "sawtooth gen";
                    break;
                }
                case 3: {
                    stringArray[0] = "triangle gen";
                }
            }
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentText(this.getCurrent());
            stringArray[2] = (this instanceof RailElm ? "V = " : "Vd = ") + CircuitFrame.this.getVoltageText(this.getVoltageDiff());
            if (this.waveform != 0 && this.waveform != 6) {
                stringArray[3] = "f = " + CircuitFrame.this.getUnitText(this.frequency, "Hz");
                stringArray[4] = "Vmax = " + CircuitFrame.this.getVoltageText(this.maxVoltage);
                int n = 5;
                if (this.bias != 0.0) {
                    stringArray[n++] = "Voff = " + CircuitFrame.this.getVoltageText(this.bias);
                } else if (this.frequency > 500.0) {
                    stringArray[n++] = "wavelength = " + CircuitFrame.this.getUnitText(2.9979E8 / this.frequency, "m");
                }
                stringArray[n++] = "P = " + CircuitFrame.this.getUnitText(this.getPower(), "W");
            }
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo(this.waveform == 0 ? "Voltage" : "Max Voltage", this.maxVoltage, -20.0, 20.0);
            }
            if (n == 1) {
                EditInfo editInfo = new EditInfo("Waveform", this.waveform, -1.0, -1.0);
                editInfo.choice = new Choice();
                editInfo.choice.add("D/C");
                editInfo.choice.add("A/C");
                editInfo.choice.add("Square Wave");
                editInfo.choice.add("Triangle");
                editInfo.choice.add("Sawtooth");
                editInfo.choice.add("Pulse");
                editInfo.choice.select(this.waveform);
                return editInfo;
            }
            if (this.waveform == 0) {
                return null;
            }
            if (n == 2) {
                return new EditInfo("Frequency (Hz)", this.frequency, 4.0, 500.0);
            }
            if (n == 3) {
                return new EditInfo("DC Offset (V)", this.bias, -20.0, 20.0);
            }
            if (n == 4) {
                return new EditInfo("Phase Offset (degrees)", this.phaseShift * 180.0 / Math.PI, -180.0, 180.0);
            }
            if (n == 5 && this.waveform == 2) {
                return new EditInfo("Duty Cycle", this.dutyCycle * 100.0, 0.0, 100.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.maxVoltage = editInfo.value;
            }
            if (n == 3) {
                this.bias = editInfo.value;
            }
            if (n == 2) {
                double d = this.frequency;
                this.frequency = editInfo.value;
                double d2 = 1.0 / (8.0 * CircuitFrame.this.timeStep);
                if (this.frequency > d2) {
                    this.frequency = d2;
                }
                double d3 = this.frequency - d;
                this.freqTimeZero = CircuitFrame.this.t - d * (CircuitFrame.this.t - this.freqTimeZero) / this.frequency;
            }
            if (n == 1) {
                int n2 = this.waveform;
                this.waveform = editInfo.choice.getSelectedIndex();
                if (this.waveform == 0 && n2 != 0) {
                    editInfo.newDialog = true;
                    this.bias = 0.0;
                } else if (this.waveform != 0 && n2 == 0) {
                    editInfo.newDialog = true;
                }
                if ((this.waveform == 2 || n2 == 2) && this.waveform != n2) {
                    editInfo.newDialog = true;
                }
                this.setPoints();
            }
            if (n == 4) {
                this.phaseShift = editInfo.value * Math.PI / 180.0;
            }
            if (n == 5) {
                this.dutyCycle = editInfo.value * 0.01;
            }
        }
    }

    class ACVoltageElm
    extends VoltageElm {
        static /* synthetic */ Class class$CircuitFrame$VoltageElm;

        public ACVoltageElm(int n, int n2) {
            super(n, n2, 1);
        }

        Class getDumpClass() {
            return class$CircuitFrame$VoltageElm == null ? (class$CircuitFrame$VoltageElm = ACVoltageElm.class$("CircuitFrame$VoltageElm")) : class$CircuitFrame$VoltageElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class DCVoltageElm
    extends VoltageElm {
        static /* synthetic */ Class class$CircuitFrame$VoltageElm;

        public DCVoltageElm(int n, int n2) {
            super(n, n2, 0);
        }

        Class getDumpClass() {
            return class$CircuitFrame$VoltageElm == null ? (class$CircuitFrame$VoltageElm = DCVoltageElm.class$("CircuitFrame$VoltageElm")) : class$CircuitFrame$VoltageElm;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class InductorElm
    extends CircuitElm {
        double inductance;
        double compResistance;
        double curSourceValue;

        public InductorElm(int n, int n2) {
            super(n, n2);
            this.inductance = 1.0;
        }

        public InductorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.inductance = new Double(stringTokenizer.nextToken());
            this.current = new Double(stringTokenizer.nextToken());
        }

        int getDumpType() {
            return 108;
        }

        String dump() {
            return super.dump() + " " + this.inductance + " " + this.current;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
        }

        void draw(Graphics graphics) {
            double d = this.volts[0];
            double d2 = this.volts[1];
            int n = 8;
            this.setBbox(this.point1, this.point2, n);
            this.draw2Leads(graphics);
            this.setPowerColor(graphics, false);
            this.drawCoil(graphics, 8, this.lead1, this.lead2, d, d2);
            if (CircuitFrame.this.showValuesCheckItem.getState()) {
                String string = CircuitFrame.this.getShortUnitText(this.inductance, "H");
                this.drawValues(graphics, string, n);
            }
            this.doDots(graphics);
            this.drawPosts(graphics);
        }

        void reset() {
            this.curcount = 0.0;
            this.volts[1] = 0.0;
            this.volts[0] = 0.0;
            this.current = 0.0;
        }

        void stamp() {
            this.compResistance = 2.0 * this.inductance / CircuitFrame.this.timeStep;
            CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], this.compResistance);
            CircuitFrame.this.stampRightSide(this.nodes[0]);
            CircuitFrame.this.stampRightSide(this.nodes[1]);
        }

        void startIteration() {
            double d = this.volts[0] - this.volts[1];
            this.curSourceValue = d / this.compResistance + this.current;
        }

        void calculateCurrent() {
            double d = this.volts[0] - this.volts[1];
            if (this.compResistance > 0.0) {
                this.current = d / this.compResistance + this.curSourceValue;
            }
        }

        void doStep() {
            CircuitFrame.this.stampCurrentSource(this.nodes[0], this.nodes[1], this.curSourceValue);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "inductor";
            this.getBasicInfo(stringArray);
            stringArray[3] = "L = " + CircuitFrame.this.getUnitText(this.inductance, "H");
            stringArray[4] = "P = " + CircuitFrame.this.getUnitText(this.getPower(), "W");
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Inductance (H)", this.inductance, 0.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.inductance = editInfo.value;
        }
    }

    class CapacitorElm
    extends CircuitElm {
        double capacitance;
        double compResistance;
        double voltdiff;
        Point[] plate1;
        Point[] plate2;
        double voltSourceValue;

        public CapacitorElm(int n, int n2) {
            super(n, n2);
            this.capacitance = 1.0E-5;
        }

        public CapacitorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.capacitance = new Double(stringTokenizer.nextToken());
            this.voltdiff = new Double(stringTokenizer.nextToken());
        }

        void setNodeVoltage(int n, double d) {
            super.setNodeVoltage(n, d);
            this.voltdiff = this.volts[0] - this.volts[1];
        }

        void reset() {
            this.curcount = 0.0;
            this.current = 0.0;
            this.voltdiff = 0.001;
        }

        int getDumpType() {
            return 99;
        }

        String dump() {
            return super.dump() + " " + this.capacitance + " " + this.voltdiff;
        }

        void setPoints() {
            super.setPoints();
            double d = (this.dn / 2.0 - 4.0) / this.dn;
            this.lead1 = this.interpPoint(this.point1, this.point2, d);
            this.lead2 = this.interpPoint(this.point1, this.point2, 1.0 - d);
            this.plate1 = this.newPointArray(2);
            this.plate2 = this.newPointArray(2);
            this.interpPoint2(this.point1, this.point2, this.plate1[0], this.plate1[1], d, 12.0);
            this.interpPoint2(this.point1, this.point2, this.plate2[0], this.plate2[1], 1.0 - d, 12.0);
        }

        void draw(Graphics graphics) {
            int n = 12;
            this.setBbox(this.point1, this.point2, n);
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.setPowerColor(graphics, false);
            CircuitFrame.this.drawThickLine(graphics, this.plate1[0], this.plate1[1]);
            if (CircuitFrame.this.powerCheckItem.getState()) {
                graphics.setColor(Color.gray);
            }
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.point2, this.lead2);
            this.setPowerColor(graphics, false);
            CircuitFrame.this.drawThickLine(graphics, this.plate2[0], this.plate2[1]);
            this.updateDotCount();
            if (CircuitFrame.this.dragElm != this) {
                this.drawDots(graphics, this.point1, this.lead1, this.curcount);
                this.drawDots(graphics, this.point2, this.lead2, -this.curcount);
            }
            this.drawPosts(graphics);
            if (CircuitFrame.this.showValuesCheckItem.getState()) {
                String string = CircuitFrame.this.getShortUnitText(this.capacitance, "F");
                this.drawValues(graphics, string, n);
            }
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[2], this.voltSource);
            this.compResistance = CircuitFrame.this.timeStep / (2.0 * this.capacitance);
            CircuitFrame.this.stampResistor(this.nodes[2], this.nodes[1], this.compResistance);
        }

        void startIteration() {
            this.voltSourceValue = -this.voltdiff - this.current * this.compResistance;
        }

        void doStep() {
            CircuitFrame.this.updateVoltageSource(this.nodes[0], this.nodes[2], this.voltSource, this.voltSourceValue);
        }

        int getVoltageSourceCount() {
            return 1;
        }

        int getInternalNodeCount() {
            return 1;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "capacitor";
            this.getBasicInfo(stringArray);
            stringArray[3] = "C = " + CircuitFrame.this.getUnitText(this.capacitance, "F");
            stringArray[4] = "P = " + CircuitFrame.this.getUnitText(this.getPower(), "W");
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Capacitance (uF)", this.capacitance * 1000000.0, 0.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.capacitance = editInfo.value * 1.0E-6;
        }
    }

    class ResistorElm
    extends CircuitElm {
        double resistance;
        Point ps3;
        Point ps4;

        public ResistorElm(int n, int n2) {
            super(n, n2);
            this.resistance = 100.0;
        }

        public ResistorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
            this.resistance = new Double(stringTokenizer.nextToken());
        }

        int getDumpType() {
            return 114;
        }

        String dump() {
            return super.dump() + " " + this.resistance;
        }

        void setPoints() {
            super.setPoints();
            this.calcLeads(32);
            this.ps3 = new Point();
            this.ps4 = new Point();
        }

        void draw(Graphics graphics) {
            int n = 16;
            int n2 = 0;
            int n3 = CircuitFrame.this.euroResistorCheckItem.getState() ? 6 : 8;
            double d = this.volts[0];
            double d2 = this.volts[1];
            this.setBbox(this.point1, this.point2, n3);
            this.draw2Leads(graphics);
            this.setPowerColor(graphics, true);
            double d3 = 1.0 / (double)n;
            if (!CircuitFrame.this.euroResistorCheckItem.getState()) {
                int n4 = 0;
                while (n4 != n) {
                    int n5 = 0;
                    switch (n4 & 3) {
                        case 0: {
                            n5 = 1;
                            break;
                        }
                        case 2: {
                            n5 = -1;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    double d4 = d + (d2 - d) * (double)n4 / (double)n;
                    this.setVoltageColor(graphics, d4);
                    this.interpPoint(this.lead1, this.lead2, CircuitFrame.this.ps1, (double)n4 * d3, n3 * n2);
                    this.interpPoint(this.lead1, this.lead2, CircuitFrame.this.ps2, (double)(n4 + 1) * d3, n3 * n5);
                    CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                    n2 = n5;
                    ++n4;
                }
            } else {
                this.setVoltageColor(graphics, d);
                this.interpPoint2(this.lead1, this.lead2, CircuitFrame.this.ps1, CircuitFrame.this.ps2, 0.0, n3);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                int n6 = 0;
                while (n6 != n) {
                    double d5 = d + (d2 - d) * (double)n6 / (double)n;
                    this.setVoltageColor(graphics, d5);
                    this.interpPoint2(this.lead1, this.lead2, CircuitFrame.this.ps1, CircuitFrame.this.ps2, (double)n6 * d3, n3);
                    this.interpPoint2(this.lead1, this.lead2, this.ps3, this.ps4, (double)(n6 + 1) * d3, n3);
                    CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, this.ps3);
                    CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps2, this.ps4);
                    ++n6;
                }
                this.interpPoint2(this.lead1, this.lead2, CircuitFrame.this.ps1, CircuitFrame.this.ps2, 1.0, n3);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
            }
            if (CircuitFrame.this.showValuesCheckItem.getState()) {
                String string = CircuitFrame.this.getShortUnitText(this.resistance, "");
                this.drawValues(graphics, string, n3);
            }
            this.doDots(graphics);
            this.drawPosts(graphics);
        }

        void calculateCurrent() {
            this.current = (this.volts[0] - this.volts[1]) / this.resistance;
        }

        void stamp() {
            CircuitFrame.this.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "resistor";
            this.getBasicInfo(stringArray);
            stringArray[3] = "R = " + CircuitFrame.this.getUnitText(this.resistance, CircuitFrame.this.ohmString);
            stringArray[4] = "P = " + CircuitFrame.this.getUnitText(this.getPower(), "W");
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                return new EditInfo("Resistance (ohms)", this.resistance, 0.0, 0.0);
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            this.resistance = editInfo.value;
        }
    }

    class WireElm
    extends CircuitElm {
        static final int FLAG_SHOWCURRENT = 1;

        public WireElm(int n, int n2) {
            super(n, n2);
        }

        public WireElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
            super(n, n2, n3, n4, n5);
        }

        void draw(Graphics graphics) {
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.point2);
            this.doDots(graphics);
            this.setBbox(this.point1, this.point2, 3.0);
            if (this.mustShowCurrent()) {
                String string = CircuitFrame.this.getShortUnitText(Math.abs(this.getCurrent()), "A");
                this.drawValues(graphics, string, 4.0);
            }
            this.drawPosts(graphics);
        }

        void stamp() {
            CircuitFrame.this.stampVoltageSource(this.nodes[0], this.nodes[1], this.voltSource, 0.0);
        }

        boolean mustShowCurrent() {
            return (this.flags & 1) != 0;
        }

        int getVoltageSourceCount() {
            return 1;
        }

        void getInfo(String[] stringArray) {
            stringArray[0] = "wire";
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
            stringArray[2] = "V = " + CircuitFrame.this.getVoltageText(this.volts[0]);
        }

        int getDumpType() {
            return 119;
        }

        double getPower() {
            return 0.0;
        }

        double getVoltageDiff() {
            return this.volts[0];
        }

        boolean isWire() {
            return true;
        }

        EditInfo getEditInfo(int n) {
            if (n == 0) {
                EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
                editInfo.checkbox = new Checkbox("Show Current", this.mustShowCurrent());
                return editInfo;
            }
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
            if (n == 0) {
                this.flags = editInfo.checkbox.getState() ? 1 : 0;
            }
        }
    }

    abstract class CircuitElm {
        int x;
        int y;
        int x2;
        int y2;
        int flags;
        int[] nodes;
        int voltSource;
        int dx;
        int dy;
        int dsign;
        double dn;
        double dpx1;
        double dpy1;
        Point point1;
        Point point2;
        Point lead1;
        Point lead2;
        double[] volts;
        double current;
        double curcount;
        Rectangle boundingBox;
        boolean noDiagonal;

        int getDumpType() {
            return 0;
        }

        Class getDumpClass() {
            return this.getClass();
        }

        int getDefaultFlags() {
            return 0;
        }

        CircuitElm(int n, int n2) {
            this.x = this.x2 = n;
            this.y = this.y2 = n2;
            this.flags = this.getDefaultFlags();
            this.allocNodes();
            this.boundingBox = new Rectangle();
        }

        CircuitElm(int n, int n2, int n3, int n4, int n5) {
            this.x = n;
            this.y = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.flags = n5;
            this.allocNodes();
            this.boundingBox = new Rectangle();
        }

        void allocNodes() {
            this.nodes = new int[this.getPostCount() + this.getInternalNodeCount()];
            this.volts = new double[this.getPostCount() + this.getInternalNodeCount()];
        }

        String dump() {
            int n = this.getDumpType();
            return (n < 127 ? (char)n + " " : n + " ") + this.x + " " + this.y + " " + this.x2 + " " + this.y2 + " " + this.flags;
        }

        void reset() {
            int n = 0;
            while (n != this.getPostCount() + this.getInternalNodeCount()) {
                this.volts[n] = 0.0;
                ++n;
            }
            this.curcount = 0.0;
        }

        void draw(Graphics graphics) {
        }

        void setCurrent(int n, double d) {
            this.current = d;
        }

        double getCurrent() {
            return this.current;
        }

        void doStep() {
        }

        void delete() {
        }

        void startIteration() {
        }

        double getPostVoltage(int n) {
            return this.volts[n];
        }

        void setNodeVoltage(int n, double d) {
            this.volts[n] = d;
            this.calculateCurrent();
        }

        void calculateCurrent() {
        }

        void setPoints() {
            this.dx = this.x2 - this.x;
            this.dy = this.y2 - this.y;
            this.dn = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            this.dpx1 = (double)this.dy / this.dn;
            this.dpy1 = (double)(-this.dx) / this.dn;
            this.dsign = this.dy == 0 ? CircuitFrame.this.sign(this.dx) : CircuitFrame.this.sign(this.dy);
            this.point1 = new Point(this.x, this.y);
            this.point2 = new Point(this.x2, this.y2);
        }

        void calcLeads(int n) {
            if (this.dn < (double)n || n == 0) {
                this.lead1 = this.point1;
                this.lead2 = this.point2;
                return;
            }
            this.lead1 = this.interpPoint(this.point1, this.point2, (this.dn - (double)n) / (2.0 * this.dn));
            this.lead2 = this.interpPoint(this.point1, this.point2, (this.dn + (double)n) / (2.0 * this.dn));
        }

        Point interpPoint(Point point, Point point2, double d) {
            Point point3 = new Point();
            this.interpPoint(point, point2, point3, d);
            return point3;
        }

        void interpPoint(Point point, Point point2, Point point3, double d) {
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            point3.x = (int)((double)point.x * (1.0 - d) + (double)point2.x * d + 0.48);
            point3.y = (int)((double)point.y * (1.0 - d) + (double)point2.y * d + 0.48);
        }

        void interpPoint(Point point, Point point2, Point point3, double d, double d2) {
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            int n3 = point2.y - point.y;
            int n4 = point.x - point2.x;
            point3.x = (int)((double)point.x * (1.0 - d) + (double)point2.x * d + (d2 /= Math.sqrt(n3 * n3 + n4 * n4)) * (double)n3 + 0.48);
            point3.y = (int)((double)point.y * (1.0 - d) + (double)point2.y * d + d2 * (double)n4 + 0.48);
        }

        Point interpPoint(Point point, Point point2, double d, double d2) {
            Point point3 = new Point();
            this.interpPoint(point, point2, point3, d, d2);
            return point3;
        }

        void interpPoint2(Point point, Point point2, Point point3, Point point4, double d, double d2) {
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            int n3 = point2.y - point.y;
            int n4 = point.x - point2.x;
            point3.x = (int)((double)point.x * (1.0 - d) + (double)point2.x * d + (d2 /= Math.sqrt(n3 * n3 + n4 * n4)) * (double)n3 + 0.48);
            point3.y = (int)((double)point.y * (1.0 - d) + (double)point2.y * d + d2 * (double)n4 + 0.48);
            point4.x = (int)((double)point.x * (1.0 - d) + (double)point2.x * d - d2 * (double)n3 + 0.48);
            point4.y = (int)((double)point.y * (1.0 - d) + (double)point2.y * d - d2 * (double)n4 + 0.48);
        }

        void draw2Leads(Graphics graphics) {
            this.setVoltageColor(graphics, this.volts[0]);
            CircuitFrame.this.drawThickLine(graphics, this.point1, this.lead1);
            this.setVoltageColor(graphics, this.volts[1]);
            CircuitFrame.this.drawThickLine(graphics, this.lead2, this.point2);
        }

        Point[] newPointArray(int n) {
            Point[] pointArray = new Point[n];
            while (n > 0) {
                pointArray[--n] = new Point();
            }
            return pointArray;
        }

        void drawDots(Graphics graphics, Point point, Point point2, double d) {
            if (CircuitFrame.this.stoppedCheck.getState() || d == 0.0 || !CircuitFrame.this.dotsCheckItem.getState()) {
                return;
            }
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            double d2 = Math.sqrt(n * n + n2 * n2);
            graphics.setColor(Color.yellow);
            int n3 = 16;
            d %= (double)n3;
            if (d < 0.0) {
                d += (double)n3;
            }
            double d3 = 0.0;
            d3 = d;
            while (d3 < d2) {
                int n4 = (int)((double)point.x + d3 * (double)n / d2);
                int n5 = (int)((double)point.y + d3 * (double)n2 / d2);
                graphics.fillRect(n4 - 1, n5 - 1, 4, 4);
                d3 += (double)n3;
            }
        }

        Polygon calcArrow(Point point, Point point2, double d, double d2) {
            Polygon polygon = new Polygon();
            Point point3 = new Point();
            Point point4 = new Point();
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            double d3 = Math.sqrt(n * n + n2 * n2);
            polygon.addPoint(point2.x, point2.y);
            this.interpPoint2(point, point2, point3, point4, 1.0 - d / d3, d2);
            polygon.addPoint(point3.x, point3.y);
            polygon.addPoint(point4.x, point4.y);
            return polygon;
        }

        Polygon createPolygon(Point point, Point point2, Point point3) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x, point.y);
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point3.x, point3.y);
            return polygon;
        }

        Polygon createPolygon(Point point, Point point2, Point point3, Point point4) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x, point.y);
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point3.x, point3.y);
            polygon.addPoint(point4.x, point4.y);
            return polygon;
        }

        Polygon createPolygon(Point[] pointArray) {
            Polygon polygon = new Polygon();
            int n = 0;
            while (n != pointArray.length) {
                polygon.addPoint(pointArray[n].x, pointArray[n].y);
                ++n;
            }
            return polygon;
        }

        void drag(int n, int n2) {
            n = CircuitFrame.this.snapGrid(n);
            n2 = CircuitFrame.this.snapGrid(n2);
            if (this.noDiagonal) {
                if (CircuitFrame.this.abs(this.x - n) < CircuitFrame.this.abs(this.y - n2)) {
                    n = this.x;
                } else {
                    n2 = this.y;
                }
            }
            this.x2 = n;
            this.y2 = n2;
            this.setPoints();
        }

        void move(int n, int n2) {
            this.x += n;
            this.y += n2;
            this.x2 += n;
            this.y2 += n2;
            this.setPoints();
        }

        void movePoint(int n, int n2, int n3) {
            if (n == 0) {
                this.x += n2;
                this.y += n3;
            } else {
                this.x2 += n2;
                this.y2 += n3;
            }
            this.setPoints();
        }

        void drawPosts(Graphics graphics) {
            int n = 0;
            while (n != this.getPostCount()) {
                Point point = this.getPost(n);
                this.drawPost(graphics, point.x, point.y, this.nodes[n]);
                ++n;
            }
        }

        void stamp() {
        }

        int getVoltageSourceCount() {
            return 0;
        }

        int getInternalNodeCount() {
            return 0;
        }

        void setNode(int n, int n2) {
            this.nodes[n] = n2;
        }

        void setVoltageSource(int n, int n2) {
            this.voltSource = n2;
        }

        int getVoltageSource() {
            return this.voltSource;
        }

        double getVoltageDiff() {
            return this.volts[0] - this.volts[1];
        }

        boolean nonLinear() {
            return false;
        }

        int getPostCount() {
            return 2;
        }

        int getNode(int n) {
            return this.nodes[n];
        }

        Point getPost(int n) {
            return n == 0 ? this.point1 : (n == 1 ? this.point2 : null);
        }

        void drawPost(Graphics graphics, int n, int n2, int n3) {
            if (CircuitFrame.this.dragElm == null && CircuitFrame.this.mouseElm != this && CircuitFrame.this.getCircuitNode((int)n3).links.size() == 2) {
                return;
            }
            if (CircuitFrame.this.mouseMode == 2 || CircuitFrame.this.mouseMode == 3) {
                return;
            }
            this.drawPost(graphics, n, n2);
        }

        void drawPost(Graphics graphics, int n, int n2) {
            graphics.setColor(CircuitFrame.this.whiteColor);
            graphics.fillOval(n - 3, n2 - 3, 7, 7);
        }

        void setBbox(int n, int n2, int n3, int n4) {
            int n5;
            if (n > n3) {
                n5 = n;
                n = n3;
                n3 = n5;
            }
            if (n2 > n4) {
                n5 = n2;
                n2 = n4;
                n4 = n5;
            }
            this.boundingBox.setBounds(n, n2, n3 - n + 1, n4 - n2 + 1);
        }

        void setBbox(Point point, Point point2, double d) {
            this.setBbox(point.x, point.y, point2.x, point2.y);
            int n = point2.y - point.y;
            int n2 = point.x - point2.x;
            int n3 = (int)(this.dpx1 * d);
            int n4 = (int)(this.dpy1 * d);
            this.adjustBbox(point.x + n3, point.y + n4, point.x - n3, point.y - n4);
        }

        void adjustBbox(int n, int n2, int n3, int n4) {
            int n5;
            if (n > n3) {
                n5 = n;
                n = n3;
                n3 = n5;
            }
            if (n2 > n4) {
                n5 = n2;
                n2 = n4;
                n4 = n5;
            }
            n = CircuitFrame.this.min(this.boundingBox.x, n);
            n2 = CircuitFrame.this.min(this.boundingBox.y, n2);
            n3 = CircuitFrame.this.max(this.boundingBox.x + this.boundingBox.width - 1, n3);
            n4 = CircuitFrame.this.max(this.boundingBox.y + this.boundingBox.height - 1, n4);
            this.boundingBox.setBounds(n, n2, n3 - n, n4 - n2);
        }

        boolean isCenteredText() {
            return false;
        }

        void drawCenteredText(Graphics graphics, String string, int n, int n2, boolean bl) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            if (bl) {
                n -= n3 / 2;
            }
            graphics.drawString(string, n, n2 + fontMetrics.getAscent() / 2);
            this.adjustBbox(n, n2 - fontMetrics.getAscent() / 2, n + n3, n2 + fontMetrics.getAscent() / 2 + fontMetrics.getDescent());
        }

        void drawValues(Graphics graphics, String string, double d) {
            int n;
            int n2;
            if (string == null) {
                return;
            }
            graphics.setFont(CircuitFrame.this.unitsFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.stringWidth(string);
            graphics.setColor(CircuitFrame.this.whiteColor);
            int n4 = fontMetrics.getAscent() / 2;
            if (this instanceof RailElm || this instanceof SweepElm) {
                n2 = this.x2;
                n = this.y2;
            } else {
                n2 = (this.x2 + this.x) / 2;
                n = (this.y2 + this.y) / 2;
            }
            int n5 = (int)(this.dpx1 * d);
            int n6 = (int)(this.dpy1 * d);
            if (n5 == 0) {
                graphics.drawString(string, n2 - n3 / 2, n - CircuitFrame.this.abs(n6) - 2);
            } else {
                int n7 = n2 + CircuitFrame.this.abs(n5) + 2;
                if (this instanceof VoltageElm || this.x < this.x2 && this.y > this.y2) {
                    n7 = n2 - (n3 + CircuitFrame.this.abs(n5) + 2);
                }
                graphics.drawString(string, n7, n + n6 + n4);
            }
        }

        void drawCoil(Graphics graphics, int n, Point point, Point point2, double d, double d2) {
            double d3 = Math.sqrt(CircuitFrame.this.distanceSq(point.x, point.y, point2.x, point2.y));
            int n2 = 30;
            double d4 = 1.0 / (double)n2;
            CircuitFrame.this.ps1.setLocation(point);
            int n3 = 0;
            while (n3 != n2) {
                double d5 = (double)(n3 + 1) * 6.0 * d4 % 2.0 - 1.0;
                double d6 = Math.sqrt(1.0 - d5 * d5);
                if (d6 < 0.0) {
                    d6 = -d6;
                }
                this.interpPoint(point, point2, CircuitFrame.this.ps2, (double)n3 * d4, d6 * (double)n);
                double d7 = d + (d2 - d) * (double)n3 / (double)n2;
                this.setVoltageColor(graphics, d7);
                CircuitFrame.this.drawThickLine(graphics, CircuitFrame.this.ps1, CircuitFrame.this.ps2);
                CircuitFrame.this.ps1.setLocation(CircuitFrame.this.ps2);
                ++n3;
            }
        }

        void updateDotCount() {
            this.curcount = this.updateDotCount(this.current, this.curcount);
        }

        double updateDotCount(double d, double d2) {
            if (CircuitFrame.this.stoppedCheck.getState()) {
                return d2;
            }
            double d3 = d * CircuitFrame.this.currentMult;
            return d2 + (d3 %= 8.0);
        }

        void doDots(Graphics graphics) {
            this.updateDotCount();
            if (CircuitFrame.this.dragElm != this) {
                this.drawDots(graphics, this.point1, this.point2, this.curcount);
            }
        }

        void doAdjust() {
        }

        void setupAdjust() {
        }

        void getInfo(String[] stringArray) {
        }

        void getBasicInfo(String[] stringArray) {
            stringArray[1] = "I = " + CircuitFrame.this.getCurrentDText(this.getCurrent());
            stringArray[2] = "Vd = " + CircuitFrame.this.getVoltageDText(this.getVoltageDiff());
        }

        void setVoltageColor(Graphics graphics, double d) {
            if (this == CircuitFrame.this.mouseElm) {
                graphics.setColor(CircuitFrame.this.selectColor);
                return;
            }
            if (!CircuitFrame.this.voltsCheckItem.getState()) {
                if (!CircuitFrame.this.powerCheckItem.getState()) {
                    graphics.setColor(CircuitFrame.this.whiteColor);
                }
                return;
            }
            int n = (int)((d + CircuitFrame.this.voltageRange) * (double)(CircuitFrame.this.colorScaleCount - 1) / (CircuitFrame.this.voltageRange * 2.0));
            if (n < 0) {
                n = 0;
            }
            if (n >= CircuitFrame.this.colorScaleCount) {
                n = CircuitFrame.this.colorScaleCount - 1;
            }
            graphics.setColor(CircuitFrame.this.colorScale[n]);
        }

        void setPowerColor(Graphics graphics, boolean bl) {
            if (!CircuitFrame.this.powerCheckItem.getState()) {
                return;
            }
            this.setPowerColor(graphics, this.getPower());
        }

        void setPowerColor(Graphics graphics, double d) {
            double d2;
            double d3 = d2 = (d *= CircuitFrame.this.powerMult) < 0.0 ? -d : d;
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            int n = 128 + (int)(d2 * 127.0);
            int n2 = (int)(128.0 * (1.0 - d2));
            if (d > 0.0) {
                graphics.setColor(new Color(n, n2, n2));
            } else {
                graphics.setColor(new Color(n2, n, n2));
            }
        }

        void setConductanceColor(Graphics graphics, double d) {
            double d2;
            double d3 = d2 = (d *= CircuitFrame.this.powerMult) < 0.0 ? -d : d;
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            int n = (int)(d2 * 255.0);
            graphics.setColor(new Color(n, n, n));
        }

        double getPower() {
            return this.getVoltageDiff() * this.current;
        }

        double getScopeValue(int n) {
            return n == 1 ? this.getPower() : this.getVoltageDiff();
        }

        String getScopeUnits(int n) {
            return n == 1 ? "W" : "V";
        }

        EditInfo getEditInfo(int n) {
            return null;
        }

        void setEditValue(int n, EditInfo editInfo) {
        }

        boolean getConnection(int n, int n2) {
            return true;
        }

        boolean hasGroundConnection(int n) {
            return false;
        }

        boolean isWire() {
            return false;
        }

        boolean canViewInScope() {
            return this.getPostCount() <= 2;
        }

        boolean comparePair(int n, int n2, int n3, int n4) {
            return n == n3 && n2 == n4 || n == n4 && n2 == n3;
        }
    }

    class FindPathInfo {
        boolean[] used;
        int dest;
        CircuitElm firstElm;
        int type;

        FindPathInfo(int n, CircuitElm circuitElm, int n2) {
            this.dest = n2;
            this.type = n;
            this.firstElm = circuitElm;
            this.used = new boolean[CircuitFrame.this.nodeList.size()];
        }

        boolean findPath(int n) {
            if (n == this.dest) {
                return true;
            }
            if (this.used[n]) {
                return false;
            }
            this.used[n] = true;
            int n2 = 0;
            while (n2 != CircuitFrame.this.elmList.size()) {
                block14: {
                    int n3;
                    CircuitElm circuitElm;
                    block15: {
                        circuitElm = CircuitFrame.this.getElm(n2);
                        if (circuitElm == this.firstElm || this.type == 1 && circuitElm instanceof CurrentElm || this.type == 2 && !circuitElm.isWire() && !(circuitElm instanceof VoltageElm) || this.type == 3 && !circuitElm.isWire() || this.type == 4 && !circuitElm.isWire() && !(circuitElm instanceof CapacitorElm) && !(circuitElm instanceof VoltageElm)) break block14;
                        if (n == 0) {
                            n3 = 0;
                            while (n3 != circuitElm.getPostCount()) {
                                if (circuitElm.hasGroundConnection(n3) && this.findPath(circuitElm.getNode(n3))) {
                                    this.used[n] = false;
                                    return true;
                                }
                                ++n3;
                            }
                        }
                        n3 = 0;
                        while (n3 != circuitElm.getPostCount()) {
                            if (circuitElm.getNode(n3) == n) break;
                            ++n3;
                        }
                        if (n3 == circuitElm.getPostCount()) break block14;
                        if (circuitElm.hasGroundConnection(n3) && this.findPath(0)) {
                            this.used[n] = false;
                            return true;
                        }
                        if (this.type != 1 || !(circuitElm instanceof InductorElm)) break block15;
                        double d = circuitElm.getCurrent();
                        if (n3 == 0) {
                            d = -d;
                        }
                        if (Math.abs(d - this.firstElm.getCurrent()) > 1.0E-10) break block14;
                    }
                    int n4 = 0;
                    while (n4 != circuitElm.getPostCount()) {
                        if (n3 != n4 && circuitElm.getConnection(n3, n4) && this.findPath(circuitElm.getNode(n4))) {
                            this.used[n] = false;
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            this.used[n] = false;
            return false;
        }
    }

    class RowInfo {
        static final int ROW_NORMAL = 0;
        static final int ROW_CONST = 1;
        static final int ROW_EQUAL = 2;
        int nodeEq;
        int type = 0;
        int mapCol;
        int mapRow;
        double value;
        boolean rsChanges;
        boolean lsChanges;
        boolean dropRow;

        RowInfo() {
        }
    }

    class CircuitNodeLink {
        int num;
        CircuitElm elm;

        CircuitNodeLink() {
        }
    }

    class CircuitNode {
        int x;
        int y;
        Vector links = new Vector();
        boolean internal;

        CircuitNode() {
        }
    }
}

