/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class TriStateElm
extends CircuitElm {
    double resistance;
    double r_on = 0.1;
    double r_off = 1.0E10;
    boolean open;
    Point ps;
    Point point3;
    Point point4;
    Point lead3;
    Polygon gatePoly;

    public TriStateElm(int n, int n2) {
        super(n, n2);
    }

    public TriStateElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        try {
            this.r_on = new Double(stringTokenizer.nextToken());
            this.r_off = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String dump() {
        return super.dump() + " " + this.r_on + " " + this.r_off;
    }

    int getDumpType() {
        return 180;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.ps = new Point();
        int n = 16;
        int n2 = 16;
        if ((double)n2 > this.dn / 2.0) {
            n2 = (int)(this.dn / 2.0);
        }
        Point[] pointArray = this.newPointArray(3);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, n + 2);
        pointArray[2] = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 2) / this.dn);
        this.gatePoly = this.createPolygon(pointArray);
        this.point3 = this.interpPoint(this.point1, this.point2, 0.5, (double)(-n));
        this.point4 = this.interpPoint(this.point1, this.point2, 0.5, 0.0);
        this.lead3 = this.interpPoint(this.point1, this.point2, 0.5, (double)(-n / 2));
    }

    void drawPosts(Graphics graphics) {
        for (int i = 0; i != 3; ++i) {
            Point point = this.getPost(i);
            this.drawPost(graphics, point.x, point.y, this.nodes[i]);
        }
    }

    void draw(Graphics graphics) {
        int n = 16;
        this.setBbox(this.point1, this.point2, n);
        this.draw2Leads(graphics);
        graphics.setColor(lightGrayColor);
        TriStateElm.drawThickPolygon(graphics, this.gatePoly);
        this.setVoltageColor(graphics, this.volts[2]);
        TriStateElm.drawThickLine(graphics, this.point3, this.lead3);
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        this.current = (this.volts[0] - this.volts[1]) / this.resistance;
    }

    boolean nonLinear() {
        return true;
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[3], this.voltSource);
        sim.stampNonLinear(this.nodes[3]);
        sim.stampNonLinear(this.nodes[1]);
    }

    void doStep() {
        this.open = this.volts[2] < 2.5;
        this.resistance = this.open ? this.r_off : this.r_on;
        sim.stampResistor(this.nodes[3], this.nodes[1], this.resistance);
        sim.updateVoltageSource(0, this.nodes[3], this.voltSource, this.volts[0] > 2.5 ? 5.0 : 0.0);
    }

    void drag(int n, int n2) {
        n = sim.snapGrid(n);
        n2 = sim.snapGrid(n2);
        if (TriStateElm.abs(this.x - n) < TriStateElm.abs(this.y - n2)) {
            n = this.x;
        } else {
            n2 = this.y;
        }
        int n3 = TriStateElm.abs(this.x - n) + TriStateElm.abs(this.y - n2);
        int n4 = n3 / 2 % TriStateElm.sim.gridSize;
        if (n4 != 0) {
            return;
        }
        this.x2 = n;
        this.y2 = n2;
        this.setPoints();
    }

    int getPostCount() {
        return 4;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    Point getPost(int n) {
        if (this.point4 == null) {
            System.out.print("Hello\n");
        }
        return n == 0 ? this.point1 : (n == 1 ? this.point2 : (n == 2 ? this.point3 : this.point4));
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "tri-state buffer";
        stringArray[1] = this.open ? "open" : "closed";
        stringArray[2] = "Vd = " + TriStateElm.getVoltageDText(this.getVoltageDiff());
        stringArray[3] = "I = " + TriStateElm.getCurrentDText(this.getCurrent());
        stringArray[4] = "Vc = " + TriStateElm.getVoltageText(this.volts[2]);
    }

    boolean getConnection(int n, int n2) {
        return n == 1 && n2 == 3 || n == 3 && n2 == 1;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("On Resistance (ohms)", this.r_on, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Off Resistance (ohms)", this.r_off, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0 && editInfo.value > 0.0) {
            this.r_on = editInfo.value;
        }
        if (n == 1 && editInfo.value > 0.0) {
            this.r_off = editInfo.value;
        }
    }
}

