/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class Switch2Elm
extends SwitchElm {
    int link;
    static final int FLAG_CENTER_OFF = 1;
    final int openhs = 16;
    Point[] swposts;
    Point[] swpoles;

    public Switch2Elm(int n, int n2) {
        super(n, n2, false);
        this.noDiagonal = true;
    }

    Switch2Elm(int n, int n2, boolean bl) {
        super(n, n2, bl);
        this.noDiagonal = true;
    }

    public Switch2Elm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.link = new Integer(stringTokenizer.nextToken());
        this.noDiagonal = true;
    }

    int getDumpType() {
        return 83;
    }

    String dump() {
        return super.dump() + " " + this.link;
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.swposts = this.newPointArray(2);
        this.swpoles = this.newPointArray(3);
        this.interpPoint2(this.lead1, this.lead2, this.swpoles[0], this.swpoles[1], 1.0, 16.0);
        this.swpoles[2] = this.lead2;
        this.interpPoint2(this.point1, this.point2, this.swposts[0], this.swposts[1], 1.0, 16.0);
        this.posCount = this.hasCenterOff() ? 3 : 2;
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 16.0);
        this.setVoltageColor(graphics, this.volts[0]);
        Switch2Elm.drawThickLine(graphics, this.point1, this.lead1);
        this.setVoltageColor(graphics, this.volts[1]);
        Switch2Elm.drawThickLine(graphics, this.swpoles[0], this.swposts[0]);
        this.setVoltageColor(graphics, this.volts[2]);
        Switch2Elm.drawThickLine(graphics, this.swpoles[1], this.swposts[1]);
        if (!this.needsHighlight()) {
            graphics.setColor(whiteColor);
        }
        Switch2Elm.drawThickLine(graphics, this.lead1, this.swpoles[this.position]);
        this.updateDotCount();
        this.drawDots(graphics, this.point1, this.lead1, this.curcount);
        if (this.position != 2) {
            this.drawDots(graphics, this.swpoles[this.position], this.swposts[this.position], this.curcount);
        }
        this.drawPosts(graphics);
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : this.swposts[n - 1];
    }

    int getPostCount() {
        return 3;
    }

    void calculateCurrent() {
        if (this.position == 2) {
            this.current = 0.0;
        }
    }

    void stamp() {
        if (this.position == 2) {
            return;
        }
        sim.stampVoltageSource(this.nodes[0], this.nodes[this.position + 1], this.voltSource, 0.0);
    }

    int getVoltageSourceCount() {
        return this.position == 2 ? 0 : 1;
    }

    void toggle() {
        super.toggle();
        if (this.link != 0) {
            for (int i = 0; i != Switch2Elm.sim.elmList.size(); ++i) {
                CircuitElm circuitElm = Switch2Elm.sim.elmList.elementAt(i);
                if (!(circuitElm instanceof Switch2Elm)) continue;
                Switch2Elm switch2Elm = (Switch2Elm)circuitElm;
                if (switch2Elm.link != this.link) continue;
                switch2Elm.position = this.position;
            }
        }
    }

    boolean getConnection(int n, int n2) {
        if (this.position == 2) {
            return false;
        }
        return this.comparePair(n, n2, 0, 1 + this.position);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = this.link == 0 ? "switch (SPDT)" : "switch (DPDT)";
        stringArray[1] = "I = " + Switch2Elm.getCurrentDText(this.getCurrent());
    }

    public EditInfo getEditInfo(int n) {
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Center Off", this.hasCenterOff());
            return editInfo;
        }
        return super.getEditInfo(n);
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 1) {
            this.flags &= 0xFFFFFFFE;
            if (editInfo.checkbox.getState()) {
                this.flags |= 1;
            }
            if (this.hasCenterOff()) {
                this.momentary = false;
            }
            this.setPoints();
        } else {
            super.setEditValue(n, editInfo);
        }
    }

    boolean hasCenterOff() {
        return (this.flags & 1) != 0;
    }

    int getShortcut() {
        return 83;
    }
}

