/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

class Scope {
    final int FLAG_YELM = 32;
    static final int VAL_POWER = 1;
    static final int VAL_IB = 1;
    static final int VAL_IC = 2;
    static final int VAL_IE = 3;
    static final int VAL_VBE = 4;
    static final int VAL_VBC = 5;
    static final int VAL_VCE = 6;
    static final int VAL_R = 2;
    double[] minV;
    double[] maxV;
    double minMaxV;
    double[] minI;
    double[] maxI;
    double minMaxI;
    int scopePointCount = 128;
    int ptr;
    int ctr;
    int speed;
    int position;
    int value;
    int ivalue;
    String text;
    Rectangle rect = new Rectangle();
    boolean showI;
    boolean showV;
    boolean showMax;
    boolean showMin;
    boolean showFreq;
    boolean lockScale;
    boolean plot2d;
    boolean plotXY;
    CircuitElm elm;
    CircuitElm xElm;
    CircuitElm yElm;
    MemoryImageSource imageSource;
    Image image;
    int[] pixels;
    int draw_ox;
    int draw_oy;
    float[] dpixels;
    CirSim sim;

    Scope(CirSim cirSim) {
        this.reset();
        this.sim = cirSim;
    }

    void showCurrent(boolean bl) {
        this.showI = bl;
        this.ivalue = 0;
        this.value = 0;
    }

    void showVoltage(boolean bl) {
        this.showV = bl;
        this.ivalue = 0;
        this.value = 0;
    }

    void showMax(boolean bl) {
        this.showMax = bl;
    }

    void showMin(boolean bl) {
        this.showMin = bl;
    }

    void showFreq(boolean bl) {
        this.showFreq = bl;
    }

    void setLockScale(boolean bl) {
        this.lockScale = bl;
    }

    void resetGraph() {
        this.scopePointCount = 1;
        while (this.scopePointCount <= this.rect.width) {
            this.scopePointCount *= 2;
        }
        this.minV = new double[this.scopePointCount];
        this.maxV = new double[this.scopePointCount];
        this.minI = new double[this.scopePointCount];
        this.maxI = new double[this.scopePointCount];
        this.ctr = 0;
        this.ptr = 0;
        this.allocImage();
    }

    boolean active() {
        return this.elm != null;
    }

    void reset() {
        this.resetGraph();
        this.minMaxV = 5.0;
        this.minMaxI = 0.1;
        this.speed = 64;
        this.showMax = true;
        this.showV = true;
        this.showI = true;
        this.showMin = false;
        this.lockScale = false;
        this.showFreq = false;
        this.plot2d = false;
        if (this.elm != null && (this.elm instanceof OutputElm || this.elm instanceof LogicOutputElm || this.elm instanceof ProbeElm)) {
            this.showI = false;
        }
        this.ivalue = 0;
        this.value = 0;
        if (this.elm instanceof TransistorElm) {
            this.value = 6;
        }
    }

    void setRect(Rectangle rectangle) {
        this.rect = rectangle;
        this.resetGraph();
    }

    int getWidth() {
        return this.rect.width;
    }

    int rightEdge() {
        return this.rect.x + this.rect.width;
    }

    void setElm(CircuitElm circuitElm) {
        this.elm = circuitElm;
        this.reset();
    }

    void timeStep() {
        if (this.elm == null) {
            return;
        }
        double d = this.elm.getScopeValue(this.value);
        if (d < this.minV[this.ptr]) {
            this.minV[this.ptr] = d;
        }
        if (d > this.maxV[this.ptr]) {
            this.maxV[this.ptr] = d;
        }
        double d2 = 0.0;
        if (this.value == 0 || this.ivalue != 0) {
            double d3 = d2 = this.ivalue == 0 ? this.elm.getCurrent() : this.elm.getScopeValue(this.ivalue);
            if (d2 < this.minI[this.ptr]) {
                this.minI[this.ptr] = d2;
            }
            if (d2 > this.maxI[this.ptr]) {
                this.maxI[this.ptr] = d2;
            }
        }
        if (this.plot2d && this.dpixels != null) {
            boolean bl = false;
            while (d > this.minMaxV || d < -this.minMaxV) {
                this.minMaxV *= 2.0;
                bl = true;
            }
            double d4 = d2;
            if (this.plotXY) {
                double d5 = d4 = this.yElm == null ? 0.0 : this.yElm.getVoltageDiff();
            }
            while (d4 > this.minMaxI || d4 < -this.minMaxI) {
                this.minMaxI *= 2.0;
                bl = true;
            }
            if (bl) {
                this.clear2dView();
            }
            double d6 = d / this.minMaxV;
            double d7 = d4 / this.minMaxI;
            int n = (int)((double)this.rect.width * (1.0 + d6) * 0.499);
            int n2 = (int)((double)this.rect.height * (1.0 - d7) * 0.499);
            this.drawTo(n, n2);
        } else {
            ++this.ctr;
            if (this.ctr >= this.speed) {
                this.ptr = this.ptr + 1 & this.scopePointCount - 1;
                this.minV[this.ptr] = this.maxV[this.ptr] = d;
                this.minI[this.ptr] = this.maxI[this.ptr] = d2;
                this.ctr = 0;
            }
        }
    }

    void drawTo(int n, int n2) {
        if (this.draw_ox == -1) {
            this.draw_ox = n;
            this.draw_oy = n2;
        }
        if (this.draw_ox == n && this.draw_oy == n2) {
            this.dpixels[n + this.rect.width * n2] = 1.0f;
        } else if (CircuitElm.abs(n2 - this.draw_oy) > CircuitElm.abs(n - this.draw_ox)) {
            double d = CircuitElm.sign(n2 - this.draw_oy);
            int n3 = this.draw_oy;
            while ((double)n3 != (double)n2 + d) {
                int n4 = this.draw_ox + (n - this.draw_ox) * (n3 - this.draw_oy) / (n2 - this.draw_oy);
                this.dpixels[n4 + this.rect.width * n3] = 1.0f;
                n3 = (int)((double)n3 + d);
            }
        } else {
            double d = CircuitElm.sign(n - this.draw_ox);
            int n5 = this.draw_ox;
            while ((double)n5 != (double)n + d) {
                int n6 = this.draw_oy + (n2 - this.draw_oy) * (n5 - this.draw_ox) / (n - this.draw_ox);
                this.dpixels[n5 + this.rect.width * n6] = 1.0f;
                n5 = (int)((double)n5 + d);
            }
        }
        this.draw_ox = n;
        this.draw_oy = n2;
    }

    void clear2dView() {
        for (int i = 0; i != this.dpixels.length; ++i) {
            this.dpixels[i] = 0.0f;
        }
        this.draw_oy = -1;
        this.draw_ox = -1;
    }

    void adjustScale(double d) {
        this.minMaxV *= d;
        this.minMaxI *= d;
    }

    void draw2d(Graphics graphics) {
        int n;
        int n2;
        if (this.pixels == null || this.dpixels == null) {
            return;
        }
        int n3 = this.sim.printableCheckItem.getState() ? -1 : 0;
        for (n2 = 0; n2 != this.pixels.length; ++n2) {
            this.pixels[n2] = n3;
        }
        for (n2 = 0; n2 != this.rect.width; ++n2) {
            this.pixels[n2 + this.rect.width * (this.rect.height / 2)] = -16711936;
        }
        int n4 = this.plotXY ? -16711936 : -256;
        for (n2 = 0; n2 != this.rect.height; ++n2) {
            this.pixels[this.rect.width / 2 + this.rect.width * n2] = n4;
        }
        n2 = 0;
        while (n2 != this.pixels.length) {
            n = (int)(255.0f * this.dpixels[n2]);
            if (n > 0) {
                this.pixels[n2] = 0xFF000000 | 65793 * n;
            }
            int n5 = n2++;
            this.dpixels[n5] = (float)((double)this.dpixels[n5] * 0.997);
        }
        graphics.drawImage(this.image, this.rect.x, this.rect.y, null);
        graphics.setColor(CircuitElm.whiteColor);
        graphics.fillOval(this.rect.x + this.draw_ox - 2, this.rect.y + this.draw_oy - 2, 5, 5);
        n = this.rect.y + 10;
        int n6 = this.rect.x;
        if (this.text != null && this.rect.y + this.rect.height > n + 5) {
            graphics.drawString(this.text, n6, n);
            n += 15;
        }
    }

    void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        double d;
        int n5;
        int n6;
        double d2;
        int n7;
        int n8;
        int n9;
        if (this.elm == null) {
            return;
        }
        if (this.plot2d) {
            this.draw2d(graphics);
            return;
        }
        if (this.pixels == null) {
            return;
        }
        int n10 = this.sim.printableCheckItem.getState() ? -1 : 0;
        for (n9 = 0; n9 != this.pixels.length; ++n9) {
            this.pixels[n9] = n10;
        }
        int n11 = 0;
        int n12 = n8 = (this.rect.height - 1) / 2;
        boolean bl = false;
        boolean bl2 = false;
        int n13 = 4;
        double d3 = -1.0E8;
        double d4 = -1.0E8;
        double d5 = 1.0E8;
        double d6 = 1.0E8;
        int n14 = -256;
        int n15 = n7 = this.value > 0 ? -1 : -16711936;
        if (this.sim.scopeSelected == -1 && this.elm == this.sim.mouseElm) {
            n7 = -16711681;
            n14 = -16711681;
        }
        int n16 = this.ptr + this.scopePointCount - this.rect.width;
        for (n9 = 0; n9 != this.rect.width; ++n9) {
            int n17 = n9 + n16 & this.scopePointCount - 1;
            while (this.maxV[n17] > this.minMaxV) {
                this.minMaxV *= 2.0;
            }
            while (this.minV[n17] < -this.minMaxV) {
                this.minMaxV *= 2.0;
            }
            while (this.maxI[n17] > this.minMaxI) {
                this.minMaxI *= 2.0;
            }
            while (this.minI[n17] < -this.minMaxI) {
                this.minMaxI *= 2.0;
            }
        }
        double d7 = 1.0E-8;
        double d8 = d2 = this.showI ? this.minMaxI : this.minMaxV;
        while (d7 * 100.0 < d2) {
            d7 *= 10.0;
        }
        if ((double)n8 * d7 / d2 < 0.3) {
            d7 = 0.0;
        }
        boolean bl3 = (double)n8 * d7 / d2 > 3.0;
        for (n6 = -100; n6 <= 100; ++n6) {
            int n18;
            if (n6 != 0 && (this.showI && this.showV || d7 == 0.0) || (n18 = n8 - (int)((double)(n8 * n6) * d7 / d2)) < 0 || n18 >= this.rect.height - 1) continue;
            int n19 = n10 = n6 == 0 ? -7303024 : -12566464;
            if (n6 % 10 != 0) {
                n10 = -15724528;
                if (!bl3) continue;
            }
            for (n9 = 0; n9 != this.rect.width; ++n9) {
                this.pixels[n9 + n18 * this.rect.width] = n10;
            }
        }
        double d9 = this.sim.timeStep * (double)this.speed;
        for (d7 = 1.0E-15; d7 < d9 * 5.0; d7 *= 10.0) {
        }
        double d10 = this.sim.t - this.sim.timeStep * (double)this.speed * (double)this.rect.width;
        double d11 = this.sim.t - this.sim.t % d7;
        boolean bl4 = true;
        n6 = 0;
        while ((n5 = (int)(((d = d11 - d7 * (double)n6) - d10) / d9)) >= 0) {
            if (n5 < this.rect.width && !(d < 0.0)) {
                n10 = -14671840;
                bl4 = false;
                if ((d + d7 / 4.0) % (d7 * 10.0) < d7) {
                    n10 = -7303024;
                    if ((d + d7 / 4.0) % (d7 * 100.0) < d7) {
                        n10 = -12566320;
                    }
                }
                for (n9 = 0; n9 < this.pixels.length; n9 += this.rect.width) {
                    this.pixels[n9 + n5] = n10;
                }
            }
            ++n6;
        }
        if (this.value == 0 && this.showI) {
            int n20 = -1;
            n4 = -1;
            for (n9 = 0; n9 != this.rect.width; ++n9) {
                n3 = n9 + n16 & this.scopePointCount - 1;
                n2 = (int)((double)n8 / this.minMaxI * this.minI[n3]);
                n = (int)((double)n8 / this.minMaxI * this.maxI[n3]);
                if (this.maxI[n3] > d4) {
                    d4 = this.maxI[n3];
                }
                if (this.minI[n3] < d6) {
                    d6 = this.minI[n3];
                }
                if (n2 > n8) continue;
                if (n2 < -n13 || n > n13) {
                    bl = true;
                }
                if (n20 != -1) {
                    if (n2 == n4 && n == n4) continue;
                    for (n5 = n20; n5 != n11 + n9; ++n5) {
                        this.pixels[n5 + this.rect.width * (n12 - n4)] = n14;
                    }
                    n4 = -1;
                    n20 = -1;
                }
                if (n2 == n) {
                    n20 = n11 + n9;
                    n4 = n2;
                    continue;
                }
                for (n5 = n2; n5 <= n; ++n5) {
                    this.pixels[n11 + n9 + this.rect.width * (n12 - n5)] = n14;
                }
            }
            if (n20 != -1) {
                for (n5 = n20; n5 != n11 + n9; ++n5) {
                    this.pixels[n5 + this.rect.width * (n12 - n4)] = n14;
                }
            }
        }
        if (this.value != 0 || this.showV) {
            int n21 = -1;
            n4 = -1;
            for (n9 = 0; n9 != this.rect.width; ++n9) {
                n3 = n9 + n16 & this.scopePointCount - 1;
                n2 = (int)((double)n8 / this.minMaxV * this.minV[n3]);
                n = (int)((double)n8 / this.minMaxV * this.maxV[n3]);
                if (this.maxV[n3] > d3) {
                    d3 = this.maxV[n3];
                }
                if (this.minV[n3] < d5) {
                    d5 = this.minV[n3];
                }
                if (this.value == 0 && !this.showV || n2 > n8) continue;
                if (n2 < -n13 || n > n13) {
                    bl2 = true;
                }
                if (n21 != -1) {
                    if (n2 == n4 && n == n4) continue;
                    for (n5 = n21; n5 != n11 + n9; ++n5) {
                        this.pixels[n5 + this.rect.width * (n12 - n4)] = n7;
                    }
                    n4 = -1;
                    n21 = -1;
                }
                if (n2 == n) {
                    n21 = n11 + n9;
                    n4 = n2;
                    continue;
                }
                for (n5 = n2; n5 <= n; ++n5) {
                    this.pixels[n11 + n9 + this.rect.width * (n12 - n5)] = n7;
                }
            }
            if (n21 != -1) {
                for (n5 = n21; n5 != n11 + n9; ++n5) {
                    this.pixels[n5 + this.rect.width * (n12 - n4)] = n7;
                }
            }
        }
        d = 0.0;
        if (this.showFreq) {
            double d12 = 0.0;
            for (n9 = 0; n9 != this.rect.width; ++n9) {
                n2 = n9 + n16 & this.scopePointCount - 1;
                d12 += this.minV[n2] + this.maxV[n2];
            }
            n2 = 0;
            double d13 = (d12 /= (double)(n9 * 2)) * 0.05;
            int n22 = 0;
            double d14 = 0.0;
            int n23 = -1;
            double d15 = 0.0;
            for (n9 = 0; n9 != this.rect.width; ++n9) {
                int n24 = n9 + n16 & this.scopePointCount - 1;
                double d16 = this.maxV[n24] - d12;
                int n25 = n2;
                if (d16 < d13) {
                    n2 = 1;
                } else if (d16 > -d13) {
                    n2 = 2;
                }
                if (n2 != 2 || n25 != 1) continue;
                int n26 = n9 - n22;
                n22 = n9;
                if (n26 < 12) continue;
                if (n23 >= 0) {
                    d14 += (double)n26;
                    d15 += (double)(n26 * n26);
                }
                ++n23;
            }
            double d17 = Math.sqrt((d15 /= (double)n23) - (d14 /= (double)n23) * d14);
            d = 1.0 / (d14 * this.sim.timeStep * (double)this.speed);
            if (n23 < 1 || d17 > 2.0) {
                d = 0.0;
            }
        }
        graphics.drawImage(this.image, this.rect.x, this.rect.y, null);
        graphics.setColor(CircuitElm.whiteColor);
        int n27 = this.rect.y + 10;
        n11 += this.rect.x;
        if (this.showMax) {
            if (this.value != 0) {
                graphics.drawString(CircuitElm.getUnitText(d3, this.elm.getScopeUnits(this.value)), n11, n27);
            } else if (this.showV) {
                graphics.drawString(CircuitElm.getVoltageText(d3), n11, n27);
            } else if (this.showI) {
                graphics.drawString(CircuitElm.getCurrentText(d4), n11, n27);
            }
            n27 += 15;
        }
        if (this.showMin) {
            n3 = this.rect.y + this.rect.height - 5;
            if (this.value != 0) {
                graphics.drawString(CircuitElm.getUnitText(d5, this.elm.getScopeUnits(this.value)), n11, n3);
            } else if (this.showV) {
                graphics.drawString(CircuitElm.getVoltageText(d5), n11, n3);
            } else if (this.showI) {
                graphics.drawString(CircuitElm.getCurrentText(d6), n11, n3);
            }
        }
        if (this.text != null && this.rect.y + this.rect.height > n27 + 5) {
            graphics.drawString(this.text, n11, n27);
            n27 += 15;
        }
        if (this.showFreq && d != 0.0 && this.rect.y + this.rect.height > n27 + 5) {
            graphics.drawString(CircuitElm.getUnitText(d, "Hz"), n11, n27);
        }
        if (this.ptr > 5 && !this.lockScale) {
            if (!bl && this.minMaxI > 1.0E-4) {
                this.minMaxI /= 2.0;
            }
            if (!bl2 && this.minMaxV > 1.0E-4) {
                this.minMaxV /= 2.0;
            }
        }
    }

    void speedUp() {
        if (this.speed > 1) {
            this.speed /= 2;
            this.resetGraph();
        }
    }

    void slowDown() {
        this.speed *= 2;
        this.resetGraph();
    }

    PopupMenu getMenu() {
        if (this.elm == null) {
            return null;
        }
        if (this.elm instanceof TransistorElm) {
            this.sim.scopeIbMenuItem.setState(this.value == 1);
            this.sim.scopeIcMenuItem.setState(this.value == 2);
            this.sim.scopeIeMenuItem.setState(this.value == 3);
            this.sim.scopeVbeMenuItem.setState(this.value == 4);
            this.sim.scopeVbcMenuItem.setState(this.value == 5);
            this.sim.scopeVceMenuItem.setState(this.value == 6 && this.ivalue != 2);
            this.sim.scopeVceIcMenuItem.setState(this.value == 6 && this.ivalue == 2);
            return this.sim.transScopeMenu;
        }
        this.sim.scopeVMenuItem.setState(this.showV && this.value == 0);
        this.sim.scopeIMenuItem.setState(this.showI && this.value == 0);
        this.sim.scopeMaxMenuItem.setState(this.showMax);
        this.sim.scopeMinMenuItem.setState(this.showMin);
        this.sim.scopeFreqMenuItem.setState(this.showFreq);
        this.sim.scopePowerMenuItem.setState(this.value == 1);
        this.sim.scopeVIMenuItem.setState(this.plot2d && !this.plotXY);
        this.sim.scopeXYMenuItem.setState(this.plotXY);
        this.sim.scopeSelectYMenuItem.setEnabled(this.plotXY);
        this.sim.scopeResistMenuItem.setState(this.value == 2);
        this.sim.scopeResistMenuItem.setEnabled(this.elm instanceof MemristorElm);
        return this.sim.scopeMenu;
    }

    void setValue(int n) {
        this.reset();
        this.value = n;
    }

    String dump() {
        if (this.elm == null) {
            return null;
        }
        int n = (this.showI ? 1 : 0) | (this.showV ? 2 : 0) | (this.showMax ? 0 : 4) | (this.showFreq ? 8 : 0) | (this.lockScale ? 16 : 0) | (this.plot2d ? 64 : 0) | (this.plotXY ? 128 : 0) | (this.showMin ? 256 : 0);
        n |= 0x20;
        int n2 = this.sim.locateElm(this.elm);
        if (n2 < 0) {
            return null;
        }
        int n3 = this.yElm == null ? -1 : this.sim.locateElm(this.yElm);
        String string = "o " + n2 + " " + this.speed + " " + this.value + " " + n + " " + this.minMaxV + " " + this.minMaxI + " " + this.position + " " + n3;
        if (this.text != null) {
            string = string + " " + this.text;
        }
        return string;
    }

    void undump(StringTokenizer stringTokenizer) {
        this.reset();
        int n = new Integer(stringTokenizer.nextToken());
        if (n == -1) {
            return;
        }
        this.elm = this.sim.getElm(n);
        this.speed = new Integer(stringTokenizer.nextToken());
        this.value = new Integer(stringTokenizer.nextToken());
        int n2 = new Integer(stringTokenizer.nextToken());
        this.minMaxV = new Double(stringTokenizer.nextToken());
        this.minMaxI = new Double(stringTokenizer.nextToken());
        if (this.minMaxV == 0.0) {
            this.minMaxV = 0.5;
        }
        if (this.minMaxI == 0.0) {
            this.minMaxI = 1.0;
        }
        this.text = null;
        this.yElm = null;
        try {
            this.position = new Integer(stringTokenizer.nextToken());
            int n3 = -1;
            if ((n2 & 0x20) != 0 && (n3 = new Integer(stringTokenizer.nextToken()).intValue()) != -1) {
                this.yElm = this.sim.getElm(n3);
            }
            while (stringTokenizer.hasMoreTokens()) {
                if (this.text == null) {
                    this.text = stringTokenizer.nextToken();
                    continue;
                }
                this.text = this.text + " " + stringTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.showI = (n2 & 1) != 0;
        this.showV = (n2 & 2) != 0;
        this.showMax = (n2 & 4) == 0;
        this.showFreq = (n2 & 8) != 0;
        this.lockScale = (n2 & 0x10) != 0;
        this.plot2d = (n2 & 0x40) != 0;
        this.plotXY = (n2 & 0x80) != 0;
        this.showMin = (n2 & 0x100) != 0;
    }

    void allocImage() {
        this.pixels = null;
        int n = this.rect.width;
        int n2 = this.rect.height;
        if (n == 0 || n2 == 0) {
            return;
        }
        if (this.sim.useBufferedImage) {
            try {
                Class<?> clazz = Class.forName("java.awt.image.BufferedImage");
                Class<?> clazz2 = Class.forName("java.awt.image.DataBufferInt");
                Class<?> clazz3 = Class.forName("java.awt.image.Raster");
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.image = (Image)constructor.newInstance(new Integer(n), new Integer(n2), new Integer(1));
                Method method = clazz.getMethod("getRaster", new Class[0]);
                Object object = method.invoke((Object)this.image, new Object[0]);
                Object object2 = clazz3.getMethod("getDataBuffer", new Class[0]).invoke(object, new Object[0]);
                this.pixels = (int[])clazz2.getMethod("getData", new Class[0]).invoke(object2, new Object[0]);
            }
            catch (Exception exception) {
                System.out.println("BufferedImage failed");
            }
        }
        if (this.pixels == null) {
            this.pixels = new int[n * n2];
            for (int i = 0; i != n * n2; ++i) {
                this.pixels[i] = -16777216;
            }
            this.imageSource = new MemoryImageSource(n, n2, this.pixels, 0, n);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.image = this.sim.cv.createImage(this.imageSource);
        }
        this.dpixels = new float[n * n2];
        this.draw_oy = -1;
        this.draw_ox = -1;
    }

    void handleMenu(ItemEvent itemEvent, Object object) {
        if (object == this.sim.scopeVMenuItem) {
            this.showVoltage(this.sim.scopeVMenuItem.getState());
        }
        if (object == this.sim.scopeIMenuItem) {
            this.showCurrent(this.sim.scopeIMenuItem.getState());
        }
        if (object == this.sim.scopeMaxMenuItem) {
            this.showMax(this.sim.scopeMaxMenuItem.getState());
        }
        if (object == this.sim.scopeMinMenuItem) {
            this.showMin(this.sim.scopeMinMenuItem.getState());
        }
        if (object == this.sim.scopeFreqMenuItem) {
            this.showFreq(this.sim.scopeFreqMenuItem.getState());
        }
        if (object == this.sim.scopePowerMenuItem) {
            this.setValue(1);
        }
        if (object == this.sim.scopeIbMenuItem) {
            this.setValue(1);
        }
        if (object == this.sim.scopeIcMenuItem) {
            this.setValue(2);
        }
        if (object == this.sim.scopeIeMenuItem) {
            this.setValue(3);
        }
        if (object == this.sim.scopeVbeMenuItem) {
            this.setValue(4);
        }
        if (object == this.sim.scopeVbcMenuItem) {
            this.setValue(5);
        }
        if (object == this.sim.scopeVceMenuItem) {
            this.setValue(6);
        }
        if (object == this.sim.scopeVceIcMenuItem) {
            this.plot2d = true;
            this.plotXY = false;
            this.value = 6;
            this.ivalue = 2;
            this.resetGraph();
        }
        if (object == this.sim.scopeVIMenuItem) {
            this.plot2d = this.sim.scopeVIMenuItem.getState();
            this.plotXY = false;
            this.resetGraph();
        }
        if (object == this.sim.scopeXYMenuItem) {
            this.plotXY = this.plot2d = this.sim.scopeXYMenuItem.getState();
            if (this.yElm == null) {
                this.selectY();
            }
            this.resetGraph();
        }
        if (object == this.sim.scopeResistMenuItem) {
            this.setValue(2);
        }
    }

    void select() {
        this.sim.mouseElm = this.elm;
        if (this.plotXY) {
            this.sim.plotXElm = this.elm;
            this.sim.plotYElm = this.yElm;
        }
    }

    void selectY() {
        int n;
        int n2 = n = this.yElm == null ? -1 : this.sim.locateElm(this.yElm);
        while (true) {
            ++n;
            while (n < this.sim.elmList.size()) {
                CircuitElm circuitElm = this.sim.getElm(n);
                if ((circuitElm instanceof OutputElm || circuitElm instanceof ProbeElm) && circuitElm != this.elm) {
                    this.yElm = circuitElm;
                    return;
                }
                ++n;
            }
            if (n2 == -1) {
                return;
            }
            n2 = -1;
            n = -1;
        }
    }
}

