/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class LampElm
extends CircuitElm {
    double resistance;
    final double roomTemp = 300.0;
    double temp;
    double nom_pow;
    double nom_v;
    double warmTime;
    double coolTime;
    Point[] bulbLead;
    Point[] filament;
    Point bulb;
    int bulbR;
    final int filament_len = 24;

    public LampElm(int n, int n2) {
        super(n, n2);
        this.temp = 300.0;
        this.nom_pow = 100.0;
        this.nom_v = 120.0;
        this.warmTime = 0.4;
        this.coolTime = 0.4;
    }

    public LampElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.temp = new Double(stringTokenizer.nextToken());
        this.nom_pow = new Double(stringTokenizer.nextToken());
        this.nom_v = new Double(stringTokenizer.nextToken());
        this.warmTime = new Double(stringTokenizer.nextToken());
        this.coolTime = new Double(stringTokenizer.nextToken());
    }

    String dump() {
        return super.dump() + " " + this.temp + " " + this.nom_pow + " " + this.nom_v + " " + this.warmTime + " " + this.coolTime;
    }

    int getDumpType() {
        return 181;
    }

    void reset() {
        super.reset();
        this.temp = 300.0;
    }

    void setPoints() {
        super.setPoints();
        int n = 16;
        this.calcLeads(n);
        this.bulbLead = this.newPointArray(2);
        this.filament = this.newPointArray(2);
        this.bulbR = 20;
        this.filament[0] = this.interpPoint(this.lead1, this.lead2, 0.0, 24.0);
        this.filament[1] = this.interpPoint(this.lead1, this.lead2, 1.0, 24.0);
        double d = 24.0 - Math.sqrt(this.bulbR * this.bulbR - n * n);
        this.bulbLead[0] = this.interpPoint(this.lead1, this.lead2, 0.0, d);
        this.bulbLead[1] = this.interpPoint(this.lead1, this.lead2, 1.0, d);
        this.bulb = this.interpPoint(this.filament[0], this.filament[1], 0.5);
    }

    Color getTempColor() {
        if (this.temp < 1200.0) {
            int n = (int)(255.0 * (this.temp - 800.0) / 400.0);
            if (n < 0) {
                n = 0;
            }
            return new Color(n, 0, 0);
        }
        if (this.temp < 1700.0) {
            int n = (int)(255.0 * (this.temp - 1200.0) / 500.0);
            if (n < 0) {
                n = 0;
            }
            return new Color(255, n, 0);
        }
        if (this.temp < 2400.0) {
            int n = (int)(255.0 * (this.temp - 1700.0) / 700.0);
            if (n < 0) {
                n = 0;
            }
            return new Color(255, 255, n);
        }
        return Color.white;
    }

    void draw(Graphics graphics) {
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.setBbox(this.point1, this.point2, 4.0);
        this.adjustBbox(this.bulb.x - this.bulbR, this.bulb.y - this.bulbR, this.bulb.x + this.bulbR, this.bulb.y + this.bulbR);
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        graphics.setColor(this.getTempColor());
        graphics.fillOval(this.bulb.x - this.bulbR, this.bulb.y - this.bulbR, this.bulbR * 2, this.bulbR * 2);
        graphics.setColor(Color.white);
        LampElm.drawThickCircle(graphics, this.bulb.x, this.bulb.y, this.bulbR);
        this.setVoltageColor(graphics, d);
        LampElm.drawThickLine(graphics, this.lead1, this.filament[0]);
        this.setVoltageColor(graphics, d2);
        LampElm.drawThickLine(graphics, this.lead2, this.filament[1]);
        this.setVoltageColor(graphics, (d + d2) * 0.5);
        LampElm.drawThickLine(graphics, this.filament[0], this.filament[1]);
        this.updateDotCount();
        if (LampElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
            double d3 = this.curcount + (this.dn - 16.0) / 2.0;
            this.drawDots(graphics, this.lead1, this.filament[0], d3);
            this.drawDots(graphics, this.filament[0], this.filament[1], d3 += 24.0);
            this.drawDots(graphics, this.filament[1], this.lead2, d3 += 16.0);
            d3 += 24.0;
            this.drawDots(graphics, this.lead2, this.point2, this.curcount);
        }
        this.drawPosts(graphics);
    }

    void calculateCurrent() {
        this.current = (this.volts[0] - this.volts[1]) / this.resistance;
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
    }

    boolean nonLinear() {
        return true;
    }

    void startIteration() {
        double d = this.nom_v * this.nom_v / this.nom_pow;
        double d2 = this.temp > 5390.0 ? 5390.0 : this.temp;
        this.resistance = d * (1.26104 - 4.90662 * Math.sqrt(17.1839 / d2 - 0.00318794) - 7.8569 / (d2 - 187.56));
        double d3 = 1.57E-4 * this.nom_pow;
        double d4 = d3 * this.warmTime / 0.4;
        double d5 = d3 * this.coolTime / 0.4;
        this.temp += this.getPower() * LampElm.sim.timeStep / d4;
        double d6 = 2600.0 / this.nom_pow;
        this.temp -= LampElm.sim.timeStep * (this.temp - 300.0) / (d5 * d6);
    }

    void doStep() {
        sim.stampResistor(this.nodes[0], this.nodes[1], this.resistance);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "lamp";
        this.getBasicInfo(stringArray);
        stringArray[3] = "R = " + LampElm.getUnitText(this.resistance, CirSim.ohmString);
        stringArray[4] = "P = " + LampElm.getUnitText(this.getPower(), "W");
        stringArray[5] = "T = " + (int)this.temp + " K";
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Nominal Power", this.nom_pow, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Nominal Voltage", this.nom_v, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Warmup Time (s)", this.warmTime, 0.0, 0.0);
        }
        if (n == 3) {
            return new EditInfo("Cooldown Time (s)", this.coolTime, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0 && editInfo.value > 0.0) {
            this.nom_pow = editInfo.value;
        }
        if (n == 1 && editInfo.value > 0.0) {
            this.nom_v = editInfo.value;
        }
        if (n == 2 && editInfo.value > 0.0) {
            this.warmTime = editInfo.value;
        }
        if (n == 3 && editInfo.value > 0.0) {
            this.coolTime = editInfo.value;
        }
    }
}

