/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.GeneticCode;
import biogenesis.Organism;
import biogenesis.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WorldStatistics
implements Serializable {
    private static final long serialVersionUID = 700L;
    private long time;
    private int maxPopulation;
    private int maxBirths = 0;
    private int maxDeaths = 0;
    private long maxPopulationTime;
    private int minPopulation = Utils.INITIAL_ORGANISMS;
    private long minPopulationTime;
    private int massExtintions;
    private int massExtintionState;
    private static final int EXTINTION_NO = 0;
    private static final int EXTINTION_POSSIBLE = 1;
    private static final int EXTINTION_CONFIRMED = 2;
    private static final int EXTINTION_FINISHING = 3;
    private int createdOrganisms;
    private long populationSum;
    private long deathSum;
    private int deathLastTime;
    private long birthSum;
    private int birthLastTime;
    private long infectionsSum;
    private double maxOxygen = Utils.INITIAL_O2;
    private long maxOxygenTime;
    private double minOxygen = Utils.INITIAL_O2;
    private long minOxygenTime;
    private double maxCarbonDioxide = Utils.INITIAL_CO2;
    private long maxCarbonDioxideTime;
    private double minCarbonDioxide = Utils.INITIAL_CO2;
    private long minCarbonDioxideTime;
    private GeneticCode aliveBeingMostChildren;
    private int aliveBeingMostChildrenNumber;
    private GeneticCode aliveBeingMostKills;
    private int aliveBeingMostKillsNumber;
    private GeneticCode aliveBeingMostInfections;
    private int aliveBeingMostInfectionsNumber;
    private GeneticCode beingMostChildren;
    private int beingMostChildrenNumber;
    private long beingMostChildrenTime;
    private GeneticCode beingMostKills;
    private int beingMostKillsNumber;
    private long beingMostKillsTime;
    private GeneticCode beingMostInfections;
    private int beingMostInfectionsNumber;
    private long beingMostInfectionsTime;
    private GeneticCode lastBornBeing;
    private GeneticCode lastDeadBeing;
    private GeneticCode lastInfectedBeing;
    private List<Double> populationList = new ArrayList<Double>(100);
    private List<Double> deathList = new ArrayList<Double>(100);
    private List<Double> birthList = new ArrayList<Double>(100);
    private List<Double> oxygenList = new ArrayList<Double>(100);
    private List<Double> carbonDioxideList = new ArrayList<Double>(100);

    public long getTime() {
        return this.time;
    }

    public int getMaxPopulation() {
        return this.maxPopulation;
    }

    public int getMaxBirth() {
        return this.maxBirths;
    }

    public int getMaxDeaths() {
        return this.maxDeaths;
    }

    public long getMaxPopulationTime() {
        return this.maxPopulationTime;
    }

    public int getMinPopulation() {
        return this.minPopulation;
    }

    public long getMinPopulationTime() {
        return this.minPopulationTime;
    }

    public int getMassExtintions() {
        return this.massExtintions;
    }

    public int getCreatedOrganisms() {
        return this.createdOrganisms;
    }

    public double getAveragePopulation() {
        if (this.time > 0L) {
            return (double)this.populationSum / (double)this.time;
        }
        return 0.0;
    }

    public double getAverageDeaths() {
        if (this.time > 0L) {
            return (double)this.deathSum / (double)this.time;
        }
        return 0.0;
    }

    public double getAverageBirths() {
        if (this.time > 0L) {
            return (double)this.birthSum / (double)this.time;
        }
        return 0.0;
    }

    public double getAverageInfections() {
        if (this.time > 0L) {
            return (double)this.infectionsSum / (double)this.time;
        }
        return 0.0;
    }

    public double getMaxOxygen() {
        return this.maxOxygen;
    }

    public long getMaxOxygenTime() {
        return this.maxOxygenTime;
    }

    public double getMinOxygen() {
        return this.minOxygen;
    }

    public long getMinOxygenTime() {
        return this.minOxygenTime;
    }

    public double getMaxCarbonDioxide() {
        return this.maxCarbonDioxide;
    }

    public long getMaxCarbonDioxideTime() {
        return this.maxCarbonDioxideTime;
    }

    public double getMinCarbonDioxide() {
        return this.minCarbonDioxide;
    }

    public long getMinCarbonDioxideTime() {
        return this.minCarbonDioxideTime;
    }

    public GeneticCode getAliveBeingMostChildren() {
        return this.aliveBeingMostChildren;
    }

    public int getAliveBeingMostChildrenNumber() {
        return this.aliveBeingMostChildrenNumber;
    }

    public GeneticCode getAliveBeingMostKills() {
        return this.aliveBeingMostKills;
    }

    public int getAliveBeingMostKillsNumber() {
        return this.aliveBeingMostKillsNumber;
    }

    public GeneticCode getAliveBeingMostInfections() {
        return this.aliveBeingMostInfections;
    }

    public int getAliveBeingMostInfectionsNumber() {
        return this.aliveBeingMostInfectionsNumber;
    }

    public GeneticCode getBeingMostChildren() {
        return this.beingMostChildren;
    }

    public int getBeingMostChildrenNumber() {
        return this.beingMostChildrenNumber;
    }

    public long getBeingMostChildrenTime() {
        return this.beingMostChildrenTime;
    }

    public GeneticCode getBeingMostKills() {
        return this.beingMostKills;
    }

    public int getBeingMostKillsNumber() {
        return this.beingMostKillsNumber;
    }

    public long getBeingMostKillsTime() {
        return this.beingMostKillsTime;
    }

    public GeneticCode getBeingMostInfections() {
        return this.beingMostInfections;
    }

    public int getBeingMostInfectionsNumber() {
        return this.beingMostInfectionsNumber;
    }

    public long getBeingMostInfectionsTime() {
        return this.beingMostInfectionsTime;
    }

    public GeneticCode getLastBornBeing() {
        return this.lastBornBeing;
    }

    public GeneticCode getLastDeadBeing() {
        return this.lastDeadBeing;
    }

    public GeneticCode getLastInfectedBeing() {
        return this.lastInfectedBeing;
    }

    public List<Double> getPopulationList() {
        return this.populationList;
    }

    public List<Double> getDeathList() {
        return this.deathList;
    }

    public List<Double> getBirthList() {
        return this.birthList;
    }

    public List<Double> getOxygenList() {
        return this.oxygenList;
    }

    public List<Double> getCarbonDioxideList() {
        return this.carbonDioxideList;
    }

    public void eventPopulationIncrease(int newPopulation) {
        if (newPopulation > this.maxPopulation) {
            this.maxPopulation = newPopulation;
            this.maxPopulationTime = this.time;
        }
    }

    public void eventPopulationDecrease(int newPopulation) {
        if (newPopulation < this.minPopulation) {
            this.minPopulation = newPopulation;
            this.minPopulationTime = this.time;
        }
    }

    public void eventOrganismCreated() {
        ++this.createdOrganisms;
    }

    public void eventOrganismBorn(Organism newOrganism, Organism parent) {
        this.lastBornBeing = newOrganism.getGeneticCode();
        if (parent.getTotalChildren() > this.beingMostChildrenNumber) {
            this.beingMostChildren = parent.getGeneticCode();
            this.beingMostChildrenNumber = parent.getTotalChildren();
            this.beingMostChildrenTime = this.time;
        }
        ++this.birthSum;
        ++this.birthLastTime;
    }

    public void eventOrganismDie(Organism dyingOrganism, Organism killingOrganism) {
        this.lastDeadBeing = dyingOrganism.getGeneticCode();
        if (killingOrganism != null && killingOrganism.getTotalKills() > this.beingMostKillsNumber) {
            this.beingMostKills = killingOrganism.getGeneticCode();
            this.beingMostKillsNumber = killingOrganism.getTotalKills();
            this.beingMostKillsTime = this.time;
        }
        ++this.deathSum;
        ++this.deathLastTime;
    }

    public void eventOrganismInfects(Organism infectedOrganism, Organism infectingOrganism) {
        this.lastInfectedBeing = infectedOrganism.getGeneticCode();
        if (infectingOrganism != null && infectingOrganism.getTotalInfected() > this.beingMostInfectionsNumber) {
            this.beingMostInfections = infectingOrganism.getGeneticCode();
            this.beingMostInfectionsNumber = infectingOrganism.getTotalInfected();
            this.beingMostInfectionsTime = this.time;
        }
        ++this.infectionsSum;
    }

    public void eventTime(int population, double O2, double CO2) {
        ++this.time;
        if ((double)this.deathLastTime > 1.5 * this.getAverageDeaths()) {
            if ((double)this.deathLastTime > 3.0 * this.getAverageDeaths()) {
                if (this.massExtintionState != 2 && this.massExtintionState != 3) {
                    ++this.massExtintions;
                }
                this.massExtintionState = 2;
            } else {
                switch (this.massExtintionState) {
                    case 0: {
                        this.massExtintionState = 1;
                        break;
                    }
                    case 1: {
                        this.massExtintionState = 2;
                        ++this.massExtintions;
                        break;
                    }
                    case 3: {
                        this.massExtintionState = 2;
                    }
                }
            }
        } else {
            switch (this.massExtintionState) {
                case 1: 
                case 3: {
                    this.massExtintionState = 0;
                    break;
                }
                case 2: {
                    this.massExtintionState = 3;
                }
            }
        }
        this.populationSum += (long)population;
        if (O2 > this.maxOxygen) {
            this.maxOxygen = O2;
            this.maxOxygenTime = this.time;
        }
        if (O2 < this.minOxygen) {
            this.minOxygen = O2;
            this.minOxygenTime = this.time;
        }
        if (CO2 > this.maxCarbonDioxide) {
            this.maxCarbonDioxide = CO2;
            this.maxCarbonDioxideTime = this.time;
        }
        if (CO2 < this.minCarbonDioxide) {
            this.minCarbonDioxide = CO2;
            this.minCarbonDioxideTime = this.time;
        }
        if (this.birthLastTime > this.maxBirths) {
            this.maxBirths = this.birthLastTime;
        }
        if (this.deathLastTime > this.maxDeaths) {
            this.maxDeaths = this.deathLastTime;
        }
        if (this.populationList.size() == 100) {
            this.populationList.remove(0);
        }
        this.populationList.add(Double.valueOf(population));
        if (this.deathList.size() == 100) {
            this.deathList.remove(0);
        }
        this.deathList.add(Double.valueOf(this.deathLastTime));
        if (this.birthList.size() == 100) {
            this.birthList.remove(0);
        }
        this.birthList.add(Double.valueOf(this.birthLastTime));
        if (this.oxygenList.size() == 100) {
            this.oxygenList.remove(0);
        }
        this.oxygenList.add(O2);
        if (this.carbonDioxideList.size() == 100) {
            this.carbonDioxideList.remove(0);
        }
        this.carbonDioxideList.add(CO2);
        this.deathLastTime = 0;
        this.birthLastTime = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findBestAliveBeings(List<Organism> organisms) {
        this.aliveBeingMostChildren = null;
        this.aliveBeingMostChildrenNumber = 0;
        this.aliveBeingMostKills = null;
        this.aliveBeingMostKillsNumber = 0;
        this.aliveBeingMostInfections = null;
        this.aliveBeingMostInfectionsNumber = 0;
        List<Organism> list = organisms;
        synchronized (list) {
            for (Organism org : organisms) {
                if (!org.isAlive()) continue;
                if (org.getTotalChildren() > this.aliveBeingMostChildrenNumber) {
                    this.aliveBeingMostChildrenNumber = org.getTotalChildren();
                    this.aliveBeingMostChildren = org.getGeneticCode();
                }
                if (org.getTotalKills() > this.aliveBeingMostKillsNumber) {
                    this.aliveBeingMostKillsNumber = org.getTotalKills();
                    this.aliveBeingMostKills = org.getGeneticCode();
                }
                if (org.getTotalInfected() <= this.aliveBeingMostInfectionsNumber) continue;
                this.aliveBeingMostInfectionsNumber = org.getTotalInfected();
                this.aliveBeingMostInfections = org.getGeneticCode();
            }
        }
    }
}

