/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.BioFileFilter;
import biogenesis.BioXMLParser;
import biogenesis.GeneticCode;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.Organism;
import biogenesis.StdAction;
import biogenesis.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.xml.sax.SAXException;

public class VisibleWorld
extends JPanel {
    private static final long serialVersionUID = 700L;
    protected MainWindow _mainWindow;
    protected JPopupMenu popupAlive;
    protected TrackAction trackAction;
    protected StdAction feedAction;
    protected StdAction weakenAction;
    protected StdAction killAction;
    protected StdAction copyAction;
    protected StdAction saveImageAction;
    protected StdAction reviveAction;
    protected StdAction disperseAction;
    protected StdAction reproduceAction;
    protected StdAction rejuvenateAction;
    protected StdAction exportAction;
    protected JPopupMenu popupDead;
    protected JPopupMenu popupVoid;
    protected StdAction pasteAction;
    protected StdAction randomCreateAction;
    protected StdAction importAction;
    protected Organism _selectedOrganism = null;
    protected GeneticCode clippedGeneticCode = null;
    protected int mouseX;
    protected int mouseY;

    public void setSelectedOrganism(Organism b) {
        Organism lastSelectedOrganism = this._selectedOrganism;
        this._selectedOrganism = b;
        if (lastSelectedOrganism != null) {
            this.repaint(lastSelectedOrganism);
        }
        this._mainWindow.getInfoPanel().setSelectedOrganism(b);
        if (this._selectedOrganism != null) {
            this.repaint(this._selectedOrganism);
        }
        if (this._selectedOrganism != lastSelectedOrganism) {
            if (this._selectedOrganism != null) {
                if (this._selectedOrganism.isAlive()) {
                    this.showAliveToolbar();
                } else {
                    this.showDeadToolbar();
                }
            } else {
                this._mainWindow.createToolBar();
            }
        }
    }

    public Organism getSelectedOrganism() {
        return this._selectedOrganism;
    }

    public void setClippedGeneticCode(GeneticCode gc) {
        if (gc != null) {
            this.clippedGeneticCode = gc;
        }
    }

    public VisibleWorld(MainWindow mainWindow) {
        this._mainWindow = mainWindow;
        this.setPreferredSize(new Dimension(Utils.WORLD_WIDTH, Utils.WORLD_HEIGHT));
        this.setBackground(Color.BLACK);
        this.createActions();
        this.createPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    VisibleWorld.this.setSelectedOrganism(VisibleWorld.this.findOrganismFromPosition(e.getX(), e.getY()));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VisibleWorld.this.maybeShowPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VisibleWorld.this.maybeShowPopupMenu(e);
            }
        });
    }

    Organism findOrganismFromPosition(int x, int y) {
        return this._mainWindow.getWorld().findOrganismFromPosition(x, y);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this._mainWindow.getWorld().draw(g);
        if (this.getSelectedOrganism() != null) {
            g.setColor(Color.ORANGE);
            g.drawRect(this._selectedOrganism.x, this._selectedOrganism.y, this._selectedOrganism.width - 1, this._selectedOrganism.height - 1);
        }
    }

    private void createActions() {
        this.trackAction = new TrackAction("T_TRACK", "T_ABORT_TRACKING", "images/menu_track.png", "T_TRACK_ORGANISM", "T_ABORT_TRACKING_ORGANISM");
        this.feedAction = new FeedAction("T_FEED", "images/menu_feed.png", "T_FEED_ORGANISM");
        this.weakenAction = new WeakenAction("T_WEAKEN", "images/menu_weaken.png", "T_WEAKEN_ORGANISM");
        this.killAction = new KillAction("T_KILL", "images/menu_kill.png", "T_KILL_ORGANISM");
        this.copyAction = new CopyAction("T_COPY", "images/menu_copy.png", "T_COPY_GENETIC_CODE");
        this.saveImageAction = new SaveImageAction("T_SAVE_IMAGE", "images/menu_save_image.png", "T_SAVE_IMAGE");
        this.reviveAction = new ReviveAction("T_REVIVE", "images/menu_revive.png", "T_REVIVE_ORGANISM");
        this.disperseAction = new DisperseAction("T_DISPERSE", "images/menu_disperse.png", "T_DISPERSE_ORGANISM");
        this.reproduceAction = new ReproduceAction("T_FORCE_REPRODUCTION", null, "T_FORCE_REPRODUCTION");
        this.rejuvenateAction = new RejuvenateAction("T_REJUVENATE", null, "T_REJUVENATE");
        this.exportAction = new ExportAction("T_EXPORT", null, "T_EXPORT_GENETIC_CODE");
        this.pasteAction = new PasteAction("T_PASTE", null, "T_PASTE_GENETIC_CODE");
        this.randomCreateAction = new RandomCreateAction("T_CREATE_RANDOMLY", null, "T_CREATE_RANDOMLY");
        this.importAction = new ImportAction("T_IMPORT", null, "T_IMPORT_GENETIC_CODE");
    }

    public void showAliveToolbar() {
        JToolBar toolBar = this._mainWindow.toolBar;
        toolBar.removeAll();
        toolBar.add(this.feedAction);
        toolBar.add(this.weakenAction);
        toolBar.add(this.killAction);
        toolBar.add(this.copyAction);
        toolBar.add(this.saveImageAction);
        toolBar.add(this.trackAction);
        toolBar.add(this._mainWindow.abortTrackingAction);
        toolBar.invalidate();
        toolBar.repaint();
    }

    public void showDeadToolbar() {
        JToolBar toolBar = this._mainWindow.toolBar;
        toolBar.removeAll();
        toolBar.add(this.reviveAction);
        toolBar.add(this.disperseAction);
        toolBar.invalidate();
        toolBar.repaint();
    }

    private void createPopupMenu() {
        this.popupAlive = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(this.trackAction);
        menuItem.setIcon(null);
        this.popupAlive.add(menuItem);
        menuItem = new JMenuItem(this.feedAction);
        menuItem.setIcon(null);
        this.popupAlive.add(menuItem);
        menuItem = new JMenuItem(this.weakenAction);
        menuItem.setIcon(null);
        this.popupAlive.add(menuItem);
        this.popupAlive.add(new JMenuItem(this.reproduceAction));
        this.popupAlive.add(new JMenuItem(this.rejuvenateAction));
        menuItem = new JMenuItem(this.killAction);
        menuItem.setIcon(null);
        this.popupAlive.add(menuItem);
        menuItem = new JMenuItem(this.copyAction);
        menuItem.setIcon(null);
        this.popupAlive.add(menuItem);
        this.popupAlive.add(new JMenuItem(this.exportAction));
        menuItem = new JMenuItem(this.saveImageAction);
        menuItem.setIcon(null);
        this.popupAlive.add(menuItem);
        this.popupDead = new JPopupMenu();
        menuItem = new JMenuItem(this.reviveAction);
        menuItem.setIcon(null);
        this.popupDead.add(menuItem);
        menuItem = new JMenuItem(this.disperseAction);
        menuItem.setIcon(null);
        this.popupDead.add(menuItem);
        this.popupVoid = new JPopupMenu();
        this.popupVoid.add(new JMenuItem(this.pasteAction));
        this.popupVoid.add(new JMenuItem(this.randomCreateAction));
        this.popupVoid.add(new JMenuItem(this.importAction));
        SecurityManager sec = System.getSecurityManager();
        try {
            if (sec != null) {
                sec.checkPropertyAccess("user.home");
            }
        }
        catch (SecurityException ex) {
            this.exportAction.setEnabled(false);
            this.importAction.setEnabled(false);
            this.saveImageAction.setEnabled(false);
        }
    }

    public void changeLocale() {
        this.trackAction.changeLocale();
        this.feedAction.changeLocale();
        this.weakenAction.changeLocale();
        this.reproduceAction.changeLocale();
        this.rejuvenateAction.changeLocale();
        this.killAction.changeLocale();
        this.copyAction.changeLocale();
        this.exportAction.changeLocale();
        this.saveImageAction.changeLocale();
        this.reviveAction.changeLocale();
        this.disperseAction.changeLocale();
        this.pasteAction.changeLocale();
        this.randomCreateAction.changeLocale();
        this.importAction.changeLocale();
        this.createPopupMenu();
    }

    public boolean pasteGeneticCode(GeneticCode gc, int x, int y) {
        Organism newOrganism = new Organism(this._mainWindow.getWorld(), gc);
        if (newOrganism.pasteOrganism(x, y)) {
            this._mainWindow.getWorld().addOrganism(newOrganism, null);
            return true;
        }
        return false;
    }

    void maybeShowPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            Organism b = this.findOrganismFromPosition(this.mouseX, this.mouseY);
            if (b != null) {
                this.setSelectedOrganism(b);
                if (b.isAlive()) {
                    this.trackAction.setTracking(this._mainWindow._trackedOrganism == b);
                    this.popupAlive.show(e.getComponent(), this.mouseX, this.mouseY);
                } else {
                    this.popupDead.show(e.getComponent(), this.mouseX, this.mouseY);
                }
            } else {
                this.popupVoid.show(e.getComponent(), this.mouseX, this.mouseY);
            }
        }
    }

    class CopyAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public CopyAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                VisibleWorld.this.clippedGeneticCode = b.getGeneticCode();
            }
        }
    }

    class DisperseAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public DisperseAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && !b.isAlive()) {
                b.useEnergy(b.getEnergy());
            }
        }
    }

    class ExportAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ExportAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                VisibleWorld.this._mainWindow.saveObjectAs(b.getGeneticCode());
            }
        }
    }

    class FeedAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public FeedAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                double q = Math.min(10.0, VisibleWorld.this._mainWindow.getWorld().getCO2());
                VisibleWorld.this._mainWindow.getWorld().addCO2(q);
                b._energy += q;
                VisibleWorld.this._mainWindow.getWorld().addO2(q);
            }
        }
    }

    class ImportAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ImportAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean processState;
            block6: {
                processState = VisibleWorld.this._mainWindow._isProcessActive;
                VisibleWorld.this._mainWindow._isProcessActive = false;
                try {
                    JFileChooser chooser = VisibleWorld.this._mainWindow.getGeneticCodeChooser();
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal != 0) break block6;
                    try {
                        BioXMLParser parser = new BioXMLParser();
                        GeneticCode g = parser.parseGeneticCode(chooser.getSelectedFile());
                        Organism newBiot = new Organism(VisibleWorld.this._mainWindow.getWorld(), g);
                        if (newBiot.pasteOrganism(VisibleWorld.this.mouseX, VisibleWorld.this.mouseY)) {
                            VisibleWorld.this._mainWindow.getWorld().addOrganism(newBiot, null);
                        }
                    }
                    catch (SAXException ex) {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("T_WRONG_FILE_VERSION"), Messages.getString("T_READ_ERROR"), 0);
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                        JOptionPane.showMessageDialog(null, Messages.getString("T_CANT_READ_FILE"), Messages.getString("T_READ_ERROR"), 0);
                    }
                }
                catch (SecurityException ex) {
                    System.err.println(ex.getMessage());
                    JOptionPane.showMessageDialog(null, Messages.getString("T_PERMISSION_DENIED"), Messages.getString("T_PERMISSION_DENIED"), 0);
                }
            }
            VisibleWorld.this._mainWindow._isProcessActive = processState;
        }
    }

    class KillAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public KillAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                b.die(null);
            }
        }
    }

    class PasteAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public PasteAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VisibleWorld.this.clippedGeneticCode != null) {
                VisibleWorld.this.pasteGeneticCode(VisibleWorld.this.clippedGeneticCode, VisibleWorld.this.mouseX, VisibleWorld.this.mouseY);
            }
        }
    }

    class RandomCreateAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public RandomCreateAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneticCode g = new GeneticCode();
            Organism newBiot = new Organism(VisibleWorld.this._mainWindow.getWorld(), g);
            if (newBiot.pasteOrganism(VisibleWorld.this.mouseX, VisibleWorld.this.mouseY)) {
                VisibleWorld.this._mainWindow.getWorld().addOrganism(newBiot, null);
            }
        }
    }

    class RejuvenateAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public RejuvenateAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                b._age = 0;
            }
        }
    }

    class ReproduceAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ReproduceAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                b.reproduce();
            }
        }
    }

    class ReviveAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public ReviveAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && !b.isAlive()) {
                int i = 0;
                while (i < b._segments) {
                    b._segColor[i] = b.getGeneticCode().getGene(i % b.getGeneticCode().getNGenes()).getColor();
                    ++i;
                }
                b.alive = true;
                b.hasMoved = true;
                b._age = 0;
                VisibleWorld.this._mainWindow.getWorld().increasePopulation();
                VisibleWorld.this.showAliveToolbar();
            }
        }
    }

    class SaveImageAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public SaveImageAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                boolean processState = VisibleWorld.this._mainWindow._isProcessActive;
                VisibleWorld.this._mainWindow._isProcessActive = false;
                BufferedImage image = b.getImage();
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileFilter(new BioFileFilter("png"));
                    int returnVal = chooser.showSaveDialog(null);
                    if (returnVal == 0) {
                        int canWrite = 0;
                        File f = chooser.getSelectedFile();
                        if (f.exists()) {
                            canWrite = JOptionPane.showConfirmDialog(null, Messages.getString("T_CONFIRM_FILE_OVERRIDE"), Messages.getString("T_FILE_EXISTS"), 0, 2);
                        }
                        if (canWrite == 0) {
                            try {
                                ImageIO.write((RenderedImage)image, "PNG", f);
                            }
                            catch (FileNotFoundException ex) {
                                System.err.println(ex.getMessage());
                            }
                            catch (IOException ex) {
                                System.err.println(ex.getMessage());
                            }
                        }
                    }
                }
                catch (SecurityException ex) {
                    System.err.println(ex.getMessage());
                    JOptionPane.showMessageDialog(null, Messages.getString("T_PERMISSION_DENIED"), Messages.getString("T_PERMISSION_DENIED"), 0);
                }
                VisibleWorld.this._mainWindow._isProcessActive = processState;
            }
        }
    }

    class TrackAction
    extends StdAction {
        private static final long serialVersionUID = 1L;
        protected String name_key2;
        protected String desc_key2;

        public TrackAction(String text_key, String text_key2, String icon_path, String desc, String desc2) {
            super(text_key, icon_path, desc);
            this.name_key2 = text_key2;
            this.desc_key2 = desc2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                if (VisibleWorld.this._mainWindow._trackedOrganism == b) {
                    VisibleWorld.this._mainWindow.setTrackedOrganism(null);
                } else {
                    VisibleWorld.this._mainWindow.setTrackedOrganism(b);
                }
            }
        }

        public void setTracking(boolean isTracking) {
            if (isTracking) {
                this.putValue("Name", Messages.getString(this.name_key2));
                this.putValue("ShortDescription", Messages.getString(this.desc_key2));
                this.putValue("MnemonicKey", Messages.getMnemonic(this.name_key2));
            } else {
                this.putValue("Name", Messages.getString(this.name_key));
                this.putValue("ShortDescription", Messages.getString(this.desc_key));
                this.putValue("MnemonicKey", Messages.getMnemonic(this.name_key));
            }
        }
    }

    class WeakenAction
    extends StdAction {
        private static final long serialVersionUID = 1L;

        public WeakenAction(String text_key, String icon_path, String desc) {
            super(text_key, icon_path, desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Organism b = VisibleWorld.this.getSelectedOrganism();
            if (b != null && b.isAlive()) {
                b.useEnergy(b.getEnergy() / 2.0);
            }
        }
    }
}

