/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.DateConverter;
import de.lehmannet.om.util.SchemaException;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Session
extends SchemaElement
implements ISession {
    private Calendar begin = Calendar.getInstance();
    private Calendar end = Calendar.getInstance();
    private ISite site = null;
    private String weather = null;
    private String equipment = null;
    private String comments = null;
    private LinkedList coObservers = new LinkedList();
    private String lang = null;
    private List images = new LinkedList();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session(Node session, IObserver[] observers, ISite[] sites) throws SchemaException, IllegalArgumentException {
        String language;
        if (session == null) {
            throw new IllegalArgumentException("Parameter session node cannot be NULL. ");
        }
        Element sessionElement = (Element)session;
        Element child = null;
        NodeList children = null;
        String ID = sessionElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Session must have a ID. ");
        }
        super.setID(ID);
        children = sessionElement.getElementsByTagName("begin");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Session must have exact one begin date. ");
        }
        child = (Element)children.item(0);
        Calendar begin = null;
        if (child == null) {
            throw new SchemaException("Session must have begin date. ");
        }
        String ISO8601Begin = null;
        if (child.getFirstChild() == null) {
            throw new SchemaException("Session cannot have an empty begin date. ");
        }
        ISO8601Begin = child.getFirstChild().getNodeValue();
        try {
            begin = DateConverter.toDate((String)ISO8601Begin);
            this.setBegin(begin);
        }
        catch (NumberFormatException nfe) {
            throw new SchemaException("Begin date is malformed. ", (Throwable)nfe);
        }
        child = null;
        children = sessionElement.getElementsByTagName("end");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Session must have exact one end date. ");
        }
        child = (Element)children.item(0);
        Calendar end = null;
        if (child == null) {
            throw new SchemaException("Session must have end date. ");
        }
        String ISO8601End = child.getFirstChild().getNodeValue();
        try {
            end = DateConverter.toDate((String)ISO8601End);
            this.setEnd(end);
        }
        catch (NumberFormatException nfe) {
            throw new SchemaException("End date is malformed. ", (Throwable)nfe);
        }
        child = null;
        children = sessionElement.getElementsByTagName("site");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Session must have exact one site. ");
        }
        child = (Element)children.item(0);
        if (child == null) {
            throw new SchemaException("Session must have a site. ");
        }
        String siteID = child.getFirstChild().getNodeValue();
        if (sites == null && sites.length <= 0) throw new IllegalArgumentException("Parameter ISite array is NULL or empty. ");
        boolean found = false;
        for (int j = 0; j < sites.length; ++j) {
            if (!sites[j].getID().equals(siteID)) continue;
            found = true;
            this.setSite(sites[j]);
            break;
        }
        if (!found) {
            throw new SchemaException("Sessions site links to not existing observer element. ");
        }
        child = null;
        children = sessionElement.getElementsByTagName("coObserver");
        if (children != null) {
            for (int x = 0; x < children.getLength(); ++x) {
                child = (Element)children.item(x);
                if (child == null) throw new SchemaException("Problem retrieving coObserver from session. ");
                String coObserverID = child.getFirstChild().getNodeValue();
                if (observers == null && observers.length <= 0) throw new IllegalArgumentException("Parameter IObserver array is NULL or empty. ");
                boolean found2 = false;
                for (int j = 0; j < observers.length; ++j) {
                    if (!observers[j].getID().equals(coObserverID)) continue;
                    found2 = true;
                    this.addCoObserver(observers[j]);
                    break;
                }
                if (found2) continue;
                throw new SchemaException("Sessions coobserver links to not existing observer element. ");
            }
        }
        child = null;
        children = sessionElement.getElementsByTagName("weather");
        String weather = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving weather from session. ");
                NodeList textElements = child.getChildNodes();
                if (textElements != null && textElements.getLength() > 0) {
                    for (int te = 0; te < textElements.getLength(); ++te) {
                        weather = weather + textElements.item(te).getNodeValue();
                    }
                    this.setWeather(weather);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Session can have only one weather entry. ");
            }
        }
        child = null;
        children = sessionElement.getElementsByTagName("equipment");
        String equipment = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving equipment from session. ");
                NodeList textElements = child.getChildNodes();
                if (textElements != null && textElements.getLength() > 0) {
                    for (int te = 0; te < textElements.getLength(); ++te) {
                        equipment = equipment + textElements.item(te).getNodeValue();
                    }
                    this.setEquipment(equipment);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Session can have only one equipment entry. ");
            }
        }
        child = null;
        children = sessionElement.getElementsByTagName("comments");
        String comments = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving comment from session. ");
                NodeList textElements = child.getChildNodes();
                if (textElements != null && textElements.getLength() > 0) {
                    for (int te = 0; te < textElements.getLength(); ++te) {
                        comments = comments + textElements.item(te).getNodeValue();
                    }
                    this.setComments(comments);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Session can have only one comment entry. ");
            }
        }
        if ((language = sessionElement.getAttribute("lang")) != null && !"".equals(language.trim())) {
            this.setLanguage(language);
        }
        child = null;
        children = sessionElement.getElementsByTagName("image");
        String image = "";
        if (children == null) return;
        for (int i = 0; i < children.getLength(); ++i) {
            child = (Element)children.item(i);
            if (child == null) throw new SchemaException("Problem while retrieving image of session. ");
            NodeList textElements = child.getChildNodes();
            if (textElements == null || textElements.getLength() <= 0) continue;
            for (int te = 0; te < textElements.getLength(); ++te) {
                image = image + textElements.item(te).getNodeValue();
            }
            image = image.replace('/', File.separatorChar);
            image = image.replace('\\', File.separatorChar);
            this.addImage(image);
            image = "";
        }
    }

    public Session(Calendar begin, Calendar end, ISite site) throws IllegalArgumentException {
        this.setBegin(begin);
        this.setEnd(end);
        this.setSite(site);
    }

    public String getDisplayName() {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        df.setCalendar(this.getBegin());
        String result = df.format(this.getBegin().getTime()) + " - ";
        df.setCalendar(this.getEnd());
        result = result + df.format(this.getEnd().getTime());
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Session: Begin=");
        buffer.append(DateConverter.toISO8601((Calendar)this.begin));
        buffer.append(" End=");
        buffer.append(DateConverter.toISO8601((Calendar)this.end));
        buffer.append(" Site=");
        buffer.append(this.site);
        if (this.weather != null) {
            buffer.append(" Weather=");
            buffer.append(this.weather);
        }
        if (this.equipment != null) {
            buffer.append(" Equipment=");
            buffer.append(this.equipment);
        }
        if (this.comments != null) {
            buffer.append(" Comments=");
            buffer.append(this.comments);
        }
        if (this.coObservers != null) {
            buffer.append(" coobservers=");
            buffer.append(this.coObservers);
        }
        if (this.images != null && this.images.size() > 0) {
            buffer.append(" Images=");
            ListIterator imageIterator = this.images.listIterator();
            while (imageIterator.hasNext()) {
                buffer.append(imageIterator.next());
                if (!imageIterator.hasNext()) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("session");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Session = ownerDoc.createElement("session");
        e_Session.setAttribute("id", super.getID());
        element.appendChild(e_Session);
        Element e_Begin = ownerDoc.createElement("begin");
        Text n_BeginText = ownerDoc.createTextNode(DateConverter.toISO8601((Calendar)this.begin));
        e_Begin.appendChild(n_BeginText);
        e_Session.appendChild(e_Begin);
        Element e_End = ownerDoc.createElement("end");
        Text n_EndText = ownerDoc.createTextNode(DateConverter.toISO8601((Calendar)this.end));
        e_End.appendChild(n_EndText);
        e_Session.appendChild(e_End);
        this.site.addAsLinkToXmlElement(e_Session);
        if (this.coObservers != null && !this.coObservers.isEmpty()) {
            ListIterator iterator = this.coObservers.listIterator();
            IObserver coObserver = null;
            while (iterator.hasNext()) {
                coObserver = (IObserver)iterator.next();
                coObserver.addAsLinkToXmlElement(e_Session, "coObserver");
            }
        }
        if (this.weather != null) {
            Element e_Weather = ownerDoc.createElement("weather");
            CDATASection n_WeatherText = ownerDoc.createCDATASection(this.weather);
            e_Weather.appendChild(n_WeatherText);
            e_Session.appendChild(e_Weather);
        }
        if (this.equipment != null) {
            Element e_Equipment = ownerDoc.createElement("equipment");
            CDATASection n_EquipmentText = ownerDoc.createCDATASection(this.equipment);
            e_Equipment.appendChild(n_EquipmentText);
            e_Session.appendChild(e_Equipment);
        }
        if (this.comments != null) {
            Element e_Comments = ownerDoc.createElement("comments");
            CDATASection n_CommentsText = ownerDoc.createCDATASection(this.comments);
            e_Comments.appendChild(n_CommentsText);
            e_Session.appendChild(e_Comments);
        }
        if (this.images != null && !this.images.isEmpty()) {
            ListIterator imagesIterator = this.images.listIterator();
            Element e_currentImage = null;
            CDATASection n_ImageText = null;
            String path = null;
            while (imagesIterator.hasNext()) {
                e_currentImage = ownerDoc.createElement("image");
                path = (String)imagesIterator.next();
                path = path.replace('\\', '/');
                n_ImageText = ownerDoc.createCDATASection(path);
                e_currentImage.appendChild(n_ImageText);
                e_Session.appendChild(e_currentImage);
            }
        }
        if (this.lang != null) {
            e_Session.setAttribute("lang", this.lang);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("session");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Sessions = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("sessions");
            boolean created = false;
            if (nodeList.getLength() == 0) {
                e_Sessions = ownerDoc.createElement("sessions");
                created = true;
            } else {
                e_Sessions = (Element)nodeList.item(0);
            }
            e_Sessions = this.addToXmlElement(e_Sessions);
            if (created) {
                ownerDoc.getDocumentElement().appendChild(e_Sessions);
            }
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public Calendar getBegin() {
        return (Calendar)this.begin.clone();
    }

    public String getComments() {
        return this.comments;
    }

    public Calendar getEnd() {
        return (Calendar)this.end.clone();
    }

    public ISite getSite() {
        return this.site;
    }

    public String getEquipment() {
        return this.equipment;
    }

    public String getWeather() {
        return this.weather;
    }

    public String getLanguage() {
        return this.lang;
    }

    public List getImages() {
        if (this.images == null || this.images.isEmpty()) {
            return null;
        }
        return this.images;
    }

    public void setBegin(Calendar begin) throws IllegalArgumentException {
        if (begin == null) {
            throw new IllegalArgumentException("Start date cannot be null. ");
        }
        this.begin = (Calendar)begin.clone();
    }

    public void setComments(String comments) {
        if (comments != null && "".equals(comments.trim())) {
            this.comments = null;
            return;
        }
        this.comments = comments;
    }

    public void setEnd(Calendar end) throws IllegalArgumentException {
        if (end == null) {
            throw new IllegalArgumentException("End date cannot be null. ");
        }
        this.end = (Calendar)end.clone();
    }

    public void setEquipment(String equipment) {
        if (equipment != null && "".equals(equipment.trim())) {
            this.equipment = null;
            return;
        }
        this.equipment = equipment;
    }

    public void setSite(ISite site) throws IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("Site cannot be null. ");
        }
        this.site = site;
    }

    public boolean setCoObservers(List coObservers) {
        if (coObservers == null) {
            this.coObservers = null;
            return true;
        }
        ListIterator iterator = coObservers.listIterator();
        IObserver current = null;
        if (iterator.hasNext()) {
            try {
                current = (IObserver)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.coObservers.clear();
        this.coObservers.addAll(coObservers);
        return true;
    }

    public boolean addCoObservers(List coObservers) {
        if (coObservers == null) {
            return true;
        }
        ListIterator iterator = coObservers.listIterator();
        IObserver current = null;
        if (iterator.hasNext()) {
            try {
                current = (IObserver)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.coObservers.addAll(coObservers);
        return true;
    }

    public boolean addCoObserver(IObserver coObserver) {
        if (coObserver == null) {
            return false;
        }
        this.coObservers.add(coObserver);
        return true;
    }

    public List getCoObservers() {
        return this.coObservers;
    }

    public void setWeather(String weather) {
        if (weather != null && "".equals(weather.trim())) {
            this.weather = null;
            return;
        }
        this.weather = weather;
    }

    public void setLanguage(String language) {
        if (language != null && "".equals(language.trim())) {
            this.lang = null;
            return;
        }
        this.lang = language;
    }

    public boolean addImages(List images) {
        if (images == null || images.isEmpty()) {
            return false;
        }
        ListIterator iterator = images.listIterator();
        String current = null;
        while (iterator.hasNext()) {
            try {
                current = (String)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.images.addAll(images);
        return true;
    }

    public void addImage(String imagePath) {
        if (imagePath == null) {
            return;
        }
        this.images.add(imagePath);
    }

    public boolean setImages(List imagesList) throws IllegalArgumentException {
        if (imagesList == null) {
            throw new IllegalArgumentException("Images list cannot be null. ");
        }
        if (imagesList.isEmpty()) {
            this.images.clear();
            return true;
        }
        ListIterator iterator = imagesList.listIterator();
        String current = null;
        if (iterator.hasNext()) {
            try {
                current = (String)iterator.next();
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
        this.images = imagesList;
        return true;
    }
}

