/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.util.IIDGenerator;
import de.lehmannet.om.util.UIDGenerator;
import de.lehmannet.om.util.UUIDGenerator;

public abstract class SchemaElement
implements ISchemaElement {
    private static IIDGenerator IDGenerator;
    private String ID = new String();

    public SchemaElement() {
        this.ID = IDGenerator.generateUID();
    }

    SchemaElement(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null or empty! ");
        }
        this.ID = id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ISchemaElement)) {
            return false;
        }
        ISchemaElement schemaElement = (ISchemaElement)obj;
        return this.getID().equals(schemaElement.getID());
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String newID) {
        this.ID = newID;
    }

    public abstract String getDisplayName();

    static {
        boolean after14;
        IDGenerator = null;
        String vmVersion = System.getProperty("java.version");
        boolean bl = after14 = !vmVersion.startsWith("1.4");
        if (after14) {
            try {
                IDGenerator = new UUIDGenerator();
            }
            catch (Exception e) {
                System.err.println("Cannot create UUID Generator. Try to get UIDGenerator...");
                IDGenerator = new UIDGenerator();
            }
        } else {
            IDGenerator = new UIDGenerator();
        }
    }
}

