/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.Angle;
import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Eyepiece
extends SchemaElement
implements IEyepiece {
    private String model = new String();
    private String vendor = null;
    private float focalLength = Float.NaN;
    private float maxFocalLength = Float.NaN;
    private Angle apparentFOV = null;
    private boolean available = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Eyepiece(Node eyepiece) throws SchemaException, IllegalArgumentException {
        if (eyepiece == null) {
            throw new IllegalArgumentException("Parameter eyepiece node cannot be NULL. ");
        }
        Element eyepieceElement = (Element)eyepiece;
        NodeList children = null;
        Element child = null;
        String ID = eyepieceElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Eyepiece must have a ID. ");
        }
        super.setID(ID);
        children = eyepieceElement.getElementsByTagName("model");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Eyepiece must have exact one model name. ");
        }
        child = (Element)children.item(0);
        String model = "";
        if (child == null) {
            throw new SchemaException("Eyepiece must have a model name. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Eyepiece cannot have an empty model name. ");
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te = 0; te < textElements.getLength(); ++te) {
                model = model + textElements.item(te).getNodeValue();
            }
            this.setModel(model);
        }
        child = null;
        children = eyepieceElement.getElementsByTagName("focalLength");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Eyepiece must have exact one focal length. ");
        }
        child = (Element)children.item(0);
        String focalLength = null;
        if (child == null) {
            throw new SchemaException("Eyepiece must have a focal length. ");
        }
        focalLength = child.getFirstChild().getNodeValue();
        this.setFocalLength(FloatUtil.parseFloat((String)focalLength));
        NodeList list = eyepieceElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = list.item(i);
            if (c.getNodeType() != 8 || !"Element no longer available".equals(c.getNodeValue())) continue;
            this.available = false;
            break;
        }
        child = null;
        children = eyepieceElement.getElementsByTagName("vendor");
        String vendor = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving vendor from eyepiece. ");
                NodeList textElements2 = child.getChildNodes();
                if (textElements2 != null && textElements2.getLength() > 0) {
                    for (int te = 0; te < textElements2.getLength(); ++te) {
                        vendor = vendor + textElements2.item(te).getNodeValue();
                    }
                    this.setVendor(vendor);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Eyepiece can have only one vendor. ");
            }
        }
        child = null;
        children = eyepieceElement.getElementsByTagName("maxFocalLength");
        String maxFL = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving max focal length from eyepiece. ");
                maxFL = child.getFirstChild().getNodeValue();
                if (maxFL != null) {
                    this.setMaxFocalLength(FloatUtil.parseFloat((String)maxFL));
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Eyepiece can have only one max focal length. ");
            }
        }
        child = null;
        children = eyepieceElement.getElementsByTagName("apparentFOV");
        Angle apparentFOV = null;
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem while retrieving apparent field of view from eyepiece. ");
            String value = child.getFirstChild().getNodeValue();
            String unit = child.getAttribute("unit");
            apparentFOV = new Angle(Double.parseDouble(value), unit);
            if (apparentFOV == null) return;
            this.setApparentFOV(apparentFOV);
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Eyepiece can have only one apparent field of view. ");
        }
    }

    public Eyepiece(String model, float focalLength) throws IllegalArgumentException {
        this.setModel(model);
        this.setFocalLength(focalLength);
    }

    public String getDisplayName() {
        String dn = this.getModel() + " " + this.getFocalLength();
        if (this.isZoomEyepiece()) {
            dn = dn + "-" + this.getMaxFocalLength();
        }
        if (this.vendor != null && !"".equals(this.vendor.trim())) {
            dn = this.getVendor() + " " + dn;
        }
        return dn;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Eyepiece Model: ");
        buffer.append(this.getModel());
        if (this.vendor != null) {
            buffer.append("Vendor: ");
            buffer.append(this.getVendor());
        }
        buffer.append("Focal length: ");
        buffer.append(this.getFocalLength());
        if (this.apparentFOV != null) {
            buffer.append("Apparent field of view: ");
            buffer.append(this.getApparentFOV());
        }
        if (!Float.isNaN(this.maxFocalLength)) {
            buffer.append("Maximal focal length: ");
            buffer.append(this.getMaxFocalLength());
        }
        return buffer.toString();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailability(boolean available) {
        this.available = available;
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("eyepiece");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Eyepiece = ownerDoc.createElement("eyepiece");
        e_Eyepiece.setAttribute("id", super.getID());
        element.appendChild(e_Eyepiece);
        if (!this.isAvailable()) {
            Comment comment = ownerDoc.createComment("Element no longer available");
            e_Eyepiece.appendChild(comment);
        }
        Element e_Model = ownerDoc.createElement("model");
        CDATASection n_ModelText = ownerDoc.createCDATASection(this.model);
        e_Model.appendChild(n_ModelText);
        e_Eyepiece.appendChild(e_Model);
        if (this.vendor != null) {
            Element e_Vendor = ownerDoc.createElement("vendor");
            CDATASection n_VendorText = ownerDoc.createCDATASection(this.vendor);
            e_Vendor.appendChild(n_VendorText);
            e_Eyepiece.appendChild(e_Vendor);
        }
        Element e_FocalLength = ownerDoc.createElement("focalLength");
        Text n_FocalLengthText = ownerDoc.createTextNode(Float.toString(this.focalLength));
        e_FocalLength.appendChild(n_FocalLengthText);
        e_Eyepiece.appendChild(e_FocalLength);
        if (!Float.isNaN(this.maxFocalLength)) {
            Element e_MaxFocalLength = ownerDoc.createElement("maxFocalLength");
            Text n_MaxFocalLengthText = ownerDoc.createTextNode(Float.toString(this.maxFocalLength));
            e_MaxFocalLength.appendChild(n_MaxFocalLengthText);
            e_Eyepiece.appendChild(e_MaxFocalLength);
        }
        if (this.apparentFOV != null) {
            Element e_ApparentFOV = ownerDoc.createElement("apparentFOV");
            e_ApparentFOV = this.apparentFOV.setToXmlElement(e_ApparentFOV);
            e_Eyepiece.appendChild(e_ApparentFOV);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("eyepiece");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Eyepieces = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("eyepieces");
            if (nodeList.getLength() == 0) {
                e_Eyepieces = ownerDoc.createElement("eyepieces");
                ownerDoc.getDocumentElement().appendChild(e_Eyepieces);
            } else {
                e_Eyepieces = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Eyepieces);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public Angle getApparentFOV() {
        return this.apparentFOV;
    }

    public float getFocalLength() {
        return this.focalLength;
    }

    public float getMaxFocalLength() {
        return this.maxFocalLength;
    }

    public String getModel() {
        return this.model;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean isZoomEyepiece() {
        return !Float.isNaN(this.maxFocalLength);
    }

    public boolean setApparentFOV(Angle apparentFOV) {
        if (apparentFOV == null || apparentFOV.getValue() <= 0.0) {
            return false;
        }
        this.apparentFOV = apparentFOV;
        return true;
    }

    public void setFocalLength(float focalLength) throws IllegalArgumentException {
        if (Float.isNaN(focalLength)) {
            throw new IllegalArgumentException("Focal length cannot be Float.NaN. ");
        }
        this.focalLength = focalLength;
    }

    public void setMaxFocalLength(float maxFocalLength) {
        this.maxFocalLength = maxFocalLength;
    }

    public void setModel(String modelname) throws IllegalArgumentException {
        if (modelname == null) {
            throw new IllegalArgumentException("Modelname cannot be null. ");
        }
        this.model = modelname;
    }

    public void setVendor(String vendorname) {
        if (vendorname != null && "".equals(vendorname.trim())) {
            this.vendor = null;
            return;
        }
        this.vendor = vendorname;
    }
}

