/*
 * Decompiled with CFR 0.152.
 */
package eap.fitsbrowser;

import eap.filter.FilterBroker;
import eap.filter.PasswordProvider;
import eap.filter.PopupPasswordProvider;
import eap.fits.FitsData;
import eap.fits.FitsFile;
import eap.fits.FitsHDU;
import eap.fits.FitsHeader;
import eap.fits.InputStreamFitsFile;
import eap.fits.NoSuchFitsHDUException;
import eap.fits.RandomAccessFitsFile;
import eap.fitsbrowser.HDUDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;

public class FITSFileDisplay
extends JTabbedPane {
    JMenuBar menu_bar;
    JFileChooser file_chooser;
    JTabbedPane tabs;
    FitsFile fits;
    IOException background_exception;
    FilterBroker filters = new FilterBroker();

    public FITSFileDisplay() {
        try {
            this.filters.addDefaultFilters();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.filters.setPasswordProvider(new PopupPasswordProvider(this));
    }

    public void setPasswordProvider(PasswordProvider passwordProvider) {
        this.filters.setPasswordProvider(passwordProvider);
    }

    public void load(String string) throws IOException {
        try {
            this.load(new URL(string));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.load(new File(string));
            return;
        }
    }

    public void load(File file) throws IOException {
        FileInputStream fileInputStream;
        InputStream inputStream;
        if (this.filters.hasFilter(file.getName()) && (inputStream = this.filters.filter(fileInputStream = new FileInputStream(file), file.getName())) != fileInputStream) {
            this.load(inputStream);
            return;
        }
        this.load(new RandomAccessFitsFile(new RandomAccessFile(file, "r")));
    }

    public void load(URL uRL) throws IOException {
        this.load(this.filters.filter(uRL.openStream(), uRL.getPath()));
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamFitsFile(inputStream));
    }

    public void save(File file) throws IOException {
        this.fits.write(new FileOutputStream(file));
    }

    public void load(FitsFile fitsFile) throws IOException {
        this.fits = fitsFile;
        this.removeAll();
        try {
            int n = 0;
            while (true) {
                FitsHDU fitsHDU = fitsFile.getHDU(n);
                FitsData fitsData = fitsHDU.getData();
                FitsHeader fitsHeader = fitsHDU.getHeader();
                this.add(n + ". " + fitsHeader.getName() + " (" + fitsHeader.getType() + ")", new HDUDisplay(fitsHDU));
                ++n;
            }
        }
        catch (NoSuchFitsHDUException noSuchFitsHDUException) {
            return;
        }
    }
}

