/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsCardException;
import java.io.UnsupportedEncodingException;

public class FitsCard {
    public static final int LENGTH = 80;
    public static final int KEY_LENGTH = 8;
    public static final int CARDS_PER_BLOCK = 36;
    public static final byte[] PADDING = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private byte[] data;
    private String key;
    private boolean parsed;
    private Object value;
    private String comment;

    public FitsCard(byte[] byArray) {
        this(byArray, 0);
    }

    public FitsCard(byte[] byArray, int n) {
        this.initializeStorage();
        System.arraycopy(byArray, n, this.data, 0, 80);
        try {
            this.key = new String(this.data, 0, 8, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("unsupported encoding exception");
        }
        this.key = this.key.trim();
        this.parsed = false;
    }

    public FitsCard(String string) {
        this(string, "");
    }

    public FitsCard(String string, String string2) {
        this.initializeStorage();
        this.key = this.writeKeywordToData(string);
        this.comment = this.writeCommentToData(string2, 8);
        this.parsed = true;
    }

    public FitsCard(String string, String string2, String string3) {
        this.initializeStorage();
        this.key = this.writeKeywordToData(string);
        int n = 8;
        this.data[n++] = 61;
        this.data[n++] = 32;
        this.data[n++] = 39;
        int n2 = 80 - n - 1;
        if (string2.length() > n2) {
            string2 = string2.substring(0, n2);
        }
        try {
            byte[] byArray = string2.getBytes("ASCII");
            for (int i = 0; i < byArray.length; ++i) {
                this.data[n++] = byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.data[n++] = 39;
        this.value = string2;
        this.comment = this.writeCommentToData(string3, n);
        this.parsed = true;
    }

    public FitsCard(String string, boolean bl, String string2) {
        this(string, new Boolean(bl), string2);
    }

    public FitsCard(String string, Boolean bl, String string2) {
        this.initializeStorage();
        this.key = this.writeKeywordToData(string);
        int n = 8;
        this.data[n++] = 61;
        while (n < 29) {
            this.data[n++] = 32;
        }
        this.data[n++] = bl != false ? 84 : 70;
        this.value = bl;
        this.comment = this.writeCommentToData(string2, n);
        this.parsed = true;
    }

    public FitsCard(String string, int n, String string2) {
        this(string, new Long(n), string2);
    }

    public FitsCard(String string, long l, String string2) {
        this(string, new Long(l), string2);
    }

    public FitsCard(String string, float f, String string2) {
        this(string, new Double(f), string2);
    }

    public FitsCard(String string, double d, String string2) {
        this(string, new Double(d), string2);
    }

    public FitsCard(String string, Number number, String string2) {
        this.initializeStorage();
        this.key = this.writeKeywordToData(string);
        int n = 8;
        this.data[n++] = 61;
        String string3 = number.toString();
        int n2 = 29 - string3.length() + 1;
        while (n < n2) {
            this.data[n++] = 32;
        }
        try {
            byte[] byArray = string3.getBytes("ASCII");
            for (int i = 0; i < byArray.length; ++i) {
                this.data[n++] = byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
        }
        this.value = number;
        this.comment = this.writeCommentToData(string2, n);
        this.parsed = true;
    }

    private void initializeStorage() {
        this.data = new byte[80];
    }

    private String writeKeywordToData(String string) {
        String string2 = FitsCard.formatKeyword(string);
        int n = 0;
        try {
            byte[] byArray = string2.getBytes("ASCII");
            for (int i = 0; i < byArray.length && n < 8; ++i) {
                this.data[n++] = byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (int i = n; i < 8; ++i) {
            this.data[i] = 32;
        }
        return string2;
    }

    private String writeCommentToData(String string, int n) {
        if (n == 8) {
            this.data[n++] = 32;
            this.data[n++] = 32;
        } else {
            if (n >= 76) {
                return "";
            }
            this.data[n++] = 32;
            if (string.length() + 2 < 49) {
                while (n < 31) {
                    this.data[n++] = 32;
                }
            }
            this.data[n++] = 47;
            this.data[n++] = 32;
        }
        int n2 = 80 - n;
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        try {
            byte[] byArray = string.getBytes("ASCII");
            for (int i = 0; i < byArray.length; ++i) {
                this.data[n++] = byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        while (n < 80) {
            this.data[n++] = 32;
        }
        return string;
    }

    public byte[] data() {
        return this.data;
    }

    public String key() {
        return this.key;
    }

    public Object value() throws FitsCardException {
        this.parse();
        return this.value;
    }

    public int intValue() throws FitsCardException {
        return ((Number)this.value()).intValue();
    }

    public double doubleValue() throws FitsCardException {
        return ((Number)this.value()).doubleValue();
    }

    public String stringValue() throws FitsCardException {
        return this.value().toString();
    }

    public String comment() throws FitsCardException {
        this.parse();
        return this.comment;
    }

    private void parse() throws FitsCardException {
        if (this.parsed) {
            return;
        }
        if (this.data[8] != 61) {
            this.value = null;
            this.comment = new String(this.data, 8, 71);
        } else {
            int n;
            for (n = 10; n < 80 && this.data[n] == 32; ++n) {
            }
            if (n == 80) {
                this.value = null;
                this.comment = "";
            } else {
                if (this.data[n] == 47) {
                    this.value = null;
                } else {
                    Object object;
                    int n2;
                    if (this.data[n] == 39) {
                        n2 = 0;
                        object = new byte[68];
                        ++n;
                        while (true) {
                            if (n == 80) {
                                throw new FitsCardException("No closing quote for " + this);
                            }
                            if (this.data[n] == 39) {
                                if (n < 79 && this.data[n + 1] != 39) {
                                    ++n;
                                    break;
                                }
                                object[n2++] = this.data[n++];
                                ++n;
                                continue;
                            }
                            object[n2++] = this.data[n++];
                        }
                        while (n2 > 1 && object[n2 - 1] == 32) {
                            --n2;
                        }
                        try {
                            this.value = new String((byte[])object, 0, n2, "ASCII");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new FitsCardException("Java doesn't understand ASCII encoding");
                        }
                    }
                    n2 = n;
                    while (n < 80 && this.data[n] != 32 && this.data[n] != 47) {
                        ++n;
                    }
                    try {
                        object = new String(this.data, n2, n - n2, "ASCII");
                        this.value = new Double((String)object);
                    }
                    catch (Exception exception) {
                        throw new FitsCardException("Ill formed number in " + this);
                    }
                    while (n < 80 && this.data[n] == 32) {
                        ++n;
                    }
                    if (n < 80 && (Character.isDigit((char)this.data[n]) || this.data[n] == 43 || this.data[n] == 45)) {
                        throw new FitsCardException("Complex numbers not supported " + this);
                    }
                }
                while (n < 80 && this.data[n] == 32) {
                    ++n;
                }
                if (n < 80 && this.data[n] == 47) {
                    ++n;
                }
                if (n < 80) {
                    try {
                        this.comment = new String(this.data, n, 80 - n, "ASCII").trim();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new FitsCardException("Java doesn't understand ASCII");
                    }
                } else {
                    this.comment = "";
                }
            }
        }
    }

    public String toString() {
        return new String(this.data).trim();
    }

    public static String formatKeyword(String string) {
        string = string.trim().toUpperCase();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() && n < 8; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_') continue;
            stringBuffer.append(string.charAt(i));
            ++n;
        }
        return stringBuffer.toString();
    }
}

