/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsColumn;
import eap.fits.FitsException;
import eap.fits.FitsHeader;

public class FitsBinaryColumn
extends FitsColumn {
    public FitsBinaryColumn(FitsHeader fitsHeader, int n) throws FitsException {
        block42: {
            int n2;
            super(fitsHeader, n);
            for (n2 = 1; n2 <= this.form.length(); ++n2) {
                try {
                    this.count = Integer.parseInt(this.form.substring(0, n2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (n2 != 1) break;
                    this.count = 1;
                    break;
                }
            }
            --n2;
            try {
                this.type = this.form.charAt(n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new FitsException("Can't parse TFORM" + n + " " + this.form);
            }
            if (this.type == 'P') {
                this.count = -1;
                ++n2;
                try {
                    this.type = this.form.charAt(n2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new FitsException("Can't parse TFORM" + n + " " + this.form);
                }
            }
            if (this.type == 'X') {
                this.count = (this.count + 7) / 8;
            }
            if (this.type == 'C' || this.type == 'M') {
                this.count *= 2;
            }
            try {
                if (this.type == 'L') {
                    this.representation = Class.forName("java.lang.Boolean");
                    break block42;
                }
                if (this.type == 'X') {
                    this.representation = Class.forName("java.lang.Byte");
                    break block42;
                }
                if (this.type == 'A') {
                    this.representation = Class.forName("java.lang.String");
                    break block42;
                }
                if (this.type == 'B') {
                    this.representation = Class.forName("java.lang.Integer");
                    break block42;
                }
                if (this.type == 'I') {
                    this.representation = Class.forName("java.lang.Short");
                    break block42;
                }
                if (this.type == 'J') {
                    this.representation = Class.forName("java.lang.Integer");
                    break block42;
                }
                if (this.type == 'E') {
                    this.representation = Class.forName("java.lang.Float");
                    break block42;
                }
                if (this.type == 'D') {
                    this.representation = Class.forName("java.lang.Double");
                    break block42;
                }
                if (this.type == 'C') {
                    this.representation = Class.forName("java.lang.Float");
                    break block42;
                }
                if (this.type == 'M') {
                    this.representation = Class.forName("java.lang.Double");
                    break block42;
                }
                throw new FitsException("Unsupported data type " + this.type + " in " + this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
                throw new FitsException("Unknown class in " + this);
            }
        }
        if (this.type == 'L') {
            this.bytes = 1;
        } else if (this.type == 'X') {
            this.bytes = 1;
        } else if (this.type == 'A') {
            this.bytes = 1;
        } else if (this.type == 'B') {
            this.bytes = 1;
        } else if (this.type == 'I') {
            this.bytes = 2;
        } else if (this.type == 'J') {
            this.bytes = 4;
        } else if (this.type == 'E') {
            this.bytes = 4;
        } else if (this.type == 'D') {
            this.bytes = 8;
        } else if (this.type == 'C') {
            this.bytes = 4;
        } else if (this.type == 'M') {
            this.bytes = 8;
        } else {
            throw new FitsException("Unsupported data type " + this.type + " in " + this);
        }
    }
}

