/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.util;

import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.DatePicker;
import de.lehmannet.om.util.DateConverter;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

class JulianDateDialog
extends JDialog
implements ActionListener {
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private Calendar calendar = null;
    private TimeZone timeZone = null;
    private JButton cancel = null;
    private JButton ok = null;
    private JTextField jdString = null;

    public JulianDateDialog(DatePicker dp, TimeZone tz) {
        super((Dialog)dp, true);
        this.timeZone = tz;
        super.setTitle(this.bundle.getString("julianDateDialog.title"));
        super.setSize(350, 90);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(dp);
        this.initDialog();
        this.setVisible(true);
        this.pack();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.cancel)) {
                this.dispose();
            } else if (source.equals(this.ok)) {
                String jdString = this.jdString.getText();
                try {
                    double jd = Double.parseDouble(jdString);
                    this.calendar = DateConverter.toGregorianDate((double)jd, (TimeZone)this.timeZone);
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("julianDateDialog.warning.wrongFormat"), this.bundle.getString("title.warning"), 2);
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("julianDateDialog.warning.wrongFormat"), this.bundle.getString("title.warning"), 2);
                }
                this.dispose();
            }
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 10, 50);
        constraints.fill = 2;
        JLabel jdLabel = new JLabel(this.bundle.getString("julianDateDialog.label.JDField"));
        jdLabel.setToolTipText(this.bundle.getString("julianDateDialog.tooltip.JDField"));
        gridbag.setConstraints(jdLabel, constraints);
        super.getContentPane().add(jdLabel);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 30, 50);
        constraints.fill = 2;
        this.jdString = new JTextField();
        String now = "" + DateConverter.toJulianDate((Calendar)Calendar.getInstance());
        now = now.substring(0, now.indexOf(46));
        this.jdString.setText(now);
        this.jdString.setEditable(true);
        this.jdString.setToolTipText(this.bundle.getString("julianDateDialog.tooltip.JDField"));
        gridbag.setConstraints(this.jdString, constraints);
        super.getContentPane().add(this.jdString);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 30, 50);
        constraints.fill = 2;
        this.ok = new JButton(this.bundle.getString("dialog.button.ok"));
        this.ok.addActionListener(this);
        gridbag.setConstraints(this.ok, constraints);
        super.getContentPane().add(this.ok);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 30, 50);
        constraints.fill = 2;
        this.cancel = new JButton(this.bundle.getString("dialog.button.cancel"));
        this.cancel.addActionListener(this);
        gridbag.setConstraints(this.cancel, constraints);
        super.getContentPane().add(this.cancel);
    }
}

