/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.util;

import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.JulianDateDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DatePicker
extends JDialog {
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private JButton[] fields = new JButton[37];
    private JLabel monthYearLabel = null;
    private int day = Calendar.getInstance().get(5);
    private int month = Calendar.getInstance().get(2);
    private int year = Calendar.getInstance().get(1);
    private Calendar calendar = null;
    private TimeZone timeZone = null;

    public DatePicker(JFrame parent, String title) {
        super((Frame)parent, true);
        this.initDialog();
        this.setDates();
        super.setTitle(title);
        super.setSize(500, 330);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setResizable(false);
    }

    public DatePicker(JFrame parent, String title, TimeZone timeZone) {
        super((Frame)parent, true);
        this.timeZone = timeZone;
        this.initDialog();
        this.setDates();
        super.setTitle(title);
        super.setSize(500, 250);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setResizable(false);
    }

    public DatePicker(JFrame parent, String title, Calendar cal) {
        super((Frame)parent, true);
        this.day = cal.get(5);
        this.month = cal.get(2);
        this.year = cal.get(1);
        this.initDialog();
        this.setDates();
        super.setTitle(title);
        super.setSize(500, 250);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setResizable(false);
    }

    public DatePicker(JFrame parent, String title, Calendar cal, TimeZone timeZone) {
        super((Frame)parent, true);
        this.timeZone = timeZone;
        this.day = cal.get(5);
        this.month = cal.get(2);
        this.year = cal.get(1);
        this.initDialog();
        this.setDates();
        super.setTitle(title);
        super.setSize(500, 250);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setResizable(false);
    }

    public Calendar getDate() {
        if (this.calendar != null) {
            return this.calendar;
        }
        GregorianCalendar cal = new GregorianCalendar(this.year, this.month, this.day);
        return cal;
    }

    public String getDateString() {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        df.setCalendar(this.getDate());
        return df.format(this.getDate().getTime());
    }

    private void initDialog() {
        String[] header = new String[]{this.bundle.getString("datePicker.sun"), this.bundle.getString("datePicker.mon"), this.bundle.getString("datePicker.tue"), this.bundle.getString("datePicker.wed"), this.bundle.getString("datePicker.thu"), this.bundle.getString("datePicker.fri"), this.bundle.getString("datePicker.sat")};
        JPanel headerPanel = new JPanel(new GridLayout(1, 7));
        for (int x = 0; x < header.length; ++x) {
            headerPanel.add(new JLabel(header[x], 0));
        }
        super.getContentPane().add((Component)headerPanel, "North");
        JPanel centerPanel = new JPanel(new GridLayout(6, 7));
        JButton currentButton = null;
        for (int x = 0; x < this.fields.length; ++x) {
            currentButton = new JButton();
            currentButton.setFocusPainted(false);
            currentButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() instanceof JButton) {
                        DatePicker.this.day = Integer.parseInt(((JButton)event.getSource()).getText());
                        DatePicker.this.dispose();
                    }
                }
            });
            this.fields[x] = currentButton;
            centerPanel.add(this.fields[x]);
        }
        super.getContentPane().add((Component)centerPanel, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel footerPanel = new JPanel(gridbag);
        JButton prevYearButton = new JButton(this.bundle.getString("datePicker.button.previousYear"));
        prevYearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DatePicker.this.year--;
                DatePicker.this.setDates();
                DatePicker.this.monthYearLabel.setText("" + (DatePicker.this.month + 1) + "/" + DatePicker.this.year);
            }
        });
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 20, 50);
        constraints.fill = 2;
        gridbag.setConstraints(prevYearButton, constraints);
        footerPanel.add(prevYearButton);
        JButton prevButton = new JButton(this.bundle.getString("datePicker.button.previous"));
        prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (DatePicker.this.month == 0) {
                    DatePicker.this.month = 11;
                    DatePicker.this.year--;
                } else {
                    DatePicker.this.month--;
                }
                DatePicker.this.setDates();
                DatePicker.this.monthYearLabel.setText("" + (DatePicker.this.month + 1) + "/" + DatePicker.this.year);
            }
        });
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 20, 50);
        constraints.fill = 2;
        gridbag.setConstraints(prevButton, constraints);
        footerPanel.add(prevButton);
        this.monthYearLabel = new JLabel("" + (this.month + 1) + "/" + this.year, 0);
        ConstraintsBuilder.buildConstraints(constraints, 2, 0, 1, 1, 20, 50);
        constraints.fill = 2;
        gridbag.setConstraints(this.monthYearLabel, constraints);
        footerPanel.add(this.monthYearLabel);
        JButton nextButton = new JButton(this.bundle.getString("datePicker.button.next"));
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (DatePicker.this.month == 11) {
                    DatePicker.this.month = 0;
                    DatePicker.this.year++;
                } else {
                    DatePicker.this.month++;
                }
                DatePicker.this.setDates();
                DatePicker.this.monthYearLabel.setText("" + (DatePicker.this.month + 1) + "/" + DatePicker.this.year);
            }
        });
        ConstraintsBuilder.buildConstraints(constraints, 3, 0, 1, 1, 20, 50);
        constraints.fill = 2;
        gridbag.setConstraints(nextButton, constraints);
        footerPanel.add(nextButton);
        JButton nextYearButton = new JButton(this.bundle.getString("datePicker.button.nextYear"));
        nextYearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DatePicker.this.year++;
                DatePicker.this.setDates();
                DatePicker.this.monthYearLabel.setText("" + (DatePicker.this.month + 1) + "/" + DatePicker.this.year);
            }
        });
        ConstraintsBuilder.buildConstraints(constraints, 4, 0, 1, 1, 20, 50);
        constraints.fill = 2;
        gridbag.setConstraints(nextYearButton, constraints);
        footerPanel.add(nextYearButton);
        JButton julianDateButton = new JButton(this.bundle.getString("datePicker.button.julianDate"));
        julianDateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JulianDateDialog jdd = new JulianDateDialog(DatePicker.this, DatePicker.this.timeZone);
                Calendar jdc = jdd.getCalendar();
                DatePicker.this.calendar = jdc;
                if (DatePicker.this.calendar != null) {
                    DatePicker.this.dispose();
                }
            }
        });
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 5, 1, 100, 50);
        constraints.fill = 2;
        gridbag.setConstraints(julianDateButton, constraints);
        footerPanel.add(julianDateButton);
        super.getContentPane().add((Component)footerPanel, "South");
        super.pack();
    }

    private void setDates() {
        for (int x = 0; x < this.fields.length; ++x) {
            this.fields[x].setText("");
            this.fields[x].setEnabled(false);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(this.year, this.month, 1);
        int dayOfWeek = cal.get(7);
        int daysInMonth = cal.getActualMaximum(5);
        Calendar currentDate = Calendar.getInstance();
        int currentMonth = currentDate.get(2);
        int currentYear = currentDate.get(1);
        int currentDay = currentDate.get(5);
        this.day = 1;
        int x = dayOfWeek - 1;
        while (this.day <= daysInMonth) {
            if (this.year == currentYear && this.month == currentMonth && this.day == currentDay) {
                this.fields[x].setForeground(Color.RED);
            } else {
                this.fields[x].setForeground(Color.BLACK);
            }
            this.fields[x].setText(String.valueOf(this.day));
            this.fields[x].setEnabled(true);
            ++x;
            ++this.day;
        }
        super.getContentPane().repaint();
    }
}

