/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.statistics;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.catalog.IListableCatalog;
import de.lehmannet.om.ui.statistics.TargetObservations;

class CatalogTargets {
    private IListableCatalog catalog = null;
    private TargetObservations[] targets = null;
    private int observations = 0;

    public CatalogTargets(IListableCatalog catalog, ITarget[] t) {
        this.catalog = catalog;
        this.targets = new TargetObservations[t.length];
        for (int i = 0; i < t.length; ++i) {
            this.targets[i] = new TargetObservations(t[i]);
        }
    }

    public void checkTarget(IObservation observation) {
        ITarget observedTarget = observation.getTarget();
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.areEqual(this.targets[i].getTarget(), observedTarget) || !this.targets[i].addObservation(observation)) continue;
            ++this.observations;
        }
    }

    public int numberOfObservations() {
        return this.observations;
    }

    public IListableCatalog getCatalog() {
        return this.catalog;
    }

    public TargetObservations[] getTargetObservations() {
        return this.targets;
    }

    private boolean areEqual(ITarget catalogTarget, ITarget observedTarget) {
        String catalogTargetName = catalogTarget.getName();
        String[] catalogTargetAliasNames = catalogTarget.getAliasNames();
        String[] allCatalogTargetNames = null;
        if (catalogTargetAliasNames != null && catalogTargetAliasNames.length > 0) {
            allCatalogTargetNames = new String[catalogTargetAliasNames.length + 1];
            System.arraycopy(catalogTargetAliasNames, 0, allCatalogTargetNames, 0, catalogTargetAliasNames.length);
        } else {
            allCatalogTargetNames = new String[1];
        }
        allCatalogTargetNames[allCatalogTargetNames.length - 1] = catalogTargetName;
        String observedTargetName = observedTarget.getName();
        String[] observedTargetAliasNames = observedTarget.getAliasNames();
        String[] allObservedTargetNames = null;
        if (observedTargetAliasNames != null && observedTargetAliasNames.length > 0) {
            allObservedTargetNames = new String[observedTargetAliasNames.length + 1];
            System.arraycopy(observedTargetAliasNames, 0, allObservedTargetNames, 0, observedTargetAliasNames.length);
        } else {
            allObservedTargetNames = new String[1];
        }
        allObservedTargetNames[allObservedTargetNames.length - 1] = observedTargetName;
        for (int x = allCatalogTargetNames.length - 1; x >= 0; --x) {
            for (int y = allObservedTargetNames.length - 1; y >= 0; --y) {
                if (allCatalogTargetNames[x].equals(allObservedTargetNames[y])) {
                    return true;
                }
                if (!this.formatName(allCatalogTargetNames[x]).equals(this.formatName(allObservedTargetNames[y]))) continue;
                return true;
            }
        }
        return false;
    }

    private String formatName(String name) {
        name = name.toUpperCase();
        name = name.replaceAll(" ", "");
        return name;
    }
}

