/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.panel;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.Session;
import de.lehmannet.om.ui.box.LanguageBox;
import de.lehmannet.om.ui.box.SiteBox;
import de.lehmannet.om.ui.container.ImageContainer;
import de.lehmannet.om.ui.container.TimeContainer;
import de.lehmannet.om.ui.dialog.ObserverDialog;
import de.lehmannet.om.ui.dialog.SchemaElementSelectorPopup;
import de.lehmannet.om.ui.dialog.SiteDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.ObserverPanel;
import de.lehmannet.om.ui.panel.SitePanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.DatePicker;
import de.lehmannet.om.ui.util.EditPopupHandler;
import de.lehmannet.om.ui.util.OMLabel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SessionPanel
extends AbstractPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 3701541525499161393L;
    private ISession session = null;
    private ObservationManager observationManager = null;
    private JTextField begin = null;
    private Calendar beginDate = null;
    private JButton beginPicker = null;
    private JButton beginNow = null;
    private TimeContainer beginTime = null;
    private JTextField end = null;
    private Calendar endDate = null;
    private JButton endPicker = null;
    private JButton endNow = null;
    private TimeContainer endTime = null;
    private JTextArea weather = null;
    private JTextArea equipment = null;
    private JTextArea comments = null;
    private JTextField coObservers = new JTextField();
    private JTabbedPane coObserverTabbedPane = null;
    private JButton selectCoObservers = null;
    private JButton newCoObservers = null;
    private SchemaElementSelectorPopup coObsSelector = null;
    private SiteBox siteBox = null;
    private JButton newSite = null;
    private LanguageBox language = null;
    private ImageContainer imageContainer = null;
    private JButton newImage = null;
    private Map cache = null;
    private ArrayList coObserversList = new ArrayList();

    public SessionPanel(ObservationManager manager, ISession session, boolean editable) {
        super(editable);
        this.observationManager = manager;
        this.session = session;
        this.cache = this.observationManager.getUIDataCache();
        this.language = new LanguageBox(this.observationManager.getConfiguration().getConfig("om.content.language.default"), true);
        this.createPanel();
        if (session != null) {
            this.loadSchemaElement();
        }
        super.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            JTextArea area = null;
            if (e.getSource() == this.comments) {
                area = this.comments;
            } else if (e.getSource() == this.weather) {
                area = this.weather;
            } else if (e.getSource() == this.equipment) {
                area = this.equipment;
            }
            new EditPopupHandler(e.getX(), e.getY(), area);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton sourceButton = (JButton)source;
            if (sourceButton.equals(this.selectCoObservers)) {
                this.coObsSelector = new SchemaElementSelectorPopup(this.observationManager, AbstractPanel.bundle.getString("dialog.coObserver.title"), null, this.coObserversList, true, 6);
                ArrayList selected = new ArrayList();
                if (this.coObsSelector.getAllSelectedElements() != null) {
                    selected = new ArrayList(this.coObsSelector.getAllSelectedElements());
                }
                this.coObserversList.clear();
                this.fillCoObserverTextField(selected);
            } else if (sourceButton.equals(this.beginPicker)) {
                DatePicker dp = null;
                dp = this.beginDate != null ? new DatePicker((JFrame)this.observationManager, AbstractPanel.bundle.getString("panel.session.datePicker.start"), this.beginDate) : new DatePicker(this.observationManager, AbstractPanel.bundle.getString("panel.session.datePicker.start"));
                this.beginDate = dp.getDate();
                this.begin.setText(dp.getDateString());
            } else if (sourceButton.equals(this.endPicker)) {
                DatePicker dp = null;
                dp = this.endDate != null ? new DatePicker((JFrame)this.observationManager, AbstractPanel.bundle.getString("panel.session.datePicker.end"), this.endDate) : (this.beginDate != null ? new DatePicker((JFrame)this.observationManager, AbstractPanel.bundle.getString("panel.session.datePicker.end"), this.beginDate) : new DatePicker(this.observationManager, AbstractPanel.bundle.getString("panel.session.datePicker.end")));
                this.endDate = dp.getDate();
                this.end.setText(dp.getDateString());
            } else if (source.equals(this.endNow)) {
                Calendar now;
                this.endDate = now = Calendar.getInstance();
                this.endTime.setTime(now.get(11), now.get(12), now.get(13));
                this.end.setText(this.formatDate(this.endDate));
            } else if (source.equals(this.beginNow)) {
                Calendar now;
                this.beginDate = now = Calendar.getInstance();
                this.beginTime.setTime(now.get(11), now.get(12), now.get(13));
                this.begin.setText(this.formatDate(this.beginDate));
            } else if (sourceButton.equals(this.newSite)) {
                SiteDialog dialog = new SiteDialog(this.observationManager, null);
                this.siteBox.addItem((ISchemaElement)dialog.getSite());
            } else if (sourceButton.equals(this.newCoObservers)) {
                ObserverDialog dialog = new ObserverDialog(this.observationManager, null);
                if (dialog.getObserver() != null) {
                    this.addCoObserverToTextfield(dialog.getObserver().getDisplayName());
                    this.coObserversList.add(dialog.getObserver());
                }
            } else if (sourceButton.equals(this.newImage)) {
                this.addNewImages();
            }
        }
    }

    public ISchemaElement getSchemaElement() {
        return this.session;
    }

    private void loadSchemaElement() {
        DateFormat format = null;
        format = super.isEditable() ? DateFormat.getDateInstance(3, Locale.getDefault()) : DateFormat.getDateInstance(2, Locale.getDefault());
        this.beginDate = this.session.getBegin();
        format.setCalendar(this.beginDate);
        this.begin.setText(format.format(this.beginDate.getTime()));
        this.begin.setEditable(super.isEditable());
        this.beginTime.setTime(this.beginDate.get(11), this.beginDate.get(12), this.beginDate.get(13));
        this.beginTime.setEditable(super.isEditable());
        this.endDate = this.session.getEnd();
        format.setCalendar(this.endDate);
        this.end.setText(format.format(this.endDate.getTime()));
        this.end.setEditable(super.isEditable());
        this.endTime.setTime(this.endDate.get(11), this.endDate.get(12), this.endDate.get(13));
        this.endTime.setEditable(super.isEditable());
        this.weather.setText(this.session.getWeather());
        this.weather.setEditable(super.isEditable());
        this.equipment.setText(this.session.getEquipment());
        this.equipment.setEditable(super.isEditable());
        this.comments.setText(this.session.getComments());
        this.comments.setEditable(super.isEditable());
        this.language.setLanguage(this.session.getLanguage());
        this.language.setEditable(super.isEditable());
        this.fillCoObserverTextField(this.session.getCoObservers());
        this.imageContainer.addImages(this.session.getImages());
        this.setVisible(false);
        this.setVisible(true);
    }

    public ISchemaElement updateSchemaElement() {
        if (this.session == null) {
            return null;
        }
        if (this.beginDate == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.noStart"));
            return null;
        }
        if (!this.beginTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.startIncorrect"));
            return null;
        }
        if (this.endDate == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.noEnd"));
            return null;
        }
        if (!this.endTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.endIncorrect"));
            return null;
        }
        if (this.siteBox.getSelectedSchemaElement() == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.noSite"));
            return null;
        }
        ISite site = (ISite)this.siteBox.getSelectedSchemaElement();
        this.beginDate.setTimeZone(new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName()));
        this.endDate.setTimeZone(new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName()));
        this.session.setSite(site);
        this.endDate.set(11, this.endTime.getHour());
        this.endDate.set(12, this.endTime.getMinutes());
        this.endDate.set(13, this.endTime.getSeconds());
        this.session.setEnd(this.endDate);
        this.beginDate.set(11, this.beginTime.getHour());
        this.beginDate.set(12, this.beginTime.getMinutes());
        this.beginDate.set(13, this.beginTime.getSeconds());
        this.session.setBegin(this.beginDate);
        if (this.endDate.before(this.beginDate)) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.endBeforeStart"));
            return null;
        }
        String weather = this.weather.getText();
        this.session.setWeather(weather);
        String equipment = this.equipment.getText();
        this.session.setEquipment(equipment);
        String comments = this.comments.getText();
        this.session.setComments(comments);
        if (this.coObsSelector != null) {
            this.session.setCoObservers((List)this.coObserversList);
        }
        if (this.siteBox.getSelectedSchemaElement() != null) {
            this.session.setSite((ISite)this.siteBox.getSelectedSchemaElement());
        }
        if (this.language.getSelectedISOLanguage() != null) {
            this.session.setLanguage(this.language.getSelectedISOLanguage());
        }
        this.session.setImages(this.imageContainer.getImages(this.observationManager.getXmlCache().getXMLFileForSchemaElement((ISchemaElement)this.session)));
        return this.session;
    }

    public ISchemaElement createSchemaElement() {
        String comments;
        String equipment;
        if (this.beginDate == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.noStart"));
            return null;
        }
        if (!this.beginTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.startIncorrect"));
            return null;
        }
        if (this.endDate == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.noEnd"));
            return null;
        }
        if (!this.endTime.checkTime()) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.endIncorrect"));
            return null;
        }
        if (this.siteBox.getSelectedSchemaElement() == null) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.noSite"));
            return null;
        }
        ISite site = (ISite)this.siteBox.getSelectedSchemaElement();
        this.beginDate.setTimeZone(new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName()));
        this.endDate.setTimeZone(new SimpleTimeZone(site.getTimezone() * 60 * 1000, site.getName()));
        this.endDate.set(11, this.endTime.getHour());
        this.endDate.set(12, this.endTime.getMinutes());
        this.endDate.set(13, this.endTime.getSeconds());
        this.beginDate.set(11, this.beginTime.getHour());
        this.beginDate.set(12, this.beginTime.getMinutes());
        this.beginDate.set(13, this.beginTime.getSeconds());
        if (this.endDate.before(this.beginDate)) {
            this.createWarning(AbstractPanel.bundle.getString("panel.session.warning.endBeforeStart"));
            return null;
        }
        this.session = new Session(this.beginDate, this.endDate, site);
        String weather = this.weather.getText();
        if (weather != null && !"".equals(weather)) {
            this.session.setWeather(weather);
        }
        if ((equipment = this.equipment.getText()) != null && !"".equals(equipment)) {
            this.session.setEquipment(equipment);
        }
        if ((comments = this.comments.getText()) != null && !"".equals(comments)) {
            this.session.setComments(comments);
        }
        this.session.setCoObservers((List)this.coObserversList);
        if (this.siteBox.getSelectedSchemaElement() != null) {
            this.session.setSite((ISite)this.siteBox.getSelectedSchemaElement());
        }
        if (this.language.getSelectedISOLanguage() != null) {
            this.session.setLanguage(this.language.getSelectedISOLanguage());
        }
        this.session.setImages(this.imageContainer.getImages(this.observationManager.getXmlCache().getXMLFileForSchemaElement((ISchemaElement)this.session)));
        return this.session;
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 5, 1);
        OMLabel Lbegin = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.begin"), true);
        Lbegin.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.begin"));
        constraints.fill = 2;
        gridbag.setConstraints(Lbegin, constraints);
        this.add(Lbegin);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 25, 1);
        constraints.fill = 2;
        this.begin = new JTextField(8);
        this.begin.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.begin"));
        this.begin.setEditable(false);
        gridbag.setConstraints(this.begin, constraints);
        this.add(this.begin);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 2, 0, 1, 1, 2, 1);
            constraints.fill = 2;
            this.beginPicker = new JButton("...");
            this.beginPicker.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.selectStartDate"));
            this.beginPicker.addActionListener(this);
            gridbag.setConstraints(this.beginPicker, constraints);
            this.add(this.beginPicker);
        }
        ConstraintsBuilder.buildConstraints(constraints, 3, 0, 1, 1, 25, 1);
        constraints.fill = 2;
        this.beginTime = new TimeContainer(0, 0, 0, super.isEditable());
        this.beginTime.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.begin"));
        gridbag.setConstraints(this.beginTime, constraints);
        this.add(this.beginTime);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 4, 0, 1, 1, 3, 1);
            constraints.anchor = 17;
            this.beginNow = new JButton(AbstractPanel.bundle.getString("panel.observation.button.beginNow"));
            this.beginNow.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.beginNow"));
            this.beginNow.addActionListener(this);
            gridbag.setConstraints(this.beginNow, constraints);
            this.add(this.beginNow);
        }
        ConstraintsBuilder.buildConstraints(constraints, 5, 0, 6, 1, 5, 1);
        JLabel Ldummy = new JLabel(" ");
        constraints.fill = 2;
        gridbag.setConstraints(Ldummy, constraints);
        this.add(Ldummy);
        ConstraintsBuilder.buildConstraints(constraints, 11, 0, 1, 1, 5, 1);
        constraints.fill = 2;
        OMLabel Llanguage = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.language"), 4, false);
        Llanguage.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.language"));
        gridbag.setConstraints(Llanguage, constraints);
        this.add(Llanguage);
        ConstraintsBuilder.buildConstraints(constraints, 12, 0, 1, 1, 15, 1);
        constraints.fill = 2;
        this.language.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.language"));
        this.language.setEnabled(super.isEditable());
        gridbag.setConstraints(this.language, constraints);
        this.add(this.language);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 5, 1);
        constraints.fill = 2;
        constraints.anchor = 17;
        OMLabel Lend = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.end"), 2, true);
        Lend.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.end"));
        gridbag.setConstraints(Lend, constraints);
        this.add(Lend);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 25, 1);
        constraints.fill = 2;
        this.end = new JTextField(8);
        this.end.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.end"));
        this.end.setEditable(false);
        gridbag.setConstraints(this.end, constraints);
        this.add(this.end);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 2, 1, 1, 1, 2, 1);
            constraints.fill = 2;
            this.endPicker = new JButton("...");
            this.endPicker.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.selectEndDate"));
            this.endPicker.addActionListener(this);
            gridbag.setConstraints(this.endPicker, constraints);
            this.add(this.endPicker);
        }
        ConstraintsBuilder.buildConstraints(constraints, 3, 1, 1, 1, 25, 1);
        constraints.fill = 2;
        this.endTime = new TimeContainer(0, 0, 0, super.isEditable());
        this.endTime.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.end"));
        gridbag.setConstraints(this.endTime, constraints);
        this.add(this.endTime);
        if (super.isEditable()) {
            ConstraintsBuilder.buildConstraints(constraints, 4, 1, 1, 1, 3, 1);
            constraints.anchor = 17;
            this.endNow = new JButton(AbstractPanel.bundle.getString("panel.observation.button.endNow"));
            this.endNow.setToolTipText(AbstractPanel.bundle.getString("panel.observation.tooltip.endNow"));
            this.endNow.addActionListener(this);
            gridbag.setConstraints(this.endNow, constraints);
            this.add(this.endNow);
        }
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 13, 1, 5, 1);
        constraints.fill = 2;
        OMLabel Lweather = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.weather"), false);
        Lweather.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.weather"));
        gridbag.setConstraints(Lweather, constraints);
        this.add(Lweather);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 13, 1, 15, 1);
        this.weather = new JTextArea(3, 30);
        this.weather.addMouseListener(this);
        this.weather.setLineWrap(true);
        this.weather.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.weather"));
        JScrollPane weatherScroll = new JScrollPane(this.weather);
        weatherScroll.setMinimumSize(new Dimension(300, 60));
        constraints.fill = 2;
        gridbag.setConstraints(weatherScroll, constraints);
        this.add(weatherScroll);
        ConstraintsBuilder.buildConstraints(constraints, 0, 4, 13, 1, 5, 1);
        OMLabel Lequipment = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.equipment"), false);
        Lequipment.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.equipment"));
        gridbag.setConstraints(Lequipment, constraints);
        this.add(Lequipment);
        ConstraintsBuilder.buildConstraints(constraints, 0, 5, 13, 1, 15, 1);
        this.equipment = new JTextArea(3, 30);
        this.equipment.addMouseListener(this);
        this.equipment.setLineWrap(true);
        this.equipment.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.equipment"));
        JScrollPane equipmentScroll = new JScrollPane(this.equipment);
        equipmentScroll.setMinimumSize(new Dimension(300, 60));
        gridbag.setConstraints(equipmentScroll, constraints);
        this.add(equipmentScroll);
        ConstraintsBuilder.buildConstraints(constraints, 0, 6, 13, 1, 5, 1);
        OMLabel Lcomments = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.comments"), false);
        Lcomments.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.comments"));
        gridbag.setConstraints(Lcomments, constraints);
        this.add(Lcomments);
        ConstraintsBuilder.buildConstraints(constraints, 0, 7, 13, 1, 15, 1);
        this.comments = new JTextArea(3, 40);
        this.comments.addMouseListener(this);
        this.comments.setLineWrap(true);
        this.comments.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.comments"));
        JScrollPane commentsScroll = new JScrollPane(this.comments);
        commentsScroll.setMinimumSize(new Dimension(300, 60));
        gridbag.setConstraints(commentsScroll, constraints);
        this.add(commentsScroll);
        ConstraintsBuilder.buildConstraints(constraints, 0, 8, 13, 1, 15, 1);
        JSeparator seperator1 = new JSeparator(0);
        gridbag.setConstraints(seperator1, constraints);
        this.add(seperator1);
        if (this.session != null && !super.isEditable()) {
            SitePanel sitePanel = new SitePanel(this.session.getSite(), false);
            ConstraintsBuilder.buildConstraints(constraints, 0, 10, 13, 1, 15, 1);
            gridbag.setConstraints(sitePanel, constraints);
            sitePanel.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.site"));
            sitePanel.setBorder(BorderFactory.createTitledBorder(AbstractPanel.bundle.getString("panel.session.label.site")));
            this.add(sitePanel);
            int yPos = 10;
            if (!this.session.getCoObservers().isEmpty()) {
                ConstraintsBuilder.buildConstraints(constraints, 0, ++yPos, 13, 1, 15, 1);
                JSeparator seperator2 = new JSeparator(0);
                gridbag.setConstraints(seperator2, constraints);
                this.add(seperator2);
                ConstraintsBuilder.buildConstraints(constraints, 0, ++yPos, 13, 1, 15, 45);
                this.coObserverTabbedPane = new JTabbedPane(1);
                this.coObserverTabbedPane.setBorder(BorderFactory.createTitledBorder(AbstractPanel.bundle.getString("panel.session.label.addObservers")));
                this.coObserverTabbedPane.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.addObservers"));
                JScrollPane scrollPane = new JScrollPane(this.coObserverTabbedPane, 20, 31);
                constraints.anchor = 11;
                constraints.fill = 1;
                gridbag.setConstraints(scrollPane, constraints);
                this.add(scrollPane);
                this.createObserverPanel();
            }
            ConstraintsBuilder.buildConstraints(constraints, 0, ++yPos, 13, 1, 15, 30);
            constraints.fill = 1;
            this.imageContainer = new ImageContainer(null, this.observationManager, false);
            JScrollPane imageContainerScroll = new JScrollPane(this.imageContainer, 20, 30);
            imageContainerScroll.setBorder(BorderFactory.createTitledBorder(AbstractPanel.bundle.getString("panel.observationItem.label.images")));
            imageContainerScroll.setToolTipText(AbstractPanel.bundle.getString("panel.observationItem.tooltip.images"));
            gridbag.setConstraints(imageContainerScroll, constraints);
            imageContainerScroll.setPreferredSize(this.imageContainer.getPreferredSize());
            this.add(imageContainerScroll);
        } else {
            ConstraintsBuilder.buildConstraints(constraints, 0, 10, 1, 1, 5, 1);
            OMLabel Lsite = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.site"), false);
            Lsite.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.site"));
            gridbag.setConstraints(Lsite, constraints);
            this.add(Lsite);
            this.createSiteDropDownBox();
            ConstraintsBuilder.buildConstraints(constraints, 0, 11, 9, 1, 5, 1);
            gridbag.setConstraints(this.siteBox, constraints);
            this.siteBox.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.site"));
            this.add(this.siteBox);
            this.newSite = new JButton(AbstractPanel.bundle.getString("panel.session.label.newSite"));
            ConstraintsBuilder.buildConstraints(constraints, 9, 11, 4, 1, 10, 1);
            gridbag.setConstraints(this.newSite, constraints);
            this.newSite.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.newSite"));
            this.newSite.addActionListener(this);
            this.add(this.newSite);
            ConstraintsBuilder.buildConstraints(constraints, 0, 12, 13, 1, 15, 1);
            JSeparator seperator2 = new JSeparator(0);
            gridbag.setConstraints(seperator2, constraints);
            this.add(seperator2);
            ConstraintsBuilder.buildConstraints(constraints, 0, 13, 13, 1, 15, 1);
            OMLabel LcoObservers = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.addObservers"), false);
            LcoObservers.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.addObservers"));
            gridbag.setConstraints(LcoObservers, constraints);
            this.add(LcoObservers);
            ConstraintsBuilder.buildConstraints(constraints, 0, 14, 9, 1, 10, 1);
            this.coObservers.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.addObservers"));
            this.coObservers.setEditable(false);
            if (this.session != null) {
                this.fillCoObserverTextField(this.session.getCoObservers());
            }
            gridbag.setConstraints(this.coObservers, constraints);
            this.add(this.coObservers);
            ConstraintsBuilder.buildConstraints(constraints, 9, 14, 2, 1, 5, 1);
            this.selectCoObservers = new JButton(AbstractPanel.bundle.getString("panel.session.label.selectCoObserver"));
            this.selectCoObservers.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.selectCoObserver"));
            this.selectCoObservers.addActionListener(this);
            gridbag.setConstraints(this.selectCoObservers, constraints);
            this.add(this.selectCoObservers);
            ConstraintsBuilder.buildConstraints(constraints, 11, 14, 2, 1, 5, 1);
            this.newCoObservers = new JButton(AbstractPanel.bundle.getString("panel.session.label.newObserver"));
            this.newCoObservers.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.newObserver"));
            this.newCoObservers.addActionListener(this);
            gridbag.setConstraints(this.newCoObservers, constraints);
            this.add(this.newCoObservers);
            ConstraintsBuilder.buildConstraints(constraints, 0, 15, 13, 1, 2, 1);
            OMLabel LimageContainer = new OMLabel(AbstractPanel.bundle.getString("panel.session.label.images"), false);
            LimageContainer.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.images"));
            gridbag.setConstraints(LimageContainer, constraints);
            this.add(LimageContainer);
            ConstraintsBuilder.buildConstraints(constraints, 0, 16, 11, 4, 1, 100);
            constraints.fill = 1;
            this.imageContainer = new ImageContainer(null, this.observationManager, true);
            JScrollPane imageContainerScroll = new JScrollPane(this.imageContainer, 20, 30);
            gridbag.setConstraints(imageContainerScroll, constraints);
            imageContainerScroll.setMinimumSize(new Dimension(this.getWidth(), 130));
            this.add(imageContainerScroll);
            ConstraintsBuilder.buildConstraints(constraints, 11, 16, 2, 1, 1, 1);
            constraints.fill = 2;
            constraints.anchor = 10;
            this.newImage = new JButton(AbstractPanel.bundle.getString("panel.session.button.newImages"));
            this.newImage.setToolTipText(AbstractPanel.bundle.getString("panel.session.tooltip.newImages"));
            this.newImage.addActionListener(this);
            gridbag.setConstraints(this.newImage, constraints);
            this.add(this.newImage);
        }
    }

    private void fillCoObserverTextField(List coObservers) {
        this.coObservers.setText("");
        Iterator iterator = coObservers.iterator();
        IObserver current = null;
        while (iterator.hasNext()) {
            current = (IObserver)iterator.next();
            this.coObserversList.add(current);
            this.addCoObserverToTextfield(current.getDisplayName());
        }
    }

    private void addCoObserverToTextfield(String coObserver) {
        String t = this.coObservers.getText();
        t = coObserver + "; " + t;
        this.coObservers.setText(t);
    }

    private void createObserverPanel() {
        Iterator iterator = this.session.getCoObservers().iterator();
        IObserver current = null;
        while (iterator.hasNext()) {
            current = (IObserver)iterator.next();
            ObserverPanel observerPanel = new ObserverPanel(current, false);
            this.coObserverTabbedPane.add(current.getDisplayName(), observerPanel);
        }
    }

    private void createSiteDropDownBox() {
        this.siteBox = new SiteBox();
        ISite[] sites = this.observationManager.getXmlCache().getSites();
        for (int x = 0; x < sites.length; ++x) {
            this.siteBox.addItem((ISchemaElement)sites[x]);
        }
        if (this.session != null) {
            this.siteBox.setSelectedItem((ISchemaElement)this.session.getSite());
        } else {
            this.siteBox.setSelectedItem(null);
        }
    }

    private String formatDate(Calendar cal) {
        DateFormat format = null;
        format = DateFormat.getDateInstance(3, Locale.getDefault());
        format.setCalendar(cal);
        return format.format(cal.getTime());
    }

    private void addNewImages() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        FileFilter imageFileFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".fits") || f.getName().toLowerCase().endsWith(".fit") || f.getName().toLowerCase().endsWith(".fts") || f.isDirectory();
            }

            public String getDescription() {
                return AbstractPanel.bundle.getString("panel.observation.addNewImages.fileSelector.description");
            }
        };
        chooser.setFileFilter(imageFileFilter);
        chooser.setMultiSelectionEnabled(true);
        File last = (File)this.cache.get("ObservationDialogPanel.lastImageDir");
        if (last != null && last.exists() && last.isDirectory()) {
            chooser.setCurrentDirectory(last);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            File[] files = chooser.getSelectedFiles();
            Cursor hourglassCursor = new Cursor(3);
            this.setCursor(hourglassCursor);
            List<File> images = Arrays.asList(files);
            this.imageContainer.addImages(images);
            this.repaint();
            this.updateUI();
            if (files != null && files.length > 0) {
                this.cache.put("ObservationDialogPanel.lastImageDir", files[0].getParentFile());
            }
            Cursor normalCursor = new Cursor(0);
            this.setCursor(normalCursor);
        }
    }
}

