/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation.tableModel;

import de.lehmannet.om.ILens;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LensTableModel
extends AbstractSchemaTableModel {
    private static final String MODEL_ID = "Lens";
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());

    public LensTableModel(ILens[] lenses) {
        this.elements = lenses;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getID() {
        return MODEL_ID;
    }

    public int getRowCount() {
        if (this.elements == null) {
            return 5;
        }
        return this.elements.length;
    }

    public Class getColumnClass(int columnIndex) {
        Class c = null;
        switch (columnIndex) {
            case 0: {
                c = String.class;
                break;
            }
            case 1: {
                c = String.class;
                break;
            }
            case 2: {
                c = Float.class;
            }
        }
        return c;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (this.elements == null) {
            return value;
        }
        ILens lens = (ILens)this.elements[rowIndex];
        switch (columnIndex) {
            case 0: {
                value = lens.getVendor();
                if (value != null) break;
                value = "";
                break;
            }
            case 1: {
                value = lens.getModel();
                break;
            }
            case 2: {
                value = new Float(lens.getFactor());
            }
        }
        return value;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = this.bundle.getString("table.header.lens.vendor");
                break;
            }
            case 1: {
                name = this.bundle.getString("table.header.lens.model");
                break;
            }
            case 2: {
                name = this.bundle.getString("table.header.lens.factor");
            }
        }
        return name;
    }
}

