/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.OALException;
import de.lehmannet.om.ui.dialog.AboutDialog;
import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.dialog.DidYouKnowDialog;
import de.lehmannet.om.ui.dialog.ExtensionInfoDialog;
import de.lehmannet.om.ui.dialog.EyepieceDialog;
import de.lehmannet.om.ui.dialog.FilterDialog;
import de.lehmannet.om.ui.dialog.IImagerDialog;
import de.lehmannet.om.ui.dialog.ITargetDialog;
import de.lehmannet.om.ui.dialog.LensDialog;
import de.lehmannet.om.ui.dialog.LogDialog;
import de.lehmannet.om.ui.dialog.NewDocumentDialog;
import de.lehmannet.om.ui.dialog.ObservationDialog;
import de.lehmannet.om.ui.dialog.ObserverDialog;
import de.lehmannet.om.ui.dialog.ProgressDialog;
import de.lehmannet.om.ui.dialog.ScopeDialog;
import de.lehmannet.om.ui.dialog.SessionDialog;
import de.lehmannet.om.ui.dialog.SiteDialog;
import de.lehmannet.om.ui.dialog.TableElementsDialog;
import de.lehmannet.om.ui.dialog.UnavailableEquipmentDialog;
import de.lehmannet.om.ui.extension.ExtensionLoader;
import de.lehmannet.om.ui.navigation.ItemView;
import de.lehmannet.om.ui.navigation.NightVisionTheme;
import de.lehmannet.om.ui.navigation.TableView;
import de.lehmannet.om.ui.navigation.TeeLog;
import de.lehmannet.om.ui.navigation.TreeView;
import de.lehmannet.om.ui.preferences.PreferencesDialog;
import de.lehmannet.om.ui.project.ProjectCatalog;
import de.lehmannet.om.ui.project.ProjectLoader;
import de.lehmannet.om.ui.statistics.StatisticsDialog;
import de.lehmannet.om.ui.update.UpdateChecker;
import de.lehmannet.om.ui.update.UpdateInfoDialog;
import de.lehmannet.om.ui.util.Configuration;
import de.lehmannet.om.ui.util.ExtenableSchemaElementSelector;
import de.lehmannet.om.ui.util.SplashScreen;
import de.lehmannet.om.ui.util.Worker;
import de.lehmannet.om.ui.util.XMLFileLoader;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import de.lehmannet.om.util.SchemaLoader;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.w3c.dom.Document;

public class ObservationManager
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -9092637724048070172L;
    public static final String CONFIG_LASTDIR = "om.lastOpenedDir";
    public static final String CONFIG_LASTXML = "om.lastOpenedXML";
    public static final String CONFIG_OPENONSTARTUP = "om.lastOpenedXML.onStartup";
    public static final String CONFIG_CONTENTDEFAULTLANG = "om.content.language.default";
    public static final String CONFIG_MAINWINDOW_SIZE = "om.mainwindow.size";
    public static final String CONFIG_MAINWINDOW_POS = "om.mainwindow.position";
    public static final String CONFIG_MAINWINDOW_MAXIMIZED = "om.mainwindow.maximized";
    public static final String CONFIG_IMAGESDIR_RELATIVE = "om.imagesDir.relaitve";
    public static final String CONFIG_UILANGUAGE = "om.language";
    public static final String CONFIG_DEFAULT_OBSERVER = "om.default.observer";
    public static final String CONFIG_DEFAULT_CATALOG = "om.default.catalog";
    public static final String CONFIG_HELP_HINTS_STARTUP = "om.help.hints.showOnStartup";
    public static final String CONFIG_RETRIEVE_ENDDATE_FROM_SESSION = "om.retrieve.endDateFromSession";
    public static final String CONFIG_STATISTICS_USE_COOBSERVERS = "om.statistics.useCoObservers";
    public static final String CONFIG_XSL_TEMPLATE = "om.transform.xsl.template";
    public static final String CONFIG_MAINWINDOW_DIVIDER_VERTICAL = "om.mainwindow.divider.vertical";
    public static final String CONFIG_MAINWINDOW_DIVIDER_HORIZONTAL = "om.mainwindow.divider.horizontal";
    public static final String CONFIG_CONSTELLATION_USEI18N = "om.constellation.useI18N";
    public static final String CONFIG_UPDATECHECK_STARTUP = "om.update.checkForUpdates";
    public static final String CONFIG_NIGHTVISION_ENABLED = "om.nightvision.enable";
    private static PropertyResourceBundle bundle = null;
    public static final String INSTALL_DIR = "instDir";
    public static final String LANGUAGE = "lang";
    public static final String CONFIGURATION = "config";
    public static final String NIGHTVISION = "nightvision";
    public static final String LOGGING = "log";
    public static final String DEBUG = "debug";
    public static final String VERSION = "1.321";
    private static final String MAIN_JAR_NAME = "observationManager.jar";
    public static URL UPDATE_URL = null;
    public static final String LOG_ERROR_PREFIX = "ERR";
    public static final String LOG_DEFAULT_PREFIX = "LOG";
    public static final String WORKING_DIR = ".observationManager";
    private JSplitPane hSplitPane = null;
    private JSplitPane vSplitPane = null;
    private JMenuBar menuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem newFile = null;
    private JMenuItem openFile = null;
    private JMenuItem saveFile = null;
    private JMenuItem saveFileAs = null;
    private JMenuItem importXML = null;
    private JMenuItem exportHTML = null;
    private JCheckBoxMenuItem nightVision = null;
    private JMenuItem exit = null;
    private JMenu dataMenu = null;
    private JMenuItem createObservation = null;
    private JMenuItem createObserver = null;
    private JMenuItem createSite = null;
    private JMenuItem createScope = null;
    private JMenuItem createEyepiece = null;
    private JMenuItem createImager = null;
    private JMenuItem createFilter = null;
    private JMenuItem createTarget = null;
    private JMenuItem createSession = null;
    private JMenuItem createLens = null;
    private JMenuItem equipmentAvailability = null;
    private JMenu extraMenu = null;
    private JMenuItem showStatistics = null;
    private JMenuItem preferences = null;
    private JMenuItem didYouKnow = null;
    private JMenuItem logMenuEntry = null;
    private JMenuItem updateMenuEntry = null;
    private JMenu extensionMenu = null;
    private JMenuItem extensionInfo = null;
    private JMenuItem installExtension = null;
    private JMenu aboutMenu = null;
    private JMenuItem aboutInfo = null;
    private TableView table = null;
    private ItemView item = null;
    private TreeView tree = null;
    private XMLFileLoader xmlCache = null;
    private ExtensionLoader extLoader = null;
    private HashMap uiDataCache = null;
    private Configuration configuration = null;
    private ProjectLoader projectLoader = null;
    private File installDir = null;
    private String logDir = null;
    private File logFile = null;
    private File schemaPath = null;
    private String configDir = null;
    private boolean changed = false;
    private Boolean nightVisionOnStartup = null;
    private Thread splash = null;
    private Thread waitForCatalogLoaderThread = null;
    private boolean debug = false;

    public ObservationManager(String[] args) {
        UpdateChecker updateChecker;
        List resultList;
        this.setInstallDir();
        this.parseArguments(args);
        if (this.debug) {
            System.out.println("Start: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
        File f_logDir = null;
        f_logDir = this.logDir == null ? new File(System.getProperty("user.home") + File.separatorChar + WORKING_DIR + File.separatorChar + LOGGING) : new File(this.logDir);
        if (!f_logDir.exists() && !f_logDir.mkdirs()) {
            System.err.println("Cannot create log dir: " + f_logDir);
        }
        this.logFile = new File(f_logDir.getAbsolutePath() + File.separatorChar + "obs.log");
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(this.logFile));
            TeeLog elog = new TeeLog(ps, LOG_ERROR_PREFIX);
            TeeLog slog = new TeeLog(ps, LOG_DEFAULT_PREFIX);
            System.setErr(elog);
            System.setOut(slog);
        }
        catch (FileNotFoundException fnf) {
            this.createWarning(bundle.getString("error.logFile") + " " + this.logFile);
        }
        this.configuration = new Configuration(this.configDir);
        boolean nightVisionOnStartup = Boolean.valueOf(this.configuration.getConfig(CONFIG_NIGHTVISION_ENABLED, "false"));
        if (this.nightVisionOnStartup != null) {
            nightVisionOnStartup = this.nightVisionOnStartup;
        }
        if (!nightVisionOnStartup) {
            this.splash = new Thread(new SplashScreen(this.installDir.getAbsolutePath()));
            this.splash.start();
        }
        this.loadLanguage();
        this.setTitle();
        super.setIconImage(new ImageIcon(this.installDir.getAbsolutePath() + File.separatorChar + "om_logo.png").getImage());
        System.out.println("--- Observation Manager 1.321 starting up...");
        System.out.println("--- Java:\t" + System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        System.out.println("--- OS:\t" + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("os.version"));
        this.schemaPath = new File(this.installDir.getAbsolutePath() + File.separatorChar + "schema");
        if (!this.schemaPath.exists()) {
            System.err.println("--- Comast schema path not found: " + this.schemaPath + "\n. Need to quit...");
        }
        this.xmlCache = new XMLFileLoader(this.schemaPath);
        this.extLoader = new ExtensionLoader(this);
        this.uiDataCache = new HashMap();
        this.initMenuBar();
        this.enableMenus(false);
        if (nightVisionOnStartup) {
            this.nightVision.setSelected(nightVisionOnStartup);
            this.enableNightVisionTheme(nightVisionOnStartup);
        }
        this.item = this.initItemView();
        this.table = this.initTableView();
        this.tree = this.initTreeView();
        this.initMain();
        this.loadConfig();
        this.loadProjectFiles();
        if (Boolean.valueOf(this.configuration.getConfig(CONFIG_UPDATECHECK_STARTUP, "false")).booleanValue() && (resultList = (updateChecker = this.checkForUpdates(true)).getResult()) != null) {
            if (!resultList.isEmpty()) {
                new UpdateInfoDialog(this, resultList);
            } else {
                System.out.println("Checked for updates: No updates found.");
            }
        }
        if (Boolean.valueOf(this.configuration.getConfig(CONFIG_HELP_HINTS_STARTUP, "true")).booleanValue()) {
            this.showDidYouKnow();
        }
        this.addShortcuts();
        this.enableMenus(true);
        if (this.debug) {
            System.out.println("Up and running: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem source = (JMenuItem)e.getSource();
            if (source.equals(this.exit)) {
                this.exit();
            } else if (source.equals(this.newFile)) {
                this.newFile();
            } else if (source.equals(this.openFile)) {
                this.openFile();
            } else if (source.equals(this.saveFile)) {
                this.saveFile();
            } else if (source.equals(this.saveFileAs)) {
                this.saveFileAs();
            } else if (source.equals(this.importXML)) {
                this.importXML();
            } else if (source.equals(this.exportHTML)) {
                this.createHTML();
            } else if (source.equals(this.nightVision)) {
                if (this.nightVision.isSelected()) {
                    this.enableNightVisionTheme(true);
                } else {
                    this.enableNightVisionTheme(false);
                }
            } else if (source.equals(this.createObservation)) {
                this.createNewObservation();
            } else if (source.equals(this.createObserver)) {
                this.createNewObserver();
            } else if (source.equals(this.createSite)) {
                this.createNewSite();
            } else if (source.equals(this.createScope)) {
                this.createNewScope();
            } else if (source.equals(this.createEyepiece)) {
                this.createNewEyepiece();
            } else if (source.equals(this.createImager)) {
                this.createNewImager();
            } else if (source.equals(this.createFilter)) {
                this.createNewFilter();
            } else if (source.equals(this.createLens)) {
                this.createNewLens();
            } else if (source.equals(this.createTarget)) {
                this.createNewTarget();
            } else if (source.equals(this.createSession)) {
                this.createNewSession();
            } else if (source.equals(this.equipmentAvailability)) {
                UnavailableEquipmentDialog uqd = new UnavailableEquipmentDialog(this);
                this.setChanged(uqd.changedElements());
            } else if (source.equals(this.showStatistics)) {
                this.showStatistics();
            } else if (source.equals(this.preferences)) {
                this.showPreferencesDialog();
            } else if (source.equals(this.didYouKnow)) {
                this.showDidYouKnow();
            } else if (source.equals(this.logMenuEntry)) {
                this.showLogDialog();
            } else if (source.equals(this.updateMenuEntry)) {
                UpdateChecker checker = this.checkForUpdates(true);
                List resultList = checker.getResult();
                if (resultList != null) {
                    if (resultList.isEmpty()) {
                        this.createInfo(bundle.getString("updates.check.noAvailable"));
                    } else {
                        new UpdateInfoDialog(this, resultList);
                    }
                } else {
                    this.createWarning(bundle.getString("updates.check.error"));
                }
            } else if (source.equals(this.aboutInfo)) {
                this.showInfo();
            } else if (source.equals(this.extensionInfo)) {
                this.showExtensionInfo();
            } else if (source.equals(this.installExtension)) {
                this.installExtension(null, true);
            }
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && this.exit()) {
            super.processWindowEvent(e);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new ObservationManager(args);
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public boolean exit() {
        switch (this.saveBeforeExit()) {
            case -1: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        System.out.println("--- Observation Manager shutting down...");
        if (this.debug) {
            System.out.println("Exit: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
        if (this.getExtendedState() == 6) {
            this.configuration.setConfig(CONFIG_MAINWINDOW_MAXIMIZED, Boolean.toString(true));
        } else {
            this.configuration.setConfig(CONFIG_MAINWINDOW_MAXIMIZED, null);
        }
        Dimension size = this.getSize();
        String stringSize = size.width + "x" + size.height;
        Point location = this.getLocation();
        String stringLocation = location.x + "," + location.y;
        this.configuration.setConfig(CONFIG_MAINWINDOW_SIZE, stringSize);
        this.configuration.setConfig(CONFIG_MAINWINDOW_POS, stringLocation);
        float vertical = (float)this.getWidth() / (float)this.vSplitPane.getDividerLocation();
        float horizontal = (float)this.getHeight() / (float)this.hSplitPane.getDividerLocation();
        this.configuration.setConfig(CONFIG_MAINWINDOW_DIVIDER_HORIZONTAL, "" + horizontal);
        this.configuration.setConfig(CONFIG_MAINWINDOW_DIVIDER_VERTICAL, "" + vertical);
        this.table.saveSettings();
        boolean result = this.configuration.saveConfiguration(this.configDir);
        if (!result) {
            this.createWarning(bundle.getString("error.saveconfig"));
        }
        System.exit(0);
        return true;
    }

    public boolean saveFileAs() {
        if (this.xmlCache.isEmpty()) {
            this.createWarning(bundle.getString("error.saveEmpty"));
            return false;
        }
        String oldPath = null;
        String[] files = this.xmlCache.getAllOpenedFiles();
        if (files != null && files.length == 1) {
            oldPath = files[0];
        }
        final File f = this.saveDialog();
        boolean result = false;
        if (f != null) {
            Worker calculation;
            Cursor hourglassCursor = new Cursor(3);
            this.setCursor(hourglassCursor);
            if (oldPath == null) {
                calculation = new Worker(){
                    private String message = null;
                    private byte returnValue = 0;

                    public void run() {
                        boolean result = ObservationManager.this.xmlCache.save(f.getAbsolutePath());
                        if (!result) {
                            this.message = bundle.getString("error.save");
                            this.returnValue = (byte)2;
                        }
                    }

                    public String getReturnMessage() {
                        return this.message;
                    }

                    public byte getReturnType() {
                        return this.returnValue;
                    }
                };
            } else {
                final String op = oldPath;
                calculation = new Worker(){
                    private String message = null;
                    private byte returnValue = 0;

                    public void run() {
                        boolean result = ObservationManager.this.xmlCache.saveAs(op, f.getAbsolutePath());
                        if (!result) {
                            this.message = bundle.getString("error.save");
                            this.returnValue = (byte)2;
                        }
                    }

                    public String getReturnMessage() {
                        return this.message;
                    }

                    public byte getReturnType() {
                        return this.returnValue;
                    }
                };
            }
            new ProgressDialog(this, bundle.getString("progress.wait.title"), bundle.getString("progress.wait.xml.save.info"), calculation);
            if (calculation.getReturnType() == 0) {
                if (calculation.getReturnMessage() != null) {
                    this.createInfo(calculation.getReturnMessage());
                }
                result = true;
            } else {
                this.createWarning(calculation.getReturnMessage());
                result = false;
            }
            this.tree.updateTree();
            this.setChanged(false);
            Cursor defaultCursor = new Cursor(0);
            this.setCursor(defaultCursor);
        }
        return result;
    }

    public boolean saveFile() {
        if (this.xmlCache.isEmpty()) {
            this.createWarning(bundle.getString("error.saveEmpty"));
            return false;
        }
        final String[] files = this.xmlCache.getAllOpenedFiles();
        boolean result = false;
        if (files == null || files.length == 0) {
            final File f = this.saveDialog();
            if (f != null) {
                Cursor hourglassCursor = new Cursor(3);
                this.setCursor(hourglassCursor);
                Worker calculation = new Worker(){
                    private String message = null;
                    private byte returnValue = 0;

                    public void run() {
                        boolean result = ObservationManager.this.xmlCache.save(f.getAbsolutePath());
                        if (!result) {
                            this.message = bundle.getString("error.save");
                            this.returnValue = (byte)2;
                        }
                    }

                    public String getReturnMessage() {
                        return this.message;
                    }

                    public byte getReturnType() {
                        return this.returnValue;
                    }
                };
                new ProgressDialog(this, bundle.getString("progress.wait.title"), bundle.getString("progress.wait.xml.save.info"), calculation);
                if (calculation.getReturnType() == 0) {
                    if (calculation.getReturnMessage() != null) {
                        this.createInfo(calculation.getReturnMessage());
                    }
                    result = true;
                } else {
                    this.createWarning(calculation.getReturnMessage());
                    result = false;
                }
                this.tree.updateTree();
                this.setChanged(false);
                Cursor defaultCursor = new Cursor(0);
                this.setCursor(defaultCursor);
            }
            return result;
        }
        Cursor hourglassCursor = new Cursor(3);
        this.setCursor(hourglassCursor);
        if (this.debug) {
            System.out.println("Save file: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
        Worker calculation = new Worker(){
            private String message = null;
            private byte returnValue = 0;

            public void run() {
                boolean result = ObservationManager.this.xmlCache.save(files[0]);
                if (!result) {
                    this.message = bundle.getString("error.save");
                    this.returnValue = (byte)2;
                }
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        };
        new ProgressDialog(this, bundle.getString("progress.wait.title"), bundle.getString("progress.wait.xml.save.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.createInfo(calculation.getReturnMessage());
            }
            result = true;
        } else {
            this.createWarning(calculation.getReturnMessage());
            result = false;
        }
        if (this.debug) {
            System.out.println("Saved: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
        this.tree.updateTree();
        this.setChanged(false);
        Cursor defaultCursor = new Cursor(0);
        this.setCursor(defaultCursor);
        return result;
    }

    public void newFile() {
        int i;
        switch (this.saveBeforeExit()) {
            case -1: {
                return;
            }
            case 0: {
                this.createInfo(bundle.getString("ok.save"));
                break;
            }
            case 2: {
                return;
            }
        }
        NewDocumentDialog newDialog = new NewDocumentDialog(this);
        int result = newDialog.getResult();
        if (result == -1) {
            return;
        }
        IImager[] imagers = (IImager[])newDialog.getSchemaElements(3);
        IEyepiece[] eyepieces = (IEyepiece[])newDialog.getSchemaElements(0);
        IFilter[] filters = (IFilter[])newDialog.getSchemaElements(8);
        ILens[] lenses = (ILens[])newDialog.getSchemaElements(9);
        IObservation[] observations = (IObservation[])newDialog.getSchemaElements(2);
        IObserver[] observers = (IObserver[])newDialog.getSchemaElements(6);
        IScope[] scopes = (IScope[])newDialog.getSchemaElements(1);
        ISession[] sessions = (ISession[])newDialog.getSchemaElements(5);
        ISite[] sites = (ISite[])newDialog.getSchemaElements(4);
        ITarget[] targets = (ITarget[])newDialog.getSchemaElements(7);
        this.cleanUp();
        if (imagers != null) {
            for (i = 0; i < imagers.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)imagers[i]);
            }
        }
        if (eyepieces != null) {
            for (i = 0; i < eyepieces.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)eyepieces[i]);
            }
        }
        if (filters != null) {
            for (i = 0; i < filters.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)filters[i]);
            }
        }
        if (lenses != null) {
            for (i = 0; i < lenses.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)lenses[i]);
            }
        }
        if (observers != null) {
            for (i = 0; i < observers.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)observers[i]);
            }
        }
        if (scopes != null) {
            for (i = 0; i < scopes.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)scopes[i]);
            }
        }
        if (sites != null) {
            for (i = 0; i < sites.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)sites[i]);
            }
        }
        if (sessions != null) {
            for (i = 0; i < sessions.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)sessions[i]);
            }
        }
        if (targets != null) {
            for (i = 0; i < targets.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)targets[i]);
            }
        }
        if (observations != null) {
            for (i = 0; i < observations.length; ++i) {
                this.xmlCache.addSchemaElement((ISchemaElement)observations[i]);
            }
        }
        this.table.showObservations(null, null);
        this.tree.updateTree();
        if (result == 1) {
            this.setChanged(true);
        }
    }

    public void openFile() {
        File dir;
        switch (this.saveBeforeExit()) {
            case -1: {
                return;
            }
            case 0: {
                this.createInfo(bundle.getString("ok.save"));
                break;
            }
            case 2: {
                return;
            }
        }
        JFileChooser chooser = new JFileChooser();
        FileFilter xmlFileFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".xml") || f.isDirectory();
            }

            public String getDescription() {
                return "OAL Files";
            }
        };
        chooser.setFileFilter(xmlFileFilter);
        String last = this.configuration.getConfig(CONFIG_LASTDIR);
        if (last != null && !"".equals(last.trim()) && (dir = new File(last)) != null && dir.exists()) {
            chooser.setCurrentDirectory(dir);
        }
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files = chooser.getSelectedFiles();
            Cursor hourglassCursor = new Cursor(3);
            this.setCursor(hourglassCursor);
            this.loadFiles(files);
            Cursor normalCursor = new Cursor(0);
            this.setCursor(normalCursor);
        }
        this.setChanged(false);
    }

    public void openDir() {
        File dir;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(1);
        String last = this.configuration.getConfig(CONFIG_LASTDIR);
        if (last != null && !"".equals(last.trim()) && (dir = new File(last)) != null && dir.exists()) {
            chooser.setCurrentDirectory(dir);
        }
        int returnVal = chooser.showOpenDialog(this);
        FilenameFilter xml = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = null;
        if (returnVal == 0) {
            File[] dirs = chooser.getSelectedFiles();
            for (int i = 0; i < dirs.length; ++i) {
                files = dirs[i].listFiles(xml);
            }
            this.loadFiles(files);
        }
    }

    public void showInfo() {
        new AboutDialog(this);
    }

    public void showStatistics() {
        if (this.getXmlCache().getObservations().length == 0) {
            this.createWarning(bundle.getString("error.noStatisticsData"));
            return;
        }
        if (this.extLoader.getExtensions().isEmpty()) {
            this.createInfo(bundle.getString("info.noCatalogsInstalled"));
            return;
        }
        new StatisticsDialog(this);
    }

    public void showExtensionInfo() {
        if (this.extLoader.getExtensions().isEmpty()) {
            this.createInfo(bundle.getString("info.noExtensionsInstalled"));
        } else {
            new ExtensionInfoDialog(this);
        }
    }

    public void reloadLanguage() {
        this.loadLanguage();
        this.setTitle();
        this.hSplitPane.removeAll();
        this.vSplitPane.removeAll();
        super.getContentPane().removeAll();
        this.extLoader.reloadLanguage();
        AbstractDialog.reloadLanguage();
        this.initMenuBar();
        this.item.reloadLanguage();
        this.item = this.initItemView();
        this.table.reloadLanguage();
        this.table = this.initTableView();
        this.tree = this.initTreeView();
        this.initMain();
        this.table.showObservations(null, null);
        this.tree.updateTree();
    }

    public void showPreferencesDialog() {
        new PreferencesDialog(this, this.extLoader.getPreferencesTabs());
    }

    public void showDidYouKnow() {
        new DidYouKnowDialog(this);
    }

    public void showLogDialog() {
        new LogDialog(this, this.logFile);
    }

    public void createHTMLForSchemaElement(ISchemaElement schemaElement) {
        String htmlName = schemaElement.getDisplayName();
        htmlName = this.replaceSpecialChars(htmlName);
        String fullFileName = this.getCurrentXMLParentPath() + File.separatorChar + htmlName + ".html";
        File html = new File(fullFileName);
        int i = 2;
        while (html.exists()) {
            fullFileName = this.getCurrentXMLParentPath() + File.separatorChar + htmlName + "(" + i + ").html";
            ++i;
            html = new File(fullFileName);
        }
        this.createHTMLForSchemaElement(schemaElement, html);
    }

    public void createXMLForSchemaElement(ISchemaElement schemaElement) {
        String xmlName = schemaElement.getDisplayName();
        xmlName = this.replaceSpecialChars(xmlName);
        String fullFileName = this.getCurrentXMLParentPath() + File.separatorChar + xmlName + ".xml";
        File xml = new File(fullFileName);
        int i = 2;
        while (xml.exists()) {
            fullFileName = this.getCurrentXMLParentPath() + File.separatorChar + xmlName + "(" + i + ").xml";
            ++i;
            xml = new File(fullFileName);
        }
        this.createXMLForSchemaElement(schemaElement, xml);
    }

    public void createHTML() {
        this.createHTML(null, null, null);
    }

    public void createHTML(Document doc, File html, File xslFile) {
        boolean result;
        String[] files;
        if (doc == null) {
            doc = this.xmlCache.getDocument();
        }
        if ((files = this.xmlCache.getAllOpenedFiles()) == null || files.length == 0) {
            this.createInfo(bundle.getString("error.noXMLFileOpen"));
            return;
        }
        if (html == null) {
            File xmlFile = new File(files[0]);
            String htmlName = xmlFile.getName();
            htmlName = htmlName.substring(0, htmlName.indexOf(46));
            htmlName = xmlFile.getParent() + File.separatorChar + htmlName + ".html";
            html = new File(htmlName);
        }
        if (result = this.transformXML2HTML(doc, html, xslFile)) {
            this.createInfo(bundle.getString("info.htmlExportDir") + " " + html);
        }
    }

    public void createNewObservation() {
        ObservationDialog dialog = null;
        while (dialog == null || dialog != null && dialog.isCreateAdditionalObservation()) {
            dialog = new ObservationDialog(this, null);
            this.xmlCache.addSchemaElement((ISchemaElement)dialog.getObservation());
            this.updateLeft();
            this.updateUI((ISchemaElement)dialog.getObservation());
        }
    }

    public void createNewObserver() {
        ObserverDialog dialog = new ObserverDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getObserver());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getObserver());
    }

    public void createNewSession() {
        SessionDialog dialog = new SessionDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getSession());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getSession());
    }

    public void createNewSite() {
        SiteDialog dialog = new SiteDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getSite());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getSite());
    }

    public void createNewScope() {
        ScopeDialog dialog = new ScopeDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getScope());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getScope());
    }

    public void createNewEyepiece() {
        EyepieceDialog dialog = new EyepieceDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getEyepiece());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getEyepiece());
    }

    public void createNewImager() {
        ExtenableSchemaElementSelector is = new ExtenableSchemaElementSelector(this, this.extLoader.getSchemaUILoader(), 3);
        if (is.getResult()) {
            IImagerDialog imagerDialog = (IImagerDialog)((Object)is.getDialog());
            this.xmlCache.addSchemaElement((ISchemaElement)imagerDialog.getImager());
            this.updateLeft();
            this.updateUI((ISchemaElement)imagerDialog.getImager());
        }
    }

    public void createNewFilter() {
        FilterDialog dialog = new FilterDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getFilter());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getFilter());
    }

    public void createNewTarget() {
        ExtenableSchemaElementSelector ts = new ExtenableSchemaElementSelector(this, this.extLoader.getSchemaUILoader(), 7);
        if (ts.getResult()) {
            ITargetDialog targetDialog = (ITargetDialog)ts.getDialog();
            this.xmlCache.addSchemaElement((ISchemaElement)targetDialog.getTarget());
            this.updateLeft();
            this.updateUI((ISchemaElement)targetDialog.getTarget());
        }
    }

    public void createNewLens() {
        LensDialog dialog = new LensDialog(this, null);
        this.xmlCache.addSchemaElement((ISchemaElement)dialog.getLens());
        this.updateLeft();
        this.updateUI((ISchemaElement)dialog.getLens());
    }

    public void deleteSchemaElement(ISchemaElement element) {
        if (element == null) {
            return;
        }
        JOptionPane pane = new JOptionPane(bundle.getString("info.delete.question"), 3, 0);
        JDialog dialog = pane.createDialog(this, bundle.getString("info.delete.title"));
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 1) {
            return;
        }
        List result = this.xmlCache.removeSchemaElement(element);
        if (result == null) {
            if (element instanceof ITarget) {
                this.createWarning(bundle.getString("error.deleteTargetFromCatalog"));
                return;
            }
            System.err.println("Error during deletion of element: " + element);
            return;
        }
        if (result.isEmpty()) {
            this.setChanged(true);
            this.update(element);
        } else {
            new TableElementsDialog(this, result);
        }
    }

    public void loadFiles(File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            this.loadFile(files[i].getAbsolutePath());
        }
        this.configuration.setConfig(CONFIG_LASTDIR, files[0].getParent());
        this.configuration.setConfig(CONFIG_LASTXML, files[files.length - 1].getAbsolutePath());
        this.hSplitPane.updateUI();
        this.vSplitPane.updateUI();
    }

    public void loadFiles(String[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            this.loadFile(files[i]);
        }
    }

    public void loadFile(final String file) {
        if (file == null) {
            return;
        }
        this.cleanUp();
        if (this.debug) {
            System.out.println("Load File: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
        Worker calculation = new Worker(){
            private String message = null;
            private byte returnValue = 0;

            public void run() {
                boolean result = ObservationManager.this.xmlCache.loadObservations(file);
                if (!result) {
                    this.message = bundle.getString("error.loadXML") + " " + file;
                    this.returnValue = (byte)2;
                }
                ObservationManager.this.table.showObservations(null, null);
                ObservationManager.this.tree.updateTree();
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        };
        this.table.showObservations(null, null);
        new ProgressDialog(this, bundle.getString("progress.wait.title"), bundle.getString("progress.wait.xml.load.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.createInfo(calculation.getReturnMessage());
            }
        } else {
            this.createWarning(calculation.getReturnMessage());
        }
        if (this.debug) {
            System.out.println("Loaded: " + new Date());
            System.out.println(this.printMemoryUsage());
        }
    }

    public void loadFile(File file) {
        if (file == null) {
            return;
        }
        this.loadFile(file.getAbsolutePath());
    }

    public XMLFileLoader getXmlCache() {
        return this.xmlCache;
    }

    public Map getUIDataCache() {
        return this.uiDataCache;
    }

    public ExtensionLoader getExtensionLoader() {
        return this.extLoader;
    }

    public ISchemaElement getSelectedTableElement() {
        return this.table.getSelectedElement();
    }

    public void updateRight(ISchemaElement element, ISchemaElement parentElement) {
        if (element != null) {
            if (element instanceof IObservation) {
                this.table.showObservations((IObservation)element, parentElement);
            } else if (element instanceof ITarget) {
                this.table.showTargets((ITarget)element);
            } else if (element instanceof IScope) {
                this.table.showScopes((IScope)element);
            } else if (element instanceof IEyepiece) {
                this.table.showEyepieces((IEyepiece)element);
            } else if (element instanceof IImager) {
                this.table.showImagers((IImager)element);
            } else if (element instanceof IFilter) {
                this.table.showFilters((IFilter)element);
            } else if (element instanceof ISite) {
                this.table.showSites((ISite)element);
            } else if (element instanceof ISession) {
                this.table.showSessions((ISession)element);
            } else if (element instanceof IObserver) {
                this.table.showObservers((IObserver)element);
            } else if (element instanceof ILens) {
                this.table.showLenses((ILens)element);
            }
        }
    }

    public void updateLeft() {
        this.tree.updateTree();
    }

    public void updateUI(ISchemaElement element) {
        this.tree.setSelection(element, null);
    }

    public void update(ISchemaElement element) {
        this.xmlCache.updateSchemaElement(element);
        this.updateLeft();
        this.updateUI(element);
    }

    public void setChanged(boolean changed) {
        if (changed && !this.changed) {
            this.setTitle(this.getTitle() + " *");
        } else if (!changed) {
            this.setTitle();
        }
        this.changed = changed;
    }

    public ItemView getItemView() {
        return this.item;
    }

    public TableView getTableView() {
        return this.table;
    }

    public TreeView getTreeView() {
        return this.tree;
    }

    public JSplitPane getHorizontalSplitPane() {
        return this.hSplitPane;
    }

    public JSplitPane getVerticalSplitPane() {
        return this.vSplitPane;
    }

    public void createWarning(String message) {
        JOptionPane.showMessageDialog(this, message, bundle.getString("title.warning"), 2);
    }

    public void createInfo(String message) {
        JOptionPane.showMessageDialog(this, message, bundle.getString("title.info"), 1);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isNightVisionEnabled() {
        return this.nightVision.isSelected();
    }

    public ProjectCatalog[] getProjects() {
        if (this.waitForCatalogLoaderThread.isAlive()) {
            try {
                this.waitForCatalogLoaderThread.join();
            }
            catch (InterruptedException ie) {
                System.err.println("Got interrupted while waiting for catalog loader...List of projects will be empty. Please try again.");
                return null;
            }
        }
        return this.projectLoader.getProjects();
    }

    public void resetWindowSizes() {
        Iterator keyIterator = this.getConfiguration().getConfigKeys().iterator();
        String currentKey = null;
        ArrayList<String> removeKeys = new ArrayList<String>();
        while (keyIterator.hasNext()) {
            currentKey = (String)keyIterator.next();
            if (!currentKey.startsWith("dialog.size.")) continue;
            removeKeys.add(currentKey);
        }
        ListIterator removeIterator = removeKeys.listIterator();
        while (removeIterator.hasNext()) {
            this.getConfiguration().setConfig((String)removeIterator.next(), null);
        }
    }

    public UpdateChecker checkForUpdates(boolean synchronousExecution) {
        UpdateChecker updateChecker = new UpdateChecker(this);
        if (synchronousExecution) {
            updateChecker.run();
        } else {
            Thread updateThread = new Thread((Runnable)updateChecker, "Check for Updates");
            updateThread.run();
        }
        return updateChecker;
    }

    public boolean checkWriteAccess(ZipFile zipFile, File destinationRoot, boolean removeRootFolder) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry ze = null;
        File currentFile = null;
        boolean result = true;
        while (enumeration.hasMoreElements()) {
            ze = enumeration.nextElement();
            currentFile = this.getDestinationFile(ze.getName(), destinationRoot, removeRootFolder);
            if (currentFile == null) continue;
            while (!currentFile.exists()) {
                currentFile = new File(currentFile.getParent());
            }
            if (currentFile.canWrite()) continue;
            System.err.println("Write check failed for: " + currentFile);
            result = false;
        }
        return result;
    }

    public boolean checkWriteAccess(File file) {
        return file.canWrite();
    }

    private File getDestinationFile(String filename, File destinationFolder, boolean removeRootFolder) {
        if (removeRootFolder && "".equals(filename = filename.substring(filename.indexOf("/") + 1))) {
            return null;
        }
        return new File(destinationFolder.getAbsolutePath() + File.separator + filename);
    }

    private void parseArguments(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith(INSTALL_DIR)) {
                    this.installDir = new File(this.getArgValue(args[i]));
                    continue;
                }
                if (args[i].startsWith(LANGUAGE)) {
                    if ("de".equals(this.getArgValue(args[i]))) {
                        Locale.setDefault(Locale.GERMAN);
                        continue;
                    }
                    Locale.setDefault(Locale.ENGLISH);
                    continue;
                }
                if (args[i].startsWith(NIGHTVISION)) {
                    this.nightVisionOnStartup = new Boolean(Boolean.parseBoolean(this.getArgValue(args[i])));
                    continue;
                }
                if (args[i].startsWith(CONFIGURATION)) {
                    this.configDir = this.getArgValue(args[i]);
                    continue;
                }
                if (args[i].startsWith(LOGGING)) {
                    this.logDir = this.getArgValue(args[i]);
                    continue;
                }
                if (!args[i].startsWith(DEBUG)) continue;
                this.debug = true;
            }
        }
    }

    private String getArgValue(String argument) {
        return argument.substring(argument.indexOf("=") + 1);
    }

    private void setInstallDir() {
        String extpath = System.getProperty("java.ext.dirs");
        StringTokenizer tokenizer = new StringTokenizer(extpath, "" + File.pathSeparatorChar);
        String entry = null;
        while (tokenizer.hasMoreTokens()) {
            entry = tokenizer.nextToken();
            if (entry.lastIndexOf(MAIN_JAR_NAME) == -1) continue;
            File jarPath = new File(entry);
            this.installDir = jarPath.getParentFile().getParentFile();
        }
        if (this.installDir != null) {
            return;
        }
        this.installDir = new File(System.getProperty("user.dir"));
    }

    private void loadConfig() {
        String lastFile;
        boolean load = Boolean.valueOf(this.configuration.getConfig(CONFIG_OPENONSTARTUP));
        if (load && (lastFile = this.configuration.getConfig(CONFIG_LASTXML)) != null && !"".equals(lastFile)) {
            this.loadFile(new File(lastFile));
        }
    }

    private File saveDialog() {
        File dir;
        JFileChooser chooser = new JFileChooser();
        String last = this.configuration.getConfig(CONFIG_LASTDIR);
        if (last != null && !"".equals(last.trim()) && (dir = new File(last)) != null && dir.exists()) {
            chooser.setCurrentDirectory(dir);
        }
        chooser.setDialogType(1);
        int returnValue = chooser.showSaveDialog(this);
        File file = null;
        if (returnValue == 0) {
            file = chooser.getSelectedFile();
        }
        if (file != null && !file.getName().toLowerCase().endsWith(".xml")) {
            file = new File(file.getAbsolutePath() + ".xml");
        }
        return file;
    }

    private void cleanUp() {
        this.uiDataCache.clear();
        this.xmlCache.clear();
        this.tree.updateTree();
    }

    private void loadLanguage() {
        String isoKey = this.configuration.getConfig(CONFIG_UILANGUAGE);
        if (isoKey != null) {
            Locale.setDefault(new Locale(isoKey, isoKey));
            System.setProperty("user.language", isoKey);
            System.setProperty("user.region", isoKey);
            JComponent.setDefaultLocale(Locale.getDefault());
        }
        try {
            bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            Locale.setDefault(Locale.ENGLISH);
            bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
        }
    }

    private void setTitle() {
        Class<?> toolkit = Toolkit.getDefaultToolkit().getClass();
        if (toolkit.getName().equals("sun.awt.X11.XToolkit")) {
            try {
                Field awtAppClassName = toolkit.getDeclaredField("awtAppClassName");
                awtAppClassName.setAccessible(true);
                awtAppClassName.set(null, "Observation Manager - " + bundle.getString("version") + " " + VERSION);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setTitle("Observation Manager - " + bundle.getString("version") + " " + VERSION);
    }

    private void initMenuBar() {
        String iconDir = this.getInstallDir().getAbsolutePath() + File.separatorChar + "images" + File.separatorChar;
        int menuKeyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(bundle.getString("menu.file"));
        this.fileMenu.setMnemonic('f');
        this.menuBar.add(this.fileMenu);
        this.newFile = new JMenuItem(bundle.getString("menu.newFile"), new ImageIcon(iconDir + "newDocument.png"));
        this.newFile.setMnemonic('n');
        this.newFile.addActionListener(this);
        this.fileMenu.add(this.newFile);
        this.openFile = new JMenuItem(bundle.getString("menu.openFile"), new ImageIcon(iconDir + "open.png"));
        this.openFile.setMnemonic('o');
        this.openFile.addActionListener(this);
        this.openFile.setAccelerator(KeyStroke.getKeyStroke(79, menuKeyModifier));
        this.fileMenu.add(this.openFile);
        this.saveFile = new JMenuItem(bundle.getString("menu.save"), new ImageIcon(iconDir + "save.png"));
        this.saveFile.setMnemonic('s');
        this.saveFile.addActionListener(this);
        this.saveFile.setAccelerator(KeyStroke.getKeyStroke(83, menuKeyModifier));
        this.fileMenu.add(this.saveFile);
        this.saveFileAs = new JMenuItem(bundle.getString("menu.saveAs"), new ImageIcon(iconDir + "save.png"));
        this.saveFileAs.setMnemonic('a');
        this.saveFileAs.addActionListener(this);
        this.fileMenu.add(this.saveFileAs);
        this.fileMenu.addSeparator();
        this.importXML = new JMenuItem(bundle.getString("menu.xmlImport"), new ImageIcon(iconDir + "importXML.png"));
        this.importXML.setMnemonic('i');
        this.importXML.addActionListener(this);
        this.fileMenu.add(this.importXML);
        this.fileMenu.addSeparator();
        this.exportHTML = new JMenuItem(bundle.getString("menu.htmlExport"), new ImageIcon(iconDir + "export.png"));
        this.exportHTML.setMnemonic('e');
        this.exportHTML.addActionListener(this);
        this.exportHTML.setAccelerator(KeyStroke.getKeyStroke(80, menuKeyModifier));
        this.fileMenu.add(this.exportHTML);
        this.fileMenu.addSeparator();
        this.exit = new JMenuItem(bundle.getString("menu.exit"), new ImageIcon(iconDir + "exit.png"));
        this.exit.setMnemonic('x');
        this.exit.addActionListener(this);
        this.fileMenu.add(this.exit);
        this.dataMenu = new JMenu(bundle.getString("menu.data"));
        this.dataMenu.setMnemonic('d');
        this.menuBar.add(this.dataMenu);
        this.createObservation = new JMenuItem(bundle.getString("menu.createObservation"), new ImageIcon(iconDir + "observation_l.png"));
        this.createObservation.setMnemonic('o');
        this.createObservation.addActionListener(this);
        this.createObservation.setAccelerator(KeyStroke.getKeyStroke(78, menuKeyModifier));
        this.dataMenu.add(this.createObservation);
        this.dataMenu.addSeparator();
        this.createObserver = new JMenuItem(bundle.getString("menu.createObserver"), new ImageIcon(iconDir + "observer_l.png"));
        this.createObserver.setMnemonic('v');
        this.createObserver.addActionListener(this);
        this.dataMenu.add(this.createObserver);
        this.createSite = new JMenuItem(bundle.getString("menu.createSite"), new ImageIcon(iconDir + "site_l.png"));
        this.createSite.setMnemonic('l');
        this.createSite.addActionListener(this);
        this.dataMenu.add(this.createSite);
        this.createScope = new JMenuItem(bundle.getString("menu.createScope"), new ImageIcon(iconDir + "scope_l.png"));
        this.createScope.setMnemonic('s');
        this.createScope.addActionListener(this);
        this.dataMenu.add(this.createScope);
        this.createEyepiece = new JMenuItem(bundle.getString("menu.createEyepiece"), new ImageIcon(iconDir + "eyepiece_l.png"));
        this.createEyepiece.setMnemonic('e');
        this.createEyepiece.addActionListener(this);
        this.dataMenu.add(this.createEyepiece);
        this.createLens = new JMenuItem(bundle.getString("menu.createLens"), new ImageIcon(iconDir + "lens_l.png"));
        this.createLens.setMnemonic('o');
        this.createLens.addActionListener(this);
        this.dataMenu.add(this.createLens);
        this.createFilter = new JMenuItem(bundle.getString("menu.createFilter"), new ImageIcon(iconDir + "filter_l.png"));
        this.createFilter.setMnemonic('f');
        this.createFilter.addActionListener(this);
        this.dataMenu.add(this.createFilter);
        this.createImager = new JMenuItem(bundle.getString("menu.createImager"), new ImageIcon(iconDir + "imager_l.png"));
        this.createImager.setMnemonic('i');
        this.createImager.addActionListener(this);
        this.dataMenu.add(this.createImager);
        this.createTarget = new JMenuItem(bundle.getString("menu.createTarget"), new ImageIcon(iconDir + "target_l.png"));
        this.createTarget.setMnemonic('t');
        this.createTarget.addActionListener(this);
        this.dataMenu.add(this.createTarget);
        this.createSession = new JMenuItem(bundle.getString("menu.createSession"), new ImageIcon(iconDir + "session_l.png"));
        this.createSession.setMnemonic('n');
        this.createSession.addActionListener(this);
        this.dataMenu.add(this.createSession);
        this.dataMenu.addSeparator();
        this.equipmentAvailability = new JMenuItem(bundle.getString("menu.equipmentAvailability"), new ImageIcon(iconDir + "equipment.png"));
        this.equipmentAvailability.setMnemonic('a');
        this.equipmentAvailability.addActionListener(this);
        this.dataMenu.add(this.equipmentAvailability);
        this.extraMenu = new JMenu(bundle.getString("menu.extra"));
        this.extraMenu.setMnemonic('e');
        this.menuBar.add(this.extraMenu);
        this.showStatistics = new JMenuItem(bundle.getString("menu.showStatistics"), new ImageIcon(iconDir + "statistic.png"));
        this.showStatistics.setMnemonic('s');
        this.showStatistics.addActionListener(this);
        this.extraMenu.add(this.showStatistics);
        this.preferences = new JMenuItem(bundle.getString("menu.preferences"), new ImageIcon(iconDir + "preferences.png"));
        this.preferences.setMnemonic('p');
        this.preferences.addActionListener(this);
        this.extraMenu.add(this.preferences);
        this.extraMenu.addSeparator();
        this.didYouKnow = new JMenuItem(bundle.getString("menu.didYouKnow"), new ImageIcon(iconDir + "questionMark.png"));
        this.didYouKnow.setMnemonic('d');
        this.didYouKnow.addActionListener(this);
        this.didYouKnow.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.extraMenu.add(this.didYouKnow);
        this.extraMenu.addSeparator();
        this.nightVision = new JCheckBoxMenuItem(bundle.getString("menu.nightVision"));
        this.nightVision.setMnemonic('v');
        this.nightVision.addActionListener(this);
        this.extraMenu.add(this.nightVision);
        this.extraMenu.addSeparator();
        this.logMenuEntry = new JMenuItem(bundle.getString("menu.log"), new ImageIcon(iconDir + "logviewer.png"));
        this.logMenuEntry.setMnemonic('l');
        this.logMenuEntry.addActionListener(this);
        this.extraMenu.add(this.logMenuEntry);
        this.extraMenu.addSeparator();
        this.updateMenuEntry = new JMenuItem(bundle.getString("menu.updateCheck"), new ImageIcon(iconDir + "updater.png"));
        this.updateMenuEntry.setMnemonic('u');
        this.updateMenuEntry.addActionListener(this);
        this.extraMenu.add(this.updateMenuEntry);
        this.extensionMenu = new JMenu(bundle.getString("menu.extension"));
        this.extensionMenu.setMnemonic('x');
        this.menuBar.add(this.extensionMenu);
        JMenu[] menus = this.extLoader.getMenus();
        for (int i = 0; i < menus.length; ++i) {
            this.extensionMenu.add(menus[i]);
        }
        if (menus.length != 0) {
            this.extensionMenu.addSeparator();
        }
        this.extensionInfo = new JMenuItem(bundle.getString("menu.extensionInfo"), new ImageIcon(iconDir + "extensionInfo.png"));
        this.extensionInfo.setMnemonic('p');
        this.extensionInfo.addActionListener(this);
        this.extensionMenu.add(this.extensionInfo);
        this.installExtension = new JMenuItem(bundle.getString("menu.installExtension"), new ImageIcon(iconDir + "extension.png"));
        this.installExtension.setMnemonic('i');
        this.installExtension.addActionListener(this);
        this.extensionMenu.add(this.installExtension);
        this.aboutMenu = new JMenu(bundle.getString("menu.about"));
        this.aboutMenu.setMnemonic('a');
        this.menuBar.add(this.aboutMenu);
        this.aboutInfo = new JMenuItem(bundle.getString("menu.aboutOM"), new ImageIcon(iconDir + "about.png"));
        this.aboutInfo.setMnemonic('i');
        this.aboutInfo.addActionListener(this);
        this.aboutMenu.add(this.aboutInfo);
        this.setJMenuBar(this.menuBar);
    }

    private void initMain() {
        this.setLocationAndSize();
        this.hSplitPane = new JSplitPane(0);
        this.hSplitPane.setTopComponent(this.table);
        this.hSplitPane.setBottomComponent(this.item);
        this.hSplitPane.setContinuousLayout(true);
        super.getContentPane().add(this.hSplitPane);
        this.vSplitPane = new JSplitPane(1);
        this.vSplitPane.setLeftComponent(this.tree);
        this.vSplitPane.setRightComponent(this.hSplitPane);
        this.vSplitPane.setContinuousLayout(true);
        super.getContentPane().add(this.vSplitPane);
        this.hSplitPane.setVisible(true);
        this.vSplitPane.setVisible(true);
        this.setDividerLocation();
        if (this.splash != null) {
            try {
                this.splash.join();
            }
            catch (InterruptedException ie) {
                System.out.println("Waiting for SplashScreen interrupted");
            }
        }
        super.setVisible(true);
    }

    private void setLocationAndSize() {
        Dimension maxSize = Toolkit.getDefaultToolkit().getScreenSize();
        String stringSize = this.configuration.getConfig(CONFIG_MAINWINDOW_SIZE, maxSize.width + "x" + maxSize.height);
        int width = Integer.parseInt(stringSize.substring(0, stringSize.indexOf(120)));
        int height = Integer.parseInt(stringSize.substring(stringSize.indexOf(120) + 1));
        if (width > maxSize.width) {
            width = maxSize.width;
        }
        if (height > maxSize.height) {
            height = maxSize.height;
        }
        Dimension size = new Dimension(width, height);
        this.setSize(size);
        String stringLocation = this.configuration.getConfig(CONFIG_MAINWINDOW_POS);
        int x = 0;
        int y = 0;
        if (stringLocation != null && !"".equals(stringLocation.trim())) {
            x = Integer.parseInt(stringLocation.substring(0, stringLocation.indexOf(44)));
            y = Integer.parseInt(stringLocation.substring(stringLocation.indexOf(44) + 1));
            if (x > maxSize.width) {
                x = 0;
            }
            if (y > maxSize.height) {
                y = 0;
            }
        }
        this.setLocation(x, y);
        boolean maximized = Boolean.valueOf(this.configuration.getConfig(CONFIG_MAINWINDOW_MAXIMIZED, Boolean.toString(false)));
        if (maximized) {
            this.setExtendedState(6);
        }
    }

    private void setDividerLocation() {
        String sVertical = this.configuration.getConfig(CONFIG_MAINWINDOW_DIVIDER_VERTICAL);
        String sHorizontal = this.configuration.getConfig(CONFIG_MAINWINDOW_DIVIDER_HORIZONTAL);
        float vertical = 0.0f;
        float horizontal = 0.0f;
        if (sHorizontal != null && sVertical != null) {
            try {
                vertical = FloatUtil.parseFloat((String)sVertical);
                horizontal = FloatUtil.parseFloat((String)sHorizontal);
            }
            catch (NumberFormatException nfe) {
                sVertical = null;
                sHorizontal = null;
            }
        }
        if (sVertical == null || "".equals(sVertical.trim())) {
            this.vSplitPane.setDividerLocation(this.getWidth() / 5);
        } else {
            this.vSplitPane.setDividerLocation((int)((float)this.getWidth() / vertical));
        }
        if (sVertical == null || "".equals(sVertical.trim())) {
            this.hSplitPane.setDividerLocation((int)((double)this.getHeight() / 2.7));
        } else {
            this.hSplitPane.setDividerLocation((int)((float)this.getHeight() / horizontal));
        }
    }

    private TableView initTableView() {
        TableView table = new TableView(this);
        table.setVisible(true);
        return table;
    }

    private ItemView initItemView() {
        ItemView item = new ItemView(this);
        item.setVisible(true);
        return item;
    }

    private TreeView initTreeView() {
        TreeView tree = new TreeView(this);
        tree.setMinimumSize(new Dimension(this.getWidth() / 8, this.getHeight()));
        tree.setVisible(true);
        return tree;
    }

    private Templates getTemplate(StreamSource xslSource) {
        Templates template = null;
        try {
            template = TransformerFactoryImpl.newInstance().newTemplates(xslSource);
        }
        catch (TransformerConfigurationException tce) {
            System.err.println("--- Unable to get XSLTransformator: " + tce);
        }
        return template;
    }

    private String replaceSpecialChars(String string) {
        string = string.replace('/', '_');
        string = string.replace('\\', '_');
        string = string.replace('@', '_');
        string = string.replace('$', '_');
        string = string.replace('%', '_');
        string = string.replace('&', '_');
        string = string.replace(':', '_');
        string = string.replace(';', '_');
        return string;
    }

    private int saveBeforeExit() {
        if (this.changed) {
            JOptionPane pane = new JOptionPane(bundle.getString("info.saveBeforeExit.question"), 3, 1);
            JDialog dialog = pane.createDialog(this, bundle.getString("info.saveBeforeExit.title"));
            dialog.setVisible(true);
            Object selectedValue = pane.getValue();
            if (selectedValue != null && selectedValue instanceof Integer) {
                if ((Integer)selectedValue == 0) {
                    boolean result = this.saveFile();
                    if (!result) {
                        return -1;
                    }
                    return 0;
                }
                if ((Integer)selectedValue == 2) {
                    return 2;
                }
            }
            return 1;
        }
        return 3;
    }

    private boolean transformXML2HTML(final Document doc, final File htmlFile, final File xslFile) {
        Worker calculation = new Worker(){
            private String message = null;
            private byte returnValue = 0;

            public void run() {
                File xsl;
                if (doc == null || htmlFile == null) {
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.transformation");
                    return;
                }
                DOMSource source = new DOMSource(doc);
                File file = xsl = xslFile == null ? ObservationManager.this.getXSLFile() : xslFile;
                if (xsl == null && xsl == null) {
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.transformation");
                    return;
                }
                StreamSource xslSource = new StreamSource(xsl);
                StreamResult result = null;
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(htmlFile);
                    result = new StreamResult(outputStream);
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("Cannot transform XML file.\n" + fnfe);
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.transformation");
                    return;
                }
                try {
                    Templates template = ObservationManager.this.getTemplate(xslSource);
                    if (template == null) {
                        this.returnValue = (byte)2;
                        this.message = bundle.getString("error.transformation");
                        try {
                            outputStream.close();
                        }
                        catch (IOException ioe) {
                            System.err.println("Cannot close stream.\n" + ioe);
                        }
                        return;
                    }
                    template.newTransformer().transform(source, result);
                }
                catch (TransformerConfigurationException tce) {
                    System.err.println("Cannot transform XML file.\n" + tce);
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.transformation");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ioe) {
                        System.err.println("Cannot close stream.\n" + ioe);
                    }
                    return;
                }
                catch (TransformerException te) {
                    System.err.println("Cannot transform XML file.\n" + te);
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.transformation");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ioe) {
                        System.err.println("Cannot close stream.\n" + ioe);
                    }
                    return;
                }
                try {
                    outputStream.close();
                }
                catch (IOException ioe) {
                    System.err.println("Cannot close stream.\n" + ioe);
                }
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        };
        new ProgressDialog(this, bundle.getString("progress.wait.title"), bundle.getString("progress.wait.html.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.createInfo(calculation.getReturnMessage());
            }
            return true;
        }
        this.createWarning(calculation.getReturnMessage());
        return false;
    }

    private File getXSLFile() {
        File path;
        String TEMPLATE_FILENAME = "transform";
        String selectedTemplate = this.configuration.getConfig(CONFIG_XSL_TEMPLATE);
        if (selectedTemplate == null || "".equals(selectedTemplate.trim())) {
            selectedTemplate = "oal2html";
        }
        if (!(path = new File(this.installDir.getAbsolutePath() + File.separator + "xsl" + File.separator + selectedTemplate + File.separator)).exists()) {
            this.createWarning(bundle.getString("warning.xslTemplate.dirDoesNotExist") + "\n" + path.getAbsolutePath());
            return null;
        }
        File xslFile = new File(path.getAbsolutePath() + File.separator + "transform" + "_" + Locale.getDefault().getLanguage() + ".xsl");
        if (!xslFile.exists() && !(xslFile = new File(path.getAbsolutePath() + File.separator + "transform" + ".xsl")).exists()) {
            this.createWarning(bundle.getString("warning.xslTemplate.noFileFoundWithName") + "\n" + path.getAbsolutePath() + File.separator + "transform" + ".xsl\n" + path.getAbsolutePath() + File.separator + "transform" + "_" + Locale.getDefault().getLanguage() + ".xsl");
            return null;
        }
        return xslFile;
    }

    private String printMemoryUsage() {
        String mem = "Memory Usage:\n\t- Current Heap Size: ";
        long fMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        mem = mem + fMem;
        mem = mem + "\n\t- Max. Heap Size: " + Runtime.getRuntime().maxMemory();
        return mem;
    }

    private void createHTMLForSchemaElement(ISchemaElement schemaElement, File htmlFile) {
        IObservation[] observations = this.xmlCache.getObservations(schemaElement);
        if (observations == null || observations.length == 0) {
            this.createWarning(bundle.getString("error.export.xml.noObservationsForSchemaElement"));
            return;
        }
        Document doc = this.xmlCache.getDocumentForSchemaElement(schemaElement);
        String[] files = this.xmlCache.getAllOpenedFiles();
        if (files == null || files.length == 0) {
            this.createInfo(bundle.getString("error.noXMLFileOpen"));
            return;
        }
        this.transformXML2HTML(doc, htmlFile, null);
        this.createInfo(bundle.getString("info.htmlExportDir") + " " + htmlFile);
    }

    private void createXMLForSchemaElement(ISchemaElement schemaElement, File xmlFile) {
        XMLFileLoader xmlHelper = new XMLFileLoader(xmlFile);
        IObservation[] observations = null;
        observations = schemaElement instanceof IObservation ? new IObservation[]{(IObservation)schemaElement} : this.xmlCache.getObservations(schemaElement);
        if (observations == null || observations.length == 0) {
            this.createWarning(bundle.getString("error.export.xml.noObservationsForSchemaElement"));
            return;
        }
        for (int i = 0; i < observations.length; ++i) {
            xmlHelper.addSchemaElement((ISchemaElement)observations[i], true);
        }
        boolean result = xmlHelper.save(xmlFile.getAbsolutePath());
        if (result) {
            this.createInfo(bundle.getString("error.export.xml.ok") + xmlFile);
        } else {
            this.createWarning(bundle.getString("error.export.xml.nok"));
        }
    }

    private String getCurrentXMLParentPath() {
        File xmlFile = new File(this.xmlCache.getAllOpenedFiles()[0]);
        return xmlFile.getParent();
    }

    private void enableMenus(boolean enabled) {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            this.menuBar.getMenu(i).setEnabled(enabled);
        }
    }

    private boolean installExtension(File[] files, boolean promptForRestart) {
        if (files == null) {
            File dir;
            JFileChooser chooser = new JFileChooser(bundle.getString("extenstion.chooser.title"));
            FileFilter zipFileFilter = new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().endsWith(".ome") || f.isDirectory();
                }

                public String getDescription() {
                    return "Observation Manager extensions";
                }
            };
            chooser.setFileFilter(zipFileFilter);
            String last = this.configuration.getConfig(CONFIG_LASTDIR);
            if (last != null && !"".equals(last.trim()) && (dir = new File(last)) != null && dir.exists()) {
                chooser.setCurrentDirectory(dir);
            }
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                files = chooser.getSelectedFiles();
            } else {
                return false;
            }
        }
        String negativeResult = "";
        ArrayList<File> filesOK = new ArrayList<File>();
        try {
            boolean checkResult = false;
            for (int i = 0; i < files.length; ++i) {
                checkResult = this.checkWriteAccess(new ZipFile(files[i]), this.installDir, false);
                if (!checkResult) {
                    negativeResult = negativeResult + " " + files[i].getName();
                    continue;
                }
                filesOK.add(files[i]);
            }
        }
        catch (IOException ioe) {
            System.out.println("Error while checking extension zip file. Zip file may be corrupted.\n" + ioe);
        }
        File[] filesCheckedOK = filesOK.toArray(new File[0]);
        Cursor hourglassCursor = new Cursor(3);
        this.setCursor(hourglassCursor);
        String positiveResult = "";
        int successCounter = 0;
        for (int i = 0; i < filesCheckedOK.length; ++i) {
            try {
                positiveResult = positiveResult + " " + this.extLoader.addExtension(new ZipFile(filesCheckedOK[i]));
                ++successCounter;
                if (i >= filesCheckedOK.length - 1) continue;
                positiveResult = positiveResult + ", ";
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Error in extension zip file. Zip file may be corrupted.\n" + ioe);
                Cursor normalCursor = new Cursor(0);
                this.setCursor(normalCursor);
                negativeResult = negativeResult + " " + filesCheckedOK[i].getName();
            }
        }
        boolean result = false;
        if (successCounter > 0) {
            this.createInfo(bundle.getString("info.addExtensionSuccess") + " " + positiveResult);
            if (promptForRestart) {
                this.createInfo(bundle.getString("info.addExtensionRestart"));
                this.exit();
            }
            result = true;
        }
        if (successCounter < files.length) {
            this.createWarning(bundle.getString("error.addExtensionFail") + " " + negativeResult);
            result = false;
        }
        Cursor normalCursor = new Cursor(0);
        this.setCursor(normalCursor);
        return result;
    }

    private void enableNightVisionTheme(boolean enable) {
        if (enable) {
            try {
                UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
                boolean found = false;
                for (int i = 0; i < laf.length; ++i) {
                    if (!"metal".equals(laf[i].getName().toLowerCase())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    System.err.println(bundle.getString("error.noMetalLAF"));
                    this.createWarning(bundle.getString("error.noNightVision"));
                    return;
                }
                MetalLookAndFeel.setCurrentTheme(new NightVisionTheme());
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this);
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                this.dispose();
                this.setUndecorated(true);
                this.addNotify();
                this.createBufferStrategy(2);
                this.getRootPane().setWindowDecorationStyle(1);
                this.update(super.getGraphics());
                this.configuration.setConfig(CONFIG_NIGHTVISION_ENABLED, Boolean.toString(true));
                this.setVisible(true);
            }
            catch (Exception e) {
                System.err.println(e);
                this.createWarning(bundle.getString("error.noNightVision"));
            }
        } else {
            try {
                Constructor<?>[] constructors;
                Class<?> themeClass = null;
                try {
                    themeClass = ClassLoader.getSystemClassLoader().loadClass("javax.swing.plaf.metal.OceanTheme");
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                boolean problem = true;
                if (themeClass != null && (constructors = themeClass.getConstructors()).length > 0) {
                    Class<?>[] parameters = null;
                    for (int i = 0; i < constructors.length; ++i) {
                        parameters = constructors[i].getParameterTypes();
                        if (parameters.length != 0) continue;
                        MetalTheme theme = (MetalTheme)constructors[i].newInstance(null);
                        MetalLookAndFeel.setCurrentTheme(theme);
                        problem = false;
                        break;
                    }
                }
                if (problem) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                }
                UIManager.setLookAndFeel(new MetalLookAndFeel());
                SwingUtilities.updateComponentTreeUI(this);
                JFrame.setDefaultLookAndFeelDecorated(false);
                JDialog.setDefaultLookAndFeelDecorated(false);
                this.dispose();
                this.setUndecorated(false);
                this.addNotify();
                this.createBufferStrategy(2);
                this.getRootPane().setWindowDecorationStyle(0);
                this.update(super.getGraphics());
                this.configuration.setConfig(CONFIG_NIGHTVISION_ENABLED, Boolean.toString(false));
                this.setVisible(true);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private void importXML() {
        File dir;
        JFileChooser chooser = new JFileChooser();
        FileFilter xmlFileFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".xml") || f.isDirectory();
            }

            public String getDescription() {
                return "OAL Files";
            }
        };
        chooser.setFileFilter(xmlFileFilter);
        String last = this.configuration.getConfig(CONFIG_LASTDIR);
        if (last != null && !"".equals(last.trim()) && (dir = new File(last)) != null && dir.exists()) {
            chooser.setCurrentDirectory(dir);
        }
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        class ImportWorker
        implements Worker {
            private File importFile = null;
            private File schemaFile = null;
            private ObservationManager om = null;
            private String message = null;
            private byte returnValue = 0;

            public ImportWorker(File importFile, File schemaFile, ObservationManager om) {
                this.importFile = importFile;
                this.schemaFile = schemaFile;
                this.om = om;
            }

            public void run() {
                SchemaLoader importer = new SchemaLoader();
                try {
                    importer.load(this.importFile, this.schemaFile);
                }
                catch (SchemaException se) {
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.import.xmlFile");
                    return;
                }
                catch (OALException oale) {
                    this.returnValue = (byte)2;
                    this.message = bundle.getString("error.import.xmlFile");
                    return;
                }
                ArrayList<Object> importedElements = new ArrayList<Object>();
                importedElements.addAll(Arrays.asList(importer.getEyepieces()));
                importedElements.addAll(Arrays.asList(importer.getFilters()));
                importedElements.addAll(Arrays.asList(importer.getImagers()));
                importedElements.addAll(Arrays.asList(importer.getObservers()));
                importedElements.addAll(Arrays.asList(importer.getScopes()));
                importedElements.addAll(Arrays.asList(importer.getSessions()));
                importedElements.addAll(Arrays.asList(importer.getSites()));
                importedElements.addAll(Arrays.asList(importer.getTargets()));
                importedElements.addAll(Arrays.asList(importer.getLenses()));
                ListIterator iterator = importedElements.listIterator();
                while (iterator.hasNext()) {
                    this.om.getXmlCache().addSchemaElement((ISchemaElement)iterator.next());
                }
                IObservation[] obs = importer.getObservations();
                if (obs != null && obs.length > 0) {
                    for (int i = 0; i < obs.length; ++i) {
                        this.om.getXmlCache().addSchemaElement((ISchemaElement)obs[i]);
                    }
                }
                this.om.updateLeft();
                this.message = bundle.getString("ok.import.xmlFile");
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        }
        ImportWorker calculation = new ImportWorker(file, this.schemaPath, this);
        Cursor hourglassCursor = new Cursor(3);
        this.setCursor(hourglassCursor);
        new ProgressDialog(this, bundle.getString("progress.wait.title"), bundle.getString("progress.wait.xml.load.info"), calculation);
        Cursor normalCursor = new Cursor(0);
        this.setCursor(normalCursor);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.createInfo(calculation.getReturnMessage());
            }
            this.setChanged(true);
        } else {
            this.createWarning(calculation.getReturnMessage());
        }
    }

    private void loadProjectFiles() {
        class WaitForCatalogLoader
        implements Runnable {
            private ObservationManager om = null;

            public WaitForCatalogLoader(ObservationManager om) {
                this.om = om;
            }

            public void run() {
                while (this.om.projectLoader == null) {
                    try {
                        if (!this.om.getExtensionLoader().getCatalogLoader().isLoading()) {
                            if (this.om.isDebug()) {
                                System.out.println("Catalog loading done. Start project loading in background...");
                            }
                            this.om.projectLoader = new ProjectLoader(this.om);
                            continue;
                        }
                        this.wait(300L);
                    }
                    catch (InterruptedException ie) {
                        System.err.println("Interrupted while waiting for Catalog Loader to finish.\n" + ie);
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {}
                }
            }
        }
        this.waitForCatalogLoaderThread = new Thread((Runnable)new WaitForCatalogLoader(this), "Waiting for Catalog Loader to finish");
        this.waitForCatalogLoaderThread.start();
    }

    private void addShortcuts() {
        int menuKeyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(78, menuKeyModifier), "NEW_OBSERVATION");
        this.getRootPane().getActionMap().put("NEW_OBSERVATION", new AbstractAction(){
            private static final long serialVersionUID = 54338866832362257L;

            public void actionPerformed(ActionEvent e) {
                ObservationManager.this.createNewObservation();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(80, menuKeyModifier), "PRINT");
        this.getRootPane().getActionMap().put("PRINT", new AbstractAction(){
            private static final long serialVersionUID = -5051798279720676416L;

            public void actionPerformed(ActionEvent e) {
                ObservationManager.this.createHTML();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "HELP");
        this.getRootPane().getActionMap().put("HELP", new AbstractAction(){
            private static final long serialVersionUID = 2672501453219731894L;

            public void actionPerformed(ActionEvent e) {
                ObservationManager.this.showDidYouKnow();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(69, menuKeyModifier), "EDIT_OBSERVATION");
        this.getRootPane().getActionMap().put("EDIT_OBSERVATION", new AbstractAction(){
            private static final long serialVersionUID = 7853484982323650329L;

            public void actionPerformed(ActionEvent e) {
                ISchemaElement element = ObservationManager.this.getSelectedTableElement();
                if (element instanceof IObservation) {
                    new ObservationDialog(ObservationManager.this, (IObservation)element);
                } else if (element instanceof ITarget) {
                    ITarget target = (ITarget)element;
                    ObservationManager.this.getExtensionLoader().getSchemaUILoader().getTargetDialog(target.getXSIType(), target, null);
                } else if (element instanceof IScope) {
                    new ScopeDialog(ObservationManager.this, (IScope)element);
                } else if (element instanceof IEyepiece) {
                    new EyepieceDialog(ObservationManager.this, (IEyepiece)element);
                } else if (element instanceof IImager) {
                    IImager imager = (IImager)element;
                    ObservationManager.this.getExtensionLoader().getSchemaUILoader().getSchemaElementDialog(imager.getXSIType(), 3, (ISchemaElement)imager, true);
                } else if (element instanceof ISite) {
                    new SiteDialog(ObservationManager.this, (ISite)element);
                } else if (element instanceof IFilter) {
                    new FilterDialog(ObservationManager.this, (IFilter)element);
                } else if (element instanceof ISession) {
                    new SessionDialog(ObservationManager.this, (ISession)element);
                } else if (element instanceof IObserver) {
                    new ObserverDialog(ObservationManager.this, (IObserver)element);
                } else if (element instanceof ILens) {
                    new LensDialog(ObservationManager.this, (ILens)element);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(83, menuKeyModifier), "SAVE_FILE");
        this.getRootPane().getActionMap().put("SAVE_FILE", new AbstractAction(){
            private static final long serialVersionUID = -4045748682943270961L;

            public void actionPerformed(ActionEvent e) {
                ObservationManager.this.saveFile();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(79, menuKeyModifier), "OPEN_FILE");
        this.getRootPane().getActionMap().put("OPEN_FILE", new AbstractAction(){
            private static final long serialVersionUID = -8299917980145286282L;

            public void actionPerformed(ActionEvent e) {
                ObservationManager.this.openFile();
            }
        });
    }

    static {
        try {
            UPDATE_URL = new URL("http://observation.sourceforge.net/update");
        }
        catch (MalformedURLException url) {
            System.err.println("Malformed update check URL: " + UPDATE_URL);
        }
    }
}

