/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IFinding;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.Lens;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.TabIDComponent;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.EyepiecePanel;
import de.lehmannet.om.ui.panel.FilterPanel;
import de.lehmannet.om.ui.panel.IFindingPanel;
import de.lehmannet.om.ui.panel.IImagerPanel;
import de.lehmannet.om.ui.panel.LensPanel;
import de.lehmannet.om.ui.panel.ObservationItemPanel;
import de.lehmannet.om.ui.panel.ObserverPanel;
import de.lehmannet.om.ui.panel.ScopePanel;
import de.lehmannet.om.ui.panel.SessionPanel;
import de.lehmannet.om.ui.panel.SitePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ItemView
extends JPanel
implements ChangeListener {
    private static final TabIDComponent FINDING_TIC = new TabIDComponent(1);
    private static final TabIDComponent TARGET_TIC = new TabIDComponent(2);
    private static final TabIDComponent SITE_TIC = new TabIDComponent(3);
    private static final TabIDComponent SESSION_TIC = new TabIDComponent(4);
    private static final TabIDComponent SCOPE_TIC = new TabIDComponent(5);
    private static final TabIDComponent OBSERVER_TIC = new TabIDComponent(6);
    private static final TabIDComponent EYEPIECE_TIC = new TabIDComponent(7);
    private static final TabIDComponent FILTER_TIC = new TabIDComponent(8);
    private static final TabIDComponent IMAGER_TIC = new TabIDComponent(9);
    private static final TabIDComponent LENS_TIC = new TabIDComponent(10);
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager main = null;
    private JTabbedPane tabbedPane = null;
    private ObservationItemPanel overviewPanel = null;
    private AbstractPanel targetPanel = null;
    private AbstractPanel findingPanel = null;
    private SitePanel sitePanel = null;
    private SessionPanel sessionPanel = null;
    private ScopePanel scopePanel = null;
    private ObserverPanel observerPanel = null;
    private EyepiecePanel eyepiecePanel = null;
    private FilterPanel filterPanel = null;
    private AbstractPanel imagerPanel = null;
    private LensPanel lensPanel = null;
    private Component lastSelectedTab = null;
    private IObservation currentObseration = null;
    private String imagesDir = null;

    public ItemView(ObservationManager main) {
        this.imagesDir = main.getInstallDir().getAbsolutePath() + File.separatorChar + "images" + File.separatorChar;
        this.main = main;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        super.setLayout(new BorderLayout());
        super.add(this.tabbedPane);
    }

    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component tabIndexComponent = ItemView.this.tabbedPane.getSelectedComponent();
                if (!(tabIndexComponent instanceof TabIDComponent)) {
                    return;
                }
                byte tabID = ((TabIDComponent)tabIndexComponent).getTabID();
                switch (tabID) {
                    case 1: {
                        IFinding f = (IFinding)ItemView.this.currentObseration.getResults().get(0);
                        ISession se = ItemView.this.currentObseration.getSession();
                        ITarget t = ItemView.this.currentObseration.getTarget();
                        ItemView.this.loadFindingPanel(f, se, t, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 2: {
                        ITarget t = ItemView.this.currentObseration.getTarget();
                        ItemView.this.loadTargetPanel(t, ItemView.this.currentObseration, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 3: {
                        ISite s = ItemView.this.currentObseration.getSite();
                        ItemView.this.loadSitePanel(s, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 4: {
                        ISession s = ItemView.this.currentObseration.getSession();
                        ItemView.this.loadSessionPanel(s, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 5: {
                        IScope s = ItemView.this.currentObseration.getScope();
                        ItemView.this.loadScopePanel(s, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 6: {
                        IObserver o = ItemView.this.currentObseration.getObserver();
                        ItemView.this.loadObserverPanel(o, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 7: {
                        IEyepiece eye = ItemView.this.currentObseration.getEyepiece();
                        ItemView.this.loadEyepiecePanel(eye, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 8: {
                        IFilter f = ItemView.this.currentObseration.getFilter();
                        ItemView.this.loadFilterPanel(f, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 9: {
                        IImager i = ItemView.this.currentObseration.getImager();
                        ItemView.this.loadImagerPanel(i, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                    case 10: {
                        ILens l = ItemView.this.currentObseration.getLens();
                        ItemView.this.loadLensPanel(l, ItemView.this.tabbedPane.getSelectedIndex());
                        return;
                    }
                }
                ItemView.this.tabbedPane.setSelectedIndex(0);
            }
        });
    }

    public void clear() {
        this.tabbedPane.removeAll();
        this.lastSelectedTab = null;
        this.currentObseration = null;
    }

    public void showObservation(IObservation observation) {
        ILens len;
        IImager img;
        IFilter fil;
        IEyepiece eye;
        IObserver obs;
        IScope sc;
        ISession se;
        ISite s;
        ITarget t;
        this.lastSelectedTab = this.tabbedPane.getTabCount() > 1 ? this.tabbedPane.getSelectedComponent() : null;
        this.currentObseration = observation;
        this.tabbedPane.removeAll();
        this.addObservationTab(observation);
        int tabIndex = 0;
        int findingIndex = 0;
        int targetIndex = 0;
        int siteIndex = 0;
        int sessionIndex = 0;
        int scopeIndex = 0;
        int observerIndex = 0;
        int eyepieceIndex = 0;
        int filterIndex = 0;
        int imagerIndex = 0;
        int lensIndex = 0;
        IFinding f = (IFinding)observation.getResults().get(0);
        if (f != null) {
            findingIndex = ++tabIndex;
            this.addFindingTab(f, observation.getSession(), observation.getTarget(), findingIndex);
        }
        if ((t = observation.getTarget()) != null) {
            targetIndex = ++tabIndex;
            this.addTargetTab(t, observation, targetIndex);
        }
        if ((s = observation.getSite()) != null) {
            siteIndex = ++tabIndex;
            this.addSiteTab(s, siteIndex);
        }
        if ((se = observation.getSession()) != null) {
            sessionIndex = ++tabIndex;
            this.addSessionTab(se, sessionIndex);
        }
        if ((sc = observation.getScope()) != null) {
            scopeIndex = ++tabIndex;
            this.addScopeTab(sc, scopeIndex);
        }
        if ((obs = observation.getObserver()) != null) {
            observerIndex = ++tabIndex;
            this.addObserverTab(obs, observerIndex);
        }
        if ((eye = observation.getEyepiece()) != null) {
            eyepieceIndex = ++tabIndex;
            this.addEyepieceTab(eye, eyepieceIndex);
        }
        if ((fil = observation.getFilter()) != null) {
            filterIndex = ++tabIndex;
            this.addFilterTab(fil, filterIndex);
        }
        if ((img = observation.getImager()) != null) {
            imagerIndex = ++tabIndex;
            this.addImagerTab(img, imagerIndex);
        }
        if ((len = observation.getLens()) != null) {
            lensIndex = ++tabIndex;
            this.addLensTab(len, lensIndex);
        }
        if (this.lastSelectedTab == null) {
            return;
        }
        if (this.lastSelectedTab instanceof ObservationItemPanel) {
            this.tabbedPane.setSelectedComponent(this.overviewPanel);
            return;
        }
        if (this.lastSelectedTab instanceof IFindingPanel) {
            if (f != null) {
                this.loadFindingPanel(f, se, t, findingIndex);
                this.tabbedPane.setSelectedComponent(this.findingPanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof SitePanel) {
            if (s != null) {
                this.loadSitePanel(s, siteIndex);
                this.tabbedPane.setSelectedComponent(this.sitePanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof SessionPanel) {
            if (se != null) {
                this.loadSessionPanel(se, sessionIndex);
                this.tabbedPane.setSelectedComponent(this.sessionPanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof ScopePanel) {
            if (sc != null) {
                this.loadScopePanel(sc, scopeIndex);
                this.tabbedPane.setSelectedComponent(this.scopePanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof ObserverPanel) {
            if (obs != null) {
                this.loadObserverPanel(obs, observerIndex);
                this.tabbedPane.setSelectedComponent(this.observerPanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof EyepiecePanel) {
            if (eye != null) {
                this.loadEyepiecePanel(eye, eyepieceIndex);
                this.tabbedPane.setSelectedComponent(this.eyepiecePanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof FilterPanel) {
            if (fil != null) {
                this.loadFilterPanel(fil, filterIndex);
                this.tabbedPane.setSelectedComponent(this.filterPanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof IImagerPanel) {
            if (img != null) {
                this.loadImagerPanel(img, imagerIndex);
                this.tabbedPane.setSelectedComponent(this.imagerPanel);
            }
            return;
        }
        if (this.lastSelectedTab instanceof LensPanel) {
            if (len != null) {
                this.loadLensPanel(len, lensIndex);
                this.tabbedPane.setSelectedComponent(this.lensPanel);
            }
            return;
        }
        if (t != null) {
            this.loadTargetPanel(t, observation, targetIndex);
            this.tabbedPane.setSelectedComponent(this.targetPanel);
        }
    }

    public void showObserver(IObserver observer) {
        this.clear();
        this.addObserverTab(observer, -1);
    }

    public void showTarget(ITarget target, IObservation o) {
        this.clear();
        this.addTargetTab(target, o, -1);
    }

    public void showFinding(IFinding finding) {
        this.clear();
        this.addFindingTab(finding, null, null, -1);
    }

    public void showSite(ISite site) {
        this.clear();
        this.addSiteTab(site, -1);
    }

    public void showSession(ISession session) {
        this.clear();
        this.addSessionTab(session, -1);
    }

    public void showScope(IScope scope) {
        this.clear();
        this.addScopeTab(scope, -1);
    }

    public void showEyepiece(IEyepiece eyepiece) {
        this.clear();
        this.addEyepieceTab(eyepiece, -1);
    }

    public void showFilter(IFilter filter) {
        this.clear();
        this.addFilterTab(filter, -1);
    }

    public void showImager(IImager imager) {
        this.clear();
        this.addImagerTab(imager, -1);
    }

    public void showLens(ILens lens) {
        this.clear();
        this.addLensTab(lens, -1);
    }

    public void reloadLanguage() {
        AbstractPanel.reloadLanguage();
    }

    private void addObservationTab(IObservation observation) {
        this.overviewPanel = new ObservationItemPanel(this.main, observation);
        this.tabbedPane.addTab(this.bundle.getString("observation"), new ImageIcon(this.imagesDir + "observation_l.png"), this.overviewPanel);
    }

    private void addFindingTab(IFinding finding, ISession session, ITarget t, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadFindingPanel(finding, session, t, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("finding"), new ImageIcon(this.imagesDir + "finding_l.png"), FINDING_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("finding"), new ImageIcon(ItemView.this.imagesDir + "finding_l.png"), FINDING_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadFindingPanel(IFinding finding, ISession session, ITarget target, int index) {
        this.findingPanel = this.main.getExtensionLoader().getSchemaUILoader().getFindingPanel(finding.getXSIType(), finding, session, target, false);
        if (this.findingPanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("finding"), new ImageIcon(this.imagesDir + "finding_l.png"), this.findingPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.findingPanel);
            }
        }
    }

    private void addTargetTab(ITarget target, IObservation o, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadTargetPanel(target, o, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("target"), new ImageIcon(this.imagesDir + "target_l.png"), TARGET_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("target"), new ImageIcon(ItemView.this.imagesDir + "target_l.png"), TARGET_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadTargetPanel(ITarget target, IObservation o, int index) {
        this.targetPanel = this.main.getExtensionLoader().getSchemaUILoader().getTargetPanel(target.getXSIType(), target, o, false);
        if (this.targetPanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("target"), new ImageIcon(this.imagesDir + "target_l.png"), this.targetPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.targetPanel);
            }
        }
    }

    private void addSiteTab(ISite site, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadSitePanel(site, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("site"), new ImageIcon(this.imagesDir + "site_l.png"), SITE_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("site"), new ImageIcon(ItemView.this.imagesDir + "site_l.png"), SITE_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadSitePanel(ISite site, int index) {
        this.sitePanel = new SitePanel(site, false);
        if (this.sitePanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("site"), new ImageIcon(this.imagesDir + "site_l.png"), this.sitePanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.sitePanel);
            }
        }
    }

    private void addSessionTab(ISession session, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadSessionPanel(session, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("session"), new ImageIcon(this.imagesDir + "session_l.png"), SESSION_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("session"), new ImageIcon(ItemView.this.imagesDir + "session_l.png"), SESSION_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadSessionPanel(ISession session, int index) {
        this.sessionPanel = new SessionPanel(this.main, session, false);
        if (this.sessionPanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("session"), new ImageIcon(this.imagesDir + "session_l.png"), this.sessionPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.sessionPanel);
            }
        }
    }

    private void addScopeTab(IScope scope, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadScopePanel(scope, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("scope"), new ImageIcon(this.imagesDir + "scope_l.png"), SCOPE_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("scope"), new ImageIcon(ItemView.this.imagesDir + "scope_l.png"), SCOPE_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadScopePanel(IScope scope, int index) {
        this.scopePanel = new ScopePanel(scope, false);
        if (this.scopePanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("scope"), new ImageIcon(this.imagesDir + "scope_l.png"), this.scopePanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.scopePanel);
            }
        }
    }

    private void addObserverTab(IObserver observer, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadObserverPanel(observer, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("observer"), new ImageIcon(this.imagesDir + "observer_l.png"), OBSERVER_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("observer"), new ImageIcon(ItemView.this.imagesDir + "observer_l.png"), OBSERVER_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadObserverPanel(IObserver observer, int index) {
        this.observerPanel = new ObserverPanel(observer, false);
        if (this.observerPanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("observer"), new ImageIcon(this.imagesDir + "observer_l.png"), this.observerPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.observerPanel);
            }
        }
    }

    private void addEyepieceTab(IEyepiece eyepiece, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadEyepiecePanel(eyepiece, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("eyepiece"), new ImageIcon(this.imagesDir + "eyepiece_l.png"), EYEPIECE_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("eyepiece"), new ImageIcon(ItemView.this.imagesDir + "eyepiece_l.png"), EYEPIECE_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadEyepiecePanel(IEyepiece eyepiece, int index) {
        this.eyepiecePanel = new EyepiecePanel(eyepiece);
        if (this.eyepiecePanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("eyepiece"), new ImageIcon(this.imagesDir + "eyepiece_l.png"), this.eyepiecePanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.eyepiecePanel);
            }
        }
    }

    private void addFilterTab(IFilter filter, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadFilterPanel(filter, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("filter"), new ImageIcon(this.imagesDir + "filter_l.png"), FILTER_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("filter"), new ImageIcon(ItemView.this.imagesDir + "filter_l.png"), FILTER_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadFilterPanel(IFilter filter, int index) {
        this.filterPanel = new FilterPanel(filter, false);
        if (this.filterPanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("filter"), new ImageIcon(this.imagesDir + "filter_l.png"), this.filterPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.filterPanel);
            }
        }
    }

    private void addImagerTab(IImager imager, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadImagerPanel(imager, index);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.tabbedPane.addTab(this.bundle.getString("imager"), new ImageIcon(this.imagesDir + "imager_l.png"), IMAGER_TIC);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ItemView.this.tabbedPane.addTab(ItemView.this.bundle.getString("imager"), new ImageIcon(ItemView.this.imagesDir + "imager_l.png"), IMAGER_TIC);
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
            }
        }
    }

    private void loadImagerPanel(IImager imager, int index) {
        this.imagerPanel = this.main.getExtensionLoader().getSchemaUILoader().getSchemaElementPanel(imager.getXSIType(), 3, (ISchemaElement)imager, false);
        if (this.imagerPanel != null) {
            if (index <= 0) {
                this.tabbedPane.addTab(this.bundle.getString("imager"), new ImageIcon(this.imagesDir + "imager_l.png"), this.imagerPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.imagerPanel);
            }
        }
    }

    private void addLensTab(ILens lens, int index) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.loadLensPanel(lens, index);
        } else {
            String tabTitle = this.bundle.getString("lens");
            if (lens.getFactor() > 1.0f) {
                tabTitle = this.bundle.getString("lens.barlow");
            } else if (lens.getFactor() < 1.0f) {
                tabTitle = this.bundle.getString("lens.sharpley");
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.tabbedPane.addTab(tabTitle, new ImageIcon(this.imagesDir + "lens_l.png"), LENS_TIC);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            String tabTitle = ItemView.this.bundle.getString("lens");
                            ItemView.this.tabbedPane.addTab(tabTitle, new ImageIcon(ItemView.this.imagesDir + "lens_l.png"), LENS_TIC);
                        }
                    });
                }
                catch (Exception e) {
                    System.err.println("Error during add tab. Most probably you can ignore this.\n" + e);
                }
            }
        }
    }

    private void loadLensPanel(ILens lens, int index) {
        this.lensPanel = new LensPanel((ILens)((Lens)lens), false);
        if (this.lensPanel != null) {
            if (index <= 0) {
                String tabTitle = this.bundle.getString("lens");
                if (lens.getFactor() > 1.0f) {
                    tabTitle = this.bundle.getString("lens.barlow");
                } else if (lens.getFactor() < 1.0f) {
                    tabTitle = this.bundle.getString("lens.sharpley");
                }
                this.tabbedPane.addTab(tabTitle, new ImageIcon(this.imagesDir + "lens_l.png"), this.lensPanel);
            } else {
                this.tabbedPane.setComponentAt(index, this.lensPanel);
            }
        }
    }
}

