/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.dialog.Watchdog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.Worker;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends OMDialog
implements ComponentListener {
    private static final long serialVersionUID = -6190690843181392987L;
    private JLabel information = null;
    private JProgressBar progressBar = null;
    private Thread calculation = null;
    private Thread watchdog = null;

    public ProgressDialog(ObservationManager om, String title, String information, Worker runnable) {
        super(om);
        super.setSize(-6190690843181392987L, 300, 100);
        super.setTitle(title);
        super.setLocationRelativeTo(om);
        super.addComponentListener(this);
        this.initDialog(information);
        this.calculation = new Thread((Runnable)runnable, "ProcessDialog: Calculation thread");
        this.calculation.start();
        this.watchdog = new Thread((Runnable)new Watchdog(this, this.calculation), "ProcessDialog: Watchdog thread");
        this.watchdog.start();
        this.pack();
        try {
            this.setVisible(true);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.out.println("Krach!");
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.watchdog.stop();
            this.calculation.stop();
            this.close();
        }
    }

    public void componentResized(ComponentEvent e) {
        int MIN_WIDTH = 300;
        int width = this.getWidth();
        boolean resize = false;
        if (width < 300) {
            resize = true;
            width = 300;
        }
        if (resize) {
            this.setSize(width, this.getHeight());
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void close() {
        this.dispose();
    }

    private void initDialog(String information) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 1, 50);
        constraints.anchor = 17;
        constraints.fill = 1;
        this.information = new JLabel(information);
        gridbag.setConstraints(this.information, constraints);
        super.getContentPane().add(this.information);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 1, 50);
        constraints.anchor = 17;
        constraints.fill = 1;
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        gridbag.setConstraints(this.progressBar, constraints);
        super.getContentPane().add(this.progressBar);
    }
}

