/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.ISite;
import de.lehmannet.om.util.Ephemerides;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class MoonDetailContainer
extends JLabel {
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private static final String BELOW_HORIZON = "below.png";
    private static final String NEW_MOON = "new.png";
    private static final String FULL_MOON = "full.png";
    private IObservation observation = null;
    private File imagePath = null;

    public MoonDetailContainer(IObservation obs, File imagePath) {
        this.imagePath = imagePath;
        this.observation = obs;
        this.setImage();
    }

    public void setObservation(IObservation obs) {
        this.observation = obs;
        this.setImage();
    }

    private void setImage() {
        String path = this.imagePath.getAbsolutePath() + File.separatorChar + "moon" + File.separatorChar;
        ISite site = this.observation.getSite();
        if (site == null) {
            return;
        }
        Calendar date = this.observation.getBegin();
        if (Ephemerides.isMoonAboveHorizon((Calendar)date, (double)site.getLongitude().toDegree(), (double)site.getLatitude().toDegree())) {
            double phase = Ephemerides.getMoonPhase((Calendar)date) * 100.0;
            double absPhase = Math.abs(phase);
            if (absPhase <= 5.0) {
                path = path + NEW_MOON;
                super.setToolTipText(this.bundle.getString("moonDetail.newMoon"));
            } else if (absPhase > 95.0) {
                path = path + FULL_MOON;
                super.setToolTipText(this.bundle.getString("moonDetail.fullMoon"));
            } else {
                path = phase <= 0.0 ? path + "waning" : path + "waxing";
                if (absPhase > 5.0 && absPhase <= 15.0) {
                    path = path + "10.png";
                } else if (absPhase > 15.0 && absPhase <= 25.0) {
                    path = path + "20.png";
                } else if (absPhase > 25.0 && absPhase <= 35.0) {
                    path = path + "30.png";
                } else if (absPhase > 35.0 && absPhase <= 45.0) {
                    path = path + "40.png";
                } else if (absPhase > 45.0 && absPhase <= 55.0) {
                    path = path + "50.png";
                } else if (absPhase > 55.0 && absPhase <= 65.0) {
                    path = path + "60.png";
                } else if (absPhase > 65.0 && absPhase <= 75.0) {
                    path = path + "70.png";
                } else if (absPhase > 75.0 && absPhase <= 85.0) {
                    path = path + "80.png";
                } else if (absPhase > 85.0 && absPhase <= 95.0) {
                    path = path + "90.png";
                }
                DecimalFormat df = new DecimalFormat("0.00");
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setDecimalSeparator('.');
                df.setDecimalFormatSymbols(dfs);
                super.setToolTipText(this.bundle.getString("moonDetail.moonIllumination") + df.format(absPhase));
            }
        } else {
            path = path + BELOW_HORIZON;
            super.setToolTipText(this.bundle.getString("moonDetail.moonBelowHorizon"));
        }
        Image image = Toolkit.getDefaultToolkit().getImage(path);
        ImageIcon icon = new ImageIcon(image);
        super.setHorizontalAlignment(2);
        super.setIcon(icon);
    }
}

