/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.IFinding;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ui.box.LanguageBox;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.EditPopupHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FindingContainer
extends Container
implements MouseListener {
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private IFinding finding = null;
    private ISession session = null;
    private boolean editable = false;
    private ObservationManager om = null;
    private JTextArea description = null;
    private LanguageBox language = null;

    public FindingContainer(ObservationManager om, IFinding finding, ISession session, boolean editable) {
        this.om = om;
        this.finding = finding;
        this.session = session;
        this.editable = editable;
        this.language = new LanguageBox(om.getConfiguration().getConfig("om.content.language.default"), true);
        this.createContainer();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            new EditPopupHandler(e.getX(), e.getY(), this.description);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public String getDescription() {
        return this.description.getText();
    }

    public String getLanguage() {
        return this.language.getSelectedISOLanguage();
    }

    private void createContainer() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 1;
        super.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 20, 1);
        JLabel Ldescription = new JLabel(this.bundle.getString("finding.label.description"));
        Ldescription.setToolTipText(this.bundle.getString("finding.tooltip.description"));
        gridbag.setConstraints(Ldescription, constraints);
        this.add(Ldescription);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 4, 1, 100, 97);
        this.description = new JTextArea(10, 40);
        this.description.setToolTipText(this.bundle.getString("finding.tooltip.description"));
        this.description.setEditable(this.editable);
        this.description.setLineWrap(true);
        this.description.addMouseListener(this);
        if (this.finding != null) {
            this.description.setText(this.finding.getDescription());
        }
        if (!this.editable) {
            if (this.om.isNightVisionEnabled()) {
                this.description.setBackground(new Color(255, 175, 175));
            } else {
                this.description.setBackground(Color.WHITE);
            }
        }
        JScrollPane descriptionScroll = new JScrollPane(this.description);
        descriptionScroll.setMinimumSize(new Dimension(300, 60));
        gridbag.setConstraints(descriptionScroll, constraints);
        this.add(descriptionScroll);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 10, 1);
        constraints.anchor = 10;
        JLabel Llanguage = new JLabel(this.bundle.getString("panel.session.label.language"), 4);
        Llanguage.setToolTipText(this.bundle.getString("panel.session.tooltip.language"));
        gridbag.setConstraints(Llanguage, constraints);
        Llanguage.setFont(new Font("sansserif", 3, 12));
        this.add(Llanguage);
        ConstraintsBuilder.buildConstraints(constraints, 2, 0, 2, 1, 70, 1);
        constraints.fill = 2;
        this.language.setToolTipText(this.bundle.getString("panel.session.tooltip.language"));
        this.language.setEnabled(this.editable);
        if (this.finding != null) {
            this.language.setLanguage(this.finding.getLanguage());
        } else if (this.session != null && this.session.getLanguage() != null) {
            this.language.setLanguage(this.session.getLanguage());
        }
        gridbag.setConstraints(this.language, constraints);
        this.add(this.language);
    }
}

