/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.box;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JComboBox;

public class LanguageBox
extends JComboBox {
    private static final String EMPTY_ENTRY = "----";
    private PropertyResourceBundle bundle = null;
    private boolean allowEmptyEntry = true;
    private TreeMap map = new TreeMap();

    public LanguageBox(List acceptedLanguages, boolean acceptEmptyEntry) {
        this.bundle = (PropertyResourceBundle)ResourceBundle.getBundle("contentLanguages", Locale.getDefault());
        this.allowEmptyEntry = acceptEmptyEntry;
        if (this.allowEmptyEntry) {
            super.addItem(EMPTY_ENTRY);
        }
        if (this.map.size() == 0) {
            Enumeration<String> e = this.bundle.getKeys();
            String isoKey = null;
            String lang = null;
            while (e.hasMoreElements()) {
                isoKey = e.nextElement();
                if (!acceptedLanguages.isEmpty() && !acceptedLanguages.contains(isoKey)) continue;
                lang = this.bundle.getString(isoKey);
                this.map.put(lang, isoKey);
            }
        }
        Iterator i = this.map.keySet().iterator();
        String key = null;
        while (i.hasNext()) {
            key = (String)i.next();
            super.addItem(key);
        }
        this.setDefaultEntry();
        this.setEditable(false);
    }

    public LanguageBox(boolean allowEmptyEntry) {
        this(new ArrayList(), allowEmptyEntry);
    }

    public LanguageBox(String isoKey, boolean allowEmptyEntry) {
        this(new ArrayList(), allowEmptyEntry);
        this.setLanguage(isoKey);
    }

    public LanguageBox(List acceptedLanguages, String isoKey, boolean allowEmptyEntry) {
        this(acceptedLanguages, allowEmptyEntry);
        this.setLanguage(isoKey);
    }

    public String getSelectedISOLanguage() {
        Object si = super.getSelectedItem();
        if (EMPTY_ENTRY.equals(si)) {
            return null;
        }
        return (String)this.map.get(si);
    }

    public void setLanguage(String isoKey) {
        if (isoKey == null || "".equals(isoKey.trim())) {
            return;
        }
        isoKey = isoKey.toLowerCase().trim();
        if (this.map.values().contains(isoKey)) {
            Iterator i = this.map.keySet().iterator();
            String current = null;
            while (i.hasNext()) {
                current = (String)i.next();
                if (!isoKey.equals(this.map.get(current))) continue;
                super.setSelectedItem(current);
                return;
            }
        }
        this.setDefaultEntry();
        System.out.println("ISO language key unknown: " + isoKey);
    }

    private void setDefaultEntry() {
        if (this.allowEmptyEntry) {
            super.setSelectedItem(EMPTY_ENTRY);
        } else if (this.map.values().contains(Locale.getDefault().getLanguage())) {
            this.setLanguage(Locale.getDefault().getLanguage());
        } else {
            this.setLanguage(Locale.ENGLISH.getLanguage());
        }
    }
}

