/*
 * Decompiled with CFR 0.152.
 */
package boplanets.planetSystem;

import boplanets.Const;
import boplanets.gui.CoordinateSystem;
import boplanets.planetSystem.MinMaxDeclin;
import boplanets.planetSystem.PlanetParams;
import boplanets.util.AstroMath;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JOptionPane;

public class Planet {
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static GregorianCalendar GMT_CALENDAR = new GregorianCalendar(GMT_TIME_ZONE);
    private static long J2000DateMillis;
    private MinMaxDeclin declin;
    private Planet observer;
    public double numExc;
    protected double xHalfAxis;
    private double focus;
    private double yHalfAxis;
    private double[] eclGaussP;
    private double[] eclGaussQ;
    private double[] equGaussP;
    private double[] equGaussQ;
    private double radFactor;
    private double[] rEclPlanet;
    private double argPerihel;
    public boolean bIsObserver;
    private double[] normalOrbPlanet;
    protected double[] normalEquPlanet;
    private double[] normalEquObs;
    private double meanAnomaly;
    private double meanAnomalyJ2000;
    private double gmstRadJ2000;
    public int iIndex;
    public double gmstRad;
    public String sName;
    public double ra;
    public double dec;
    public double azi;
    public double alt;
    public double[][] minMaxEclXyz;
    public double[][] minMaxEquXyz;
    public double[][] minMaxRaDec;
    public Image imgPlanet;
    public Color cColor;
    public boolean orbParamsModified;
    public double inclination;
    public double longAscNode;
    public double obliqu;
    public double rotPer;
    public double period;
    public double sunDay;
    public double argEquinox;

    public Planet(Planet planet, PlanetParams planetParams) {
        if (planet != null) {
            this.bIsObserver = false;
            this.observer = planet;
        } else {
            this.bIsObserver = true;
            this.observer = this;
        }
        this.initPlanet(planetParams);
    }

    private void initPlanet(PlanetParams planetParams) {
        Object object;
        Object object2;
        GMT_CALENDAR.clear(14);
        GMT_CALENDAR.set(2000, 0, 1, 0, 0, 0);
        J2000DateMillis = GMT_CALENDAR.getTimeInMillis();
        this.sName = planetParams.name;
        this.iIndex = planetParams.index;
        this.xHalfAxis = planetParams.xAxis;
        this.cColor = planetParams.color;
        this.rEclPlanet = planetParams.startPos;
        this.numExc = planetParams.numExc;
        this.inclination = planetParams.inclination;
        this.longAscNode = planetParams.longAscNode;
        this.argPerihel = planetParams.argPerihel;
        this.obliqu = planetParams.obliqu;
        this.argEquinox = planetParams.argEquinox;
        this.rotPer = planetParams.rotPer;
        this.period = Math.sqrt(this.xHalfAxis * this.xHalfAxis * this.xHalfAxis * Const.GRAV);
        if (this.sName.compareTo("Sun") == 0) {
            this.sunDay = this.rotPer;
        } else {
            this.sunDay = this.period * this.rotPer;
            this.sunDay = this.obliqu > 1.5707963267948966 ? (this.sunDay /= this.rotPer + this.period) : (this.sunDay /= Math.abs(this.period - this.rotPer));
        }
        String string = "images/" + this.sName + ".jpg";
        URL uRL = null;
        try {
            object2 = Class.forName("boplanets.gui.SelectPlanets");
            uRL = ((Class)object2).getResource(string);
            if (uRL == null) {
                object = "The image " + string + " was not found in package " + "boplanets.gui";
                object = (String)object + "\n Application will be aborted.";
                JOptionPane.showMessageDialog(null, object, "Image not found", 0);
                System.exit(1);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = "Searching for images Class boplanets.gui.SelectPlanets was not found.";
            object = (String)object + "\n" + classNotFoundException.toString();
            object = (String)object + "\n Application will be aborted.";
            JOptionPane.showMessageDialog(null, object, "Class not found", 0);
            System.exit(1);
        }
        object2 = Toolkit.getDefaultToolkit();
        object = ((Toolkit)object2).createImage(uRL);
        this.imgPlanet = ((Image)object).getScaledInstance(7, 6, 2);
        ((Image)object).flush();
        this.deriveFromEditableParams();
        this.orbParamsModified = false;
        this.calculateMinMaxEcliptic();
        this.calculateMinMaxRaDecl();
        double[] dArray = AstroMath.eclipticToOrb(this.rEclPlanet, this.eclGaussP, this.eclGaussQ);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = Math.atan2(d2 / this.yHalfAxis, d / this.xHalfAxis + this.numExc);
        this.meanAnomalyJ2000 = this.meanAnomaly = -Math.sin(d3) * this.numExc + d3;
        if (this.xHalfAxis > 1.0E-8) {
            if (this.sName.compareTo("Earth") != 0) {
                double[] dArray2 = AstroMath.eclipticToEquator(this.longAscNode, this.inclination, this.argEquinox, this.obliqu, this.rEclPlanet);
                double d4 = Math.atan2(dArray2[1], dArray2[0]);
                this.gmstRad = (d4 + Math.PI * 2) % (Math.PI * 2);
            } else {
                this.gmstRad = 1.744767163243314;
            }
        } else {
            this.gmstRad = 0.0;
        }
        this.gmstRadJ2000 = this.gmstRad;
        this.ra = 0.0;
        this.dec = 0.0;
        this.azi = 0.0;
        this.alt = 0.0;
    }

    private void deriveFromEditableParams() {
        this.radFactor = Math.sqrt(-this.numExc * this.numExc + 1.0);
        this.yHalfAxis = this.radFactor * this.xHalfAxis;
        this.focus = this.numExc * this.xHalfAxis;
        double[][] dArray = AstroMath.getEclGaussVector(this.longAscNode, this.inclination, this.argPerihel);
        double[] dArray2 = new double[]{dArray[0][0], dArray[0][1], dArray[0][2]};
        double[] dArray3 = new double[]{dArray[1][0], dArray[1][1], dArray[1][2]};
        this.eclGaussP = dArray2;
        this.eclGaussQ = dArray3;
        dArray = this.bIsObserver ? AstroMath.getEquGaussVectorObs(this.argPerihel, this.argEquinox, this.obliqu) : AstroMath.getEquGaussVectorPlanet(this.observer.longAscNode, this.observer.inclination, this.observer.argEquinox, this.observer.obliqu, this.longAscNode, this.inclination, this.argPerihel);
        double[] dArray4 = new double[]{dArray[0][0], dArray[0][1], dArray[0][2]};
        double[] dArray5 = new double[]{dArray[1][0], dArray[1][1], dArray[1][2]};
        this.equGaussP = dArray4;
        this.equGaussQ = dArray5;
        this.normalOrbPlanet = AstroMath.getOrbitalNormal(this.longAscNode, this.inclination);
        this.normalEquPlanet = AstroMath.getEquatorNormal(this.longAscNode, this.inclination, this.argEquinox, this.obliqu);
        this.normalEquObs = this.observer.normalEquPlanet;
    }

    public Double[] getDynOrbParams() {
        double d = this.meanAnomaly + this.longAscNode + this.argPerihel;
        d = (d + Math.PI * 2) % (Math.PI * 2);
        Double[] doubleArray = new Double[]{this.rEclPlanet[0], this.rEclPlanet[1], this.rEclPlanet[2], this.ra, this.dec, this.azi, this.alt, this.gmstRad * 57.29577951308232, d * 57.29577951308232};
        return doubleArray;
    }

    public Double[] getStaticOrbParams() {
        Double[] doubleArray = new Double[]{this.xHalfAxis, this.period, this.rotPer, this.sunDay, this.obliqu * 57.29577951308232, this.argEquinox * 57.29577951308232};
        return doubleArray;
    }

    public Double[] getEditableOrbParams() {
        Double[] doubleArray = new Double[]{this.numExc, this.inclination * 57.29577951308232, this.argPerihel * 57.29577951308232, this.longAscNode * 57.29577951308232};
        return doubleArray;
    }

    public void setOrbParameters(double d, double d2, double d3, double d4) {
        this.numExc = d;
        this.inclination = d2;
        this.longAscNode = d4;
        this.argPerihel = d3;
        this.orbParamsModified = true;
        this.deriveFromEditableParams();
        this.calculateMinMaxEcliptic();
        this.calculateMinMaxRaDecl();
        this.getNextPlanetEcl(0.0);
        this.ra = 0.0;
        this.dec = 0.0;
        this.azi = 0.0;
        this.alt = 0.0;
    }

    public void calculateMinMaxEcliptic() {
        double[] dArray = this.getMinMaxCartesianCoordinate(this.eclGaussP[0], this.eclGaussQ[0]);
        double d = dArray[1] - dArray[0];
        double[] dArray2 = this.getMinMaxCartesianCoordinate(this.eclGaussP[1], this.eclGaussQ[1]);
        d = Math.max(d, dArray2[1] - dArray2[0]);
        double[] dArray3 = this.getMinMaxCartesianCoordinate(this.eclGaussP[2], this.eclGaussQ[2]);
        double d2 = dArray3[1] - dArray3[0];
        if (d2 < d * 0.1) {
            dArray3[0] = dArray3[0] - d * 0.1;
            dArray3[1] = dArray3[1] + d * 0.1;
        }
        double[][] dArrayArray = new double[][]{dArray, dArray2, dArray3};
        this.minMaxEclXyz = dArrayArray;
    }

    public void calculateMinMaxRaDecl() {
        double[] dArray = new double[]{-180.0, 180.0};
        double[] dArray2 = new double[2];
        if (!this.bIsObserver) {
            dArray2 = this.getMinMaxDeclination2();
        } else {
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
        }
        double[][] dArrayArray = new double[][]{dArray, dArray2};
        this.minMaxRaDec = dArrayArray;
    }

    private double[] getMinMaxCartesianCoordinate(double d, double d2) {
        double[] dArray = AstroMath.minMaxCartesianCoord(d, d2, this.numExc, this.xHalfAxis, this.yHalfAxis);
        if (dArray == null) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        }
        return dArray;
    }

    private double[] getMinMaxDeclination2() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (!this.bIsObserver) {
            double d8;
            this.declin = new MinMaxDeclin(this, this.observer);
            double[] dArray = this.getRoughStartValues();
            double d9 = dArray[0];
            d7 = this.declin.getDeclination(d9, d8 = dArray[1]);
            if (Math.abs(d7) < 1.0E-11) {
                d6 = 0.5;
                d5 = -0.5;
            } else {
                int n = 1;
                dArray = this.getPositionOfMinMaxDeclination(n, d9, d8);
                d6 = dArray[0];
                d3 = dArray[1];
                d = dArray[2];
                n = d6 > 0.0 ? -1 : 1;
                double d10 = AstroMath.getExcAnoOfOpposite(d3, this.numExc);
                double d11 = AstroMath.getExcAnoOfOpposite(d, this.observer.numExc);
                dArray = this.getPositionOfMinMaxDeclination(n, d10, d11);
                d7 = dArray[0];
                d10 = dArray[1];
                d11 = dArray[2];
                if (d7 > d6) {
                    d5 = d6;
                    d4 = d3;
                    d2 = d;
                    d6 = d7;
                    d3 = d10;
                    d = d11;
                } else {
                    d5 = d7;
                    d4 = d10;
                    d2 = d11;
                }
                if (d5 > 0.0) {
                    d5 *= -1.0;
                }
                d5 = Math.abs(d5) < 0.3 ? -0.5 : d5;
                double d12 = d6 = Math.abs(d6) < 0.3 ? 0.5 : d6;
                if (d5 < -0.5) {
                    double d13 = d5 = d5 < -88.501 ? -90.0 : Math.ceil(d5 - 1.499);
                }
                if (d6 > 0.5) {
                    d6 = d6 > 88.501 ? 90.0 : Math.floor(d6 + 1.499);
                }
            }
            this.declin = null;
        }
        double[] dArray = new double[]{d5, d6};
        return dArray;
    }

    private double[] getPositionOfMinMaxDeclination(int n, double d, double d2) {
        double[] dArray = this.declin.findMinMaxDeclination(n, d, d2);
        double d3 = dArray[0];
        double d4 = AstroMath.to0_2PiIntervall(dArray[1]);
        double d5 = AstroMath.to0_2PiIntervall(dArray[2]);
        double[] dArray2 = new double[]{d3, d4, d5};
        return dArray2;
    }

    public double[] getNextPosition(CoordinateSystem coordinateSystem, double d, double[] dArray) {
        if (!this.bIsObserver) {
            this.getNextPlanetEcl(d);
            double[] dArray2 = AstroMath.vectorDiff(this.rEclPlanet, dArray);
            double[] dArray3 = coordinateSystem.getNextCoordinates(this, dArray2);
            return dArray3;
        }
        double[] dArray4 = new double[]{0.0, 0.0};
        return dArray4;
    }

    public double[] getNextPlanetEcl(double d) {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        if (this.xHalfAxis > 1.0E-8) {
            this.meanAnomaly = (Math.PI * 2 * d / this.period + this.meanAnomaly) % (Math.PI * 2);
            this.meanAnomaly = (this.meanAnomaly + Math.PI * 2) % (Math.PI * 2);
            dArray = this.getPositionEcl(this.meanAnomaly);
        }
        this.gmstRad = (Math.PI * 2 * d / this.rotPer + this.gmstRad) % (Math.PI * 2);
        this.gmstRad = (this.gmstRad + Math.PI * 2) % (Math.PI * 2);
        this.rEclPlanet = dArray;
        return dArray;
    }

    public double getGmst(long l) {
        long l2 = l - J2000DateMillis;
        double d = (double)l2 / 8.64E7;
        double d2 = (Math.PI * 2 * d / this.rotPer + this.gmstRadJ2000) % (Math.PI * 2);
        d2 = (d2 + Math.PI * 2) % (Math.PI * 2);
        return d2;
    }

    public double[][] getPositionAndTangensEclAtDate(long l) {
        long l2 = l - J2000DateMillis;
        double d = (double)l2 / 8.64E7;
        double d2 = (Math.PI * 2 * d / this.period + this.meanAnomalyJ2000) % (Math.PI * 2);
        double[] dArray = this.getPositionEcl(d2);
        double[] dArray2 = this.getTangensEcl(d2);
        double[][] dArrayArray = new double[][]{dArray, dArray2};
        return dArrayArray;
    }

    private double[] getPositionEcl(double d) {
        double d2 = AstroMath.kepplerEquation(this.numExc, d);
        double d3 = (Math.cos(d2) - this.numExc) * this.xHalfAxis;
        double d4 = Math.sin(d2) * this.yHalfAxis;
        double[] dArray = AstroMath.orbToEcliptic(d3, d4, this.eclGaussP, this.eclGaussQ);
        return dArray;
    }

    private double[] getTangensEcl(double d) {
        double d2;
        double d3;
        if (this.xHalfAxis <= 1.0E-4) {
            d3 = 0.0;
            d2 = 0.0;
        } else {
            double d4 = AstroMath.kepplerEquation(this.numExc, d);
            double d5 = this.period * 8.64E7;
            double d6 = Math.PI * 2 / ((1.0 + this.numExc * Math.cos(d4)) * d5);
            d3 = -Math.sin(d4) * this.xHalfAxis * d6;
            d2 = Math.cos(d4) * this.yHalfAxis * d6;
        }
        double[] dArray = AstroMath.orbToEcliptic(d3, d2, this.eclGaussP, this.eclGaussQ);
        return dArray;
    }

    protected double[] getRadiusVector(double d) {
        double d2 = (Math.cos(d) - this.numExc) * this.xHalfAxis;
        double d3 = Math.sin(d) * this.yHalfAxis;
        double[] dArray = AstroMath.orbToEcliptic(d2, d3, this.eclGaussP, this.eclGaussQ);
        return dArray;
    }

    protected double[] getRadiusVectorOrb(double[] dArray) {
        return AstroMath.eclipticToOrb(dArray, this.eclGaussP, this.eclGaussQ);
    }

    protected double[] getTangent(double d) {
        double d2 = -Math.sin(d) * this.xHalfAxis;
        double d3 = Math.cos(d) * this.yHalfAxis;
        double[] dArray = AstroMath.orbToEcliptic(d2, d3, this.eclGaussP, this.eclGaussQ);
        return dArray;
    }

    protected double[] getDerivOfTangent(double d) {
        double d2 = -Math.cos(d) * this.xHalfAxis;
        double d3 = -Math.sin(d) * this.yHalfAxis;
        double[] dArray = AstroMath.orbToEcliptic(d2, d3, this.eclGaussP, this.eclGaussQ);
        return dArray;
    }

    private double[] getRoughStartValues() {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        double d = this.xHalfAxis;
        double d2 = this.observer.xHalfAxis;
        double[] dArray4 = this.observer.normalOrbPlanet;
        double[] dArray5 = AstroMath.vectorProductByLng(1.0, dArray4, this.normalEquObs);
        double[] dArray6 = AstroMath.vectorProductByLng(1.0, dArray4, this.normalOrbPlanet);
        if (dArray6 == null) {
            if (dArray5 != null) {
                dArray3 = AstroMath.vectorProductByLng(-d2, dArray5, dArray4);
                dArray2 = AstroMath.vectorProductByLng(d, dArray5, this.normalOrbPlanet);
            } else {
                dArray3 = AstroMath.orbToEcliptic(-d2, 0.0, this.observer.eclGaussP, this.observer.eclGaussQ);
                dArray2 = AstroMath.orbToEcliptic(d, 0.0, this.eclGaussP, this.eclGaussQ);
            }
        } else if (d < d2) {
            dArray2 = AstroMath.vectorProductByLng(d, dArray6, this.normalOrbPlanet);
            dArray3 = dArray5 != null ? AstroMath.vectorProductByLng(-d2, dArray5, dArray4) : AstroMath.vectorProductByLng(-d2, dArray6, dArray4);
        } else {
            dArray3 = AstroMath.vectorProductByLng(d2, dArray4, dArray6);
            dArray = AstroMath.vectorProductByLng(1.0, this.normalOrbPlanet, this.normalEquObs);
            dArray2 = dArray != null ? AstroMath.vectorProductByLng(d, dArray, this.normalOrbPlanet) : AstroMath.vectorProductByLng(-d, dArray6, this.normalOrbPlanet);
        }
        dArray = this.getRadiusVectorOrb(dArray2);
        double d3 = Math.atan2(dArray[1], dArray[0]);
        d3 = AstroMath.getExcAno(d3, this.numExc);
        dArray = this.observer.getRadiusVectorOrb(dArray3);
        double d4 = Math.atan2(dArray[1], dArray[0]);
        d4 = AstroMath.getExcAno(d4, this.observer.numExc);
        double[] dArray7 = new double[]{d3, d4};
        return dArray7;
    }
}

