/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.ILocationReceiver;
import boplanets.gui.Location;
import boplanets.gui.LocationTreeCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PnlLocations
extends JPanel {
    private JTree jtrLocationTree;
    private JScrollPane scrpLocation;
    private ILocationReceiver _locationReceiver;
    private DefaultMutableTreeNode _top;
    private DefaultTreeModel _treeModel;
    protected double _longitude;
    protected double _latitude;
    protected int _timeZone;
    private static final String TREE_TITLE = "Observer Locations";
    private static final String[] CONTINENTS = new String[]{"Africa", "Asia", "Australia & Polynesia", "Europe", "North America", "South & Middle America"};
    private static final Location[] locationsAfrica = new Location[]{new Location("Abidjan Ivory coast", 5.317, -0.083, 0), new Location("Addis ababa Ethiopia", -9.05, 38.7, 3), new Location("Algiers Algeria", 36.833, 3.0, 0), new Location("Antananarivo Madaga", -18.867, 47.5, 3), new Location("Asmara Eritrea", 15.333, 38.967, 3), new Location("Aswan Egypt", -24.083, 32.933, 2), new Location("Bamako Mali", -12.65, -8.0, -1), new Location("Benghazi Libya", -32.117, 20.067, 1), new Location("Beira Mozambique", -19.817, 34.867, 2), new Location("Cairo Egypt", 30.05, 31.25, 2), new Location("Capetown South africa", -35.917, 18.367, 1), new Location("Dakar Senegal", 14.667, -17.433, -1), new Location("Fes Marocco", 34.083, -5.0, 0), new Location("Freetown Sierra Leon", 8.5, -13.25, -1), new Location("Harare Zimbabwe", -17.833, 31.5, 2), new Location("Johannesburg South africa", -26.167, 28.033, 2), new Location("Kampala Uganda", -0.317, 35.417, 2), new Location("Kano Nigeria", 12.0, 8.517, 1), new Location("Khartoum Sudan", 15.6, 32.533, 2), new Location("Kinshasa Zaire", -4.3, 15.3, 1), new Location("Kisangani Zaire", -0.55, 25.233, 2), new Location("Lagos Nigeria", -6.45, 3.4, 0), new Location("Las palmas (Gran Canaria) Spain", 28.133, -15.45, -1), new Location("Lindi Tanzania", -10.0, 39.683, 3), new Location("Lome Togo", 6.133, 1.217, 0), new Location("Lubumbashi Zaire", -11.683, 27.483, 2), new Location("Luderitz Namibia", -26.633, 15.167, 1), new Location("Luzamba Angola", -4.983, 23.433, 2), new Location("Maputo Mozambique", -25.967, 32.583, 2), new Location("Maseru Lesotho", -29.317, 27.483, 2), new Location("Mbala Zambia", 1.067, 34.2, 2), new Location("Mogadishu Somalia", 2.033, 45.35, 3), new Location("Monrovia Liberia", 6.3, -10.783, -1), new Location("Mwanza Tanzania", -7.85, 26.717, 2), new Location("Ndjamena Chad", 12.167, 14.983, 1), new Location("Nairobi Kenya", -1.283, 36.817, 2), new Location("Namibe Angola", -15.167, 12.15, 1), new Location("Nouakchott Mauritania", -18.15, -15.967, -1), new Location("Ouagadougou Burkina", 12.367, -1.517, 0), new Location("Pointe noire Congo", -4.767, 11.883, 1), new Location("Sebha Libya", 27.033, 14.433, 1), new Location("Seronera Tanzania", -22.417, 26.733, 2), new Location("Sidi ifni Morocco", 29.4, -10.2, -1), new Location("Tulear Madagascar", -23.333, 43.683, 3), new Location("Tombouctou Mali", 16.817, -2.983, 0), new Location("Tripoli Libya", -32.9, 13.183, 1), new Location("Tsumeb Namibia", -19.217, 17.7, 1), new Location("Tunis Tunisia", 36.8, 10.183, 1), new Location("Winhoek Namibia", -22.567, 17.1, 1), new Location("Yaounde Cameroon", 3.867, 11.517, 1), new Location("Zanzibar Tanzania", -6.167, 39.333, 3)};
    private static final Location[] locationsAsia = new Location[]{new Location("Alma-Ata Kazakhstan", 44.0, 76.0, 5), new Location("Ankara Turkey", 39.917, 32.833, 2), new Location("Baghdad Iraq", 33.333, 44.433, 3), new Location("Bangalore India", 12.967, 77.583, 5), new Location("Bangkok Thailand", 13.733, 100.5, 7), new Location("Beijing China", 39.917, 116.433, 8), new Location("Bombay India", 18.933, 74.583, 5), new Location("Calcutta India", 22.5, 88.333, 6), new Location("Colombo Sri Lanka ", 6.917, 79.867, 5), new Location("Damaskus Syria", 33.5, 36.317, 2), new Location("Delhi India", 28.667, 77.233, 5), new Location("Gunungsitoli Indonesia", -6.05, 116.533, 8), new Location("Hanoi Vietnam", 21.017, 105.867, 7), new Location("Harbin China", 45.75, 126.683, 8), new Location("Herat Afghanistan", 34.333, 62.2, 4), new Location("Ho-Chi-Minh Vietnam", 10.767, 106.717, 7), new Location("Hong-Kong China ", 22.25, 114.167, 8), new Location("Islamabad Pakistan", 33.667, 73.133, 5), new Location("Jakarta Indonesia", -6.133, 106.75, 7), new Location("Jerusalem Israel", 31.783, 35.217, 2), new Location("Kabul Afghanistan", 34.517, 69.2, 5), new Location("Kagoshima Japan", 31.617, 130.533, 9), new Location("Kandla India", 23.05, 70.183, 5), new Location("Karachi Pakistan", 24.85, 67.033, 4), new Location("Kathmandu Nepal", 27.7, 85.317, 6), new Location("Kota Bharu Malaysia ", 2.55, 102.167, 7), new Location("Kuala Lumpur Malaysia ", 3.133, 101.7, 7), new Location("Kunming China", 25.067, 102.683, 7), new Location("Kuwait Kuwait", 29.333, 48.0, 3), new Location("Lhasa Tibet", 29.683, 91.167, 6), new Location("Malang Indonesia", -7.983, 112.75, 8), new Location("Mandalay Myanmar", 21.95, 96.067, 6), new Location("Manila Philippines", 14.583, 120.983, 8), new Location("Mashad Iran", 36.267, 59.567, 4), new Location("Mekka Saudi Arabia", 21.45, 39.817, 3), new Location("Nagpur India", 21.167, 79.2, 5), new Location("Novosibirsk Russia", 55.067, 83.083, 6), new Location("Okhotsk Russia", 59.333, 143.25, 10), new Location("Padang Indonesia", -6.2, 120.45, 8), new Location("Palu Indonesia", -8.317, 121.733, 8), new Location("Penang Malaysia", 5.5, 100.467, 7), new Location("Petropavlovsk Kazakhstan", 54.883, 69.217, 5), new Location("Pontianak Indonesia", -0.083, 109.267, 7), new Location("Rangoon Myanmar", 16.783, 96.167, 6), new Location("Riyadh Saudi Arabia", 24.65, 46.767, 3), new Location("Salalah Oman", 17.0, 54.067, 4), new Location("Sanaa Yemen", 15.4, 44.233, 3), new Location("Sapporo Japan", 43.083, 141.35, 9), new Location("Saratov Russia", 51.5, 45.917, 3), new Location("Seoul Korea", 37.5, 127.0, 8), new Location("Shanghai China", 31.1, 121.367, 8), new Location("Shiraz Iran", 29.633, 52.567, 4), new Location("Singapore Singapore", 1.3, 103.833, 7), new Location("Sorong Indonesia", -0.833, 131.283, 9), new Location("Tabriz Iran", 38.083, 46.3, 3), new Location("Taipei Taiwan", 25.083, 121.533, 8), new Location("Tanahmerah Indonesia", -6.133, 140.3, 9), new Location("Tashkent Uzbekistan", 41.267, 69.217, 5), new Location("Tehran Iran", 35.667, 51.433, 3), new Location("Thimbu Bhutan", 27.533, 89.717, 6), new Location("Tokyo Japan", 35.667, 139.75, 9), new Location("Ulaanbaatar Mongolia", 47.9, 106.867, 7), new Location("Urumqi China", 43.717, 87.633, 6), new Location("Vladivostok Russia ", 43.15, 131.883, 9), new Location("Workuta Russia", 67.45, 64.0, 4), new Location("Wuhan China", 30.583, 108.9, 7), new Location("Xian Xiguan China ", 34.267, 108.9, 7), new Location("Yakutsk Russia", 62.167, 129.833, 9)};
    private static final Location[] locationsAustralia = new Location[]{new Location("Adelaide Austr.", -34.917, 138.583, 9), new Location("Alice Springs Austr.", -23.7, 133.883, 9), new Location("Apia Samoa", -13.8, -171.75, -12), new Location("Auckland New Zeal.", -36.917, 174.783, 12), new Location("Bora-Bora Polyn.", -16.5, -151.75, -10), new Location("Brisbane Austr.", -27.467, 153.033, 10), new Location("Canberra Austr.", -35.283, 149.133, 10), new Location("Coober Pedy Austr.", -28.933, 134.75, 9), new Location("Darwin Austr.", -12.467, 130.833, 9), new Location("Derby Austr.", -17.317, 123.633, 8), new Location("Honiara Solomon Isl.", -9.467, 159.95, 11), new Location("Nadi Fiji", -17.783, 177.483, 12), new Location("Melbourne Austr.", -37.75, 144.967, 10), new Location("Newman Austr.", -23.333, 119.567, 8), new Location("Perth Austr.", -31.933, 115.833, 8), new Location("Pitcairn Island (Bounty)", -25.04, -130.5, -9), new Location("Port Moresby Papua NG", -9.5, 147.117, 10), new Location("Timaru New Zeal.", -44.383, 171.233, 11), new Location("Townsville Austr.", -19.217, 146.8, 10), new Location("Sydney Austr.", -33.917, 151.167, 10)};
    private static final Location[] locationsEurope = new Location[]{new Location("Amsterdam Netherl.", 52.35, 4.9, 1), new Location("Athens Greece", 37.967, 23.717, 2), new Location("Baku Aserb.", 40.367, 49.883, 3), new Location("Barcelona Spain", 41.383, 2.183, 1), new Location("Beograd Serbia", 44.833, 20.5, 1), new Location("Bergen Norw.", 60.391, 5.324, 1), new Location("Berlin Germ.", 52.5, 13.417, 1), new Location("Berne Switzerl.", 46.95, 7.433, 1), new Location("Bordeaux France", 44.833, -0.567, 1), new Location("Bremen Germ.", 53.05, 8.833, 1), new Location("Brest France", 48.383, -4.5, 1), new Location("Brno Czech.", 49.217, 16.667, 1), new Location("Bruxelles Belg.", 50.833, 4.333, 1), new Location("Bucaresti Roman.", 44.433, 26.1, 2), new Location("Budapest Hung.", 47.5, 19.083, 1), new Location("Cork Irel.", 51.9, -8.467, -1), new Location("Danzig Pol.", 54.383, 18.667, 1), new Location("Dortmund Germ.", 51.517, 7.45, 1), new Location("Dresden Germ.", 51.167, 14.0, 1), new Location("Dublin Irel.", 53.333, -6.25, 0), new Location("Essen Germ.", 51.45, 6.95, 1), new Location("Frankfurt/M Germ.", 50.11, 8.69, 1), new Location("Frankfurt/O Germ.", 52.37, 14.55, 1), new Location("Glasgow Uk", 55.883, -4.25, 0), new Location("Halle Germ.", 51.472, 11.925, 1), new Location("Hamburg Germ.", 53.55, 9.983, 1), new Location("Hammerfest Norw.", 70.667, 23.7, 2), new Location("Hannover Germ.", 52.5, 9.0, 1), new Location("Helsinki Finnl.", 60.133, 25.0, 2), new Location("Istanbul Turk.", 41.017, 28.967, 2), new Location("Jena Germ.", 50.926, 11.584, 1), new Location("Kassel Germ.", 51.32, 9.5, 1), new Location("Kiel Germ.", 54.333, 10.133, 1), new Location("Kiew Ukr.", 50.433, 30.517, 2), new Location("Koeln Germ.", 50.94, 6.96, 1), new Location("Krakow Pol.", 50.05, 19.917, 1), new Location("Lahti Finnl.", 60.967, 25.667, 2), new Location("Lisboa Portug.", 38.733, -9.133, 0), new Location("Lofoten Norw.", 68.3, 14.0, 1), new Location("London Uk", 51.5, -0.083, 0), new Location("Longyearbyen Norw.", 78.2, 15.667, 1), new Location("Madrid Spain", 40.5, -3.667, 1), new Location("Mainz Germ.", 49.946, 7.919, 1), new Location("Milano Italy", 45.45, 9.283, 1), new Location("Moskva Russia", 55.75, 37.7, 3), new Location("Munich Germ.", 48.133, 11.583, 1), new Location("Napoli Italy", 40.85, 14.283, 1), new Location("Nice France", 43.7, 7.25, 1), new Location("Oslo Norw.", 59.917, 10.75, 1), new Location("Palermo Italy", 37.817, 13.583, 1), new Location("Paris France", 48.867, 2.333, 1), new Location("Petersburg Russia", 59.883, 30.25, 3), new Location("Potsdam Germ.", 52.397, 13.039, 1), new Location("Praha Czech.", 50.1, 14.433, 1), new Location("Reykjavik Icel.", 64.15, -21.85, -1), new Location("Riga Latvia", 57.5, 24.083, 2), new Location("Roma Italy", 41.883, 12.5, 1), new Location("Saarbruecken Germ.", 49.25, 6.967, 1), new Location("Schwerin Germ.", 53.633, 11.417, 1), new Location("Sevilla Spain", 37.417, -5.833, 1), new Location("Sofia Bulg.", 42.667, 23.3, 2), new Location("Stockholm Sweden", 59.333, 18.083, 1), new Location("Stuttgart Germ.", 48.667, 9.333, 1), new Location("Tarifa Spain", 36.017, -5.6, 1), new Location("Trondheim Norw.", 63.36, 10.25, 1), new Location("Uppsala Sweden", 59.917, 17.633, 1), new Location("Vardoe Norw.", 60.267, 20.333, 1), new Location("Vienna Austria", 48.267, 16.383, 1), new Location("Volgograd Russia", 48.75, 44.5, 3), new Location("Warszaw Pol.", 52.25, 21.0, 1), new Location("Weimar Germ.", 51.367, 9.383, 1), new Location("Wiesbaden Germ.", 50.083, 8.233, 1), new Location("Zuerich Switzerl.", 47.383, 8.55, 1)};
    private static final Location[] locationsNorthAmerica = new Location[]{new Location("Albany N.Y.", 42.667, -73.75, -5), new Location("Albuquerque N.Mex", 35.083, -106.65, -7), new Location("Amarillo Tex.", 35.183, -101.833, -6), new Location("Anchorage Alaska", 61.217, -149.9, -9), new Location("Atlanta Georgia", 33.75, -84.383, -5), new Location("Austin Tex.", 30.267, -97.733, -6), new Location("Baker Ore.", 44.783, -117.833, -8), new Location("Baltimore Maryl.", 39.3, -76.633, -5), new Location("Bangor Maine", 44.8, -68.783, -5), new Location("Birmingham Ala.", 33.5, -86.833, -6), new Location("Bismarck N.Dac.", 46.8, -100.783, -6), new Location("Boise Idaho", 43.6, -116.217, -7), new Location("Boston Mass.", 42.35, -71.083, -5), new Location("Buffalo N.Y.", 42.917, -78.833, -5), new Location("Calgary Alba. Can.", 51.017, -114.017, -7), new Location("Carlsbad N.Mex", 32.433, -104.25, -7), new Location("Charleston S.Car", 32.783, -79.933, -5), new Location("Charleston W.Virg", 38.35, -81.633, -5), new Location("Charlotte N.Car", 35.233, -80.833, -5), new Location("Cheyenne Wyo.", 41.15, -104.867, -7), new Location("Chicago Ill.", 41.833, -87.617, -6), new Location("Cincinnati Ohio", 39.133, -84.5, -5), new Location("Cleveland Ohio", 41.467, -81.617, -5), new Location("Columbia S.Car", 34.0, -81.033, -5), new Location("Columbus Ohio", 40.0, -83.017, -5), new Location("Dallas Tex.", 32.767, -96.767, -6), new Location("Denver Colo.", 39.75, -105.0, -7), new Location("Des Moines Iowa", 41.583, -93.617, -6), new Location("Detroit Mich.", 42.333, -83.05, -5), new Location("Dubuque Iowa", 42.517, -90.667, -6), new Location("Duluth Minn.", 46.817, -92.083, -6), new Location("Eastport Maine", 44.9, -67.0, -5), new Location("Edmonton Alb. Can.", 53.567, -113.467, -7), new Location("El Centro Calif.", 32.633, -115.55, -8), new Location("El Paso Tex.", 31.767, -106.483, -7), new Location("Eugene Ore.", 44.05, -123.083, -8), new Location("Fargo N.Dac", 46.867, -96.8, -6), new Location("Flagstaff Ariz.", 35.217, -111.683, -7), new Location("Fort Worth Tex.", 32.717, -97.317, -6), new Location("Fresno Calif.", 36.733, -119.8, -8), new Location("Grand Junction Colo.", 39.083, -108.55, -7), new Location("Grand Rapids Mich.", 42.967, -85.667, -5), new Location("Honolulu Hawaii", 21.3, -157.833, -10), new Location("Hot Springs Ark.", 34.517, -93.05, -6), new Location("Houston Tex.", 29.75, -95.35, -6), new Location("Idaho Falls Idaho", 43.5, -112.017, -7), new Location("Indianapolis Ind.", 39.767, -86.167, -5), new Location("Jackson Miss.", 32.333, -90.2, -6), new Location("Jacksonville Florida", 30.367, -81.667, -5), new Location("Juneau Alaska", 58.3, -134.4, -9), new Location("Kansas City Missouri", 39.1, -94.583, -6), new Location("Key West Florida", 24.55, -81.8, -5), new Location("Kingston Ont. Can.", 44.25, -76.5, -5), new Location("Klamath Falls Ore.", 42.167, -121.733, -8), new Location("Knoxville Tenn.", 35.95, -83.933, -5), new Location("Las Vegas Nev.", 36.167, -115.2, -8), new Location("Lewiston Idaho", 46.4, -117.033, -8), new Location("Lihue Kauai Hawai", 21.983, -159.383, -10), new Location("Lincoln Neb.", 40.833, -96.667, -6), new Location("London Ont. Can.", 43.033, -81.567, -5), new Location("Long Beach Calif.", 33.767, -118.183, -8), new Location("Los Angeles Calif.", 34.05, -118.25, -8), new Location("Louisville Kent.", 38.25, -85.767, -5), new Location("Manchester N.Hampsh", 43.0, -71.5, -5), new Location("Memphis Tenn.", 35.15, -90.05, -6), new Location("Miami Florida", 25.767, -80.2, -5), new Location("Milwaukee Wis.", 43.033, -87.917, -6), new Location("Minneapolis Minn.", 44.983, -93.233, -6), new Location("Mobile Ala.", 30.7, -88.05, -6), new Location("Montgomery Ala.", 32.35, -86.3, -6), new Location("Montpelier Vermont", 44.25, -72.533, -5), new Location("Montreal Que. Can.", 45.5, -73.583, -5), new Location("Moose Jaw Sask. Can.", 50.617, -105.517, -6), new Location("Nashville Tenn.", 36.167, -86.783, -6), new Location("Nelson B.C. Can.", 49.5, -117.283, -8), new Location("Newark N.J.", 40.733, -74.167, -5), new Location("New Haven Conn.", 41.317, -72.917, -5), new Location("New Orleans Louis.", 29.95, -90.067, -6), new Location("New York N.Y.", 40.783, -73.967, -5), new Location("Nome Alaska", 64.417, -165.5, -9), new Location("Oakland Calif.", 37.8, -122.267, -8), new Location("Oklahoma City Okla.", 35.433, -97.467, -6), new Location("Omaha Neb.", 41.25, -95.933, -6), new Location("Ottawa Ont. Can.", 45.4, -75.717, -5), new Location("Philadelphia Pennsylv.", 39.95, -75.167, -5), new Location("Phoenix Ariz.", 33.483, -112.067, -7), new Location("Pierre S.Dac.", 44.367, -100.35, -6), new Location("Pittsburgh Pennsylv.", 40.45, -79.95, -5), new Location("Portland Maine", 43.667, -70.25, -5), new Location("Portland Ore.", 45.517, -122.683, -8), new Location("Providence Rhode Isl.", 41.833, -71.4, -5), new Location("Quebec Que. Can.", 46.817, -71.183, -5), new Location("Raleigh N.Car", 35.767, -78.65, -5), new Location("Reno Nev.", 39.5, -119.817, -8), new Location("Richfield Utah", 38.767, -112.083, -7), new Location("Richmond Virg.", 37.55, -77.483, -5), new Location("Roanoke Virg.", 37.283, -79.95, -5), new Location("Sacramento Calif.", 38.583, -121.5, -8), new Location("Saint Helena Mont.", 46.583, -112.033, -7), new Location("St. John New Brunsw Can.", 45.3, -66.167, -4), new Location("St. Louis Missouri", 38.583, -90.2, -6), new Location("Salt Lake City Utah", 40.767, -111.9, -7), new Location("San Antonio Tex.", 29.383, -98.55, -6), new Location("San Diego Calif.", 32.7, -117.167, -8), new Location("San Francisco Calif.", 37.783, -122.433, -8), new Location("San Jose Calif.", 37.333, -121.883, -8), new Location("San Juan P.Rico", 18.5, -66.167, -4), new Location("Santa Fe N.Mex", 35.683, -105.95, -7), new Location("Savannah Georgia", 32.083, -81.083, -5), new Location("Seattle Wash.", 47.617, -122.333, -8), new Location("Shreveport Louis.", 32.467, -93.7, -6), new Location("Sioux Falls S.Dac.", 43.55, -96.733, -6), new Location("Sitka Alaska", 57.167, -135.25, -9), new Location("Spokane Wash.", 47.667, -117.433, -8), new Location("Springfield Ill.", 39.8, -89.633, -6), new Location("Springfield Mass.", 42.1, -72.567, -5), new Location("Springfield Missouri", 37.217, -93.283, -6), new Location("Syracuse N.Y.", 43.033, -76.133, -5), new Location("Tampa Florida", 27.95, -82.45, -5), new Location("Thule Greenl.", 77.483, -69.317, -5), new Location("Toledo Ohio", 41.65, -83.55, -5), new Location("Toronto Ont. Can.", 43.667, -79.4, -5), new Location("Tulsa Okla.", 36.15, -95.983, -6), new Location("Vancouver B.C. Can.", 49.217, -123.1, -8), new Location("Victoria B.C. Can.", 48.417, -123.35, -8), new Location("Virginia Beach Virg.", 36.85, -75.967, -5), new Location("Washington D.C.", 38.883, -77.033, -5), new Location("Wichita Kan.", 37.717, -97.283, -6), new Location("Wilmington N.Car", 34.233, -77.95, -5), new Location("Winnipeg Man. Can.", 49.9, -97.117, -6)};
    private static final Location[] locationsSouthAmerica = new Location[]{new Location("Antofagasta Chile", -23.667, -70.383, -5), new Location("Arequipa Peru", -16.417, -71.533, -5), new Location("Belem Brazil", -1.45, -48.483, -3), new Location("Bogota Colombia", 4.6, -74.083, -5), new Location("Brasilia Brazil", -15.117, -47.917, -3), new Location("Buenos Aires Argent.", -34.667, -58.5, -4), new Location("Caracas Venezuela", 10.5, -66.933, -4), new Location("Cayenne Fr. Guiana", 4.933, -52.333, -3), new Location("Chihuahua Mexico", 28.667, -106.1, -7), new Location("Comodoro Argentina", -45.833, -67.5, -5), new Location("Cordoba Argentina", -18.917, -96.917, -6), new Location("Cuiaba Brazil", -7.25, -58.417, -4), new Location("Easter Island Chile", -27.083, -109.333, -7), new Location("Georgetown Guyana", 6.8, -58.167, -4), new Location("Guadalajara Mexico", 20.667, -103.333, -7), new Location("Guantanamo Cuba", 20.15, -75.233, -5), new Location("Guatemala City Guatemala", 14.633, -90.517, -6), new Location("Guayaquil Ecuador", -2.167, -79.833, -5), new Location("Ilheus Brazil", -14.833, -39.1, -3), new Location("Iquitos Peru", -3.85, -73.217, -5), new Location("Havana Cuba", 23.133, -82.367, -5), new Location("Lima Peru", -12.05, -77.05, -5), new Location("Managua Nicaragua", 12.1, -86.3, -6), new Location("Manaus Brazil", -3.1, -60.0, -4), new Location("Merida Venezuela", 8.4, -71.133, -5), new Location("Mexico-City Mexico", 19.4, -99.15, -7), new Location("Montevideo Uruguay", -34.883, -56.183, -4), new Location("Panama City Panama", 8.95, -79.5, -5), new Location("Port au Prince Haiti", 18.533, -72.333, -5), new Location("Porto Velho Brazil", -8.75, -63.9, -4), new Location("Recife Brazil", -8.1, -34.883, -2), new Location("Rio de Janeiro Brazil", -22.9, -43.233, -3), new Location("Santarem Brazil", -2.433, -54.683, -4), new Location("Sao Paulo Brazil", -23.533, -46.617, -3), new Location("Tijuana Mexico", 32.533, -117.017, -8), new Location("Valparaiso Brazil", -21.267, -50.9, -3), new Location("Veracruz Mexico", 19.2, -96.133, -6)};
    private static final Location[][] locationsAll = new Location[][]{locationsAfrica, locationsAsia, locationsAustralia, locationsEurope, locationsNorthAmerica, locationsSouthAmerica};

    public PnlLocations(ILocationReceiver iLocationReceiver) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this._locationReceiver = iLocationReceiver;
        this._top = new DefaultMutableTreeNode(TREE_TITLE, true);
        this._treeModel = new DefaultTreeModel(this._top);
        this.initComponents();
        PnlLocations.insertContiments(this._top, CONTINENTS);
        TreePath treePath = this.jtrLocationTree.getPathForRow(0);
        int n = locationsAll.length;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this._treeModel.getChild(this._top, i);
            PnlLocations.insertLocations(defaultMutableTreeNode, locationsAll[i]);
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)this._treeModel.getChild(this._top, 3);
        this.jtrLocationTree.expandPath(treePath);
        this.jtrLocationTree.getSelectionModel().setSelectionMode(1);
        this.jtrLocationTree.setShowsRootHandles(true);
        Object[] objectArray = new Object[]{this._top, defaultMutableTreeNode, this._treeModel.getChild(defaultMutableTreeNode, 45)};
        TreePath treePath2 = new TreePath(objectArray);
        this.jtrLocationTree.setSelectionPath(treePath2);
        this.jtrLocationTree.scrollPathToVisible(treePath2);
    }

    private void initComponents() {
        this.scrpLocation = new JScrollPane();
        this.jtrLocationTree = new JTree(this._treeModel);
        this.setFont(new Font("Arial", 0, 11));
        this.setPreferredSize(new Dimension(240, 300));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PnlLocations.this.PnlLocations_ComponentResized(componentEvent);
            }
        });
        this.setLayout(new FlowLayout(1, 5, 10));
        this.scrpLocation.setBorder(null);
        this.scrpLocation.setFont(new Font("Arial", 0, 10));
        this.scrpLocation.setPreferredSize(new Dimension(230, 300));
        this.jtrLocationTree.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.jtrLocationTree.setFont(new Font("Arial", 0, 12));
        this.jtrLocationTree.setToolTipText("select an observing  location.");
        this.jtrLocationTree.setCellRenderer(new LocationTreeCellRenderer());
        this.jtrLocationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PnlLocations.this.jtrLocationTree_ValueChanged(treeSelectionEvent);
            }
        });
        this.scrpLocation.setViewportView(this.jtrLocationTree);
        this.add(this.scrpLocation);
    }

    private void PnlLocations_ComponentResized(ComponentEvent componentEvent) {
        this.setVisible(false);
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.scrpLocation.setPreferredSize(new Dimension(n - 10, n2 - 25));
        this.setVisible(true);
    }

    private void jtrLocationTree_ValueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jtrLocationTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof Location) {
            Location location = (Location)object;
            this._longitude = location.geoLongitude;
            this._latitude = location.geoLatitude;
            this._timeZone = location.timeZone;
            this._locationReceiver.setLocation(location);
        }
    }

    protected void clearSelection() {
        this.jtrLocationTree.clearSelection();
    }

    private static void insertContiments(DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[i], true);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private static void insertLocations(DefaultMutableTreeNode defaultMutableTreeNode, Location[] locationArray) {
        int n = locationArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(locationArray[i], false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }
}

