import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.*;
/**
 * Title:        WatermarkFilter
 * Description:  Like TextFilter, but with a watermark effect
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class WatermarkFilter extends TextFilter {
    private int strengthPercent = 20;

		// Implements JAFilter
    public String getName() {
        return "Watermark filter";
    }
		// Implements JAFilter
    public String getDescription() {
        return "Like TextFilter, but with a watermark effect";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, Map vars) {
        Color current = getColor();
        setColor(new Color(0,0,0,(255*strengthPercent)/100));
        setOffset(getOffset()+1);
        setVoffset(getVoffset()+1);
        bi = super.filter(bi, vars);
        setOffset(getOffset()-2);
        setVoffset(getVoffset()-2);
        setColor(new Color(255,255,255,(255*strengthPercent)/100));
        bi = super.filter(bi, vars);
        //Restore properties
        setOffset(getOffset()+1);
        setVoffset(getVoffset()+1);
        setColor(current);
        return bi;
    }

    public void setStrengthPercent(int newStrengthPercent) {
        strengthPercent = newStrengthPercent;
        if (strengthPercent > 100) strengthPercent = 100;
        else if (strengthPercent < 0) strengthPercent = 0;
    }

    public int getStrengthPercent() {
        return strengthPercent;
    }
}
