/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Attributizer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.ManagesImport;
import se.datadosen.util.PersistentChoice;
import se.datadosen.util.PersistentList;
import se.datadosen.util.annotations.Bound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBinder {
    private static Map<Class, ComponentBinder> componentBinders = new HashMap<Class, ComponentBinder>();

    public static Properties getProperties(JComponentHolder jComponentHolder) {
        return PropertyBinder.getProperties(jComponentHolder, new Properties());
    }

    public static <T extends Map> T getProperties(JComponentHolder jComponentHolder, T existing) {
        T props = existing;
        try {
            Field[] fields;
            Class<?> guiClass = jComponentHolder.getClass();
            for (Field field : fields = BeanBinder.getFields(guiClass)) {
                Object comp;
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || (comp = field.get(jComponentHolder)) == null) continue;
                if (comp instanceof JComponentHolder) {
                    if (field.getName().startsWith("this$")) continue;
                    Properties subProps = PropertyBinder.getProperties((JComponentHolder)comp);
                    props.putAll(subProps);
                    continue;
                }
                if (componentBinders.containsKey(comp.getClass()) && (comp instanceof JComponent || field.getAnnotation(Bound.class) != null)) {
                    ComponentBinder mgr = componentBinders.get(comp.getClass());
                    props.put((String)name, (String)mgr.getValue(comp));
                    continue;
                }
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        props.put((String)name, (String)tc.getText());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        Object sel = jc.getSelectedItem();
                        if (sel == null) continue;
                        if (sel instanceof Item) {
                            sel = ((Item)sel).value.toString();
                        } else if (sel instanceof Enum) {
                            sel = ((Enum)sel).name();
                        }
                        props.put((String)name, (String)sel.toString());
                        continue;
                    }
                    if (comp instanceof PersistentChoice) {
                        PersistentChoice pc = (PersistentChoice)comp;
                        props.put((String)name, (String)pc.getChoice());
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb = (JCheckBox)comp;
                        props.put((String)name, (String)(cb.isSelected() ? "true" : "false"));
                        continue;
                    }
                    if (comp instanceof JToggleButton) {
                        JToggleButton tb = (JToggleButton)comp;
                        props.put((String)name, (String)(tb.isSelected() ? "true" : "false"));
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        props.put((String)name, (String)cs.getHTMLColor());
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        props.put((String)name, (String)("" + js.getValue()));
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    StringBuilder buf = new StringBuilder();
                    for (String s : ((PersistentList)comp).getContent()) {
                        if (buf.length() > 0) {
                            buf.append('\t');
                        }
                        buf.append(s);
                    }
                    props.put((String)name, (String)buf.toString());
                    continue;
                }
                if (comp instanceof ButtonGroup) {
                    ButtonGroup bg = (ButtonGroup)comp;
                    Enumeration<AbstractButton> buttons = bg.getElements();
                    while (buttons.hasMoreElements()) {
                        AbstractButton button = buttons.nextElement();
                        if (!button.isSelected()) continue;
                        props.put((String)name, (String)button.getActionCommand());
                    }
                    continue;
                }
                if (!(comp instanceof Attributizer)) continue;
                Attributizer attr = (Attributizer)comp;
                props.put((String)name, (String)attr.getAttributes());
            }
            return props;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static void syncUI(Map props, JComponentHolder jComponentHolder) {
        try {
            Field[] fields;
            if (jComponentHolder instanceof ManagesImport) {
                ((ManagesImport)((Object)jComponentHolder)).importVariables(props);
            }
            Class<?> guiClass = jComponentHolder.getClass();
            block4: for (Field field : fields = BeanBinder.getFields(guiClass)) {
                String value;
                Object comp;
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || (comp = field.get(jComponentHolder)) == null || !props.containsKey(name) && !(comp instanceof JComponentHolder)) continue;
                if (comp instanceof JComponentHolder) {
                    if (field.getName().startsWith("this$")) continue;
                    PropertyBinder.syncUI(props, (JComponentHolder)comp);
                    continue;
                }
                Object oVal = props.get(name);
                if (oVal == null) continue;
                String string = value = oVal instanceof Enum ? ((Enum)oVal).name() : oVal.toString();
                if (componentBinders.containsKey(comp.getClass()) && (comp instanceof JComponent || field.getAnnotation(Bound.class) != null)) {
                    ComponentBinder mgr = componentBinders.get(comp.getClass());
                    mgr.setValue(comp, value);
                    continue;
                }
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        tc.setText(value);
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        boolean setOk = false;
                        for (int k = 0; k < jc.getItemCount(); ++k) {
                            Object item = jc.getItemAt(k);
                            if (item instanceof Integer) {
                                item = ((Integer)item).toString();
                            }
                            if (!item.equals(value)) continue;
                            jc.setSelectedIndex(k);
                            setOk = true;
                            break;
                        }
                        if (setOk) continue;
                        jc.setSelectedItem(value);
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb = (JCheckBox)comp;
                        cb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JToggleButton) {
                        JToggleButton tb = (JToggleButton)comp;
                        tb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        cs.setColor(value);
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        js.setValue(Integer.parseInt(value));
                        continue;
                    }
                    if (comp instanceof PersistentList) {
                        ArrayList<String> values = new ArrayList<String>();
                        if (value.startsWith("item") && value.indexOf(9) == -1) {
                            try {
                                String val;
                                Properties p = AttributeTokenizer.getProperties(value);
                                int j = 1;
                                while ((val = p.getProperty("item" + j)) != null) {
                                    values.add(val);
                                    ++j;
                                }
                            }
                            catch (ElementException ex) {
                                throw new RuntimeException(ex);
                            }
                        } else {
                            StringTokenizer tokens = new StringTokenizer(value, "\t");
                            while (tokens.hasMoreTokens()) {
                                values.add(tokens.nextToken());
                            }
                        }
                        ((PersistentList)comp).setContent(values);
                        continue;
                    }
                    if (!(comp instanceof PersistentChoice)) continue;
                    ((PersistentChoice)comp).setChoice(value);
                    continue;
                }
                if (!(comp instanceof ButtonGroup)) continue;
                ButtonGroup bg = (ButtonGroup)comp;
                Enumeration<AbstractButton> buttons = bg.getElements();
                while (buttons.hasMoreElements()) {
                    AbstractButton button = buttons.nextElement();
                    String ac = button.getActionCommand();
                    if (ac == null || !ac.equals(value)) continue;
                    bg.setSelected(button.getModel(), true);
                    continue block4;
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static String toAttributes(List<String> values) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < values.size(); ++i) {
            if (!first) {
                buf.append(' ');
            }
            first = false;
            buf.append("item" + (i + 1) + "=\"" + values.get(i) + "\"");
        }
        return buf.toString();
    }

    public static ComponentBinder registerComponentBinder(Class componentClass, ComponentBinder binder) {
        if (binder != null) {
            return componentBinders.put(componentClass, binder);
        }
        return componentBinders.remove(componentClass);
    }

    static {
        PropertyBinder.registerComponentBinder(JSpinner.class, new ComponentBinder(){

            public String getValue(Object comp) {
                return ((JSpinner)comp).getValue().toString();
            }

            public void setValue(Object comp, String value) {
                ((JSpinner)comp).setValue(new Integer(value));
            }
        });
        PropertyBinder.registerComponentBinder(Rectangle.class, new ComponentBinder(){

            public String getValue(Object comp) {
                Rectangle r = (Rectangle)comp;
                return "x=" + r.x + " y=" + r.y + " width=" + r.width + " height=" + r.height;
            }

            public void setValue(Object comp, String value) {
                try {
                    Properties props = AttributeTokenizer.getProperties(value);
                    Rectangle r = (Rectangle)comp;
                    int x = Integer.parseInt(props.getProperty("x"));
                    int y = Integer.parseInt(props.getProperty("y"));
                    int width = Integer.parseInt(props.getProperty("width"));
                    int height = Integer.parseInt(props.getProperty("height"));
                    r.setBounds(x, y, width, height);
                }
                catch (ElementException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public static interface ComponentBinder {
        public String getValue(Object var1);

        public void setValue(Object var1, String var2);
    }
}

