/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtilities {
    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear && img.getWidth() > targetWidth && img.getHeight() > targetHeight) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public static BufferedImage duplicate(BufferedImage image) {
        if (image == null) {
            throw new NullPointerException();
        }
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g = copy.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return copy;
    }
}

