/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.text.DecimalFormat;

public class DataSizeFormatter {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final DecimalFormat fmt = new DecimalFormat("#,##0.0");
    private static final DecimalFormat thousands = new DecimalFormat("###,###,###,###");

    public static String format(long value) {
        long[] dividers = new long[]{0x10000000000L, 0x40000000L, 0x100000L, 1024L, 0L};
        String[] units = new String[]{"TB", "GB", "MB", "KB", "B"};
        if (value < 0L) {
            throw new IllegalArgumentException("Invalid size: " + value);
        }
        String result = null;
        for (int i = 0; i < dividers.length; ++i) {
            long divider = dividers[i];
            if (value < divider) continue;
            result = DataSizeFormatter.format(value, divider, units[i]);
            break;
        }
        return result;
    }

    public static String groupByThousands(long value) {
        return thousands.format(value);
    }

    private static String format(long value, long divider, String unit) {
        double result = divider > 1L ? (double)value / (double)divider : (double)value;
        return fmt.format(result) + " " + unit;
    }
}

